/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ResumeCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.lock.LockListCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ConflictsCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.ResolveCmd;
import com.ibm.team.filesystem.cli.client.internal.subcommands.StatusCmd;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsAcceptChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsExternalTool;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsStructuredResultOptions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspaceUpdateDilemmaHandler;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.StructuredUpdateReportDTO;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.WorkspaceUpdateResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ShareableDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.subcommands.HelpCmd;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.ActiveChangeSetsException;
import com.ibm.team.scm.common.ActiveChangeSetsOverlapException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ResumeCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        int noOfUncheckedInChanges;
        WorkspaceUpdateResultDTO result;
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ICommandLine subcmd = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(subcmd.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        boolean automergeDisabled = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE);
        if (automergeDisabled && subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.AcceptCmd2_INVALID_INPLACE_CONFLICT_MARKER_REQUEST, (Object)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER.getName(), (Object)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE.getName()));
        }
        ScmCommandLineArgument targetSelector = ScmCommandLineArgument.create((ICommandLineArgument)subcmd.getOptionValue((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR, null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)targetSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ITeamRepository repo = null;
        ParmsWorkspace targetWs = new ParmsWorkspace();
        if (targetSelector == null) {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            if (wsInSandboxList.size() != 1) {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_7, (Object)subcmd.getDefinition().getOption((IOptionKey)CommonOptions.OPT_STREAM_TARGET_SELECTOR).getName()));
            }
            ISandboxWorkspace wsInSandbox = (ISandboxWorkspace)wsInSandboxList.iterator().next();
            targetWs.repositoryUrl = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
            targetWs.workspaceItemId = wsInSandbox.getWorkspaceItemId();
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(targetWs.repositoryUrl));
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)targetSelector);
            IWorkspace ws = RepoUtil.getWorkspace((String)targetSelector.getItemSelector(), (boolean)true, (boolean)false, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            targetWs.repositoryUrl = repo.getRepositoryURI();
            targetWs.workspaceItemId = ws.getItemId().getUuidValue();
        }
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)targetWs, (String)Messages.ResumeCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)this.config);
        ParmsWorkspaceUpdate parms = new ParmsWorkspaceUpdate();
        this.generateResumeParms(this.config, client, subcmd, parms, targetWs, repo);
        if (this.config.isDryRun()) {
            return;
        }
        try {
            result = client.postWorkspaceUpdate(parms, null);
        }
        catch (TeamRepositoryException e) {
            PatchInProgressException port = (PatchInProgressException)SubcommandUtil.findExceptionByType(PatchInProgressException.class, (TeamRepositoryException)e);
            if (port != null) {
                throw StatusHelper.portsInProgress((String)port.getLocalizedMessage());
            }
            if (this.isActiveChangeSetsException(e)) {
                throw StatusHelper.disallowed((String)Messages.ResumeCmd_0);
            }
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            GapException gap = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
            if (gap != null) {
                String commandName = SubcommandUtil.getExecutionString((ISubcommandDefinition)this.config.getSubcommandDefinition()).toString();
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, HelpCmd.class);
                throw StatusHelper.gap((String)(String.valueOf(Messages.AcceptCmd_MISSING_CHANGE_SETS) + "\n" + NLS.bind((String)Messages.ResumeCmd_HINT_ON_GAP, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString(), commandName})));
            }
            NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
            if (nway != null) {
                throw StatusHelper.nWayConflict((String)Messages.ResumeCmd_2);
            }
            ActiveChangeSetsOverlapException overlap = (ActiveChangeSetsOverlapException)SubcommandUtil.findExceptionByType(ActiveChangeSetsOverlapException.class, (TeamRepositoryException)e);
            if (overlap != null) {
                throw StatusHelper.disallowed((String)Messages.ResumeCmd_11);
            }
            throw StatusHelper.wrap((String)Messages.ResumeCmd_3, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)targetWs.repositoryUrl);
        }
        if (result.isCancelled() && (noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
            throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.ResumeCmd_UNCOMMITTED_COMPLAINT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
        }
        JSONArray status = null;
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (this.config.isJSONEnabled()) {
            status = new JSONArray();
        } else {
            out.println((CharSequence)Messages.ResumeCmd_CS_RESUME);
        }
        ArrayList<ShareableDTO> deletedContentShareables = new ArrayList<ShareableDTO>();
        if (!automergeDisabled && result != null && result.getSandboxUpdateDilemma().getDeletedContentShareables().size() > 0) {
            deletedContentShareables.addAll(result.getSandboxUpdateDilemma().getDeletedContentShareables());
        }
        List<String> unresolvedWorkspaces = AcceptCmd.hasConflicts(result);
        boolean verbose = subcmd.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE);
        JSONObject jResult = AcceptResultDisplayer.showResult(client, repo, false, parms, result, deletedContentShareables, verbose, this.config, status);
        if (subcmd.hasOption((IOptionKey)CommonOptions.OPT_ACQUIRE_LOCK) && result.getLocksWereHeld() != null && result.getLocksWereHeld().size() > 0) {
            ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, LockListCmd.class);
            String message = NLS.bind((String)Messages.ResumeCmd_ITEM_LOCKED_IN_STREAM, (Object)this.config.getContext().getAppName(), (Object)SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString());
            if (this.config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)50, (String)message, (String)Constants.Severity.warning.toString()));
            } else {
                out.println((CharSequence)message);
            }
        }
        if (unresolvedWorkspaces.size() > 0 && subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_INPLACE_CONFLICT_HANDLER)) {
            AcceptCmd.markInPlaceConflicts(this.config, result, client, verbose);
            if (this.config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)70, (String)Messages.Conflicts_InPlaceMarkers_Help, (String)Constants.Severity.info.toString()));
            } else {
                out.println((CharSequence)Messages.Conflicts_InPlaceMarkers_Help);
            }
        }
        if (this.hasConflicts(result)) {
            ISubcommandDefinition defnTemp1 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ResolveCmd.class);
            ISubcommandDefinition defnTemp2 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, ConflictsCmd.class);
            ISubcommandDefinition defnTemp3 = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)this.config, StatusCmd.class);
            String message = String.valueOf(Messages.ResumeCmd_4) + " " + NLS.bind((String)Messages.AcceptCmd_CONFLICT_GUIDANCE, (Object[])new String[]{this.config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp1).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp2).toString(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp3).toString()});
            if (this.config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)11, (String)message, (String)Constants.Severity.error.toString()));
                jResult.put((Object)"status", (Object)status);
                this.config.getOutputStream().print((CharSequence)jResult.toString());
                throw StatusHelper.returnValue((int)11);
            }
            throw StatusHelper.conflict((String)message);
        }
        AcceptCmd.reportErrorOnUnresolvedLocalConflicts(this.config, client, parms, out, status, jResult);
        if (result.isSetEclipseReadFailureMessage()) {
            for (Object nextMsg : result.getEclipseReadFailureMessage()) {
                if (this.config.isJSONEnabled()) {
                    status.add((Object)JSONPrintUtil.getJsonStatusObject((int)71, (String)((String)nextMsg), (String)Constants.Severity.warning.toString()));
                    continue;
                }
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)((String)nextMsg));
            }
        }
        if (this.config.isJSONEnabled()) {
            if (status.size() > 0) {
                jResult.put((Object)"status", (Object)status);
            }
            this.config.getOutputStream().print((CharSequence)jResult.toString());
        }
    }

    private boolean hasConflicts(WorkspaceUpdateResultDTO result) {
        for (StructuredUpdateReportDTO wsReport : result.getStructuredResult()) {
            if (!wsReport.isHasConflicts()) continue;
            return true;
        }
        return false;
    }

    private boolean isActiveChangeSetsException(TeamRepositoryException e) {
        int tries = 0;
        for (Throwable cause = e; cause != null; cause = cause.getCause()) {
            if (!(cause instanceof ActiveChangeSetsException)) continue;
            return true;
        }
        return false;
    }

    private void generateResumeParms(IScmClientConfiguration config, IFilesystemRestClient client, ICommandLine subcmd, ParmsWorkspaceUpdate parms, ParmsWorkspace targetWs, ITeamRepository repo) throws FileSystemException {
        List<ParmsChangeSet> changes;
        ArrayList<IScmCommandLineArgument> selectors = new ArrayList<IScmCommandLineArgument>(subcmd.getOptionValues((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS).size());
        for (ICommandLineArgument selector : subcmd.getOptionValues((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS)) {
            selectors.add((IScmCommandLineArgument)ScmCommandLineArgument.create((ICommandLineArgument)selector, (IScmClientConfiguration)config));
        }
        SubcommandUtil.validateArgument(selectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, selectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
        RepoUtil.findChangeSets((List)RepoUtil.getSelectors(selectors), (boolean)false, (String)targetWs.workspaceItemId, (String)"workspace", (String)targetWs.repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        parms.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
        parms.structuredResultOptions = new ParmsStructuredResultOptions();
        parms.workspaceUpdateDilemmaHandler = new ParmsWorkspaceUpdateDilemmaHandler();
        parms.workspaceUpdateDilemmaHandler.disconnectedComponentsDirection = "continue";
        ITypedPreferenceRegistry prefs = ((ScmClientConfiguration)config).getPersistentPreferences();
        String mergeTool = prefs.getExternalAutoResolveTool();
        if (mergeTool != null && !mergeTool.isEmpty()) {
            parms.updateDilemmaHandler = new ParmsUpdateDilemmaHandler();
            parms.updateDilemmaHandler.externalAutoResolveTool = mergeTool;
            ParmsExternalTool parmsTool = new ParmsExternalTool();
            parmsTool.externalTool = mergeTool;
            parmsTool.filePatterns = prefs.getExternalAutoResolveToolFilePatterns();
            parmsTool.policy = prefs.getExternalAutoResolveToolPolicy();
            parms.updateDilemmaHandler.externalTool = parmsTool;
        }
        parms.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
        parms.pendingChangesDilemmaHandler.pendingChangesInstruction = subcmd.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
        parms.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
        parms.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
        String gapStrategy = "fail";
        if (subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_ACCEPT_WITH_PORTING)) {
            gapStrategy = "continue";
        }
        parms.workspaceUpdateDilemmaHandler.gapDirection = gapStrategy;
        parms.workspaceUpdateDilemmaHandler.portInProgressDirection = subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_ACCEPT_WITH_PORTING) ? "continue" : "fail";
        ParmsAcceptChangeSets update = new ParmsAcceptChangeSets();
        update.changeSets = ResumeCmd.normalizeCsUuidAndAlias(repo, selectors, config);
        update.workspace = targetWs;
        parms.acceptChangeSets = new ParmsAcceptChangeSets[]{update};
        if (config.getSubcommandCommandLine().hasOption((IOptionKey)ResumeCmdOptions.OPT_RESUME_MISSING_CHANGESETS) && (changes = AcceptCmd.fetchGapFillingChangeSets(repo, targetWs, selectors)) != null && !changes.isEmpty()) {
            ParmsAcceptChangeSets newUpdate = new ParmsAcceptChangeSets();
            newUpdate.workspace = targetWs;
            newUpdate.changeSets = changes.toArray(new ParmsChangeSet[changes.size()]);
            ParmsAcceptChangeSets[] b = new ParmsAcceptChangeSets[parms.acceptChangeSets.length + 1];
            System.arraycopy(parms.acceptChangeSets, 0, b, 0, parms.acceptChangeSets.length);
            b[parms.acceptChangeSets.length] = newUpdate;
            parms.acceptChangeSets = b;
        }
        parms.autoAcquireLocks = !config.getSubcommandCommandLine().hasOption((IOptionKey)CommonOptions.OPT_ACQUIRE_LOCK) ? Boolean.valueOf(((ScmClientConfiguration)config).getPersistentPreferences().getAcquireLockForResume()) : Boolean.valueOf(Boolean.parseBoolean(config.getSubcommandCommandLine().getOption((IOptionKey)CommonOptions.OPT_ACQUIRE_LOCK).toString()));
        if (!subcmd.hasOption((IOptionKey)AcceptCmdOptions.OPT_DISABLE_AUTOMERGE)) {
            parms.autoResolve = Boolean.TRUE;
        }
    }

    private static ParmsChangeSet[] normalizeCsUuidAndAlias(ITeamRepository repo, List<IScmCommandLineArgument> csSelectors, IScmClientConfiguration config) throws FileSystemException {
        ArrayList<ParmsChangeSet> normalized = new ArrayList<ParmsChangeSet>(csSelectors.size());
        HashSet<String> UuidSet = new HashSet<String>(csSelectors.size());
        int i = 0;
        while (i < csSelectors.size()) {
            IScmCommandLineArgument selector = csSelectors.get(i);
            UUID uuid = RepoUtil.lookupUuid((String)selector.getItemSelector());
            if (uuid != null) {
                if (UuidSet.add(uuid.getUuidValue())) {
                    ParmsChangeSet parmsCs = new ParmsChangeSet();
                    parmsCs.changeSetItemId = uuid.getUuidValue();
                    parmsCs.repositoryUrl = repo.getRepositoryURI();
                    normalized.add(parmsCs);
                }
            } else {
                throw StatusHelper.ambiguousSelector((String)NLS.bind((String)Messages.ResumeCmd_6, (Object)selector.getItemSelector()));
            }
            ++i;
        }
        ParmsChangeSet[] normalizedArr = new ParmsChangeSet[normalized.size()];
        normalizedArr = normalized.toArray(normalizedArr);
        return normalizedArr;
    }
}

