/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.ITypedPreferenceRegistry;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolsUtil;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ExternalToolUtils {
    public static String getExternalCompareTool(ScmClientConfiguration config, boolean compare3way) throws FileSystemException {
        ITypedPreferenceRegistry prefs = config.getPersistentPreferences();
        String externalCompareTool = null;
        if (compare3way) {
            externalCompareTool = prefs.getExternal3wayCompareTool();
        }
        if (externalCompareTool == null) {
            externalCompareTool = prefs.getExternal2wayCompareTool();
        }
        if (externalCompareTool == null) {
            throw StatusHelper.inappropriateArgument((String)Messages.DiffCmd_NO_EXTERNAL_COMPARE_TOOL_SET);
        }
        if (!ExternalToolUtils.isValidExecutable(externalCompareTool)) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.DiffCmd_INVALID_EXTERNAL_COMPARE_TOOL, (Object)externalCompareTool));
        }
        return externalCompareTool;
    }

    private static boolean isValidExecutable(String commandLine) {
        boolean isValid = false;
        String[] commandArray = ExternalCompareToolsUtil.createCommandArray((String)commandLine);
        if (commandArray.length > 0) {
            String filePath = commandArray[0];
            if (filePath == null || filePath.length() == 0) {
                isValid = false;
            } else {
                try {
                    try {
                        isValid = SubcommandUtil.exists((IPath)new Path(filePath), null);
                    }
                    catch (FileSystemException e) {
                        isValid = false;
                    }
                }
                catch (SecurityException e) {
                    isValid = false;
                }
            }
        }
        return isValid;
    }
}

