/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.CombineChangeSetsBaseOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.CombineChangeSetsCmd;
import com.ibm.team.filesystem.cli.client.internal.changeset.DuplicateChangeSetCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsDuplicateChangeSet;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.CombineChangeSetsResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import java.util.List;

public class DuplicateChangeSetCmd
extends CombineChangeSetsCmd {
    @Override
    protected List<IScmCommandLineArgument> getCsetSelectors(ICommandLine cli) throws FileSystemException {
        List csetSelectors = null;
        if (!cli.hasOption((IOptionKey)DuplicateChangeSetCmdOptions.OPT_SELECTOR)) {
            throw StatusHelper.argSyntax((String)Messages.DuplicateChangeSetCmd_ONE_CHANGESET_REQUIRED);
        }
        csetSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)DuplicateChangeSetCmdOptions.OPT_SELECTOR), (IScmClientConfiguration)this.config);
        if (csetSelectors.size() != 1) {
            throw StatusHelper.argSyntax((String)Messages.DuplicateChangeSetCmd_ONE_CHANGESET_REQUIRED);
        }
        return csetSelectors;
    }

    @Override
    protected void validateChangeSets(ChangeSetSyncDTO[] changeSetDTOs) throws FileSystemException {
        if (changeSetDTOs.length != 1) {
            throw StatusHelper.argSyntax((String)Messages.DuplicateChangeSetCmd_ONE_CHANGESET_REQUIRED);
        }
    }

    @Override
    protected CombineChangeSetsResultDTO runPostCommand(ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo, ChangeSetSyncDTO[] changeSetDTOs, ParmsWorkspace parmsWorkspace, IFileSystemWorkItemRestClient workitemClient) throws TeamRepositoryException {
        ParmsDuplicateChangeSet parms = this.generateDuplicateChangeSetParms(cli, client, repo, changeSetDTOs, parmsWorkspace, this.config);
        return workitemClient.postDuplicateChangeSet(parms, null);
    }

    private ParmsDuplicateChangeSet generateDuplicateChangeSetParms(ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo, ChangeSetSyncDTO[] changeSetDTOs, ParmsWorkspace parmsWorkspace, IScmClientConfiguration config) throws FileSystemException {
        ParmsDuplicateChangeSet parms = new ParmsDuplicateChangeSet();
        parms.workspace = parmsWorkspace;
        parms.changeSetItemIds = new String[1];
        parms.changeSetItemIds[0] = changeSetDTOs[0].getChangeSetItemId();
        if (cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_WORKITEM)) {
            parms.workItem = this.generateWorkItemParm(cli, client, repo);
        }
        parms.isDiscardOldChangeSets = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD);
        parms.isRemoveOldChangeSets = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_REMOVE);
        parms.comment = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_COMMENT) ? cli.getOption(CombineChangeSetsBaseOptions.OPT_COMMENT.getId()) : changeSetDTOs[0].getChangeSetComment();
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        return parms;
    }

    @Override
    protected String getErrorMessage_OPT1_REQUIRES_OPT2() {
        return Messages.DuplicateChangeSetCmdOpts_OPT1_REQUIRES_OPT2;
    }

    @Override
    protected String getErrorMessage_WOULD_CREATE_GAP() {
        return Messages.DuplicateChangeSetCmd_WOULD_CREATE_GAP;
    }

    @Override
    protected String getErrorMessage_WOULD_CREATE_NWAY_CONFLICT() {
        return Messages.DuplicateChangeSetCmd_WOULD_CREATE_NWAY_CONFLICT;
    }

    @Override
    protected String getErrorMessage_CS_NOT_IN_HISTORY() {
        return Messages.DuplicateChangeSetCmd_CS_NOT_IN_HISTORY;
    }

    @Override
    protected String getErrorMessage_FAILED() {
        return Messages.DuplicateChangeSetCmd_FAILED;
    }

    @Override
    protected String getErrorMessage_CHANGESETS_NOT_FOUND() {
        return Messages.DuplicateChangeSetCmd_CHANGESET_NOT_FOUND;
    }

    @Override
    protected String getErrorMessage_WORKITEM_LINK_FAILED() {
        return Messages.DuplicateChangeSetCmd_WORKITEM_LINK_FAILED;
    }

    @Override
    protected String getMessage_SUCCESS() {
        return Messages.DuplicateChangeSetCmd_SUCCESSFUL;
    }

    @Override
    protected String getResultingChangesetMessage() {
        return Messages.DuplicateChangeSetCmd_DUPLICATE_CHANGESET;
    }

    @Override
    protected String getJsonizedResultKey() {
        return "duplicate";
    }

    @Override
    protected String getUntrackedWorkspaceMessage() {
        return Messages.DuplicateChangeSetCmd_UNTRACKED_WORKSPACE;
    }
}

