/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.CombineChangeSetsBaseOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.CombineChangeSetsCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.Constants;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsCombineChangeSets;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsWorkItem;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.workitems.internal.rest.CombineChangeSetsResultDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.PermissionDeniedException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.ChangeSetsNotOutgoingException;
import com.ibm.team.scm.common.DiscardNotInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class CombineChangeSetsCmd
extends AbstractSubcommand {
    private void testInvalidOptions(ICommandLine cli) throws FileSystemException {
        if (cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD) && cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_SUSPEND)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD.getName(), (Object)CombineChangeSetsBaseOptions.OPT_MODE_SUSPEND.getName()));
        }
        if (cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_REMOVE) && !cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_WORKITEM)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.CombineChangeSetsCmdOpts_OPT1_REQUIRES_OPT2, (Object)CombineChangeSetsBaseOptions.OPT_MODE_REMOVE.getName(), (Object)CombineChangeSetsBaseOptions.OPT_WORKITEM.getName()));
        }
    }

    protected List<IScmCommandLineArgument> getCsetSelectors(ICommandLine cli) throws FileSystemException {
        List csetSelectors = null;
        if (!cli.hasOption((IOptionKey)CombineChangeSetsCmdOptions.OPT_SELECTORS)) {
            throw StatusHelper.argSyntax((String)Messages.CombineChangeSetsCmd_TWO_CHANGESETS_REQUIRED);
        }
        csetSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)CombineChangeSetsCmdOptions.OPT_SELECTORS), (IScmClientConfiguration)this.config);
        if (csetSelectors.size() < 2) {
            throw StatusHelper.argSyntax((String)Messages.CombineChangeSetsCmd_TWO_CHANGESETS_REQUIRED);
        }
        return csetSelectors;
    }

    protected void validateChangeSets(ChangeSetSyncDTO[] changeSetDTOs) throws FileSystemException {
        HashSet<String> componentSet = new HashSet<String>();
        ChangeSetSyncDTO[] changeSetSyncDTOArray = changeSetDTOs;
        int n = changeSetDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n2];
            componentSet.add(csDTO.getComponentItemId());
            ++n2;
        }
        if (componentSet.size() > 1) {
            throw StatusHelper.argSyntax((String)Messages.CombineChangeSetsCmd_SAME_COMPONENT);
        }
        if (changeSetDTOs.length < 2) {
            throw StatusHelper.argSyntax((String)Messages.CombineChangeSetsCmd_TWO_CHANGESETS_REQUIRED);
        }
    }

    protected CombineChangeSetsResultDTO runPostCommand(ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo, ChangeSetSyncDTO[] changeSetDTOs, ParmsWorkspace parmsWorkspace, IFileSystemWorkItemRestClient workitemClient) throws TeamRepositoryException {
        ParmsCombineChangeSets parms = this.generateCombineChangeSetsParms(cli, client, repo, changeSetDTOs, parmsWorkspace, this.config);
        return workitemClient.postCombineChangeSets(parms, null);
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.testInvalidOptions(cli);
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ISandbox[] sandboxes = this.config.getSandboxes();
        IFileSystemWorkItemRestClient workitemClient = (IFileSystemWorkItemRestClient)SubcommandUtil.startDaemon(IFileSystemWorkItemRestClient.class, (ISandbox[])sandboxes, (IScmClientConfiguration)this.config);
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CombineChangeSetsBaseOptions.OPT_WORKSPACE.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        List<IScmCommandLineArgument> csetSelectors = this.getCsetSelectors(cli);
        SubcommandUtil.validateArgument(csetSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        ParmsWorkspace parmsWorkspace = null;
        ITeamRepository repo = null;
        if (wsSelector != null) {
            parmsWorkspace = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.getSharedRepository((String)parmsWorkspace.repositoryUrl, (boolean)true);
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, null);
            parmsWorkspace = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        RepoUtil.validateWorkspaceIsTracked((ParmsWorkspace)parmsWorkspace, (String)this.getUntrackedWorkspaceMessage(), (IScmClientConfiguration)this.config);
        RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, csetSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        ArrayList<String> changeSetSelectorList = new ArrayList<String>();
        ArrayList<String> missingChangeSetSelectorList = new ArrayList<String>();
        for (IScmCommandLineArgument csSelector : csetSelectors) {
            IUuidAliasRegistry.IUuidAlias csUuidAlias = RepoUtil.lookupUuidAndAlias((String)csSelector.getItemSelector());
            if (csUuidAlias == null) {
                missingChangeSetSelectorList.add(csSelector.getItemSelector());
            }
            changeSetSelectorList.add(csSelector.getItemSelector());
        }
        if (missingChangeSetSelectorList.size() > 0) {
            this.throwMissingChangeSetsError(missingChangeSetSelectorList);
        }
        ChangeSetSyncDTO[] changeSetDTOs = RepoUtil.findChangeSets(changeSetSelectorList, (boolean)cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), (String)parmsWorkspace.workspaceItemId, (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        this.validateChangeSets(changeSetDTOs);
        CombineChangeSetsResultDTO result = null;
        try {
            result = this.runPostCommand(cli, client, repo, changeSetDTOs, parmsWorkspace, workitemClient);
        }
        catch (TeamRepositoryException e) {
            PatchInProgressException port = (PatchInProgressException)SubcommandUtil.findExceptionByType(PatchInProgressException.class, (TeamRepositoryException)e);
            if (port != null) {
                throw StatusHelper.portsInProgress((String)port.getLocalizedMessage());
            }
            GapException gap = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
            if (gap != null) {
                throw StatusHelper.gap((String)this.getErrorMessage_WOULD_CREATE_GAP());
            }
            NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
            if (nway != null) {
                throw StatusHelper.nWayConflict((String)this.getErrorMessage_WOULD_CREATE_NWAY_CONFLICT());
            }
            DiscardNotInHistoryException notinHistory = (DiscardNotInHistoryException)SubcommandUtil.findExceptionByType(DiscardNotInHistoryException.class, (TeamRepositoryException)e);
            if (notinHistory != null) {
                throw StatusHelper.discardNotInHistory((String)this.getErrorMessage_CS_NOT_IN_HISTORY());
            }
            PermissionDeniedException pde = (PermissionDeniedException)((Object)SubcommandUtil.findExceptionByType(PermissionDeniedException.class, (TeamRepositoryException)e));
            if (pde != null) {
                throw StatusHelper.permissionFailure((TeamRepositoryException)((Object)pde), (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            ChangeSetsNotOutgoingException noe = (ChangeSetsNotOutgoingException)SubcommandUtil.findExceptionByType(ChangeSetsNotOutgoingException.class, (TeamRepositoryException)e);
            if (noe != null) {
                throw StatusHelper.disallowed((String)e.getLocalizedMessage());
            }
            throw StatusHelper.wrap((String)this.getErrorMessage_FAILED(), (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        if (result.isCancelled()) {
            if (result.getOutOfSyncShares().size() > 0) {
                AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), this.config);
            }
        } else {
            this.printResult(result, changeSetDTOs, parmsWorkspace.repositoryUrl, parmsWorkspace.workspaceItemId, cli, client);
        }
    }

    protected ParmsWorkItem generateWorkItemParm(ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo) throws FileSystemException {
        IWorkItem workItem;
        int wiNumber;
        ScmCommandLineArgument wiSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(CombineChangeSetsBaseOptions.OPT_WORKITEM.getId()), (IScmClientConfiguration)this.config, (boolean)false);
        String wiString = wiSelector.getItemSelector();
        try {
            wiNumber = Integer.parseInt(wiString);
        }
        catch (NumberFormatException e) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_2, (Object)wiString));
        }
        String wiRepoUri = wiSelector.getRepositorySelector();
        if (wiRepoUri == null) {
            workItem = RepoUtil.findWorkItem((int)wiNumber, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            wiRepoUri = repo.getRepositoryURI();
        } else {
            ITeamRepository wiRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(wiRepoUri));
            workItem = RepoUtil.findWorkItem((int)wiNumber, (ITeamRepository)wiRepo, (IScmClientConfiguration)this.config);
            wiRepoUri = wiRepo.getRepositoryURI();
        }
        return new ParmsWorkItem(workItem.getItemId().getUuidValue(), wiRepoUri);
    }

    private ParmsCombineChangeSets generateCombineChangeSetsParms(ICommandLine cli, IFilesystemRestClient client, ITeamRepository repo, ChangeSetSyncDTO[] changeSetDTOs, ParmsWorkspace parmsWorkspace, IScmClientConfiguration config) throws FileSystemException {
        ParmsCombineChangeSets parms = new ParmsCombineChangeSets();
        parms.workspace = parmsWorkspace;
        parms.changeSetItemIds = new String[changeSetDTOs.length];
        int i = 0;
        while (i < changeSetDTOs.length) {
            parms.changeSetItemIds[i] = changeSetDTOs[i].getChangeSetItemId();
            ++i;
        }
        if (cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_WORKITEM)) {
            parms.workItem = this.generateWorkItemParm(cli, client, repo);
        }
        parms.isDiscardOldChangeSets = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD);
        parms.isRemoveOldChangeSets = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_REMOVE);
        parms.comment = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_COMMENT) ? cli.getOption(CombineChangeSetsBaseOptions.OPT_COMMENT.getId()) : "";
        parms.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
        parms.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
        parms.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
        return parms;
    }

    private void printResult(CombineChangeSetsResultDTO result, ChangeSetSyncDTO[] changeSetDTOs, String repositoryUrl, String workspaceItemId, ICommandLine cli, IFilesystemRestClient client) throws FileSystemException {
        JSONObject newlyCreatedCSJSONObject;
        ChangeSetSyncDTO newlyCreatedChangeSetDTO = null;
        try {
            newlyCreatedChangeSetDTO = RepoUtil.findChangeSet((String)result.getChangeSetItemId(), (boolean)cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), (String)workspaceItemId, (String)"workspace", (String)repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        JSONObject jsonizedResult = new JSONObject();
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        PendingChangesUtil.PendingChangesOptions options = this.getPendingChangesOptions(changeSetDTOs, cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE));
        if (newlyCreatedChangeSetDTO != null) {
            newlyCreatedCSJSONObject = new JSONObject();
            JSONPrintUtil.jsonizeChangeSet((JSONObject)newlyCreatedCSJSONObject, (ChangeSetSyncDTO)newlyCreatedChangeSetDTO, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, null, null);
            if (this.config.isJSONEnabled()) {
                jsonizedResult.put((Object)this.getJsonizedResultKey(), (Object)newlyCreatedCSJSONObject);
            } else {
                out.println((CharSequence)this.getResultingChangesetMessage());
                PendingChangesUtil.printChangeSet((JSONObject)newlyCreatedCSJSONObject, (String)repositoryUrl, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out.indent());
            }
        } else {
            newlyCreatedCSJSONObject = JSONPrintUtil.jsonizeResult((String)Messages.CreateChangeSetCmd_9, (String)result.getChangeSetItemId(), (String)repositoryUrl, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
            if (this.config.isJSONEnabled()) {
                jsonizedResult.put((Object)this.getJsonizedResultKey(), (Object)newlyCreatedCSJSONObject);
            } else {
                PendingChangesUtil.printSuccess((JSONObject)newlyCreatedCSJSONObject, (IScmClientConfiguration)this.config, (IndentingPrintStream)out);
            }
        }
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
            String changeSetTypeHeader = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD) ? "discarded" : "suspended";
            JSONPrintUtil.jsonizeChangeSets((JSONObject)jsonizedResult, (String)changeSetTypeHeader, Arrays.asList(changeSetDTOs), null, (PendingChangesUtil.PendingChangesOptions)options, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config, null, null, null);
            if (!this.config.isJSONEnabled()) {
                String titleText = cli.hasOption((IOptionKey)CombineChangeSetsBaseOptions.OPT_MODE_DISCARD) ? Messages.DiscardCmd_CHANGESETS_DISCARDED : Messages.SuspendCmd_7;
                PendingChangesUtil.printChangeSets((JSONObject)jsonizedResult, (String)changeSetTypeHeader, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, null, (String)titleText);
            }
        }
        JSONArray status = new JSONArray();
        if (result.isWorkItemLinkFailed()) {
            String message = this.getErrorMessage_WORKITEM_LINK_FAILED();
            if (this.config.isJSONEnabled()) {
                status.add((Object)JSONPrintUtil.getJsonStatusObject((int)74, (String)message, (String)Constants.Severity.warning.toString()));
            } else {
                IndentingPrintStream err = this.config.getWrappedErrorStream();
                err.println((CharSequence)message);
            }
        }
        if (status.size() > 0) {
            jsonizedResult.put((Object)"status", (Object)status);
        }
        if (this.config.isJSONEnabled()) {
            this.config.getOutputStream().println((CharSequence)jsonizedResult.toString());
        } else {
            out.println((CharSequence)this.getMessage_SUCCESS());
        }
    }

    private void throwMissingChangeSetsError(List<String> missingChangeSetSelectorList) throws FileSystemException {
        boolean multiple = missingChangeSetSelectorList.size() > 1;
        IndentingPrintStream error = this.config.getWrappedErrorStream();
        error.println((CharSequence)(multiple ? Messages.Common_CS_NOT_FOUND_HEADER : Messages.Common_CS_NOT_FOUND_HEADER_SINGLE));
        for (String missingChangeSetSelector : missingChangeSetSelectorList) {
            error.indent().println((CharSequence)missingChangeSetSelector);
        }
        error.println((CharSequence)this.getErrorMessage_CHANGESETS_NOT_FOUND());
        throw StatusHelper.itemNotFound((String)(multiple ? Messages.Common_CS_NOT_FOUND : Messages.Common_CS_NOT_FOUND_SINGLE));
    }

    private PendingChangesUtil.PendingChangesOptions getPendingChangesOptions(ChangeSetSyncDTO[] changeSetDTOs, boolean isVerbose) {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        if (isVerbose) {
            options.setVerbose(true);
            options.enablePrinter(6);
        }
        options.enablePrinter(4);
        options.enableFilter(4);
        ChangeSetSyncDTO[] changeSetSyncDTOArray = changeSetDTOs;
        int n = changeSetDTOs.length;
        int n2 = 0;
        while (n2 < n) {
            ChangeSetSyncDTO changeSetDTO = changeSetSyncDTOArray[n2];
            options.addFilter(UUID.valueOf((String)changeSetDTO.getChangeSetItemId()), 4);
            ++n2;
        }
        return options;
    }

    protected String getErrorMessage_OPT1_REQUIRES_OPT2() {
        return Messages.CombineChangeSetsCmdOpts_OPT1_REQUIRES_OPT2;
    }

    protected String getErrorMessage_WOULD_CREATE_GAP() {
        return Messages.CombineChangeSetsCmd_WOULD_CREATE_GAP;
    }

    protected String getErrorMessage_WOULD_CREATE_NWAY_CONFLICT() {
        return Messages.CombineChangeSetsCmd_WOULD_CREATE_NWAY_CONFLICT;
    }

    protected String getErrorMessage_CS_NOT_IN_HISTORY() {
        return Messages.CombineChangeSetsCmd_CS_NOT_IN_HISTORY;
    }

    protected String getErrorMessage_FAILED() {
        return Messages.CombineChangeSetsCmd_FAILED;
    }

    protected String getErrorMessage_CHANGESETS_NOT_FOUND() {
        return Messages.CombineChangeSetsCmd_CHANGESETS_NOT_FOUND;
    }

    protected String getErrorMessage_WORKITEM_LINK_FAILED() {
        return Messages.CombineChangeSetsCmd_WORKITEM_LINK_FAILED;
    }

    protected String getMessage_SUCCESS() {
        return Messages.CombineChangeSetsCmd_SUCCESSFUL;
    }

    protected String getResultingChangesetMessage() {
        return Messages.CombineChangeSetsCmd_COMBINED_CHANGESET;
    }

    protected String getJsonizedResultKey() {
        return "combined";
    }

    protected String getUntrackedWorkspaceMessage() {
        return Messages.CombineChangeSetsCmd_UNTRACKED_WORKSPACE;
    }

    protected static enum CommandName {
        Combine,
        Duplicate;

    }
}

