/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetAssociateWorkitemOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.workitem.common.model.IWorkItem;
import java.util.Collections;
import org.eclipse.osgi.util.NLS;

public abstract class ChangesetWorkitemBase
extends AbstractSubcommand {
    public IWorkItem workItem;
    public String wsId = null;
    public ChangeSetSyncDTO csDTO;
    public String repoUri;
    public String wiRepoUri;

    public void run() throws FileSystemException {
        ITeamRepository repo;
        int wiNumber;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        ITeamRepository wiRepo = null;
        String wi = null;
        ScmCommandLineArgument wiSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetAssociateWorkitemOptions.OPT_WORKITEM.getId()), (IScmClientConfiguration)this.config, (boolean)false);
        this.wiRepoUri = wiSelector.getRepositorySelector();
        wi = wiSelector.getItemSelector();
        try {
            wiNumber = Integer.parseInt(wi);
        }
        catch (NumberFormatException e) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetAssociateWorkitemCmd_2, (Object)wi));
        }
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(csSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            this.wsId = ws.workspaceItemId;
            this.repoUri = ws.repositoryUrl;
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            this.repoUri = repo.getRepositoryURI();
        }
        this.csDTO = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (boolean)false, (String)this.wsId, (String)"workspace", (String)this.repoUri, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (this.wiRepoUri == null) {
            this.workItem = RepoUtil.findWorkItem((int)wiNumber, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            wiRepo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(this.wiRepoUri));
            this.workItem = RepoUtil.findWorkItem((int)wiNumber, (ITeamRepository)wiRepo, (IScmClientConfiguration)this.config);
            this.wiRepoUri = wiRepo.getRepositoryURI();
        }
        this.doIt();
    }

    protected abstract void doIt() throws FileSystemException;
}

