/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommentCmd;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCompleteCmd;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCurrentCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ChangesetSetCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final NamedOptionDefinition OPT_COMPLETE = new NamedOptionDefinition(null, "complete", 0);
    public static final NamedOptionDefinition OPT_CURRENT = new NamedOptionDefinition(null, "current", 0);
    public static final NamedOptionDefinition OPT_COMMENT = new NamedOptionDefinition(null, "comment", 1);
    public static final NamedOptionDefinition OPT_SKIP_MERGE_TARGET = new NamedOptionDefinition(null, "skip-merge-targets", 0);

    public Options getOptions() throws ConflictingOptionException {
        Options opts = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)opts);
        opts.addOption((INamedOptionDefinition)CommonOptions.OPT_DIRECTORY, CommonOptions.OPT_DIRECTORY_HELP).addOption(ChangesetCommonOptions.OPT_WORKSPACE_NAME, Messages.ChangesetCompleteCmdOptions_0).addOption((IOptionGroup)new ContinuousGroup(true).addOption(new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_COMPLETE, Messages.ChangesetSetCmd_Complete_HELP, false).addOption((INamedOptionDefinition)OPT_CURRENT, Messages.ChangesetSetCmd_Current_HELP, false)).addOption((INamedOptionDefinition)OPT_COMMENT, Messages.ChangesetSetCmd_Comment_HELP, false)).addOption((INamedOptionDefinition)OPT_SKIP_MERGE_TARGET, Messages.ChangesetCompleteCmdOptions_OPT_SKIP_CURRENT_MERGE).addOption(ChangesetCommonOptions.OPT_CHANGESETS, Messages.ChangesetCompleteCmdOptions_OPT_CHANGESET_HELP);
        return opts;
    }

    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        int count = 0;
        if (cli.hasOption((IOptionKey)OPT_COMPLETE)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_CURRENT)) {
            ++count;
        }
        if (cli.hasOption((IOptionKey)OPT_COMMENT)) {
            ++count;
        }
        if (count == 0) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ConflictsCmd_1, (Object[])new String[]{OPT_COMPLETE.getName(), OPT_CURRENT.getName(), OPT_COMMENT.getName()}));
        }
        if (cli.hasOption((IOptionKey)OPT_COMPLETE) && cli.hasOption((IOptionKey)OPT_CURRENT)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object[])new String[]{OPT_COMPLETE.getName(), OPT_CURRENT.getName()}));
        }
        if (cli.hasOption((IOptionKey)OPT_CURRENT) && cli.getOptions(ChangesetCommonOptions.OPT_CHANGESETS.getId()).size() > 1) {
            throw StatusHelper.argSyntax((String)Messages.ChangesetSetCmd_ONE_CURRENT_HELP);
        }
        int successCount = 0;
        try {
            List csSelectors;
            if (cli.hasOption((IOptionKey)OPT_COMPLETE)) {
                ChangesetCompleteCmd.setComplete(this.config);
                ++successCount;
            }
            if (cli.hasOption((IOptionKey)OPT_CURRENT)) {
                ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
                csSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(ChangesetCommonOptions.OPT_CHANGESETS.getId()), (IScmClientConfiguration)this.config);
                SubcommandUtil.validateArgument((List)csSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
                ChangesetCurrentCmd.setCurrent((IScmCommandLineArgument)wsSelector, (IScmCommandLineArgument)csSelectors.get(0), this.config);
                ++successCount;
            }
            if (cli.hasOption((IOptionKey)OPT_COMMENT)) {
                String comment = cli.getOption(OPT_COMMENT.getId());
                csSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(ChangesetCommonOptions.OPT_CHANGESETS.getId()), (IScmClientConfiguration)this.config);
                ChangesetCommentCmd.setComment(comment, csSelectors, this.config);
                ++successCount;
            }
        }
        finally {
            if (successCount == 1) {
                if (cli.hasOption((IOptionKey)OPT_COMPLETE)) {
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetSetCmd_Success1, (Object)Messages.ChangesetSetCmd_Complete));
                } else if (cli.hasOption((IOptionKey)OPT_CURRENT)) {
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetSetCmd_Success1, (Object)Messages.ChangesetSetCmd_Current));
                } else {
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetSetCmd_Success1, (Object)Messages.ChangesetSetCmd_Comment));
                }
            } else if (successCount == 2) {
                if (cli.hasOption((IOptionKey)OPT_COMPLETE)) {
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetSetCmd_Success2, (Object)Messages.ChangesetSetCmd_Comment, (Object)Messages.ChangesetSetCmd_Complete));
                } else {
                    this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetSetCmd_Success2, (Object)Messages.ChangesetSetCmd_Comment, (Object)Messages.ChangesetSetCmd_Current));
                }
            }
        }
    }
}

