/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetRelocateCmdOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangesToRelocate;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRelocateChanges;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ChangesetRelocateCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetRelocateCmdOptions.OPT_DST_CHANGESET.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ParmsWorkspace ws = null;
        ITeamRepository repo = null;
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(csSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        }
        ChangeSetSyncDTO targetCsDTO = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (boolean)false, (String)ws.workspaceItemId, (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (!targetCsDTO.isIsActive()) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetRelocateCmd_CS_NOT_ACTIVE, (Object)csSelector.getItemSelector()));
        }
        List selectors = cli.getOptions(ChangesetRelocateCmdOptions.OPT_CHANGES.getId());
        HashSet<String> absSelectorPaths = new HashSet<String>();
        HashMap<String, String> selectorToChangeIdMap = new HashMap<String, String>();
        for (String selector : selectors) {
            IUuidAliasRegistry.IUuidAlias uuidAlias = RepoUtil.lookupUuidAndAlias((String)selector);
            if (uuidAlias == null) {
                ILocation absPath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)selector);
                if (!SubcommandUtil.exists((ILocation)absPath, null)) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_DOES_NOT_EXIST, (Object)selector));
                }
                absSelectorPaths.add(absPath.toOSString());
                continue;
            }
            if (selectorToChangeIdMap.values().contains(uuidAlias.getUuid().getUuidValue())) continue;
            selectorToChangeIdMap.put(selector, uuidAlias.getUuid().getUuidValue());
        }
        HashMap<Object, ResourcePropertiesDTO> resourceProperties = new HashMap<Object, ResourcePropertiesDTO>(absSelectorPaths.size());
        ResourcesDTO resourcesDTO = null;
        if (absSelectorPaths.size() > 0) {
            ParmsResourceProperties parms = new ParmsResourceProperties(false, absSelectorPaths.toArray(new String[absSelectorPaths.size()]));
            try {
                resourcesDTO = client.postFetchResourceProperties(parms, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.PropertyListCmd_CouldNotFetchProperty, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
            }
            for (ResourcePropertiesDTO dto : resourcesDTO.getResourceProperties()) {
                if (dto.getShare() == null) {
                    throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_PATH_NOT_SHARED, (Object)dto.getFullPath()));
                }
                if (!dto.getShare().getContextItemId().equals(ws.workspaceItemId) || !dto.getShare().getComponentItemId().equals(targetCsDTO.getComponentItemId())) {
                    throw StatusHelper.argSyntax((String)Messages.ChangesetRelocateCmd_9);
                }
                String fullPath = dto.getFullPath();
                resourceProperties.put(fullPath, dto);
            }
        }
        SyncViewDTO syncView = SubcommandUtil.getSyncView(Collections.singletonList(ws), (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ArrayList<String> activeChangeSets = new ArrayList<String>();
        for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
            if (!wsSync.getWorkspaceItemId().equals(ws.workspaceItemId)) continue;
            for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                if (!compSync.getComponentItemId().equals(targetCsDTO.getComponentItemId())) continue;
                for (ChangeSetSyncDTO changeSetSync : compSync.getOutgoingChangeSetsAfterBasis()) {
                    if (!changeSetSync.isIsActive()) continue;
                    activeChangeSets.add(changeSetSync.getChangeSetItemId());
                }
            }
        }
        ChangeSetSyncDTO[] csDTOList = RepoUtil.findChangeSets(activeChangeSets, (boolean)true, (String)ws.workspaceItemId, (String)"workspace", (String)ws.repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        HashMap<String, List<String>> csToChangesMap = new HashMap<String, List<String>>();
        ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOList;
        int changeSetSync = csDTOList.length;
        int n = 0;
        while (n < changeSetSync) {
            ChangeSetSyncDTO changeSetSync2 = changeSetSyncDTOArray[n];
            for (ChangeFolderSyncDTO changeFolderSync : changeSetSync2.getChanges()) {
                for (ChangeSyncDTO changeSync : changeFolderSync.getChanges()) {
                    ArrayList<String> changes = (ArrayList<String>)csToChangesMap.get(changeSetSync2.getChangeSetItemId());
                    if (changes == null) {
                        changes = new ArrayList<String>();
                        csToChangesMap.put(changeSetSync2.getChangeSetItemId(), changes);
                    }
                    changes.add(changeSync.getVersionableItemId());
                }
            }
            ++n;
        }
        HashMap<String, List<String>> csToChangesRelocateMap = new HashMap<String, List<String>>();
        if (resourcesDTO != null) {
            for (ResourcePropertiesDTO dto : resourcesDTO.getResourceProperties()) {
                if (this.findChangeAndAdd(csToChangesMap, csToChangesRelocateMap, dto.getItemId())) continue;
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetRelocateCmd_7, (Object)dto.getFullPath()));
            }
        }
        for (Map.Entry entry : selectorToChangeIdMap.entrySet()) {
            if (this.findChangeAndAdd(csToChangesMap, csToChangesRelocateMap, (String)entry.getValue())) continue;
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetRelocateCmd_7, entry.getKey()));
        }
        ParmsRelocateChanges parmsRelocate = new ParmsRelocateChanges();
        parmsRelocate.workspace = ws;
        parmsRelocate.targetChangeSetItemId = targetCsDTO.getChangeSetItemId();
        ArrayList<ParmsChangesToRelocate> parmsChanges = new ArrayList<ParmsChangesToRelocate>();
        for (Map.Entry entry : csToChangesRelocateMap.entrySet()) {
            for (String change : (List)entry.getValue()) {
                ParmsChangesToRelocate parmsChange = new ParmsChangesToRelocate();
                parmsChange.changeSetItemId = (String)entry.getKey();
                parmsChange.versionableItemId = change;
                parmsChanges.add(parmsChange);
            }
        }
        parmsRelocate.changesToRelocate = parmsChanges.toArray(new ParmsChangesToRelocate[parmsChanges.size()]);
        if (this.config.isDryRun()) {
            return;
        }
        try {
            client.postRelocateChanges(parmsRelocate, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetRelocateCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream());
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetRelocateCmd_5);
    }

    private boolean findChangeAndAdd(Map<String, List<String>> csToChangesMap, Map<String, List<String>> csToChangesRelocateMap, String changeId) {
        boolean found = false;
        for (Map.Entry<String, List<String>> entry : csToChangesMap.entrySet()) {
            if (!entry.getValue().contains(changeId)) continue;
            List<String> changes = csToChangesRelocateMap.get(entry.getKey());
            if (changes == null) {
                changes = new ArrayList<String>();
                csToChangesRelocateMap.put(entry.getKey(), changes);
            }
            changes.add(changeId);
            found = true;
            break;
        }
        return found;
    }
}

