/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.util.ChangeSetUtil;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.AliasUtil;
import com.ibm.team.filesystem.cli.core.util.ChangeSetStateFactory;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.JSONPrintUtil;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.common.internal.rest.client.core.BaselineDTO;
import com.ibm.team.filesystem.common.internal.rest.client.patch.ChangeSetSourceDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.ITeamArea;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.json.JSONArray;
import com.ibm.team.repository.common.json.JSONObject;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IOptionSource;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ContinuousGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.INamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IPositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.MutuallyExclusiveGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.NamedOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.Options;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.PositionalOptionDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.SimpleGroup;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.exceptions.ConflictingOptionException;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IBaseline;
import com.ibm.team.scm.common.IBaselineSet;
import com.ibm.team.scm.common.IWorkspace;
import com.ibm.team.scm.common.internal.rest.dto.WorkspaceListDTO;
import com.ibm.team.scm.common.internal.rest.dto.WorkspaceListItemDTO;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSetLocationsEntry;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSetLocationsEntry2;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSetLocationsEntry3;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmChangeSetLocationsResult;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.osgi.util.NLS;

public class ChangesetLocateCmd
extends AbstractSubcommand
implements IOptionSource {
    public static final PositionalOptionDefinition OPT_SELECTORS = new PositionalOptionDefinition("selectors", 1, -1, "@");
    public static final NamedOptionDefinition OPT_CHANGESETS = new NamedOptionDefinition("C", "change-sets", 0);
    public static final NamedOptionDefinition OPT_WORKITEMS = new NamedOptionDefinition("W", "workitems", 0);
    public static final NamedOptionDefinition OPT_WORKITEMS_ALL = new NamedOptionDefinition(null, "include-child-workitems", 0);
    public static final NamedOptionDefinition OPT_WORKSPACES = new NamedOptionDefinition("w", "workspaces", -1, "@");
    public static final NamedOptionDefinition OPT_SNAPSHOTS = new NamedOptionDefinition("s", "snapshots", -1, "@");
    public static final NamedOptionDefinition OPT_BASELINES = new NamedOptionDefinition("b", "baselines", -1, "@");
    public static final NamedOptionDefinition OPT_PROJECTAREA = new NamedOptionDefinition(null, "projectarea", 1, "@");
    public static final NamedOptionDefinition OPT_TEAMAREA = new NamedOptionDefinition(null, "teamarea", 1, "@");
    public static final NamedOptionDefinition OPT_RELATED_CHANGESETS = new NamedOptionDefinition(null, "include-related", 0);
    protected ChangeSetUtil csUtil = new ChangeSetUtil();

    public Options getOptions() throws ConflictingOptionException {
        Options options = new Options(false, true);
        SubcommandUtil.addRepoLocationToOptions((Options)options);
        options.addOption((INamedOptionDefinition)CommonOptions.OPT_JSON, Messages.Common_JSON_OUTPUT).addOption((INamedOptionDefinition)CommonOptions.OPT_VERBOSE, CommonOptions.OPT_VERBOSE_HELP).addOption((INamedOptionDefinition)OPT_RELATED_CHANGESETS, Messages.ChangesetLocateCmdOptions_OPT_RELATED_HELP).addOption((IOptionGroup)new ContinuousGroup(true).addOption((INamedOptionDefinition)OPT_WORKSPACES, Messages.ChangesetLocateCmdOptions_WORKSPACE_HELP, false).addOption((INamedOptionDefinition)OPT_SNAPSHOTS, Messages.ChangesetLocateCmdOptions_SNAPSHOT_HELP, false).addOption((INamedOptionDefinition)OPT_BASELINES, Messages.ChangesetLocateCmd_BASELINE_HELP, false).addOption(new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_PROJECTAREA, Messages.ChangesetLocateCmdOptions_PROJECTAREA_HELP, false).addOption((INamedOptionDefinition)OPT_TEAMAREA, Messages.ChangesetLocateCmdOptions_TEAMAREA_HELP, false))).addOption((IOptionGroup)new MutuallyExclusiveGroup().addOption((INamedOptionDefinition)OPT_CHANGESETS, Messages.ChangesetLocateCmdOptions_OPT_CHANGESETS_HELP, false).addOption(new SimpleGroup(false).addOption((INamedOptionDefinition)OPT_WORKITEMS, Messages.ChangesetLocateCmdOptions_OPT_WORKITEMS_HELP, true).addOption((INamedOptionDefinition)OPT_WORKITEMS_ALL, NLS.bind((String)Messages.ChangesetLocateCmdOptions_OPT_WORKITEMS_ALL_HELP, (Object)OPT_WORKITEMS.getName()), false))).addOption((INamedOptionDefinition)CommonOptions.OPT_POSITIONAL_ARG_SEPARATOR, NLS.bind((String)Messages.PositionalArgSeparator_Help, (Object)OPT_SELECTORS.getName())).addOption((IPositionalOptionDefinition)OPT_SELECTORS, NLS.bind((String)Messages.ChangesetLocateCmdOptions_OPT_CS_WI_HELP, (Object)OPT_CHANGESETS.getName(), (Object)OPT_WORKITEMS.getName()));
        return options;
    }

    public void run() throws FileSystemException {
        List selectors;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        this.config.setEnableJSON(cli.hasOption((IOptionKey)CommonOptions.OPT_JSON));
        if (!(cli.hasOption((IOptionKey)OPT_PROJECTAREA) || cli.hasOption((IOptionKey)OPT_TEAMAREA) || cli.hasOption((IOptionKey)OPT_BASELINES) || cli.hasOption((IOptionKey)OPT_SNAPSHOTS) || cli.hasOption((IOptionKey)OPT_WORKSPACES))) {
            throw StatusHelper.argSyntax((String)Messages.ChangesetLocateCmd_SPECIFY_TARGET);
        }
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA) && cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_SPECIFY_1_OF_2_ARGUMENTS, (Object)cli.getDefinition().getOption((IOptionKey)OPT_PROJECTAREA).getName(), (Object)cli.getDefinition().getOption((IOptionKey)OPT_TEAMAREA).getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS_ALL) && !cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.ChangesetLocateCmd_WI_ALL_ONLY_FOR_WORKITEMS, (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS_ALL).getName(), (Object)cli.getDefinition().getOption((IOptionKey)OPT_WORKITEMS).getName()));
        }
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            selectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SELECTORS), (IScmClientConfiguration)this.config, (boolean)false);
            SubcommandUtil.validateArgument((List)selectors, (RepoUtil.ItemType)RepoUtil.ItemType.WORKITEM);
        } else {
            selectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SELECTORS), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((List)selectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        }
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        if (cli.hasOption((IOptionKey)CommonOptions.OPT_URI)) {
            String repoUri = cli.getOption((IOptionKey)CommonOptions.OPT_URI);
            repo = RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(repoUri));
            this.csUtil.repoStrToRepo.put(repoUri, repo);
        }
        this.validateArgumentRepoAndLogin(cli, client, this.config);
        Map<String, ChangeSetSyncDTO> csList = null;
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            csList = this.csUtil.getChangeSetsFromWorkitem(selectors, repo, client, this.config, cli.hasOption((IOptionKey)OPT_WORKITEMS_ALL));
            if (csList == null || csList.size() == 0) {
                this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetLocateCmd_CS_NOT_FOUND_FOR_WI);
                return;
            }
        } else {
            csList = this.csUtil.getChangeSets(selectors, repo, client, this.config);
        }
        Map<ITeamRepository, Map<String, IWorkspace>> repoToWsList = this.getWorkspaces(cli, repo, client, this.config);
        Map<ITeamRepository, Map<String, IBaselineSet>> repoToSsList = this.getSnapshots(cli, repo, client, this.config);
        Map<ITeamRepository, Map<String, IBaseline>> repoToBlList = this.getBaselines(cli, repo, client, this.config);
        boolean hasWs = false;
        boolean hasSs = false;
        boolean hasBl = false;
        for (Map.Entry<ITeamRepository, Map<String, IWorkspace>> entry : repoToWsList.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
            hasWs = true;
            break;
        }
        for (Map.Entry<ITeamRepository, Map<String, IWorkspace>> entry : repoToSsList.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
            hasSs = true;
            break;
        }
        for (Map.Entry<ITeamRepository, Map<String, IWorkspace>> entry : repoToBlList.entrySet()) {
            if (entry.getValue() == null || entry.getValue().size() <= 0) continue;
            hasBl = true;
            break;
        }
        if (!(hasWs || hasSs || hasBl)) {
            this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetLocateCmd_NO_TARGETS_FOUND);
            return;
        }
        HashSet<ITeamRepository> hashSet = new HashSet<ITeamRepository>();
        if (repoToWsList.size() > 0) {
            hashSet.addAll(repoToWsList.keySet());
        }
        if (repoToSsList.size() > 0) {
            hashSet.addAll(repoToSsList.keySet());
        }
        if (repoToBlList.size() > 0) {
            hashSet.addAll(repoToBlList.keySet());
        }
        HashMap<ITeamRepository, List<ScmChangeSetLocationsEntry>> repoToCsLocEntryList = new HashMap<ITeamRepository, List<ScmChangeSetLocationsEntry>>();
        for (ITeamRepository locateInRepo : hashSet) {
            Map<String, IWorkspace> wsList = repoToWsList.get(locateInRepo);
            Map<String, IBaselineSet> ssList = repoToSsList.get(locateInRepo);
            Map<String, IBaseline> blList = repoToBlList.get(locateInRepo);
            List<ScmChangeSetLocationsEntry> csLocEntryList = this.locateChangeSets(csList.keySet(), wsList != null ? wsList.keySet() : null, ssList != null ? ssList.keySet() : null, blList != null ? blList.keySet() : null, locateInRepo, this.config);
            if (csLocEntryList == null) continue;
            repoToCsLocEntryList.put(locateInRepo, csLocEntryList);
        }
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.enablePrinter(4);
        if (cli.hasOption((IOptionKey)OPT_RELATED_CHANGESETS)) {
            options.enablePrinter(31);
        }
        if (cli.hasOption((IOptionKey)OPT_WORKITEMS)) {
            options.enablePrinter(22);
        }
        JSONArray itemArray = new JSONArray();
        for (Map.Entry entry : repoToCsLocEntryList.entrySet()) {
            if (entry.getValue() == null) continue;
            Map<String, IWorkspace> wsList = repoToWsList.get(entry.getKey());
            Map<String, IBaselineSet> ssList = repoToSsList.get(entry.getKey());
            Map<String, IBaseline> blList = repoToBlList.get(entry.getKey());
            JSONArray repoItemArray = this.jsonizeCsLocEntries((List)entry.getValue(), (ITeamRepository)entry.getKey(), client, this.config, csList, wsList, ssList, blList, cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), options);
            itemArray.addAll((Collection)repoItemArray);
        }
        if (this.config.isJSONEnabled()) {
            if (itemArray.size() > 0) {
                JSONObject entriesObj = new JSONObject();
                entriesObj.put((Object)"entries", (Object)itemArray);
                this.config.getOutputStream().print((CharSequence)entriesObj.toString());
            }
        } else {
            this.printCsLocEntries(itemArray, (IClientConfiguration)this.config, this.config.getWrappedOutputStream(), cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE), options);
        }
    }

    private void validateArgumentRepoAndLogin(ICommandLine cli, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        List csWiSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SELECTORS), (IScmClientConfiguration)config);
        this.csUtil.validateRepoAndLogin(csWiSelectors, client, config, cli, true);
        if (cli.hasOption((IOptionKey)OPT_WORKSPACES)) {
            List wsSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_WORKSPACES), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(wsSelectors, client, config, cli, true);
        }
        if (cli.hasOption((IOptionKey)OPT_SNAPSHOTS)) {
            List ssSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SNAPSHOTS), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(ssSelectors, client, config, cli, true);
        }
        if (cli.hasOption((IOptionKey)OPT_BASELINES)) {
            List blSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_BASELINES), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(blSelectors, client, config, cli, true);
        }
        ScmCommandLineArgument projAreaSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROJECTAREA, null), (IScmClientConfiguration)config);
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA)) {
            this.csUtil.validateRepoAndLogin(Collections.singletonList(projAreaSelector), client, config, cli, true);
        }
        if (cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            ScmCommandLineArgument teamAreaSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_TEAMAREA), (IScmClientConfiguration)config);
            this.csUtil.validateRepoAndLogin(Collections.singletonList(teamAreaSelector), client, config, cli, projAreaSelector == null);
        }
    }

    private void getRelatedChangeSets(List<ScmChangeSetLocationsEntry> csLocEntryList, String repoUri, IFilesystemRestClient client, Map<String, ChangeSetSyncDTO> csList) throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)OPT_RELATED_CHANGESETS)) {
            ChangeSetSyncDTO[] csDTOList;
            ArrayList<String> csIdList = new ArrayList<String>();
            if (csLocEntryList != null) {
                for (ScmChangeSetLocationsEntry csLocEntry : csLocEntryList) {
                    String csId = csLocEntry.getChangeSetItemId();
                    if (csList.containsKey(csId)) continue;
                    csIdList.add(csId);
                }
            }
            if (csIdList.size() > 0 && (csDTOList = RepoUtil.findChangeSets(csIdList, (boolean)false, null, null, (String)repoUri, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config)) != null) {
                ChangeSetSyncDTO[] changeSetSyncDTOArray = csDTOList;
                int n = csDTOList.length;
                int n2 = 0;
                while (n2 < n) {
                    ChangeSetSyncDTO csDTO = changeSetSyncDTOArray[n2];
                    String csId = csDTO.getChangeSetItemId();
                    if (!csList.containsKey(csId)) {
                        csList.put(csId, csDTO);
                    }
                    ++n2;
                }
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private Map<ITeamRepository, Map<String, IWorkspace>> getWorkspaces(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, Map<String, IWorkspace>> repoToWsList = new HashMap<ITeamRepository, Map<String, IWorkspace>>();
        if (cli.hasOption((IOptionKey)OPT_WORKSPACES)) {
            List wsSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_WORKSPACES), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((List)wsSelectors, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            HashMap<ITeamRepository, ArrayList<String>> repoToWsSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
            for (IScmCommandLineArgument iScmCommandLineArgument : wsSelectors) {
                ArrayList<String> wsList;
                ITeamRepository wsRepo = repo;
                if (iScmCommandLineArgument.getRepositorySelector() != null) {
                    wsRepo = this.csUtil.repoStrToRepo.get(iScmCommandLineArgument.getRepositorySelector());
                }
                if ((wsList = (ArrayList<String>)repoToWsSelectors.get(wsRepo)) == null) {
                    wsList = new ArrayList<String>();
                    repoToWsSelectors.put(wsRepo, wsList);
                }
                wsList.add(iScmCommandLineArgument.getItemSelector());
            }
            for (Map.Entry entry : repoToWsSelectors.entrySet()) {
                Map<String, IWorkspace> wsList = this.getWorkspacesFromRepo((List)entry.getValue(), (ITeamRepository)entry.getKey(), config);
                repoToWsList.put((ITeamRepository)entry.getKey(), wsList);
            }
        }
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA) || cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            ArrayList<IWorkspace> workspaces = new ArrayList<IWorkspace>();
            ITeamRepository processAreaRepo = this.getWorkspacesFromProcessArea(cli, workspaces, repo, config);
            Map map = (Map)repoToWsList.get(processAreaRepo);
            if (map == null) {
                HashMap hashMap = new HashMap();
                repoToWsList.put(processAreaRepo, hashMap);
            }
            for (IWorkspace ws : workspaces) {
                void var8_14;
                if (!var8_14.containsKey(ws.getItemId().getUuidValue())) {
                    var8_14.put(ws.getItemId().getUuidValue(), ws);
                }
                if (var8_14.keySet().size() >= 512) break;
            }
        }
        return repoToWsList;
    }

    private Map<String, IWorkspace> getWorkspacesFromRepo(List<String> wsSelectors, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        HashMap<String, IWorkspace> wsList = new HashMap<String, IWorkspace>();
        for (String wsSelector : wsSelectors) {
            IWorkspace ws;
            IUuidAliasRegistry.IUuidAlias wsAlias;
            WorkspaceListDTO result = RepoUtil.getWorkspacesByName((String)wsSelector, (boolean)true, (boolean)true, (boolean)true, (int)512, (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (result != null) {
                for (WorkspaceListItemDTO wsItem : result.getItems()) {
                    IWorkspace ws2 = wsItem.getWorkspace();
                    if (wsList.containsKey(ws2.getItemId().getUuidValue())) continue;
                    wsList.put(ws2.getItemId().getUuidValue(), ws2);
                }
            }
            if ((wsAlias = RepoUtil.lookupUuidAndAlias((String)wsSelector, (String)repo.getRepositoryURI())) != null && (ws = RepoUtil.getWorkspaceById((String)wsAlias.getUuid().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config)) != null && !wsList.containsKey(ws.getItemId().getUuidValue())) {
                wsList.put(ws.getItemId().getUuidValue(), ws);
            }
            if (wsList.keySet().size() == 0) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetLocateCmd_WORKSPACE_NOT_FOUND, (Object)wsSelector));
            }
            if (wsList.keySet().size() >= 512) break;
        }
        return wsList;
    }

    private ITeamRepository getWorkspacesFromProcessArea(ICommandLine cli, List<IWorkspace> workspaces, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IProjectArea projectArea = null;
        ITeamRepository processAreaRepo = repo;
        if (cli.hasOption((IOptionKey)OPT_PROJECTAREA)) {
            ScmCommandLineArgument projAreaSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_PROJECTAREA), (IScmClientConfiguration)config);
            if (projAreaSelector.getRepositorySelector() != null) {
                processAreaRepo = this.csUtil.repoStrToRepo.get(projAreaSelector.getRepositorySelector());
            }
            if ((projectArea = RepoUtil.getProjectArea((ITeamRepository)processAreaRepo, (String)projAreaSelector.getItemSelector(), (IScmClientConfiguration)config)) == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_NOPROJECTAREA, (Object)projAreaSelector.getItemSelector()));
            }
        }
        ITeamArea teamArea = null;
        if (cli.hasOption((IOptionKey)OPT_TEAMAREA)) {
            ScmCommandLineArgument teamAreaSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue((IOptionKey)OPT_TEAMAREA), (IScmClientConfiguration)config);
            if (processAreaRepo == null) {
                processAreaRepo = repo;
                if (teamAreaSelector.getRepositorySelector() != null) {
                    processAreaRepo = this.csUtil.repoStrToRepo.get(teamAreaSelector.getRepositorySelector());
                }
            }
            if ((teamArea = RepoUtil.getTeamArea((String)teamAreaSelector.getItemSelector(), (IProjectArea)projectArea, (IScmClientConfiguration)config, (ITeamRepository)processAreaRepo)) == null) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ListCmd_TeamAreaNotFound, (Object)teamAreaSelector.getItemSelector()));
            }
        }
        RepoUtil.getWorkspacesByName((String)"*", (IProjectArea)projectArea, teamArea, null, (int)512, (boolean)false, (boolean)true, (boolean)false, (ITeamRepository)processAreaRepo, workspaces, (IScmClientConfiguration)config);
        return processAreaRepo;
    }

    private Map<ITeamRepository, Map<String, IBaselineSet>> getSnapshots(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, Map<String, IBaselineSet>> repoToSsList = new HashMap<ITeamRepository, Map<String, IBaselineSet>>();
        if (cli.hasOption((IOptionKey)OPT_SNAPSHOTS)) {
            List ssSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_SNAPSHOTS), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((List)ssSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.SNAPSHOT);
            HashMap<ITeamRepository, ArrayList<String>> repoToSsSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
            for (IScmCommandLineArgument iScmCommandLineArgument : ssSelectors) {
                ArrayList<String> ssList;
                ITeamRepository ssRepo = repo;
                if (iScmCommandLineArgument.getRepositorySelector() != null) {
                    ssRepo = this.csUtil.repoStrToRepo.get(iScmCommandLineArgument.getRepositorySelector());
                }
                if ((ssList = (ArrayList<String>)repoToSsSelectors.get(ssRepo)) == null) {
                    ssList = new ArrayList<String>();
                    repoToSsSelectors.put(ssRepo, ssList);
                }
                ssList.add(iScmCommandLineArgument.getItemSelector());
            }
            for (Map.Entry entry : repoToSsSelectors.entrySet()) {
                Map<String, IBaselineSet> ssList = this.getSnapshotsFromRepo((List)entry.getValue(), (ITeamRepository)entry.getKey(), config);
                repoToSsList.put((ITeamRepository)entry.getKey(), ssList);
            }
        }
        return repoToSsList;
    }

    private Map<String, IBaselineSet> getSnapshotsFromRepo(List<String> ssSelectors, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        HashMap<String, IBaselineSet> ssList = new HashMap<String, IBaselineSet>();
        for (String ssSelector : ssSelectors) {
            IUuidAliasRegistry.IUuidAlias ssAlias;
            List result = RepoUtil.getSnapshotByName(null, (String)ssSelector, (boolean)false, (int)512, (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (result != null && result.size() > 0) {
                for (IBaselineSet ssItem : result) {
                    ssList.put(ssItem.getItemId().getUuidValue(), ssItem);
                }
            }
            if ((ssAlias = RepoUtil.lookupUuidAndAlias((String)ssSelector, (String)repo.getRepositoryURI())) != null) {
                IBaselineSet ss = null;
                try {
                    ss = RepoUtil.getSnapshotById((String)ssAlias.getUuid().getUuidValue(), (ITeamRepository)repo, (IScmClientConfiguration)config);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (ss != null && !ssList.containsKey(ss.getItemId().getUuidValue())) {
                    ssList.put(ss.getItemId().getUuidValue(), ss);
                }
            }
            if (ssList.keySet().size() == 0) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetLocateCmd_SNAPSHOT_NOT_FOUND, (Object)ssSelector));
            }
            if (ssList.keySet().size() >= 512) break;
        }
        return ssList;
    }

    private Map<ITeamRepository, Map<String, IBaseline>> getBaselines(ICommandLine cli, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<ITeamRepository, Map<String, IBaseline>> repoToBlList = new HashMap<ITeamRepository, Map<String, IBaseline>>();
        if (cli.hasOption((IOptionKey)OPT_BASELINES)) {
            List blSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)OPT_BASELINES), (IScmClientConfiguration)config);
            SubcommandUtil.validateArgument((List)blSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.BASELINE);
            HashMap<ITeamRepository, ArrayList<String>> repoToBlSelectors = new HashMap<ITeamRepository, ArrayList<String>>();
            for (IScmCommandLineArgument iScmCommandLineArgument : blSelectors) {
                ArrayList<String> blList;
                ITeamRepository blRepo = repo;
                if (iScmCommandLineArgument.getRepositorySelector() != null) {
                    blRepo = this.csUtil.repoStrToRepo.get(iScmCommandLineArgument.getRepositorySelector());
                }
                if ((blList = (ArrayList<String>)repoToBlSelectors.get(blRepo)) == null) {
                    blList = new ArrayList<String>();
                    repoToBlSelectors.put(blRepo, blList);
                }
                blList.add(iScmCommandLineArgument.getItemSelector());
            }
            for (Map.Entry entry : repoToBlSelectors.entrySet()) {
                Map<String, IBaseline> blList = this.getBaselinesFromRepo((List)entry.getValue(), (ITeamRepository)entry.getKey(), client, config);
                repoToBlList.put((ITeamRepository)entry.getKey(), blList);
            }
        }
        return repoToBlList;
    }

    private Map<String, IBaseline> getBaselinesFromRepo(List<String> baselineSelectors, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        HashMap<String, IBaseline> blList = new HashMap<String, IBaseline>();
        for (String blSelector : baselineSelectors) {
            IUuidAliasRegistry.IUuidAlias blAlias = RepoUtil.lookupUuidAndAlias((String)blSelector, (String)repo.getRepositoryURI());
            if (blAlias != null) {
                IBaseline baseline = null;
                try {
                    BaselineDTO blDTO = RepoUtil.getBaselineById((String)blAlias.getUuid().getUuidValue(), (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
                    if (blDTO != null) {
                        baseline = (IBaseline)RepoUtil.getItem((IItemType)IBaseline.ITEM_TYPE, (UUID)UUID.valueOf((String)blDTO.getItemId()), (ITeamRepository)repo, (IScmClientConfiguration)config);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (baseline != null && !blList.containsKey(baseline.getItemId().getUuidValue())) {
                    blList.put(baseline.getItemId().getUuidValue(), baseline);
                }
            }
            if (blList.keySet().size() == 0) {
                throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetLocateCmd_BASELINE_NOT_FOUND, (Object)blSelector));
            }
            if (blList.keySet().size() >= 512) break;
        }
        return blList;
    }

    private List<ScmChangeSetLocationsEntry> locateChangeSets(Set<String> csIds, Set<String> wsIds, Set<String> ssIds, Set<String> blIds, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IScmRichClientRestService.ParmsGetChangeSetLocations parms = new IScmRichClientRestService.ParmsGetChangeSetLocations();
        parms.changeSetItemIds = csIds.toArray(new String[csIds.size()]);
        if (wsIds != null && wsIds.size() > 0) {
            parms.workspaceItemIds = wsIds.toArray(new String[wsIds.size()]);
        }
        if (ssIds != null && ssIds.size() > 0) {
            parms.snapshotItemIds = ssIds.toArray(new String[ssIds.size()]);
        }
        if (blIds != null && blIds.size() > 0) {
            parms.baselineItemIds = blIds.toArray(new String[blIds.size()]);
        }
        ICommandLine cli = config.getSubcommandCommandLine();
        parms.includePorts = cli.hasOption((IOptionKey)OPT_RELATED_CHANGESETS);
        ScmChangeSetLocationsResult result = null;
        try {
            result = scmService.postGetChangeSetLocations(parms);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListChangesetsCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
        if (result != null) {
            return result.getEntries();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private JSONArray jsonizeCsLocEntries(List<ScmChangeSetLocationsEntry> csLocEntryList, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config, Map<String, ChangeSetSyncDTO> csList, Map<String, IWorkspace> wsList, Map<String, IBaselineSet> ssList, Map<String, IBaseline> blList, boolean verbose, PendingChangesUtil.PendingChangesOptions options) throws FileSystemException {
        JSONObject itemObj;
        HashMap<String, List<String>> wsToCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> ssToCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> blToCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> wsToRelCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> ssToRelCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> blToRelCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> wsToIncCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> ssToIncCsMap = new HashMap<String, List<String>>();
        HashMap<String, List<String>> blToIncCsMap = new HashMap<String, List<String>>();
        for (ScmChangeSetLocationsEntry scmChangeSetLocationsEntry : csLocEntryList) {
            this.groupChangeSets(scmChangeSetLocationsEntry.getWorkspaceItemIds(), wsToCsMap, wsToRelCsMap, wsToIncCsMap, scmChangeSetLocationsEntry, csList, csLocEntryList);
            this.groupChangeSets(scmChangeSetLocationsEntry.getSnapshotItemIds(), ssToCsMap, ssToRelCsMap, ssToIncCsMap, scmChangeSetLocationsEntry, csList, csLocEntryList);
            if (!(scmChangeSetLocationsEntry instanceof ScmChangeSetLocationsEntry3)) continue;
            this.groupChangeSets(((ScmChangeSetLocationsEntry3)scmChangeSetLocationsEntry).getBaselineItemIds(), blToCsMap, blToRelCsMap, blToIncCsMap, scmChangeSetLocationsEntry, csList, csLocEntryList);
        }
        if (wsList != null) {
            for (Map.Entry<String, IWorkspace> entry : wsList.entrySet()) {
                this.fillEmptyTarget(entry.getKey(), wsToCsMap, wsToRelCsMap);
            }
        }
        Object var20_31 = null;
        if (ssList != null) {
            Map map = RepoUtil.getJsonizedSnapshotOwner((ITeamRepository)repo, (IScmClientConfiguration)config, new ArrayList<IBaselineSet>(ssList.values()));
            for (Map.Entry<String, IBaseline> entry : ssList.entrySet()) {
                this.fillEmptyTarget(entry.getKey(), ssToCsMap, ssToRelCsMap);
            }
        }
        if (blList != null) {
            for (Map.Entry<String, IBaseline> entry : blList.entrySet()) {
                this.fillEmptyTarget(entry.getKey(), blToCsMap, blToRelCsMap);
            }
        }
        JSONArray jSONArray = new JSONArray();
        int totalCs = csList.size();
        String repoUri = repo.getRepositoryURI();
        this.getRelatedChangeSets(csLocEntryList, repoUri, client, csList);
        for (Map.Entry entry : wsToCsMap.entrySet()) {
            String wsId = (String)entry.getKey();
            if (wsList == null || !wsList.containsKey(wsId)) continue;
            IWorkspace ws = wsList.get(wsId);
            itemObj = this.jsonizeItem(client, config, ws.getName(), ws.getItemId().getUuidValue(), repoUri, totalCs, (List)entry.getValue(), (List)wsToRelCsMap.get(wsId), (List)wsToIncCsMap.get(wsId), csList, ws.isStream() ? RepoUtil.ItemType.STREAM : RepoUtil.ItemType.WORKSPACE, verbose, options, null);
            jSONArray.add((Object)itemObj);
        }
        for (Map.Entry entry : ssToCsMap.entrySet()) {
            void var20_33;
            String ssId = (String)entry.getKey();
            if (ssList == null || !ssList.containsKey(ssId)) continue;
            IBaselineSet ss = ssList.get(ssId);
            String ssOwnerId = ss.getOwner().getItemId().getUuidValue();
            JSONObject ssOwner = var20_33 != null ? (JSONObject)var20_33.get(ssOwnerId) : null;
            JSONObject itemObj2 = this.jsonizeItem(client, config, ss.getName(), ss.getItemId().getUuidValue(), repoUri, totalCs, (List)entry.getValue(), (List)ssToRelCsMap.get(ssId), (List)ssToIncCsMap.get(ssId), csList, RepoUtil.ItemType.SNAPSHOT, verbose, options, ssOwner);
            jSONArray.add((Object)itemObj2);
        }
        for (Map.Entry entry : blToCsMap.entrySet()) {
            String blId = (String)entry.getKey();
            if (blList == null || !blList.containsKey(blId)) continue;
            IBaseline bl = blList.get(blId);
            itemObj = this.jsonizeItem(client, config, bl.getName(), bl.getItemId().getUuidValue(), repoUri, totalCs, (List)entry.getValue(), (List)ssToRelCsMap.get(blId), (List)ssToIncCsMap.get(blId), csList, RepoUtil.ItemType.BASELINE, verbose, options, null);
            jSONArray.add((Object)itemObj);
        }
        return jSONArray;
    }

    private void groupChangeSets(List<String> targetIds, Map<String, List<String>> targetToCsMap, Map<String, List<String>> targetToRelCsMap, Map<String, List<String>> targetToIncCsMap, ScmChangeSetLocationsEntry csLocEntry, Map<String, ChangeSetSyncDTO> csList, List<ScmChangeSetLocationsEntry> csLocEntryList) {
        for (String targetId : targetIds) {
            String csId;
            ScmChangeSetLocationsEntry2 csLocEntry2;
            List<String> csIdList = targetToCsMap.get(targetId);
            List<String> relCsIdList = targetToRelCsMap.get(targetId);
            List<String> incCsIdList = targetToIncCsMap.get(targetId);
            if (csIdList == null) {
                csIdList = new ArrayList<String>();
                targetToCsMap.put(targetId, csIdList);
            }
            if (relCsIdList == null) {
                relCsIdList = new ArrayList<String>();
                targetToRelCsMap.put(targetId, relCsIdList);
            }
            if (incCsIdList == null) {
                incCsIdList = new ArrayList<String>();
                targetToIncCsMap.put(targetId, incCsIdList);
            }
            String portId = null;
            if (csLocEntry instanceof ScmChangeSetLocationsEntry2 && (csLocEntry2 = (ScmChangeSetLocationsEntry2)csLocEntry).getPortInfo() != null) {
                portId = csLocEntry2.getPortInfo().getOriginalPortId();
            }
            if (csList.containsKey(csId = csLocEntry.getChangeSetItemId()) && !csIdList.contains(csId)) {
                csIdList.add(csId);
            }
            for (ScmChangeSetLocationsEntry resCsLocEntry : csLocEntryList) {
                if (!(resCsLocEntry instanceof ScmChangeSetLocationsEntry2)) continue;
                ScmChangeSetLocationsEntry2 resCsLocEntry2 = (ScmChangeSetLocationsEntry2)resCsLocEntry;
                String relPortId = null;
                if (resCsLocEntry2.getPortInfo() != null) {
                    relPortId = resCsLocEntry2.getPortInfo().getOriginalPortId();
                }
                String relCsId = resCsLocEntry2.getChangeSetItemId();
                if (portId == null || !portId.equals(relPortId) || !csList.containsKey(relCsId) || csIdList.contains(relCsId) || relCsIdList.contains(relCsId)) continue;
                relCsIdList.add(relCsId);
            }
            if (incCsIdList.contains(csId)) continue;
            incCsIdList.add(csId);
        }
    }

    private void fillEmptyTarget(String targetId, Map<String, List<String>> targetToCsMap, Map<String, List<String>> targetToRelCsMap) {
        if (!targetToCsMap.containsKey(targetId)) {
            targetToCsMap.put(targetId, new ArrayList());
        }
        if (!targetToRelCsMap.containsKey(targetId)) {
            targetToRelCsMap.put(targetId, new ArrayList());
        }
    }

    private JSONObject jsonizeItem(IFilesystemRestClient client, IScmClientConfiguration config, String itemName, String itemUuid, String repoUri, int totalCs, List<String> csMatchedList, List<String> relCsMatchedList, List<String> incCsList, Map<String, ChangeSetSyncDTO> csList, RepoUtil.ItemType itemType, boolean verbose, PendingChangesUtil.PendingChangesOptions options, JSONObject owner) throws FileSystemException {
        ICommandLine cli;
        boolean includeRelated;
        JSONObject itemObj = new JSONObject();
        itemObj.put((Object)"uuid", (Object)itemUuid);
        itemObj.put((Object)"url", (Object)repoUri);
        itemObj.put((Object)"name", (Object)itemName);
        itemObj.put((Object)"type", (Object)itemType.toString());
        itemObj.put((Object)"items-total", (Object)Integer.toString(totalCs));
        itemObj.put((Object)"items-matched", (Object)Integer.toString(csMatchedList.size()));
        if (owner != null) {
            itemObj.put((Object)"ownedby", (Object)owner);
        }
        if (includeRelated = (cli = config.getSubcommandCommandLine()).hasOption((IOptionKey)OPT_RELATED_CHANGESETS)) {
            itemObj.put((Object)"rel-items-matched", (Object)Integer.toString(relCsMatchedList.size()));
        }
        if (verbose || config.isJSONEnabled()) {
            JSONArray csArray = new JSONArray();
            for (String cs : csMatchedList) {
                JSONObject csObj = new JSONObject();
                JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)csObj, (ChangeSetSyncDTO)csList.get(cs), (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
                csArray.add((Object)csObj);
            }
            itemObj.put((Object)"changesets", (Object)csArray);
            if (includeRelated) {
                HashMap<String, ChangeSetSyncDTO> incCsDTOList = new HashMap<String, ChangeSetSyncDTO>();
                for (String incCs : incCsList) {
                    ChangeSetSyncDTO incCsDTO = csList.get(incCs);
                    if (incCsDTO == null) continue;
                    incCsDTOList.put(incCs, incCsDTO);
                }
                JSONArray relCsArray = new JSONArray();
                for (String relCs : relCsMatchedList) {
                    JSONObject relCsObj = new JSONObject();
                    ChangeSetSyncDTO relCsDTO = csList.get(relCs);
                    JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)relCsObj, (ChangeSetSyncDTO)relCsDTO, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)config);
                    relCsObj.put((Object)"related", (Object)this.jsonizeRelatedItem(relCsDTO, incCsDTOList, options));
                    relCsArray.add((Object)relCsObj);
                }
                itemObj.put((Object)"rel-changesets", (Object)relCsArray);
            }
        }
        return itemObj;
    }

    private JSONObject jsonizeRelatedItem(ChangeSetSyncDTO csDTO, Map<String, ChangeSetSyncDTO> relCsList, PendingChangesUtil.PendingChangesOptions options) {
        JSONObject relCsObj = new JSONObject();
        ChangeSetSourceDTO csSourceDTO = csDTO.getOriginalSource();
        String csSourceId = csSourceDTO.getSourceId();
        for (ChangeSetSyncDTO relCsDTO : relCsList.values()) {
            String relSourceId;
            ChangeSetSourceDTO relCsSourceDTO = relCsDTO.getOriginalSource();
            if (relCsSourceDTO == null || !csSourceId.equals(relSourceId = relCsSourceDTO.getSourceId())) continue;
            JSONPrintUtil.jsonizeChangeSetHeader((JSONObject)relCsObj, (ChangeSetSyncDTO)relCsDTO, (ChangeSetStateFactory)new ChangeSetStateFactory(), (PendingChangesUtil.PendingChangesOptions)options, (IScmClientConfiguration)this.config);
            break;
        }
        return relCsObj;
    }

    private void printCsLocEntries(JSONArray itemArray, IClientConfiguration config, IndentingPrintStream out, boolean verbose, PendingChangesUtil.PendingChangesOptions options) {
        for (Object itemObj : itemArray) {
            String numRelCs;
            JSONObject item = (JSONObject)itemObj;
            String matchedCS = NLS.bind((String)Messages.ChangesetLocateCmd_DISPLAY_INCLUDED_DIRECTLY_CS, (Object)item.get((Object)"items-matched"), (Object)item.get((Object)"items-total"));
            String matchedRelCS = "";
            ICommandLine cli = config.getSubcommandCommandLine();
            boolean includeRelated = cli.hasOption((IOptionKey)OPT_RELATED_CHANGESETS);
            if (includeRelated && (numRelCs = (String)item.get((Object)"rel-items-matched")) != null) {
                matchedRelCS = NLS.bind((String)Messages.ChangesetLocateCmd_DISPLAY_INCLUDED_INDIRECTLY_CS, (Object)numRelCs, (Object)item.get((Object)"items-total"));
            }
            String ownedBy = "";
            if (item.get((Object)"ownedby") != null) {
                JSONObject owner = (JSONObject)item.get((Object)"ownedby");
                String ownerSelector = AliasUtil.selector((String)((String)owner.get((Object)"name")), (UUID)UUID.valueOf((String)((String)owner.get((Object)"uuid"))), (String)((String)owner.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.valueOf((String)((String)owner.get((Object)"type"))));
                ownedBy = NLS.bind((String)Messages.ChangesetLocateCmd_DISPLAY_OWNER, (Object)ownerSelector);
            }
            String itemSelector = AliasUtil.selector((String)((String)item.get((Object)"name")), (UUID)UUID.valueOf((String)((String)item.get((Object)"uuid"))), (String)((String)item.get((Object)"url")), (RepoUtil.ItemType)RepoUtil.ItemType.valueOf((String)((String)item.get((Object)"type"))));
            out.println((CharSequence)(String.valueOf(itemSelector) + this.appendSpaceToValueIfNonEmpty(ownedBy) + this.appendSpaceToValueIfNonEmpty(matchedCS) + this.appendSpaceToValueIfNonEmpty(matchedRelCS)));
            if (!verbose) continue;
            IndentingPrintStream csOut = out.indent();
            JSONArray csArray = (JSONArray)item.get((Object)"changesets");
            for (Object csObj : csArray) {
                JSONObject cs = (JSONObject)csObj;
                PendingChangesUtil.printChangeSetHeader((JSONObject)cs, (String)((String)item.get((Object)"url")), (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)csOut);
            }
            if (!includeRelated) continue;
            JSONArray relCsArray = (JSONArray)item.get((Object)"rel-changesets");
            for (Object csObj : relCsArray) {
                JSONObject cs = (JSONObject)csObj;
                PendingChangesUtil.printChangeSetHeader((JSONObject)cs, (String)((String)item.get((Object)"url")), (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out.indent());
                JSONObject relCs = (JSONObject)cs.get((Object)"related");
                PendingChangesUtil.printChangeSetHeader((JSONObject)relCs, (String)((String)item.get((Object)"url")), (String)Messages.ChangesetLocateCmd_RELATED, null, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)csOut.indent());
            }
        }
    }

    private String appendSpaceToValueIfNonEmpty(String value) {
        if (value != null && value.length() > 0) {
            return " " + value;
        }
        return "";
    }
}

