/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetExtractCmdOpts;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.internal.ManagedFileStore;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadFileRequest;
import com.ibm.team.filesystem.client.rest.parameters.ParmsLoadFiles;
import com.ibm.team.filesystem.client.rest.parameters.ParmsResourceProperties;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcePropertiesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.resource.ResourcesDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeFolderSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.util.IClientLibraryContext;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmIntermediateChangeNode;
import com.ibm.team.scm.common.internal.rich.rest.dto.ScmIntermediateHistory;
import com.ibm.team.scm.common.rest.IScmRichClientRestService;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.osgi.util.NLS;

public class ChangesetExtractCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)this.config);
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType[])new RepoUtil.ItemType[]{RepoUtil.ItemType.WORKSPACE, RepoUtil.ItemType.STREAM});
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(csSelector), (ITeamRepository)repo, (IScmClientConfiguration)this.config);
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            try {
                ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        ScmCommandLineArgument itemSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetExtractCmdOpts.OPT_ITEMPATH.getId()), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)itemSelector, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
        String wsId = ws != null ? ws.workspaceItemId : null;
        RelativeLocation itemPath = null;
        String itemUuid = null;
        IUuidAliasRegistry.IUuidAlias itemAlias = RepoUtil.lookupUuidAndAlias((String)itemSelector.getItemSelector(), (String)repo.getRepositoryURI());
        if (itemAlias != null) {
            itemUuid = itemAlias.getUuid().getUuidValue();
        } else {
            ResourcePropertiesDTO itemResource = this.getResource(itemSelector.getItemSelector(), client, this.config);
            if (itemResource != null) {
                itemUuid = itemResource.getItemId();
                itemPath = new RelativeLocation(itemResource.getShare().getPath().getSegments());
                if (wsId == null) {
                    wsId = itemResource.getShare().getContextItemId();
                }
            } else {
                itemPath = new RelativeLocation(new Path(itemSelector.getItemSelector()).segments());
            }
        }
        if (itemUuid == null && ws == null) {
            throw StatusHelper.argSyntax((String)Messages.ChangesetExtractCmd_CANNOT_DETERMINE_WS);
        }
        String diskPathStr = cli.getOption(ChangesetExtractCmdOpts.OPT_DISKPATH.getId());
        ILocation diskPath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)this.config, (String)diskPathStr);
        this.validateDiskPath(diskPath, client, this.config);
        ChangeSetSyncDTO csDTO = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (boolean)true, (String)wsId, (String)"workspace", (String)repo.getRepositoryURI(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        ChangeSyncDTO matchedChange = this.getChange(csDTO, itemUuid, (IRelativeLocation)itemPath, itemSelector.getItemSelector());
        String stateId = null;
        if (cli.hasOption((IOptionKey)ChangesetExtractCmdOpts.OPT_VER_STATE)) {
            ScmCommandLineArgument stateSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetExtractCmdOpts.OPT_VER_STATE.getId()), (IScmClientConfiguration)this.config);
            SubcommandUtil.validateArgument((IScmCommandLineArgument)stateSelector, (RepoUtil.ItemType)RepoUtil.ItemType.VERSIONABLE);
            IUuidAliasRegistry.IUuidAlias stateAlias = RepoUtil.lookupUuidAndAlias((String)stateSelector.getItemSelector(), (String)repo.getRepositoryURI());
            if (stateAlias == null) {
                throw StatusHelper.argSyntax((String)NLS.bind((String)Messages.Common_INVALID_ALIAS_UUID, (Object)stateSelector.getItemSelector()));
            }
            stateId = stateAlias.getUuid().getUuidValue();
        } else {
            stateId = matchedChange.getAfterStateId();
        }
        this.validateState(csDTO.getChangeSetItemId(), matchedChange, stateId, repo, this.config);
        String sandboxDiskPath = RepoUtil.getSandboxPath((String)diskPath.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        if (sandboxDiskPath != null) {
            PathLocation sandboxDiskLoc = new PathLocation(sandboxDiskPath);
            this.load(sandboxDiskPath, diskPath.getLocationRelativeTo((ILocation)sandboxDiskLoc).toString(), matchedChange.getVersionableItemId(), stateId, matchedChange.getVersionableItemType(), repo, client, this.config);
        } else {
            this.extractContent(diskPath, wsId, csDTO.getComponentItemId(), matchedChange.getVersionableItemId(), stateId, matchedChange.getVersionableItemType(), repo, this.config);
        }
        this.config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangesetExtractCmd_SUCCESS, (Object)diskPath.toOSString()));
    }

    private ResourcePropertiesDTO getResource(String itemSelector, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        List resourceProperties;
        ResourcePropertiesDTO dto;
        ILocation itemPath = SubcommandUtil.makeAbsolutePath((IScmClientConfiguration)config, (String)itemSelector);
        try {
            RepoUtil.getSandboxPathsAndRegister((String)itemPath.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ParmsResourceProperties parms = new ParmsResourceProperties(false, new String[]{itemPath.toOSString()});
        ResourcesDTO resourcesDTO = null;
        try {
            resourcesDTO = client.postFetchResourceProperties(parms, null);
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
        if (resourcesDTO != null && (dto = (ResourcePropertiesDTO)(resourceProperties = resourcesDTO.getResourceProperties()).get(0)) != null && dto.getShare() != null) {
            return dto;
        }
        return null;
    }

    private void validateDiskPath(ILocation diskPath, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        PathLocation sandboxPath;
        IRelativeLocation relDiskPath;
        String sandboxDiskPath = RepoUtil.getSandboxPath((String)diskPath.toOSString(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        if (sandboxDiskPath != null && (relDiskPath = diskPath.getLocationRelativeTo((ILocation)(sandboxPath = new PathLocation(sandboxDiskPath)))).segmentCount() == 1) {
            throw StatusHelper.failure((String)Messages.ChangesetExtractCmd_NOT_A_VALID_PATH, null);
        }
        ILocation parentPath = diskPath.getParent();
        if (!parentPath.isEmpty() && !SubcommandUtil.exists((ILocation)parentPath, null)) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetExtractCmd_ITEM_DOES_NOT_EXIST, (Object)parentPath.toOSString()));
        }
        this.checkForOverwrite(diskPath, config);
    }

    private void checkForOverwrite(ILocation path, IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        if (cli.hasOption((IOptionKey)ChangesetExtractCmdOpts.OPT_OVERWRITE)) {
            ResourceType resType = SubcommandUtil.getResourceType((ILocation)path, null);
            if (resType != null && resType == ResourceType.FOLDER) {
                throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_NOT_A_FILE, (Object)path.toOSString()), null);
            }
        } else if (SubcommandUtil.exists((ILocation)path, null)) {
            throw StatusHelper.failure((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_OVERWRITE, (Object)path.toOSString(), (Object)cli.getDefinition().getOption((IOptionKey)ChangesetExtractCmdOpts.OPT_OVERWRITE).getName()), null);
        }
    }

    private ChangeSyncDTO getChange(ChangeSetSyncDTO csDTO, String itemUuid, IRelativeLocation itemPath, String itemSelector) throws FileSystemException {
        ChangeSyncDTO matchedChange = null;
        block0: for (ChangeFolderSyncDTO changeFolderSyncDTO : csDTO.getChanges()) {
            for (ChangeSyncDTO changeSyncDTO : changeFolderSyncDTO.getChanges()) {
                if (itemUuid != null) {
                    if (itemUuid.equals(changeSyncDTO.getVersionableItemId())) {
                        matchedChange = changeSyncDTO;
                    }
                } else {
                    RelativeLocation relCSPath = new RelativeLocation(new Path(changeSyncDTO.getPathHint()).segments());
                    if (itemPath.sameLocation((IRelativeLocation)relCSPath, false)) {
                        matchedChange = changeSyncDTO;
                    }
                }
                if (matchedChange != null) break block0;
            }
        }
        if (matchedChange == null) {
            throw StatusHelper.itemNotFound((String)NLS.bind((String)Messages.ChangesetExtractCmd_NOT_A_VALID_ITEM, (Object)itemSelector));
        }
        if (matchedChange.getVersionableItemType().equals("folder")) {
            throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_NOT_A_FILE, (Object)itemSelector));
        }
        return matchedChange;
    }

    private void validateState(String csId, ChangeSyncDTO change, String stateId, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IScmRichClientRestService scmService = (IScmRichClientRestService)((IClientLibraryContext)repo).getServiceInterface(IScmRichClientRestService.class);
        IScmRichClientRestService.ParmsGetIntermediateHistory parms = new IScmRichClientRestService.ParmsGetIntermediateHistory();
        parms.changeSetItemId = csId;
        parms.versionableItemId = change.getVersionableItemId();
        if (change.getVersionableItemType().equals("file")) {
            parms.versionableItemNamespace = IFileItem.ITEM_TYPE.getNamespaceURI();
            parms.versionableItemType = IFileItem.ITEM_TYPE.getName();
        } else if (change.getVersionableItemType().equals("folder")) {
            parms.versionableItemNamespace = IFolder.ITEM_TYPE.getNamespaceURI();
            parms.versionableItemType = IFolder.ITEM_TYPE.getName();
        } else if (change.getVersionableItemType().equals("symbolic_link")) {
            parms.versionableItemNamespace = ISymbolicLink.ITEM_TYPE.getNamespaceURI();
            parms.versionableItemType = ISymbolicLink.ITEM_TYPE.getName();
        }
        ScmIntermediateHistory result = null;
        try {
            result = scmService.getChangeSetHistory(parms);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ListStatesCmd_FAILURE, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
        ScmIntermediateChangeNode matchedChangeNode = null;
        for (ScmIntermediateChangeNode changeNode : result.getHistory()) {
            if (changeNode.getStateId() == null || !changeNode.getStateId().equals(stateId) || changeNode.getType() == ScmIntermediateChangeNode.TYPE_DELETE) continue;
            matchedChangeNode = changeNode;
        }
        if (matchedChangeNode == null) {
            throw StatusHelper.argSyntax((String)Messages.ChangesetExtractCmd_INVALID_STATE);
        }
    }

    private void extractContent(ILocation diskPath, String wsId, String compId, String itemId, String stateId, String itemType, ITeamRepository repo, IScmClientConfiguration config) throws FileSystemException {
        IVersionable versionable = RepoUtil.getVersionable3((String)itemId, (String)stateId, (String)itemType, (ITeamRepository)repo, (IScmClientConfiguration)config);
        ICommandLine cli = config.getSubcommandCommandLine();
        ChangesetExtractCmd.extractContent(diskPath, wsId, compId, versionable, repo, config, cli.hasOption((IOptionKey)ChangesetExtractCmdOpts.OPT_OVERWRITE));
    }

    public static void extractContent(ILocation diskPath, String wsId, String compId, IVersionable versionable, ITeamRepository repo, IScmClientConfiguration config, boolean overwrite) throws FileSystemException {
        block13: {
            PrintStream out = null;
            boolean downloaded = false;
            try {
                try {
                    if (versionable.getItemType().equals(IFileItem.ITEM_TYPE)) {
                        out = new PrintStream(diskPath.toOSString());
                        RepoUtil.httpDownloadFile((ITeamRepository)repo, (String)wsId, (String)compId, (IVersionable)versionable, (OutputStream)out, (IScmClientConfiguration)config);
                        downloaded = true;
                        break block13;
                    }
                    if (versionable.getItemType().equals(ISymbolicLink.ITEM_TYPE)) {
                        ISymbolicLink symbolicLink = (ISymbolicLink)versionable;
                        File file = new File(diskPath.toOSString());
                        IFileStore store = EFS.getLocalFileSystem().fromLocalFile(file);
                        if (store != null && ManagedFileStore.supportsSymLinks()) {
                            try {
                                if (overwrite) {
                                    file.delete();
                                }
                                String target = ManagedFileStore.convertTargetToLocal((String)symbolicLink.getTarget());
                                ManagedFileStore.createSymlink((IFileStore)store, (String)target, (boolean)symbolicLink.isDirectoryLink(), null);
                                downloaded = true;
                                break block13;
                            }
                            catch (CoreException e) {
                                throw StatusHelper.failure((String)Messages.ChangesetExtractCmd_UNABLE_TO_EXTRACT, (Throwable)e);
                            }
                        }
                        out = new PrintStream(diskPath.toOSString());
                        out.write(symbolicLink.getTarget().getBytes(Charset.defaultCharset().name()));
                        out.flush();
                        downloaded = true;
                        break block13;
                    }
                    throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetExtractCmd_COMPLAIN_NOT_A_FILE_ITEM, (Object)versionable.getItemId().getUuidValue()));
                }
                catch (IOException e) {
                    throw StatusHelper.failure((String)Messages.ChangesetExtractCmd_IO_ERROR, (Throwable)e);
                }
            }
            finally {
                File file;
                if (out != null) {
                    out.close();
                }
                if (!downloaded && (file = new File(diskPath.toOSString())).exists()) {
                    file.delete();
                }
            }
        }
    }

    private void load(String sandboxPath, String filePath, String itemId, String stateId, String itemType, ITeamRepository repo, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsLoadFileRequest loadFile = new ParmsLoadFileRequest();
        loadFile.versionableItemId = itemId;
        loadFile.versionableItemStateId = stateId;
        loadFile.versionableItemType = itemType;
        loadFile.sandboxPath = sandboxPath;
        loadFile.filePath = filePath;
        ParmsLoadFiles parms = new ParmsLoadFiles();
        parms.repositoryUrl = repo.getRepositoryURI();
        parms.toLoad = new ParmsLoadFileRequest[]{loadFile};
        try {
            client.postLoadFiles(parms, null);
        }
        catch (VersionablePermissionDeniedException e) {
            throw StatusHelper.permissionFailure((String)Messages.Common_VERSIONABLE_PERMISSSION_DENIED);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetExtractCmd_UNABLE_TO_EXTRACT, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
        }
    }
}

