/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.subcommands.AcceptResultDisplayer;
import com.ibm.team.filesystem.cli.core.internal.ScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.CommonOptions;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IUuidAliasRegistry;
import com.ibm.team.filesystem.cli.core.util.ConnectionInfo;
import com.ibm.team.filesystem.cli.core.util.ISandboxWorkspace;
import com.ibm.team.filesystem.cli.core.util.PendingChangesUtil;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsBackupDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDeletedContentDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsDiscardChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsOutOfSyncInstructions;
import com.ibm.team.filesystem.client.rest.parameters.ParmsPendingChangesDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsRemoveSuspendedChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSandboxUpdateDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.DiscardResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ChangeSetSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.ComponentSyncDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.SyncViewDTO;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkspaceSyncDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.DiscardNotInHistoryException;
import com.ibm.team.scm.common.GapException;
import com.ibm.team.scm.common.NWayConflictUnsupportedException;
import com.ibm.team.scm.common.PatchInProgressException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.osgi.util.NLS;

public class ChangesetDiscardCmd
extends AbstractSubcommand {
    /*
     * WARNING - void declaration
     */
    public void run() throws FileSystemException {
        void var11_15;
        ICommandLine cli = this.config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        List csSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues((IOptionKey)CommonOptions.OPT_CHANGESET_SELECTORS), (IScmClientConfiguration)this.config);
        SubcommandUtil.validateArgument((List)csSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)this.config);
        ArrayList<ParmsWorkspace> wsList = new ArrayList<ParmsWorkspace>();
        if (wsSelector != null) {
            ParmsWorkspace ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            ITeamRepository repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, (List)csSelectors, (ITeamRepository)repo, (IScmClientConfiguration)this.config);
            wsList.add(ws);
        } else {
            List wsInSandboxList = RepoUtil.findWorkspacesInSandbox((IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
            for (ISandboxWorkspace wsInSandbox : wsInSandboxList) {
                String uri = RepoUtil.getRepoUri((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (String)wsInSandbox.getRepositoryId(), Collections.singletonList(wsInSandbox));
                RepoUtil.login((IScmClientConfiguration)this.config, (IFilesystemRestClient)client, (ConnectionInfo)this.config.getConnectionInfo(uri));
                wsList.add(new ParmsWorkspace(uri, wsInSandbox.getWorkspaceItemId()));
            }
        }
        RepoUtil.validateWorkspacesAreTracked(wsList, (String)Messages.DiscardCmd_UNTRACKED_WORKSPACE, (IScmClientConfiguration)this.config);
        SyncViewDTO syncView = SubcommandUtil.getSyncView(wsList, (boolean)false, (IFilesystemRestClient)client, (IScmClientConfiguration)this.config);
        IndentingPrintStream out = this.config.getWrappedOutputStream();
        if (syncView.getWorkspaces().size() == 0) {
            throw StatusHelper.itemNotFound((String)Messages.Common_WS_NOT_FOUND);
        }
        ArrayList<String> foundCsList = new ArrayList<String>();
        Map<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToOutgoingCsMap = this.findDiscardChangesets(csSelectors, syncView, true, client, this.config, out);
        for (Map.Entry<ParmsWorkspace, List<ChangeSetSyncDTO>> entry : wsToOutgoingCsMap.entrySet()) {
            for (ChangeSetSyncDTO changeSetSyncDTO : entry.getValue()) {
                foundCsList.add(changeSetSyncDTO.getChangeSetItemId());
            }
        }
        Map<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToSuspendCsMap = null;
        if (foundCsList.size() != csSelectors.size()) {
            wsToSuspendCsMap = this.findDiscardChangesets(csSelectors, syncView, false, client, this.config, out);
            for (Map.Entry<ParmsWorkspace, List<ChangeSetSyncDTO>> entry : wsToSuspendCsMap.entrySet()) {
                for (ChangeSetSyncDTO changeSetSync : entry.getValue()) {
                    foundCsList.add(changeSetSync.getChangeSetItemId());
                }
            }
        }
        Object var11_13 = null;
        Object var12_20 = null;
        if (foundCsList.size() != csSelectors.size()) {
            if (wsList.size() > 1) {
                throw StatusHelper.itemNotFound((String)Messages.DiscardCmd_MultipleWorkspaces);
            }
            ParmsWorkspace parmsWorkspace = (ParmsWorkspace)wsList.get(0);
            ArrayList<IScmCommandLineArgument> csSelectorsPotentiallyInHistory = new ArrayList<IScmCommandLineArgument>();
            for (IScmCommandLineArgument csSelector : csSelectors) {
                IUuidAliasRegistry.IUuidAlias csUuidAlias = RepoUtil.lookupUuidAndAlias((String)csSelector.getItemSelector());
                if (foundCsList.contains(csUuidAlias.getUuid().getUuidValue())) continue;
                csSelectorsPotentiallyInHistory.add(csSelector);
            }
            List<ChangeSetSyncDTO> list = this.fetchChangeSets(csSelectorsPotentiallyInHistory, parmsWorkspace.repositoryUrl, client, this.config, out);
        }
        if (wsToOutgoingCsMap.size() > 0 || var11_15 != null && var11_15.size() > 0) {
            HashMap<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToCsMap = new HashMap<ParmsWorkspace, List<ChangeSetSyncDTO>>(wsToOutgoingCsMap);
            if (var11_15 != null && var11_15.size() > 0) {
                void var12_22;
                if (wsToCsMap.containsKey(var12_22)) {
                    ((List)wsToCsMap.get(var12_22)).addAll(var11_15);
                } else {
                    wsToCsMap.put((ParmsWorkspace)var12_22, (List<ChangeSetSyncDTO>)var11_15);
                }
            }
            this.discardChangesets(wsToCsMap, client, this.config, Messages.DiscardCmd_CHANGESETS_DISCARDED, out);
        }
        if (wsToSuspendCsMap != null && wsToSuspendCsMap.size() > 0) {
            String header = wsToOutgoingCsMap.size() == 0 ? Messages.DiscardCmd_CHANGESETS_DISCARDED : null;
            this.discardSuspendedChangesets(wsToSuspendCsMap, client, this.config, header, out);
        }
        out.println((CharSequence)Messages.DiscardCmd_CHANGESETS_SUCCESSFULLY_DISCARDED);
    }

    private void printError(IScmCommandLineArgument csSelector, IndentingPrintStream out) throws FileSystemException {
        out.println((CharSequence)Messages.Common_CS_NOT_FOUND_HEADER_SINGLE);
        out.indent().println((CharSequence)csSelector.getItemSelector());
        out.println((CharSequence)Messages.DiscardCmd_HINT);
        throw StatusHelper.itemNotFound((String)Messages.Common_CS_NOT_FOUND_SINGLE);
    }

    private Map<ParmsWorkspace, List<ChangeSetSyncDTO>> findDiscardChangesets(List<IScmCommandLineArgument> csSelectors, SyncViewDTO syncView, boolean inOutgoing, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        HashMap<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToCsMap = new HashMap<ParmsWorkspace, List<ChangeSetSyncDTO>>();
        HashMap<String, ParmsWorkspace> wsIdToWs = new HashMap<String, ParmsWorkspace>();
        block0: for (IScmCommandLineArgument csSelector : csSelectors) {
            IUuidAliasRegistry.IUuidAlias csUuidAlias = RepoUtil.lookupUuidAndAlias((String)csSelector.getItemSelector());
            if (csUuidAlias == null) {
                this.printError(csSelector, config.getWrappedErrorStream());
            }
            for (WorkspaceSyncDTO wsSync : syncView.getWorkspaces()) {
                ParmsWorkspace ws = (ParmsWorkspace)wsIdToWs.get(wsSync.getWorkspaceItemId());
                if (ws == null) {
                    ws = new ParmsWorkspace(wsSync.getRepositoryUrl(), wsSync.getWorkspaceItemId());
                    wsIdToWs.put(wsSync.getWorkspaceItemId(), ws);
                }
                for (ComponentSyncDTO compSync : wsSync.getComponents()) {
                    List changeSetSyncList = null;
                    changeSetSyncList = inOutgoing ? compSync.getOutgoingChangeSetsAfterBasis() : compSync.getSuspended();
                    for (ChangeSetSyncDTO changeSetSync : changeSetSyncList) {
                        if (csUuidAlias == null || !csUuidAlias.getUuid().getUuidValue().equals(changeSetSync.getChangeSetItemId()) || csSelector.getRepositorySelector() != null && !RepoUtil.isRepoUriSame((String)csSelector.getRepositorySelector(), (String)changeSetSync.getRepositoryUrl(), (IScmClientConfiguration)config)) continue;
                        ArrayList<ChangeSetSyncDTO> csList = (ArrayList<ChangeSetSyncDTO>)wsToCsMap.get(ws);
                        if (csList == null) {
                            csList = new ArrayList<ChangeSetSyncDTO>();
                            wsToCsMap.put(ws, csList);
                        }
                        changeSetSync.setComponentItemId(compSync.getComponentItemId());
                        if (csList.contains(changeSetSync)) continue block0;
                        csList.add(changeSetSync);
                        continue block0;
                    }
                }
            }
        }
        return wsToCsMap;
    }

    private List<ChangeSetSyncDTO> fetchChangeSets(List<IScmCommandLineArgument> csSelectors, String repositoryUrl, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        List<ChangeSetSyncDTO> foundChangeSets = new ArrayList<ChangeSetSyncDTO>();
        if (csSelectors.size() > 0) {
            ChangeSetSyncDTO[] changeSetSyncArr = null;
            ArrayList<String> csItemSelectors = new ArrayList<String>(csSelectors.size());
            for (IScmCommandLineArgument csSelector : csSelectors) {
                csItemSelectors.add(csSelector.getItemSelector());
            }
            try {
                changeSetSyncArr = RepoUtil.findChangeSets(csItemSelectors, (boolean)false, null, null, (String)repositoryUrl, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            }
            catch (FileSystemException e) {
                throw StatusHelper.wrap((String)Messages.Common_CS_NOT_FOUND_SINGLE, (TeamRepositoryException)((Object)e), (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (changeSetSyncArr.length == 0) {
                this.printError(csSelectors.get(0), config.getWrappedErrorStream());
            }
            foundChangeSets = Arrays.asList(changeSetSyncArr);
        }
        return foundChangeSets;
    }

    private void discardChangesets(Map<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToCsMap, IFilesystemRestClient client, IScmClientConfiguration config, String header, IndentingPrintStream out) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        for (Map.Entry<ParmsWorkspace, List<ChangeSetSyncDTO>> entry : wsToCsMap.entrySet()) {
            DiscardResultDTO result;
            ParmsDiscardChangeSets parmsCs = new ParmsDiscardChangeSets();
            parmsCs.workspace = entry.getKey();
            List<ChangeSetSyncDTO> csList = entry.getValue();
            parmsCs.changeSetItemIds = new String[csList.size()];
            int count = 0;
            for (ChangeSetSyncDTO cs : csList) {
                parmsCs.changeSetItemIds[count++] = cs.getChangeSetItemId();
            }
            parmsCs.preoperationRefresh = SubcommandUtil.getPreopRefreshPolicy((IScmClientConfiguration)config);
            parmsCs.pendingChangesDilemmaHandler = new ParmsPendingChangesDilemmaHandler();
            parmsCs.pendingChangesDilemmaHandler.pendingChangesInstruction = cli.hasOption((IOptionKey)CommonOptions.OPT_OVERWRITE_UNCOMMITTED) ? "no" : "cancel";
            parmsCs.outOfSyncInstructions = new ParmsOutOfSyncInstructions();
            parmsCs.outOfSyncInstructions.outOfSyncNoPendingChanges = "cancel";
            parmsCs.outOfSyncInstructions.outOfSyncWithPendingChanges = "cancel";
            parmsCs.sandboxUpdateDilemmaHandler = new ParmsSandboxUpdateDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.backupDilemmaHandler = new ParmsBackupDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.backupDilemmaHandler.backupEnabled = true;
            parmsCs.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler = new ParmsDeletedContentDilemmaHandler();
            parmsCs.sandboxUpdateDilemmaHandler.deletedContentDilemmaHandler.deletedContentDirection = "continue";
            parmsCs.autoReleaseLocks = !cli.hasOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK) ? Boolean.valueOf(((ScmClientConfiguration)config).getPersistentPreferences().getReleaseAutoLockForDiscard()) : Boolean.valueOf(Boolean.parseBoolean(cli.getOption((IOptionKey)CommonOptions.OPT_RELEASE_LOCK).toString()));
            try {
                result = client.postDiscardChangeSets(parmsCs, null);
            }
            catch (TeamRepositoryException e) {
                PatchInProgressException port = (PatchInProgressException)SubcommandUtil.findExceptionByType(PatchInProgressException.class, (TeamRepositoryException)e);
                if (port != null) {
                    throw StatusHelper.portsInProgress((String)port.getLocalizedMessage());
                }
                GapException gap = (GapException)SubcommandUtil.findExceptionByType(GapException.class, (TeamRepositoryException)e);
                if (gap != null) {
                    throw StatusHelper.gap((String)(String.valueOf(Messages.DiscardCmd_9) + " " + Messages.DeliverCmd_HINT_ON_GAP));
                }
                NWayConflictUnsupportedException nway = (NWayConflictUnsupportedException)SubcommandUtil.findExceptionByType(NWayConflictUnsupportedException.class, (TeamRepositoryException)e);
                if (nway != null) {
                    throw StatusHelper.nWayConflict((String)Messages.DiscardCmd_10);
                }
                DiscardNotInHistoryException notInHist = (DiscardNotInHistoryException)SubcommandUtil.findExceptionByType(DiscardNotInHistoryException.class, (TeamRepositoryException)e);
                if (notInHist != null) {
                    throw StatusHelper.discardNotInHistory((String)Messages.DiscardCmd_ChangesetNotInHistory);
                }
                throw StatusHelper.wrap((String)Messages.DiscardCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (result.isCancelled()) {
                int noOfUncheckedInChanges;
                if (result.getOutOfSyncShares().size() > 0) {
                    AcceptResultDisplayer.showOutOfSync(result.getOutOfSyncShares(), config);
                }
                if ((noOfUncheckedInChanges = SubcommandUtil.getNoOfUncheckedInChanges((List)result.getConfigurationsWithUncheckedInChanges())) > 0) {
                    throw StatusHelper.uncheckedInChanges((String)NLS.bind((String)Messages.AcceptCmd2_UNCHECKEDIN_ITEMS_PRESENT, (Object)noOfUncheckedInChanges, (Object)CommonOptions.OPT_OVERWRITE_UNCOMMITTED.getName()));
                }
            }
            if (cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) {
                out.println((CharSequence)header);
                this.printDiscardedChangesets(entry.getKey(), csList, client, config, out);
            }
            if (result.getSandboxUpdateDilemma().getBackedUpToShed().size() > 0) {
                SubcommandUtil.showShedUpdate((String)Messages.AcceptResultDisplayer_SHED_MESSAGE, (IndentingPrintStream)out, (List)result.getSandboxUpdateDilemma().getBackedUpToShed());
            }
            if (result.getSandboxUpdateDilemma().getDeletedContentShareables().size() <= 0) continue;
            SubcommandUtil.showDeletedContent((List)result.getSandboxUpdateDilemma().getDeletedContentShareables(), (IndentingPrintStream)out);
        }
    }

    private void printDiscardedChangesets(ParmsWorkspace ws, List<ChangeSetSyncDTO> csList, IFilesystemRestClient client, IScmClientConfiguration config, IndentingPrintStream out) throws FileSystemException {
        PendingChangesUtil.PendingChangesOptions options = new PendingChangesUtil.PendingChangesOptions();
        options.setVerbose(true);
        options.enablePrinter(4);
        options.enableFilter(4);
        for (ChangeSetSyncDTO cs : csList) {
            options.addFilter(UUID.valueOf((String)cs.getChangeSetItemId()), 4);
        }
        PendingChangesUtil.printChangeSets(null, csList, null, (PendingChangesUtil.PendingChangesOptions)options, (IndentingPrintStream)out, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
    }

    private void discardSuspendedChangesets(Map<ParmsWorkspace, List<ChangeSetSyncDTO>> wsToCsMap, IFilesystemRestClient client, IScmClientConfiguration config, String header, IndentingPrintStream out) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        for (Map.Entry<ParmsWorkspace, List<ChangeSetSyncDTO>> entry : wsToCsMap.entrySet()) {
            ParmsRemoveSuspendedChangeSets parmsCs = new ParmsRemoveSuspendedChangeSets();
            parmsCs.repositoryUrl = entry.getKey().repositoryUrl;
            List<ChangeSetSyncDTO> csList = entry.getValue();
            parmsCs.changeSetItemIds = new String[csList.size()];
            int count = 0;
            for (ChangeSetSyncDTO cs : csList) {
                parmsCs.changeSetItemIds[count++] = cs.getChangeSetItemId();
            }
            try {
                client.postRemoveSuspendedChangeSets(parmsCs, null);
            }
            catch (TeamRepositoryException e) {
                throw StatusHelper.wrap((String)Messages.DiscardCmd_11, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream());
            }
            if (!cli.hasOption((IOptionKey)CommonOptions.OPT_VERBOSE)) continue;
            if (header != null) {
                out.println((CharSequence)header);
            }
            this.printDiscardedChangesets(entry.getKey(), csList, client, config, out);
        }
    }
}

