/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetWorkitemBase;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.internal.calm.OslcLinkUtil;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.workitems.IFileSystemWorkItemRestClient;
import com.ibm.team.filesystem.client.workitems.rest.parameters.ParmsPostChangeSetWorkItem;
import com.ibm.team.filesystem.common.internal.rest.client.sync.WorkItemSyncDTO;
import com.ibm.team.links.common.ILink;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IChangeSetHandle;
import java.util.Collections;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ChangesetDisassociateWorkitemCmd
extends ChangesetWorkitemBase {
    @Override
    protected void doIt() throws FileSystemException {
        boolean isWiLinkedToCs = false;
        for (WorkItemSyncDTO wiSync : this.csDTO.getWorkItems()) {
            if (!wiSync.getWorkItemItemId().equals(this.workItem.getItemId().getUuidValue())) continue;
            isWiLinkedToCs = true;
        }
        if (!isWiLinkedToCs) {
            boolean isOslcLinked = false;
            try {
                isOslcLinked = this.isOslcLinked();
            }
            catch (TeamRepositoryException teamRepositoryException) {
                // empty catch block
            }
            if (!isOslcLinked) {
                ICommandLine cli = this.config.getSubcommandCommandLine();
                ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)this.config);
                throw StatusHelper.inappropriateArgument((String)NLS.bind((String)Messages.ChangesetDisassociateWorkitemCmd_4, (Object)csSelector.getItemSelector(), (Object)this.workItem.getId()));
            }
        }
        ISandbox[] sandboxes = this.config.getSandboxes();
        IFileSystemWorkItemRestClient client = (IFileSystemWorkItemRestClient)SubcommandUtil.startDaemon(IFileSystemWorkItemRestClient.class, (ISandbox[])sandboxes, (IScmClientConfiguration)this.config);
        ParmsPostChangeSetWorkItem parmsCsWi = new ParmsPostChangeSetWorkItem();
        parmsCsWi.repositoryUrl = this.repoUri;
        parmsCsWi.workspaceId = this.wsId;
        parmsCsWi.changeSetId = this.csDTO.getChangeSetItemId();
        parmsCsWi.workItemItemId = this.workItem.getItemId().getUuidValue();
        if (this.wiRepoUri != null) {
            parmsCsWi.wiRepositoryUrl = this.wiRepoUri;
        }
        try {
            client.postRemoveWorkItem(parmsCsWi, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetDisassociateWorkitemCmd_1, (TeamRepositoryException)e, (IndentingPrintStream)this.config.getWrappedErrorStream(), (String)this.repoUri);
        }
        this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetDisassociateWorkitemCmd_3);
    }

    private boolean isOslcLinked() throws TeamRepositoryException {
        boolean oslcLink = false;
        ITeamRepository repo = CommonUtil.getTeamRepository((String)this.repoUri);
        if (!repo.loggedIn()) {
            repo.login(null);
        }
        IChangeSetHandle changeSetHandle = (IChangeSetHandle)IChangeSet.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.csDTO.getChangeSetItemId()), null);
        List links = OslcLinkUtil.fetchScmOslcLinks((ITeamRepository)repo, Collections.singleton(changeSetHandle), null);
        for (ILink link : links) {
            if (!OslcLinkUtil.isScmOslcLink((ILink)link)) continue;
            oslcLink = true;
            break;
        }
        return oslcLink;
    }
}

