/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSetCurrentChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.IWorkspace;
import java.util.Collections;

public class ChangesetCurrentCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ChangesetCurrentCmd.setCurrent(this.config);
    }

    public static void setCurrent(IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)csSelector, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        ChangesetCurrentCmd.setCurrent((IScmCommandLineArgument)wsSelector, (IScmCommandLineArgument)csSelector, config);
    }

    public static void setCurrent(IScmCommandLineArgument wsSelector, IScmCommandLineArgument csSelector, IScmClientConfiguration config) throws FileSystemException {
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)wsSelector);
            IWorkspace wsFound = RepoUtil.getWorkspace((String)wsSelector.getItemSelector(), (boolean)true, (boolean)true, (ITeamRepository)repo, (IScmClientConfiguration)config);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, Collections.singletonList(csSelector), (ITeamRepository)repo, (IScmClientConfiguration)config);
            ws = new ParmsWorkspace(repo.getRepositoryURI(), wsFound.getItemId().getUuidValue());
        } else {
            repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        IChangeSet changeSet = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
        ParmsSetCurrentChangeSet parms = new ParmsSetCurrentChangeSet();
        parms.changeSetItemId = changeSet.getItemId().getUuidValue();
        parms.workspace = ws;
        try {
            client.postSetCurrentChangeSet(parms, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetCurrentCmd_UNABLE_TO_SET_CURRENT, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repo.getRepositoryURI());
        }
    }
}

