/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetSetCmd;
import com.ibm.team.filesystem.cli.client.internal.portcommand.CurrentPortCmd;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCloseChangeSetsDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsCompleteChangeSets;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.internal.rest.client.changeset.CompleteChangeSetsResultDTO;
import com.ibm.team.filesystem.common.internal.rest.client.core.ChangeSetDTO;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.rtc.cli.infrastructure.internal.core.IClientConfiguration;
import com.ibm.team.rtc.cli.infrastructure.internal.core.ISubcommandDefinition;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.IOptionKey;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.CompletedChangeSetException;
import com.ibm.team.scm.common.IChangeSet;
import com.ibm.team.scm.common.VersionablePermissionDeniedException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.osgi.util.NLS;

public class ChangesetCompleteCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ChangesetCompleteCmd.setComplete(this.config);
    }

    public static void setComplete(IScmClientConfiguration config) throws FileSystemException {
        ICommandLine cli = config.getSubcommandCommandLine();
        ScmCommandLineArgument wsSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_WORKSPACE_NAME.getId(), null), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((IScmCommandLineArgument)wsSelector, (RepoUtil.ItemType)RepoUtil.ItemType.WORKSPACE);
        List csSelectors = ScmCommandLineArgument.createList((List)cli.getOptionValues(ChangesetCommonOptions.OPT_CHANGESETS.getId()), (IScmClientConfiguration)config);
        SubcommandUtil.validateArgument((List)csSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        ITeamRepository repo = null;
        ParmsWorkspace ws = null;
        if (wsSelector != null) {
            ws = RepoUtil.findWorkspaceAndLogin((IScmCommandLineArgument)wsSelector, (IFilesystemRestClient)client, (IScmClientConfiguration)config);
            repo = RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true);
            RepoUtil.validateItemRepos((RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET, (List)csSelectors, (ITeamRepository)repo, (IScmClientConfiguration)config);
        } else {
            for (IScmCommandLineArgument csSelector : csSelectors) {
                ITeamRepository repoCs = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)csSelector);
                if (repo == null) {
                    repo = repoCs;
                    continue;
                }
                if (repo.getId().equals((Object)repoCs.getId())) continue;
                throw StatusHelper.inappropriateArgument((String)Messages.ChangesetCompleteCmd_ALL_CS_NOT_IN_SAME_REPO);
            }
            ws = RepoUtil.findWorkspaceInSandbox(null, (UUID)repo.getId(), (IFilesystemRestClient)client, (IScmClientConfiguration)config);
        }
        ArrayList<String> csList = new ArrayList<String>(csSelectors.size());
        for (IScmCommandLineArgument csSelector : csSelectors) {
            IChangeSet changeSet = RepoUtil.findChangeSet((String)csSelector.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            if (csList.contains(changeSet.getItemId().getUuidValue())) continue;
            csList.add(changeSet.getItemId().getUuidValue());
        }
        ChangesetCompleteCmd.setComplete(ws, csList, repo.getRepositoryURI(), client, config);
    }

    public static void setComplete(ParmsWorkspace ws, List<String> csList, String repoUri, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsCompleteChangeSets parmsCompleteCS = new ParmsCompleteChangeSets();
        parmsCompleteCS.workspace = ws;
        parmsCompleteCS.changeSetItemIds = csList.toArray(new String[csList.size()]);
        parmsCompleteCS.closeChangeSetsDilemmaHandler = new ParmsCloseChangeSetsDilemmaHandler();
        ICommandLine cli = config.getSubcommandCommandLine();
        parmsCompleteCS.closeChangeSetsDilemmaHandler.portsInProgressInstruction = cli.hasOption((IOptionKey)ChangesetSetCmd.OPT_SKIP_MERGE_TARGET) ? "continue" : "cancel";
        CompleteChangeSetsResultDTO result = null;
        try {
            result = client.postCompleteChangeSets(parmsCompleteCS, null);
        }
        catch (TeamRepositoryException e) {
            CompletedChangeSetException csNotComplete = (CompletedChangeSetException)SubcommandUtil.findExceptionByType(CompletedChangeSetException.class, (TeamRepositoryException)e);
            if (csNotComplete != null) {
                throw StatusHelper.completeCSFailure((String)Messages.ChangesetCompleteCmd_9, (Throwable)csNotComplete);
            }
            VersionablePermissionDeniedException permissionDenied = (VersionablePermissionDeniedException)SubcommandUtil.findExceptionByType(VersionablePermissionDeniedException.class, (TeamRepositoryException)e);
            if (permissionDenied != null) {
                String msg = permissionDenied.getLocalizedMessage();
                throw StatusHelper.permissionFailure((String)(msg != null && msg.length() > 0 ? msg : Messages.Common_VERSIONABLE_PERMISSSION_DENIED));
            }
            throw StatusHelper.wrap((String)Messages.ChangesetCompleteCmd_9, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)(ws != null ? ws.repositoryUrl : repoUri));
        }
        List changesetDtoList = result.getTargetChangeSets();
        if (changesetDtoList != null) {
            boolean isPartialSuccess;
            int noOftargetChangeSets = changesetDtoList.size();
            boolean bl = isPartialSuccess = csList.size() > noOftargetChangeSets;
            if (noOftargetChangeSets != 0) {
                if (result.isCancelled()) {
                    throw StatusHelper.portsInProgress((String)NLS.bind((String)Messages.ListUsersCmd_USE_OPTION, (Object)ChangesetSetCmd.OPT_SKIP_MERGE_TARGET.getName()));
                }
                ISubcommandDefinition defnTemp = SubcommandUtil.getClassSubCommandDefn((IClientConfiguration)config, CurrentPortCmd.class);
                if (isPartialSuccess) {
                    config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetCompleteCmd_10);
                    ChangesetCompleteCmd.printUnCompletedChangeSetList(changesetDtoList, config, RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true));
                    config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangeSetPortCmd_PORT_TARGETS_PRESENT_Hint, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString()}));
                    throw StatusHelper.returnValue((int)54);
                }
                ChangesetCompleteCmd.printUnCompletedChangeSetList(changesetDtoList, config, RepoUtil.getSharedRepository((String)ws.repositoryUrl, (boolean)true));
                config.getWrappedOutputStream().println((CharSequence)NLS.bind((String)Messages.ChangeSetPortCmd_PORT_TARGETS_PRESENT_Hint, (Object[])new String[]{config.getContext().getAppName(), SubcommandUtil.getExecutionString((ISubcommandDefinition)defnTemp).toString()}));
                throw StatusHelper.returnValue((int)37);
            }
        }
    }

    public static void printUnCompletedChangeSetList(List<ChangeSetDTO> changesetDtoList, IScmClientConfiguration config, ITeamRepository repo) {
        IndentingPrintStream err = config.getWrappedErrorStream();
        err.println((CharSequence)Messages.ChangeSetPortCmd_PORT_TARGETS_PRESENT);
        for (ChangeSetDTO csList : changesetDtoList) {
            err.indent().println((CharSequence)RepoUtil.lookupUuidAndAlias((String)csList.getItemId(), (String)repo.getRepositoryURI()).getMonicker());
        }
    }
}

