/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.internal.changeset;

import com.ibm.team.filesystem.cli.client.AbstractSubcommand;
import com.ibm.team.filesystem.cli.client.internal.Messages;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommentCmdOptions;
import com.ibm.team.filesystem.cli.client.internal.changeset.ChangesetCommonOptions;
import com.ibm.team.filesystem.cli.core.internal.ScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.subcommands.IScmClientConfiguration;
import com.ibm.team.filesystem.cli.core.subcommands.IScmCommandLineArgument;
import com.ibm.team.filesystem.cli.core.util.RepoUtil;
import com.ibm.team.filesystem.cli.core.util.StatusHelper;
import com.ibm.team.filesystem.cli.core.util.SubcommandUtil;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.rest.IFilesystemRestClient;
import com.ibm.team.filesystem.client.rest.parameters.ParmsChangeSet;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSetChangeSetComment;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLine;
import com.ibm.team.rtc.cli.infrastructure.internal.parser.ICommandLineArgument;
import com.ibm.team.rtc.cli.infrastructure.internal.util.IndentingPrintStream;
import com.ibm.team.scm.common.IChangeSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ChangesetCommentCmd
extends AbstractSubcommand {
    public void run() throws FileSystemException {
        ICommandLine cli = this.config.getSubcommandCommandLine();
        String comment = cli.getOption(ChangesetCommentCmdOptions.OPT_COMMENT.getId());
        ScmCommandLineArgument csSelector = ScmCommandLineArgument.create((ICommandLineArgument)cli.getOptionValue(ChangesetCommonOptions.OPT_CHANGESET.getId()), (IScmClientConfiguration)this.config);
        ArrayList<IScmCommandLineArgument> csSelectors = new ArrayList<IScmCommandLineArgument>(1);
        csSelectors.add((IScmCommandLineArgument)csSelector);
        ChangesetCommentCmd.setComment(comment, csSelectors, this.config);
        this.config.getWrappedOutputStream().println((CharSequence)Messages.ChangesetCommentCmd_3);
    }

    public static void setComment(String comment, List<IScmCommandLineArgument> csSelectors, IScmClientConfiguration config) throws FileSystemException {
        SubcommandUtil.validateArgument(csSelectors, (RepoUtil.ItemType)RepoUtil.ItemType.CHANGESET);
        IFilesystemRestClient client = SubcommandUtil.setupDaemon((IScmClientConfiguration)config);
        HashMap repo2CsList = new HashMap();
        for (IScmCommandLineArgument iScmCommandLineArgument : csSelectors) {
            ITeamRepository repo = RepoUtil.loginUrlArgAncestor((IScmClientConfiguration)config, (IFilesystemRestClient)client, (IScmCommandLineArgument)iScmCommandLineArgument);
            IChangeSet changeSet = RepoUtil.findChangeSet((String)iScmCommandLineArgument.getItemSelector(), (ITeamRepository)repo, (IScmClientConfiguration)config);
            ArrayList<IChangeSet> csList = (ArrayList<IChangeSet>)repo2CsList.get(repo);
            if (csList == null) {
                csList = new ArrayList<IChangeSet>();
                repo2CsList.put(repo, csList);
            }
            if (csList.contains(changeSet)) continue;
            csList.add(changeSet);
        }
        for (Map.Entry entry : repo2CsList.entrySet()) {
            for (IChangeSet cs : (List)entry.getValue()) {
                ChangesetCommentCmd.setComment(cs.getItemId().getUuidValue(), comment, ((ITeamRepository)entry.getKey()).getRepositoryURI(), client, config);
            }
        }
    }

    public static void setComment(String csId, String comment, String repoUri, IFilesystemRestClient client, IScmClientConfiguration config) throws FileSystemException {
        ParmsSetChangeSetComment parmsComment = new ParmsSetChangeSetComment();
        parmsComment.changeSet = new ParmsChangeSet();
        parmsComment.changeSet.changeSetItemId = csId;
        parmsComment.changeSet.repositoryUrl = repoUri;
        parmsComment.comment = comment;
        try {
            client.postSetChangeSetComment(parmsComment, null);
        }
        catch (TeamRepositoryException e) {
            throw StatusHelper.wrap((String)Messages.ChangesetCommentCmd_2, (TeamRepositoryException)e, (IndentingPrintStream)config.getWrappedErrorStream(), (String)repoUri);
        }
    }
}

