/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.AbstractCompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.CompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IComponentSyncContext;
import com.ibm.team.filesystem.rcp.core.internal.compare.ComparePropertiesState;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.ShareableComparePropertiesState;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.LocalFileCompareEditorInput;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class RestOpenInExternalCompareDilemmaHandler
extends OpenInExternalCompareDilemmaHandler {
    private final boolean TRACE = Boolean.getBoolean(System.getProperty("jazz.scm.externalCompare.trace", Boolean.toString(false)));
    private final String[] compareProperties;
    private CompareRestClient compareRESTClient;

    public RestOpenInExternalCompareDilemmaHandler(CompareRestClient compareRESTClient, String[] compareProperties) {
        this.compareRESTClient = compareRESTClient;
        this.compareProperties = compareProperties;
    }

    protected AbstractCompareRestClient getCompareRestClient() {
        return this.compareRESTClient;
    }

    public int differentProperties(ComparePropertiesState comparison, String errorMessage) throws TeamRepositoryException {
        if (comparison instanceof ShareableComparePropertiesState) {
            ShareableComparePropertiesState scps = (ShareableComparePropertiesState)comparison;
            this.openFilteredLocalFileCompareEditor(scps.getShareable(), scps.getRight());
        } else {
            this.openFilteredFileChangeCompareEditor(comparison.getLeft(), comparison.getLeftLabel(), comparison.getRight(), comparison.getRightLabel());
        }
        this.TRACE(errorMessage);
        return 0;
    }

    public int filesMovedButDidNotChangeStatesInRemoteCompare(FileState leftState, FileState rightState, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_2, NLS.bind((String)Messages.WarnRESTOpenInExternalCompare_3, (Object)rightState.getPath(), (Object[])new Object[]{leftState.getPath()}), new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 1;
    }

    public int mergeHasUnloadedComponent(IComponentSyncContext context, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_6, NLS.bind((String)Messages.WarnRESTOpenInExternalCompare_7, (Object)context.getComponent().getName(), (Object[])new Object[0]), new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 0;
    }

    public int mergeIsDeleteToDeleteConflict(IAbstractConflictItem conflict, String errorMessage) throws TeamRepositoryException {
        this.compareRESTClient.showMessageButtonsBlocking(Messages.WarnRESTOpenInExternalCompare_8, Messages.WarnRESTOpenInExternalCompare_9, new String[]{IDialogConstants.OK_LABEL}, 4, 1);
        this.TRACE(errorMessage);
        return 1;
    }

    private void openFilteredLocalFileCompareEditor(IShareable shareable, FileState remoteFileState) throws TeamRepositoryException {
        if (this.doOpenInternalCompare(remoteFileState.isDeleted())) {
            LocalFileCompareEditorInput editorInput = new LocalFileCompareEditorInput(new CompareConfiguration(), shareable, null, remoteFileState, true);
            this.compareRESTClient.showInput((CompareEditorInput)editorInput);
        }
    }

    private void openFilteredFileChangeCompareEditor(FileState leftFileState, String givenLeftLabel, FileState rightFileState, String givenRightLabel) throws TeamRepositoryException {
        if (this.doOpenInternalCompare(leftFileState.isDeleted() || rightFileState.isDeleted())) {
            FileChangeEditorInput editorInput = FileChangeEditorInput.createFrom((FileState)leftFileState, (FileState)rightFileState, (boolean)true);
            editorInput.setLabels(givenLeftLabel, givenRightLabel);
            this.compareRESTClient.showInput((CompareEditorInput)editorInput);
        }
    }

    protected boolean doOpenInternalCompare(final boolean addedOrRemoved) throws TeamRepositoryException {
        final boolean[] result = new boolean[]{true};
        if (this.compareProperties[0].equals("always")) {
            result[0] = true;
        } else if (this.compareProperties[0].equals("never")) {
            result[0] = false;
        } else {
            this.compareRESTClient.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                    shell.setMinimized(false);
                    shell.forceActive();
                    if (addedOrRemoved) {
                        MessageDialogWithToggle dialog = MessageDialogWithToggle.openYesNoQuestion((Shell)shell, (String)Messages.WarnRESTOpenInExternalCompare_0, (String)Messages.WarnRESTOpenInExternalCompare_1, (String)Messages.WarnRESTOpenInExternalCompare_1_REMEMBER, (boolean)false, null, null);
                        boolean bl = result[0] = dialog.getReturnCode() == 2;
                        if (dialog.getToggleState()) {
                            ((RestOpenInExternalCompareDilemmaHandler)RestOpenInExternalCompareDilemmaHandler.this).compareProperties[0] = result[0] ? "always" : "never";
                        }
                    } else {
                        result[0] = MessageDialog.openQuestion((Shell)shell, (String)Messages.WarnRESTOpenInExternalCompare_0, (String)Messages.WarnRESTOpenInExternalCompare_1);
                    }
                }
            });
        }
        return result[0];
    }

    private void TRACE(String message) {
        if (this.TRACE) {
            System.out.println("WarnOpenInExternalCompare dilemma message: " + message);
        }
    }
}

