/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.ApplicationActionBarAdvisor;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.PlainWorkbenchAdvisor;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;
import org.eclipse.ui.application.ActionBarAdvisor;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.application.WorkbenchWindowAdvisor;

public class ApplicationWorkbenchWindowAdvisor
extends WorkbenchWindowAdvisor {
    private static final String RTC_Y = "rtc_y";
    private static final String RTC_X = "rtc_x";
    private static final String RTC_HEIGHT = "rtc_height";
    private static final String RTC_WIDTH = "rtc_width";
    private static String state;

    public ApplicationWorkbenchWindowAdvisor(IWorkbenchWindowConfigurer configurer) {
        super(configurer);
    }

    public void preWindowOpen() {
        Shell shell;
        IWorkbenchWindowConfigurer configurer = this.getWindowConfigurer();
        if (state != null) {
            try {
                XMLMemento m = XMLMemento.createReadRoot((Reader)new StringReader(state));
                int width = m.getInteger(RTC_WIDTH);
                int height = m.getInteger(RTC_HEIGHT);
                this.getWindowConfigurer().setInitialSize(new Point(width, height));
            }
            catch (WorkbenchException width) {
                // empty catch block
            }
        }
        configurer.setShowCoolBar(false);
        configurer.setShowStatusLine(false);
        configurer.setShowFastViewBars(false);
        configurer.setShowProgressIndicator(false);
        configurer.setShowPerspectiveBar(false);
        configurer.setShowMenuBar(true);
        configurer.setTitle(Messages.ApplicationWorkbenchWindowAdvisor_0);
        IWorkbenchWindow workbenchWindow = configurer.getWindow();
        if (workbenchWindow != null && (shell = workbenchWindow.getShell()) != null) {
            shell.setImages(PlainWorkbenchAdvisor.windowImages);
        }
    }

    public ActionBarAdvisor createActionBarAdvisor(IActionBarConfigurer configurer) {
        return new ApplicationActionBarAdvisor(configurer);
    }

    public IStatus saveState(IMemento memento) {
        Shell shell = this.getWindowConfigurer().getWindow().getShell();
        if (shell != null) {
            memento.putInteger(RTC_WIDTH, shell.getBounds().width);
            memento.putInteger(RTC_HEIGHT, shell.getBounds().height);
            memento.putInteger(RTC_X, shell.getBounds().x);
            memento.putInteger(RTC_Y, shell.getBounds().y);
        }
        return super.saveState(memento);
    }

    public IStatus restoreState(IMemento memento) {
        try {
            XMLMemento savedState = XMLMemento.createReadRoot((Reader)new StringReader(state));
            savedState.putInteger(RTC_WIDTH, memento.getInteger(RTC_WIDTH).intValue());
            savedState.putInteger(RTC_HEIGHT, memento.getInteger(RTC_HEIGHT).intValue());
            savedState.putInteger(RTC_X, memento.getInteger(RTC_X).intValue());
            savedState.putInteger(RTC_Y, memento.getInteger(RTC_Y).intValue());
            return super.restoreState(memento);
        }
        catch (WorkbenchException e) {
            return Status.OK_STATUS;
        }
    }

    public void createWindowContents(Shell shell) {
        super.createWindowContents(shell);
        shell.setImages(PlainWorkbenchAdvisor.windowImages);
        if (state != null) {
            try {
                XMLMemento m = XMLMemento.createReadRoot((Reader)new StringReader(state));
                int x = m.getInteger(RTC_X);
                int y = m.getInteger(RTC_Y);
                shell.setLocation(x, y);
            }
            catch (WorkbenchException workbenchException) {
                // empty catch block
            }
        }
        shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                try {
                    XMLMemento savedState = XMLMemento.createWriteRoot((String)"settings");
                    ApplicationWorkbenchWindowAdvisor.this.saveState((IMemento)savedState);
                    StringWriter sw = new StringWriter();
                    savedState.save((Writer)sw);
                    state = sw.toString();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
    }
}

