/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare.internal;

import com.ibm.team.filesystem.cli.client.ui.compare.ICompareRestClient;
import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.client.FileSystemCore;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.ILocalChange;
import com.ibm.team.filesystem.client.ILocation;
import com.ibm.team.filesystem.client.IRelativeLocation;
import com.ibm.team.filesystem.client.ISandbox;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ResourceType;
import com.ibm.team.filesystem.client.daemon.JSONHandler;
import com.ibm.team.filesystem.client.daemon.JSONReceiver;
import com.ibm.team.filesystem.client.internal.ClientFileStateFactory;
import com.ibm.team.filesystem.client.internal.PathLocation;
import com.ibm.team.filesystem.client.internal.RelativeLocation;
import com.ibm.team.filesystem.client.internal.TempHelper;
import com.ibm.team.filesystem.client.internal.utils.ConfigurationFacade;
import com.ibm.team.filesystem.client.operations.UpdateCurrentPatchDilemmaHandler;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.changemodel.FileState;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.ComponentSyncUtil;
import com.ibm.team.filesystem.rcp.core.internal.changes.model.IAbstractConflictItem;
import com.ibm.team.filesystem.rcp.core.internal.changes.util.ComponentSyncModel;
import com.ibm.team.filesystem.rcp.core.internal.compare.ExternalCompareToolsUtil;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenConflictInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenFileItemInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenInExternalCompareDilemmaHandler;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenShareableInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.compare.OpenVersionableChangeInExternalCompareOperation;
import com.ibm.team.filesystem.rcp.core.internal.rest.util.SyncViewDTOUtil;
import com.ibm.team.filesystem.rcp.ui.internal.compare.ConflictCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileChangeEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.FileStateRemoteFunction;
import com.ibm.team.filesystem.rcp.ui.internal.compare.LocalFileCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.PropertyChangeDetailCompareEditorInput;
import com.ibm.team.filesystem.rcp.ui.internal.compare.VersionableChangeCompareEditorInput;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.client.TeamPlatform;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import com.ibm.team.repository.rcp.common.IRemoteFunction;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.client.SCMPlatform;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.IContextHandle;
import com.ibm.team.scm.common.IPropertyChangeDetail;
import com.ibm.team.scm.common.IVersionable;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import com.ibm.team.scm.common.internal.util.StateId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.internal.ICompareUIConstants;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.SubMonitor;

public abstract class AbstractCompareRestClient
extends JSONReceiver
implements ICompareRestClient {
    protected static final int WAIT_INCR = 100;
    protected static final int MAX_WAIT = 600;
    protected JSONHandler jsonHandler;
    protected static final Object lock = new Object();

    protected abstract void checkState() throws TeamRepositoryException;

    protected abstract void showInput(CompareEditorInput var1) throws TeamRepositoryException;

    protected abstract OpenInExternalCompareDilemmaHandler getConflictExternalCompareDilemmaHandler(IAbstractConflictItem var1);

    protected abstract OpenInExternalCompareDilemmaHandler getFileItemExternalCompareDilemmaHandler(String[] var1);

    protected abstract OpenInExternalCompareDilemmaHandler getShareableExternalCompareDilemmaHandler(String[] var1);

    private static boolean isValidExecutable(String commandLine) {
        boolean isValid = false;
        String[] commandArray = ExternalCompareToolsUtil.createCommandArray((String)commandLine);
        if (commandArray.length > 0) {
            String filePath = commandArray[0];
            if (filePath == null || filePath.length() == 0) {
                isValid = false;
            } else {
                try {
                    try {
                        isValid = AbstractCompareRestClient.exists((IPath)new Path(filePath), (IProgressMonitor)TempHelper.MONITOR);
                    }
                    catch (FileSystemException e) {
                        isValid = false;
                    }
                }
                catch (SecurityException e) {
                    isValid = false;
                }
            }
        }
        return isValid;
    }

    private static IShareable getShareable(String sandboxPath, String filePath) throws TeamRepositoryException {
        ISandbox sandbox = FileSystemCore.getSharingManager().getSandbox((ILocation)new PathLocation(sandboxPath), true);
        if (sandbox == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_5, (Object)sandboxPath, (Object[])new Object[0]));
        }
        return sandbox.findShareable((IRelativeLocation)new RelativeLocation(new Path(filePath).segments()), ResourceType.FILE);
    }

    @Override
    public void postShowConflictCompare(ParmsSyncDescription parms) throws TeamRepositoryException {
        Object element = SyncViewDTOUtil.find((Object)ComponentSyncModel.getInstance(), (int)parms.id);
        if (!(element instanceof IAbstractConflictItem)) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_2, (Object)parms.id, (Object[])new Object[0]));
        }
        IAbstractConflictItem conflict = (IAbstractConflictItem)element;
        String externalCompareTool = parms.getExternalToolCommandLine(conflict.getName(true));
        if (externalCompareTool == null || !(conflict.getItem() instanceof IFileItemHandle)) {
            this.showConflictEclipseCompare(conflict, parms);
        } else {
            this.showConflictExternalCompare(conflict, externalCompareTool);
        }
    }

    private void showConflictEclipseCompare(IAbstractConflictItem conflict, ParmsSyncDescription parms) throws TeamRepositoryException {
        this.checkState();
        ConflictCompareEditorInput input = new ConflictCompareEditorInput(new CompareConfiguration(), conflict, null, false);
        this.showInput((CompareEditorInput)input);
    }

    private void showConflictExternalCompare(IAbstractConflictItem conflict, String externalCompareTool) throws TeamRepositoryException {
        if (!AbstractCompareRestClient.isValidExecutable(externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_1);
        }
        OpenConflictInExternalCompareOperation externalCompareOperation = this.getOpenConflictInExternalCompareOperation(externalCompareTool, conflict);
        externalCompareOperation.run(null);
    }

    protected OpenVersionableChangeInExternalCompareOperation getOpenVersionableChangeInExternalCompareOperation(String commandLine, IWorkspaceConnection workspace, IComponentHandle component, IVersionableChange versionableChange, boolean useThreeWayCompare, OpenInExternalCompareDilemmaHandler shareableExternalCompareDilemmaHandler) {
        return new OpenVersionableChangeInExternalCompareOperation(commandLine, workspace, component, versionableChange, useThreeWayCompare, shareableExternalCompareDilemmaHandler);
    }

    protected OpenConflictInExternalCompareOperation getOpenConflictInExternalCompareOperation(String externalCompareTool, IAbstractConflictItem conflict) {
        OpenConflictInExternalCompareOperation externalCompareOperation = new OpenConflictInExternalCompareOperation(externalCompareTool, conflict, this.getConflictExternalCompareDilemmaHandler(conflict));
        return externalCompareOperation;
    }

    @Override
    public String postShowFileItemCompare(ICompareRestClient.ParmsShowItemCompare parms) throws TeamRepositoryException {
        String[] compareProperties = new String[]{parms.compareProperties};
        this.checkState();
        String externalCompareTool = parms.getExternalToolCommandLine();
        if (externalCompareTool == null || !"file".equals(parms.versionableItemType)) {
            this.showFileItemEclipseCompare(parms);
        } else {
            this.showFileItemExternalCompare(parms, compareProperties, externalCompareTool, null);
        }
        return compareProperties[0];
    }

    private void showFileItemEclipseCompare(ICompareRestClient.ParmsShowItemCompare parms) throws TeamRepositoryException {
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_3, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        StateId beforeState = parms.beforeStateId == null ? new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), StateId.STATE_DELETED) : new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.beforeStateId));
        StateId afterState = parms.afterStateId == null ? new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), StateId.STATE_DELETED) : new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.afterStateId));
        Path beforePath = parms.beforePathHint == null ? new Path(parms.afterPathHint == null ? "" : parms.afterPathHint) : new Path(parms.beforePathHint);
        Path afterPath = parms.afterPathHint == null ? beforePath : new Path(parms.afterPathHint);
        FileChangeEditorInput input = FileChangeEditorInput.createFrom((ITeamRepository)repo, (StateId)afterState, (IPath)afterPath, (StateId)beforeState, (IPath)beforePath);
        if (parms.afterLabelSuffix == null) {
            parms.afterLabelSuffix = Messages.AbstractCompareRestClient_0;
        }
        if (parms.beforeLabelSuffix == null) {
            parms.beforeLabelSuffix = Messages.AbstractCompareRestClient_1;
        }
        input.setLabels(parms.afterLabelSuffix, parms.beforeLabelSuffix);
        this.showInput((CompareEditorInput)input);
    }

    private String showFileItemExternalCompare(ICompareRestClient.ParmsShowItemCompare parms, String[] compareProperties, String externalCompareTool, IProgressMonitor monitor) throws TeamRepositoryException {
        FileState afterFileState;
        int afterStateIndex;
        FileState beforeFileState;
        boolean hasAfterState;
        if (!AbstractCompareRestClient.isValidExecutable(externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_0);
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_3, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        UUID itemUUID = UUID.valueOf((String)parms.itemId);
        ArrayList<IFileItemHandle> toFetch = new ArrayList<IFileItemHandle>();
        boolean hasBeforeState = false;
        if (parms.beforeStateId == null || parms.beforeStateId.length() == 0) {
            hasBeforeState = false;
        } else {
            UUID beforeStateUUID = UUID.valueOf((String)parms.beforeStateId);
            IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, beforeStateUUID);
            toFetch.add(filehandle);
            hasBeforeState = true;
        }
        if (parms.afterStateId == null || parms.afterStateId.length() == 0) {
            hasAfterState = false;
        } else {
            UUID afterStateUUID = UUID.valueOf((String)parms.afterStateId);
            IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, afterStateUUID);
            toFetch.add(filehandle);
            hasAfterState = true;
        }
        List versionables = SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteStates(toFetch, monitor);
        if (hasBeforeState && versionables.get(0) != null) {
            IVersionable versionable = (IVersionable)versionables.get(0);
            beforeFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
        } else {
            beforeFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
        }
        int n = afterStateIndex = hasBeforeState ? 1 : 0;
        if (hasAfterState && versionables.get(afterStateIndex) != null) {
            IVersionable versionable = (IVersionable)versionables.get(afterStateIndex);
            afterFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)versionable.getItemType(), (IVersionable)versionable);
        } else {
            afterFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
        }
        if (parms.afterLabelSuffix == null) {
            parms.afterLabelSuffix = Messages.AbstractCompareRestClient_0;
        }
        if (parms.beforeLabelSuffix == null) {
            parms.beforeLabelSuffix = Messages.AbstractCompareRestClient_1;
        }
        OpenFileItemInExternalCompareOperation externalCompareOperation = this.getOpenFileItemInExternalCompareOperation(externalCompareTool, compareProperties, beforeFileState, parms.beforeLabelSuffix, afterFileState, parms.afterLabelSuffix);
        externalCompareOperation.run(null);
        return compareProperties[0];
    }

    protected OpenFileItemInExternalCompareOperation getOpenFileItemInExternalCompareOperation(String externalCompareTool, String[] compareProperties, FileState beforeFileState, String beforeLabelSuffix, FileState afterFileState, String afterLabelSuffix) {
        OpenFileItemInExternalCompareOperation externalCompareOperation = new OpenFileItemInExternalCompareOperation(externalCompareTool, afterFileState, afterLabelSuffix, beforeFileState, beforeLabelSuffix, this.getFileItemExternalCompareDilemmaHandler(compareProperties));
        return externalCompareOperation;
    }

    @Override
    public String postShowVersionableChangeCompare(ICompareRestClient.ParmsShowVersionableChangeCompare parms) throws TeamRepositoryException {
        String[] compareProperties = new String[]{parms.compareProperties};
        String externalCompareTool = parms.getExternalToolCommandLine();
        if (externalCompareTool == null) {
            this.showVersionableChangeEclipseCompare(parms);
        } else {
            compareProperties[0] = this.showVersionableChangeExternalCompare(parms, compareProperties, externalCompareTool);
        }
        return compareProperties[0];
    }

    @Override
    public void postShowPropertyChangeDetailCompare(ICompareRestClient.ParmsShowPropertyChangeDetailCompare parms, IProgressMonitor monitor) throws TeamRepositoryException {
        this.checkState();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)50);
        IWorkspaceConnection workspace = parms.getWorkspaceConnection((IProgressMonitor)progress.newChild(10));
        IComponentHandle component = parms.getComponentHandle();
        IVersionableChange versionableChange = parms.getVersionableChange((IProgressMonitor)progress.newChild(10));
        IPropertyChangeDetail propertyChangeDetail = parms.getPropertyChangeDetail((IProgressMonitor)progress.newChild(10));
        IShareable shareable = ComponentSyncUtil.findShareable((IContextHandle)workspace.getContextHandle(), (IComponentHandle)component, (IVersionableHandle)versionableChange.getVersionable(), (IProgressMonitor)progress.newChild(10));
        if (shareable == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.AbstractCompareRestClient_3, (Object)versionableChange.getName(), (Object[])new Object[0]));
        }
        UpdateCurrentPatchDilemmaHandler customHandler = new UpdateCurrentPatchDilemmaHandler(){

            public int uncheckedInChanges(Map<ConfigurationFacade, Collection<ILocalChange>> changes) {
                return 0;
            }
        };
        PropertyChangeDetailCompareEditorInput input = PropertyChangeDetailCompareEditorInput.create((IWorkspaceConnection)workspace, (IComponentHandle)component, (IVersionableChange)versionableChange, (IPropertyChangeDetail)propertyChangeDetail, (IShareable)shareable, (UpdateCurrentPatchDilemmaHandler)customHandler, (IProgressMonitor)progress.newChild(10));
        input.setInEditor(true);
        this.showInput((CompareEditorInput)input);
    }

    private String showVersionableChangeExternalCompare(ICompareRestClient.ParmsShowVersionableChangeCompare parms, String[] compareProperties, String externalCompareTool) throws TeamRepositoryException {
        String commandLine = externalCompareTool;
        if (!AbstractCompareRestClient.isValidExecutable(commandLine)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_0);
        }
        IWorkspaceConnection workspace = parms.getWorkspaceConnection(null);
        IComponentHandle component = parms.getComponentHandle();
        IVersionableChange versionableChange = parms.getVersionableChange();
        OpenVersionableChangeInExternalCompareOperation operation = this.getOpenVersionableChangeInExternalCompareOperation(commandLine, workspace, component, versionableChange, parms.useThreeWayCompare, this.getShareableExternalCompareDilemmaHandler(compareProperties));
        operation.run(null);
        return compareProperties[0];
    }

    private void showVersionableChangeEclipseCompare(ICompareRestClient.ParmsShowVersionableChangeCompare parms) throws TeamRepositoryException {
        this.checkState();
        IWorkspaceConnection workspace = parms.getWorkspaceConnection(null);
        IComponentHandle component = parms.getComponentHandle();
        IVersionableChange versionableChange = parms.getVersionableChange();
        CompareConfiguration compareConfiguration = new CompareConfiguration();
        compareConfiguration.setProperty(ICompareUIConstants.PROP_ANCESTOR_VISIBLE, (Object)parms.useThreeWayCompare);
        compareConfiguration.setChangeIgnored(3, parms.useThreeWayCompare);
        VersionableChangeCompareEditorInput input = new VersionableChangeCompareEditorInput(null, compareConfiguration, workspace, component, versionableChange, false);
        input.setHelpContextId("com.ibm.team.filesystem.ide.ui.editor_patchcompare");
        this.showInput((CompareEditorInput)input);
    }

    @Override
    public String postShowLocalFileChangeCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms) throws TeamRepositoryException {
        String[] compareProperties = new String[]{parms.compareProperties};
        String externalCompareTool = parms.getExternalToolCommandLine();
        if (externalCompareTool == null || !"file".equals(parms.versionableItemType)) {
            this.showLocalFileChangeEclipseCompare(parms);
        } else {
            compareProperties[0] = this.showLocalFileChangeExternalCompare(parms, compareProperties, externalCompareTool);
        }
        return compareProperties[0];
    }

    private void showLocalFileChangeEclipseCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms) throws TeamRepositoryException {
        this.checkState();
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_4, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        IShareable shareable = AbstractCompareRestClient.getShareable(parms.sandboxPath, parms.path);
        if (shareable != null) {
            LocalFileCompareEditorInput input;
            if (parms.itemId == null || parms.stateId == null || parms.itemId.length() == 0 || parms.stateId.length() == 0) {
                input = new LocalFileCompareEditorInput(new CompareConfiguration(), shareable, null, FileState.getDeletedState((IItemType)parms.getItemType(), null), false);
            } else {
                StateId remote = new StateId(parms.getItemType(), UUID.valueOf((String)parms.itemId), UUID.valueOf((String)parms.stateId));
                input = new LocalFileCompareEditorInput(new CompareConfiguration(), shareable, (IRemoteFunction)new FileStateRemoteFunction(repo, remote), false);
            }
            this.showInput((CompareEditorInput)input);
        }
    }

    private String showLocalFileChangeExternalCompare(ICompareRestClient.ParmsShowLocalChangeCompare parms, String[] compareProperties, String externalCompareTool) throws TeamRepositoryException {
        if (!AbstractCompareRestClient.isValidExecutable(externalCompareTool)) {
            throw new TeamRepositoryException(Messages.CompareRestClient_EXTERNAL_TOOLS_0);
        }
        ITeamRepository repo = TeamPlatform.getTeamRepositoryService().getTeamRepository(parms.repositoryUrl);
        if (repo == null) {
            throw new TeamRepositoryException(NLS.bind((String)Messages.CompareRestClient_4, (Object)parms.repositoryUrl, (Object[])new Object[0]));
        }
        IShareable shareable = AbstractCompareRestClient.getShareable(parms.sandboxPath, parms.path);
        if (shareable != null) {
            FileState remoteFileState;
            if (parms.itemId == null || parms.stateId == null || parms.itemId.length() == 0 || parms.stateId.length() == 0) {
                remoteFileState = FileState.getDeletedState((IItemType)IFileItem.ITEM_TYPE, null);
            } else {
                UUID itemUUID = UUID.valueOf((String)parms.itemId);
                UUID stateUUID = UUID.valueOf((String)parms.stateId);
                IFileItemHandle filehandle = (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, itemUUID, stateUUID);
                IFileItem versionable = (IFileItem)SCMPlatform.getWorkspaceManager((ITeamRepository)repo).versionableManager().fetchCompleteState((IVersionableHandle)filehandle, null);
                remoteFileState = ClientFileStateFactory.create((ITeamRepository)repo, (IItemType)filehandle.getItemType(), (IVersionable)versionable);
            }
            OpenShareableInExternalCompareOperation externalCompareOperation = this.getOpenShareableInExternalCompareOperation(externalCompareTool, compareProperties, shareable, remoteFileState);
            externalCompareOperation.run(null);
        }
        return compareProperties[0];
    }

    protected OpenShareableInExternalCompareOperation getOpenShareableInExternalCompareOperation(String externalCompareTool, String[] compareProperties, IShareable shareable, FileState remoteFileState) {
        OpenShareableInExternalCompareOperation externalCompareOperation = new OpenShareableInExternalCompareOperation(externalCompareTool, shareable, remoteFileState, this.getShareableExternalCompareDilemmaHandler(compareProperties));
        return externalCompareOperation;
    }

    private static boolean exists(IPath path, IProgressMonitor progress) throws FileSystemException {
        IFileInfo fileInfo;
        block3: {
            SubMonitor monitor = SubMonitor.convert((IProgressMonitor)progress, (int)100);
            IFileStore fileStorage = EFS.getLocalFileSystem().getStore(path);
            try {
                fileInfo = fileStorage.fetchInfo(0, (IProgressMonitor)monitor.newChild(100));
                if (!fileInfo.getAttribute(32)) break block3;
                return true;
            }
            catch (CoreException e) {
                throw new FileSystemException(NLS.bind((String)Messages.AbstractCompareRestClient_2, (Object)path.toString(), (Object[])new Object[0]), (Throwable)e);
            }
        }
        return fileInfo.exists();
    }
}

