/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.filesystem.cli.client.ui.compare;

import com.ibm.team.filesystem.cli.client.ui.compare.internal.Messages;
import com.ibm.team.filesystem.client.internal.rest.CommonUtil;
import com.ibm.team.filesystem.client.internal.rest.IValidatingParameterWrapper;
import com.ibm.team.filesystem.client.internal.rest.ParmValidation;
import com.ibm.team.filesystem.client.rest.parameters.ParmsExternalTool;
import com.ibm.team.filesystem.client.rest.parameters.ParmsSyncDescription;
import com.ibm.team.filesystem.client.rest.parameters.ParmsWorkspace;
import com.ibm.team.filesystem.common.IFileItem;
import com.ibm.team.filesystem.common.IFileItemHandle;
import com.ibm.team.filesystem.common.ISymbolicLink;
import com.ibm.team.filesystem.common.ISymbolicLinkHandle;
import com.ibm.team.filesystem.rcp.ui.internal.util.PathUtils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.scm.client.IWorkspaceConnection;
import com.ibm.team.scm.common.IChangeDetail;
import com.ibm.team.scm.common.IComponentHandle;
import com.ibm.team.scm.common.ICurrentPatch;
import com.ibm.team.scm.common.IFolder;
import com.ibm.team.scm.common.IFolderHandle;
import com.ibm.team.scm.common.IPropertyChangeDetail;
import com.ibm.team.scm.common.IVersionableChange;
import com.ibm.team.scm.common.IVersionableHandle;
import org.eclipse.core.runtime.IProgressMonitor;

public interface ICompareRestClient {
    public static final String COMPARE_PROPERTIES_ALWAYS = "always";
    public static final String COMPARE_PROPERTIES_NEVER = "never";
    public static final String COMPARE_PROPERTIES_PROMPT = "prompt";

    public String postShowFileItemCompare(ParmsShowItemCompare var1) throws TeamRepositoryException;

    public void postShowConflictCompare(ParmsSyncDescription var1) throws TeamRepositoryException;

    public String postShowLocalFileChangeCompare(ParmsShowLocalChangeCompare var1) throws TeamRepositoryException;

    public String postShowVersionableChangeCompare(ParmsShowVersionableChangeCompare var1) throws TeamRepositoryException;

    public void postShowPropertyChangeDetailCompare(ParmsShowPropertyChangeDetailCompare var1, IProgressMonitor var2) throws TeamRepositoryException;

    public static class ParmsShowItemCompare
    implements IValidatingParameterWrapper {
        public String repositoryUrl;
        public String versionableItemType;
        public String itemId;
        public String beforeStateId;
        public String afterStateId;
        public String beforePathHint;
        public String afterPathHint;
        public String beforeLabelSuffix;
        public String afterLabelSuffix;
        public String externalCompareTool;
        public ParmsExternalTool externalTool;
        public String compareProperties = "prompt";

        public ParmsShowItemCompare() {
        }

        public ParmsShowItemCompare(String repositoryUrl, String itemId, String versionableItemType, String beforeStateId, String beforePathHint, String beforeLabelSuffix, String afterStateId, String afterPathHint, String afterLabelSuffix) {
            this.repositoryUrl = repositoryUrl;
            this.itemId = itemId;
            this.versionableItemType = versionableItemType;
            this.beforeStateId = beforeStateId;
            this.beforePathHint = beforePathHint;
            this.beforeLabelSuffix = beforeLabelSuffix;
            this.afterStateId = afterStateId;
            this.afterPathHint = afterPathHint;
            this.afterLabelSuffix = afterLabelSuffix;
        }

        public void validate(String requestName, Object ... path) {
            ParmValidation.requiredValue((Object)this.repositoryUrl, (String)requestName, (Object[])new Object[]{path, "repositoryUrl"});
            ParmValidation.requiredValue((Object)this.itemId, (String)requestName, (Object[])new Object[]{path, "itemId"});
            ParmValidation.requiredValue((Object)this.versionableItemType, (String)requestName, (Object[])new Object[]{path, "versionableItemType"});
            ParmValidation.inEnum((String)this.versionableItemType, (String)requestName, (String[])new String[]{"file", "symbolic_link", "folder"}, (Object[])new Object[]{"versionableItemType"});
            ParmValidation.inEnum((String)this.compareProperties, (String)requestName, (String[])new String[]{ICompareRestClient.COMPARE_PROPERTIES_ALWAYS, ICompareRestClient.COMPARE_PROPERTIES_NEVER, ICompareRestClient.COMPARE_PROPERTIES_PROMPT}, (Object[])new Object[]{"compareProperties"});
            if (this.externalTool != null) {
                this.externalTool.validate(requestName, new Object[]{path, "externalTool"});
            }
        }

        public IVersionableHandle getVersionableHandle(ITeamRepository repo) throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return (IFileItemHandle)IFileItem.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            if ("folder".equals(this.versionableItemType)) {
                return (IFolderHandle)IFolder.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return (ISymbolicLinkHandle)ISymbolicLink.ITEM_TYPE.createItemHandle((Object)repo, UUID.valueOf((String)this.itemId), null);
            }
            return null;
        }

        public IItemType getItemType() throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return IFileItem.ITEM_TYPE;
            }
            if ("folder".equals(this.versionableItemType)) {
                return IFolder.ITEM_TYPE;
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return ISymbolicLink.ITEM_TYPE;
            }
            return null;
        }

        public String getExternalToolCommandLine() {
            String[] segments;
            if (this.externalCompareTool != null) {
                return this.externalCompareTool;
            }
            String path = this.afterPathHint;
            if (path == null) {
                path = this.beforePathHint;
            }
            if (this.externalTool != null && path != null && (segments = PathUtils.getSegments((String)path)).length > 0 && this.externalTool.matches(segments[segments.length - 1])) {
                return this.externalTool.externalTool;
            }
            return null;
        }
    }

    public static class ParmsShowLocalChangeCompare
    implements IValidatingParameterWrapper {
        public String repositoryUrl;
        public String sandboxPath;
        public String path;
        public String versionableItemType;
        public String itemId;
        public String stateId;
        public String externalCompareTool;
        public ParmsExternalTool externalTool;
        public String compareProperties = "prompt";

        public ParmsShowLocalChangeCompare() {
        }

        public ParmsShowLocalChangeCompare(String repositoryUrl, String sandboxPath, String path, String itemId, String versionableItemType, String stateId) {
            this.repositoryUrl = repositoryUrl;
            this.sandboxPath = sandboxPath;
            this.path = path;
            this.itemId = itemId;
            this.versionableItemType = versionableItemType;
            this.stateId = stateId;
        }

        public void validate(String requestName, Object ... parameterName) {
            ParmValidation.requiredValue((Object)this.repositoryUrl, (String)requestName, (Object[])new Object[]{parameterName, "repositoryUrl"});
            ParmValidation.requiredValue((Object)this.sandboxPath, (String)requestName, (Object[])new Object[]{parameterName, "sandboxPath"});
            ParmValidation.requiredValue((Object)this.path, (String)requestName, (Object[])new Object[]{parameterName, "filePath"});
            ParmValidation.requiredValue((Object)this.versionableItemType, (String)requestName, (Object[])new Object[]{parameterName, "versionableItemType"});
            ParmValidation.inEnum((String)this.versionableItemType, (String)requestName, (String[])new String[]{"file", "symbolic_link", "folder"}, (Object[])new Object[]{parameterName, "versionableItemType"});
            ParmValidation.inEnum((String)this.compareProperties, (String)requestName, (String[])new String[]{ICompareRestClient.COMPARE_PROPERTIES_ALWAYS, ICompareRestClient.COMPARE_PROPERTIES_NEVER, ICompareRestClient.COMPARE_PROPERTIES_PROMPT}, (Object[])new Object[]{"compareProperties"});
            if (this.externalTool != null) {
                this.externalTool.validate(requestName, new Object[]{this.path, "externalTool"});
            }
        }

        public IItemType getItemType() throws TeamRepositoryException {
            if ("file".equals(this.versionableItemType)) {
                return IFileItem.ITEM_TYPE;
            }
            if ("folder".equals(this.versionableItemType)) {
                return IFolder.ITEM_TYPE;
            }
            if ("symbolic_link".equals(this.versionableItemType)) {
                return ISymbolicLink.ITEM_TYPE;
            }
            return null;
        }

        public String getExternalToolCommandLine() {
            String[] segments;
            if (this.externalCompareTool != null) {
                return this.externalCompareTool;
            }
            if (this.externalTool != null && this.path != null && (segments = PathUtils.getSegments((String)this.path)).length > 0 && this.externalTool.matches(segments[segments.length - 1])) {
                return this.externalTool.externalTool;
            }
            return null;
        }
    }

    public static class ParmsShowPropertyChangeDetailCompare
    implements IValidatingParameterWrapper {
        public ParmsWorkspace workspace;
        public String componentId;
        public String versionableId;
        public String propertyChangeDetailId;

        public ParmsShowPropertyChangeDetailCompare() {
        }

        public ParmsShowPropertyChangeDetailCompare(ParmsWorkspace workspace, String componentId, String versionableId, String propertyChangeDetailId) {
            this.workspace = workspace;
            this.componentId = componentId;
            this.versionableId = versionableId;
            this.propertyChangeDetailId = propertyChangeDetailId;
        }

        public void validate(String requestName, Object ... parameterName) {
            ParmValidation.requiredValue((Object)this.workspace, (String)requestName, (Object[])new Object[]{parameterName, "workspace"});
            ParmValidation.requiredValue((Object)this.componentId, (String)requestName, (Object[])new Object[]{parameterName, "componentId"});
            ParmValidation.requiredValue((Object)this.versionableId, (String)requestName, (Object[])new Object[]{parameterName, "versionableId"});
            ParmValidation.requiredValue((Object)this.propertyChangeDetailId, (String)requestName, (Object[])new Object[]{parameterName, "propertyChangeDetailId"});
        }

        public IComponentHandle getComponentHandle() throws TeamRepositoryException {
            ITeamRepository repo = CommonUtil.getTeamRepository((String)this.workspace.repositoryUrl);
            IComponentHandle componentHandle = CommonUtil.createComponentHandle((ITeamRepository)repo, (String)this.componentId);
            return componentHandle;
        }

        public IVersionableChange getVersionableChange(IProgressMonitor monitor) throws TeamRepositoryException {
            IWorkspaceConnection workspaceConnection = this.workspace.getWorkspaceConnection(monitor);
            ICurrentPatch currentPort = workspaceConnection.getCurrentPatch(this.getComponentHandle());
            return currentPort.getVersionableChange(UUID.valueOf((String)this.versionableId));
        }

        public IPropertyChangeDetail getPropertyChangeDetail(IProgressMonitor monitor) throws TeamRepositoryException {
            IVersionableChange versionableChange = this.getVersionableChange(monitor);
            if (versionableChange == null) {
                throw new TeamRepositoryException(Messages.ICompareRestClient_2);
            }
            IChangeDetail changeDetail = versionableChange.getChangeDetail(UUID.valueOf((String)this.propertyChangeDetailId));
            if (changeDetail == null) {
                throw new TeamRepositoryException(Messages.ICompareRestClient_3);
            }
            if (!(changeDetail instanceof IPropertyChangeDetail)) {
                throw new TeamRepositoryException(Messages.ICompareRestClient_4);
            }
            return (IPropertyChangeDetail)changeDetail;
        }

        public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
            return this.workspace.getWorkspaceConnection(monitor);
        }
    }

    public static class ParmsShowVersionableChangeCompare
    implements IValidatingParameterWrapper {
        public ParmsWorkspace workspace;
        public String componentId;
        public String versionableId;
        public String name;
        public boolean useThreeWayCompare;
        public String externalCompareTool;
        public ParmsExternalTool externalTool;
        public String compareProperties = "prompt";

        public ParmsShowVersionableChangeCompare() {
        }

        public ParmsShowVersionableChangeCompare(ParmsWorkspace workspace, String componentId, String versionableId, boolean useThreeWayCompare) {
            this.workspace = workspace;
            this.componentId = componentId;
            this.versionableId = versionableId;
            this.useThreeWayCompare = useThreeWayCompare;
        }

        public void validate(String requestName, Object ... parameterName) {
            ParmValidation.requiredValue((Object)this.workspace, (String)requestName, (Object[])new Object[]{parameterName, "workspace"});
            ParmValidation.requiredValue((Object)this.componentId, (String)requestName, (Object[])new Object[]{parameterName, "componentId"});
            ParmValidation.requiredValue((Object)this.versionableId, (String)requestName, (Object[])new Object[]{parameterName, "versionableId"});
            ParmValidation.requiredValue((Object)this.useThreeWayCompare, (String)requestName, (Object[])new Object[]{parameterName, "useThreeWayCompare"});
            ParmValidation.inEnum((String)this.compareProperties, (String)requestName, (String[])new String[]{ICompareRestClient.COMPARE_PROPERTIES_ALWAYS, ICompareRestClient.COMPARE_PROPERTIES_NEVER, ICompareRestClient.COMPARE_PROPERTIES_PROMPT}, (Object[])new Object[]{"compareProperties"});
            if (this.externalTool != null) {
                this.externalTool.validate(requestName, new Object[]{parameterName, "externalTool"});
            }
        }

        public IComponentHandle getComponentHandle() throws TeamRepositoryException {
            ITeamRepository repo = CommonUtil.getTeamRepository((String)this.workspace.repositoryUrl);
            IComponentHandle componentHandle = CommonUtil.createComponentHandle((ITeamRepository)repo, (String)this.componentId);
            return componentHandle;
        }

        public IVersionableChange getVersionableChange() throws TeamRepositoryException {
            IWorkspaceConnection workspaceConnection = this.workspace.getWorkspaceConnection(null);
            ICurrentPatch currentPort = workspaceConnection.getCurrentPatch(this.getComponentHandle());
            return currentPort.getVersionableChange(UUID.valueOf((String)this.versionableId));
        }

        public IWorkspaceConnection getWorkspaceConnection(IProgressMonitor monitor) throws TeamRepositoryException {
            return this.workspace.getWorkspaceConnection(monitor);
        }

        public String getExternalToolCommandLine() {
            if (this.externalCompareTool != null) {
                return this.externalCompareTool;
            }
            if (this.externalTool != null && this.name != null && this.externalTool.matches(this.name)) {
                return this.externalTool.externalTool;
            }
            return null;
        }
    }
}

