/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

public class Mappings {
    public static int getSubjectRelationshipValue(String relation) {
        if (relation != null) {
            if ("owner".equalsIgnoreCase(relation)) {
                return 0;
            }
            if ("creator".equalsIgnoreCase(relation)) {
                return 1;
            }
            if ("subscriber".equalsIgnoreCase(relation)) {
                return 2;
            }
            if ("contributor".equalsIgnoreCase(relation)) {
                return 3;
            }
            if ("consumer".equalsIgnoreCase(relation)) {
                return 4;
            }
            if ("modifier".equalsIgnoreCase(relation)) {
                return 5;
            }
        }
        return -1;
    }

    public static boolean isOwner(String relation) {
        return relation != null && "owner".equalsIgnoreCase(relation);
    }

    public static boolean isUnknown(String relation) {
        return Mappings.getSubjectRelationshipValue(relation) <= 0;
    }

    public static int getSeverity(String severity) {
        if (severity != null) {
            if ("minor".equalsIgnoreCase(severity)) {
                return 1;
            }
            if ("normal".equalsIgnoreCase(severity)) {
                return 2;
            }
            if ("major".equalsIgnoreCase(severity)) {
                return 3;
            }
            if ("critical".equalsIgnoreCase(severity)) {
                return 4;
            }
            if ("blocker".equalsIgnoreCase(severity)) {
                return 5;
            }
        }
        return 0;
    }

    public static boolean isHighSeverity(String severity) {
        return Mappings.getSeverity(severity) >= 4;
    }
}

