/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.itemview.Messages;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.itemview.ItemViewer;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.itemview.TimelineFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.editor.FormEditor;

public class ItemViewerContentProvider
implements IStructuredContentProvider {
    private HashMap fGenericAggBins;
    private final Map fNewsListener = new HashMap();
    private final List fChannelListener = new ArrayList();
    private Object fInput;
    private FormEditor fEditor;

    public ItemViewerContentProvider() {
        this(null);
    }

    public ItemViewerContentProvider(FormEditor editor) {
        this.fEditor = editor;
    }

    public void dispose() {
        this.unregister();
    }

    public Object[] getElements(Object inputElement) {
        if (this.fGenericAggBins != null) {
            this.fGenericAggBins.clear();
        }
        if (this.fInput instanceof Channel[]) {
            ArrayList<NewsItem> elements = new ArrayList<NewsItem>();
            Channel[] channels = (Channel[])this.fInput;
            int i = 0;
            while (i < channels.length) {
                Channel channel = channels[i];
                elements.addAll(Arrays.asList(channel.getItems()));
                ++i;
            }
            return this.aggregateEvents(elements.toArray(new NewsItem[elements.size()]));
        }
        if (this.fInput instanceof Object[]) {
            return (Object[])this.fInput;
        }
        return new Object[0];
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.unregister();
        this.fInput = newInput;
        this.register(viewer);
    }

    private void register(final Viewer viewer) {
        if (this.fInput instanceof Channel[]) {
            final Channel[] channels = (Channel[])this.fInput;
            int i = 0;
            while (i < channels.length) {
                INewsListener newsListener = new INewsListener(){

                    public void newsReceived(NewsEvent event) {
                        ItemViewerContentProvider.this.refreshViewer(viewer, event, EventType.NEWS_RECEIVED);
                    }

                    public void newsRemoved(NewsEvent event) {
                        ItemViewerContentProvider.this.refreshViewer(viewer, event, EventType.NEWS_REMOVED);
                    }

                    public void newsStateChanged(NewsEvent event) {
                        if (ItemViewerContentProvider.this.fGenericAggBins != null) {
                            NewsItem[] items;
                            HashSet<String> toUpdate = new HashSet<String>();
                            NewsItem[] newsItemArray = items = event.getChangedNews();
                            int n = items.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Object object;
                                NewsItem item = newsItemArray[n2];
                                GenericAggregationBin bin = (GenericAggregationBin)ItemViewerContentProvider.this.fGenericAggBins.get(ItemViewerContentProvider.this.generateKey(item));
                                if (bin != null && (object = bin.getMostRecent()) != null) {
                                    toUpdate.add(String.valueOf(object.hashCode()));
                                }
                                ++n2;
                            }
                            ((ItemViewer)viewer).update(toUpdate.toArray());
                        }
                    }
                };
                this.fNewsListener.put(channels[i], newsListener);
                FeedManager.getDefault().addNewsListener(channels[i], newsListener);
                IChannelListener channelListener = new IChannelListener(){

                    public void channelEdited(ChannelEvent event) {
                        boolean affectsViewer = false;
                        int j = 0;
                        while (j < channels.length) {
                            if (channels[j].equals((Object)event.getChannel())) {
                                affectsViewer = true;
                                break;
                            }
                            ++j;
                        }
                        if (affectsViewer) {
                            ItemViewerContentProvider.this.refreshViewer(viewer, null, EventType.CHANNEL_EDITED);
                        }
                    }

                    public void channelStatusChanged(ChannelEvent event) {
                    }
                };
                this.fChannelListener.add(channelListener);
                FeedManager.getDefault().addChannelListener(channelListener);
                ++i;
            }
        }
    }

    private boolean affectsViewer(Viewer viewer, NewsItem[] events) {
        if (events == null || events.length == 0) {
            return false;
        }
        if (viewer instanceof ItemViewer) {
            ViewerFilter[] filters = ((ItemViewer)viewer).getFilters();
            if (filters.length == 0) {
                return true;
            }
            NewsItem[] newsItemArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                NewsItem event = newsItemArray[n2];
                boolean affected = true;
                ViewerFilter[] viewerFilterArray = filters;
                int n3 = filters.length;
                int n4 = 0;
                while (n4 < n3) {
                    ViewerFilter filter = viewerFilterArray[n4];
                    if (!(filter instanceof TimelineFilter) && !filter.select(viewer, (Object)TreePath.EMPTY, (Object)event)) {
                        affected = false;
                        break;
                    }
                    ++n4;
                }
                if (affected) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        return true;
    }

    private void addNewsToBin(NewsItem item) {
        String key = this.generateKey(item);
        if (item != null && this.fGenericAggBins.containsKey(key)) {
            GenericAggregationBin bin = (GenericAggregationBin)this.fGenericAggBins.get(key);
            bin.add((Object)item);
        } else {
            GenericAggregationBin bin = new GenericAggregationBin();
            bin.add((Object)item);
            this.fGenericAggBins.put(key, bin);
        }
    }

    private String generateKey(NewsItem item) {
        return String.valueOf(item.getLink()) + item.getCategory();
    }

    private GenericAggregationBin[] aggregateEvents(NewsItem[] items) {
        if (this.fGenericAggBins == null) {
            this.fGenericAggBins = new HashMap();
        }
        int i = 0;
        while (i < items.length) {
            NewsItem item = items[i];
            if (item != null) {
                this.addNewsToBin(item);
            }
            ++i;
        }
        return this.fGenericAggBins.values().toArray(new GenericAggregationBin[this.fGenericAggBins.size()]);
    }

    private void refreshViewer(final Viewer viewer, final NewsEvent event, final EventType type) {
        Control control = viewer.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        if (type == EventType.NEWS_REMOVED && !event.isUserInitiated()) {
            return;
        }
        control.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                    public void run() throws Exception {
                        if (type == EventType.NEWS_RECEIVED && !event.isUserInitiated() && ItemViewerContentProvider.this.fEditor != null && ItemViewerContentProvider.this.fEditor instanceof MarkupItemView) {
                            if (ItemViewerContentProvider.this.affectsViewer(viewer, event.getAddedNews())) {
                                ItemViewerContentProvider.this.showTitlePartMessage(Messages.ItemViewerContentProvider_REFRESH_FOR_UPDATE, 1);
                            }
                        } else if (type == EventType.NEWS_RECEIVED && event.isUserInitiated()) {
                            if (ItemViewerContentProvider.this.affectsViewer(viewer, event.getAddedNews())) {
                                ItemViewerContentProvider.this.showTitlePartMessage(null, 0);
                                viewer.refresh();
                            }
                        } else {
                            ItemViewerContentProvider.this.showTitlePartMessage(null, 0);
                            viewer.refresh();
                        }
                    }

                    public void handleException(Throwable exception) {
                        if (exception instanceof Exception) {
                            FeedUIPlugin.getDefault().log(exception.getMessage(), (Exception)exception);
                        }
                    }
                });
            }
        });
    }

    private void showTitlePartMessage(String message, int type) {
        if (this.fEditor != null && this.fEditor instanceof MarkupItemView) {
            ((MarkupItemView)this.fEditor).showMessage(message, type);
        }
    }

    private void unregister() {
        if (this.fInput == null) {
            return;
        }
        if (this.fInput instanceof Channel[]) {
            Set keys = this.fNewsListener.keySet();
            for (Channel channel : keys) {
                INewsListener newsListener = (INewsListener)this.fNewsListener.get(channel);
                FeedManager.getDefault().removeNewsListener(channel, newsListener);
            }
            for (IChannelListener channelListener : this.fChannelListener) {
                FeedManager.getDefault().removeChannelListener(channelListener);
            }
            this.fChannelListener.clear();
            this.fNewsListener.clear();
        }
    }

    private static enum EventType {
        NEWS_RECEIVED,
        NEWS_REMOVED,
        CHANNEL_EDITED;

    }
}

