/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.itemview.Mappings;
import com.ibm.team.feed.ui.internal.itemview.Messages;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.itemview.IItemViewUIAdvisor;
import com.ibm.team.jface.itemview.ItemViewUIConfigurer;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.MarkupItemView;
import java.util.ArrayList;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;

public class FeedItemViewUIAdvisor
implements IItemViewUIAdvisor {
    public static final String MODIFIED_BY_ME_FILTER_ID = "com.ibm.team.feed.ui.internal.ModifiedFilter";

    public void configure(ItemViewUIConfigurer configurer) {
        configurer.addSorter(this.createSeveritySorter("com.ibm.team.feed.ui.internal.itemview.SeveritySorter", Messages.FeedItemViewUIAdvisor_SEVERITY));
        configurer.addFilter(this.createModifiedByMeFilter());
    }

    private ItemViewerFilter createModifiedByMeFilter() {
        ItemViewerFilter modifiedFilter = new ItemViewerFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                ArrayList<NewsItem> items = new ArrayList<NewsItem>();
                boolean isBin = false;
                if (element instanceof GenericAggregationBin) {
                    items.addAll(((GenericAggregationBin)element).getItems());
                    isBin = true;
                } else if (element instanceof NewsItem) {
                    NewsItem item = (NewsItem)element;
                    items.add(item);
                }
                for (NewsItem newsItem : items) {
                    String modifierId;
                    String contributorId = ClientFeedUtils.getInstance().getCurrentContributorId(newsItem);
                    if (contributorId == null && (contributorId = ClientFeedUtils.getInstance().getCurrentAuthorContributorUserId(newsItem)) == null || !contributorId.equals(modifierId = newsItem.getCustomAttribute("http://www.ibm.com/team/Feed", "modifier"))) continue;
                    if (items.size() == 1) {
                        return false;
                    }
                    if (!isBin) continue;
                    GenericAggregationBin bin = (GenericAggregationBin)element;
                    bin.remove((Object)newsItem);
                    if (bin.getSize() != 0) continue;
                    return false;
                }
                return true;
            }
        }, MODIFIED_BY_ME_FILTER_ID, Messages.FeedItemViewUIAdvisor_MODIFIED_BY_ME, 1);
        modifiedFilter.setEnabledByDefault(true);
        return modifiedFilter;
    }

    private ItemViewerSorter createSeveritySorter(String id, String name) {
        ViewerSorter sorter = new ViewerSorter(){

            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof GenericAggregationBin) {
                    e1 = ((GenericAggregationBin)e1).getMostRecent();
                }
                if (e2 instanceof GenericAggregationBin) {
                    e2 = ((GenericAggregationBin)e2).getMostRecent();
                }
                if (e1 instanceof NewsItem && e2 instanceof NewsItem) {
                    int sev2;
                    NewsItem item1 = (NewsItem)e1;
                    NewsItem item2 = (NewsItem)e2;
                    int sev1 = Mappings.getSeverity(item1.getCustomAttribute("http://www.ibm.com/team/Feed", "severity"));
                    if (sev1 == (sev2 = Mappings.getSeverity(item2.getCustomAttribute("http://www.ibm.com/team/Feed", "severity")))) {
                        return this.compareByDate(viewer, e1, e2);
                    }
                    if (sev1 == 0) {
                        return 1;
                    }
                    return sev1 < sev2 ? 1 : -1;
                }
                return super.compare(viewer, e1, e2);
            }

            private int compareByDate(Viewer viewer, Object e1, Object e2) {
                IDateProvider dateProvider1 = MarkupItemView.getDateProvider((Object)e1);
                IDateProvider dateProvider2 = MarkupItemView.getDateProvider((Object)e2);
                if (dateProvider1 != null && dateProvider2 != null) {
                    Date date1 = dateProvider1.getDate();
                    Date date2 = dateProvider2.getDate();
                    if (date2 != null) {
                        return Dates.compareTo((Date)date2, (Date)date1);
                    }
                }
                return super.compare(viewer, e1, e2);
            }
        };
        return new ItemViewerSorter(sorter, id, name);
    }
}

