/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.internal.throttle.FeedReadType;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.itemview.FeedItemViewPage;
import com.ibm.team.feed.ui.internal.itemview.Messages;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class FeedItemView
extends MarkupItemView {
    private Channel[] fChannels;
    IChannelListener fChannelListener = new IChannelListener(){

        public void channelEdited(ChannelEvent event) {
        }

        public void channelStatusChanged(ChannelEvent event) {
            FeedItemView.this.updateBusyState();
        }
    };

    protected void addPages() {
        this.setPartName(this.getEditorInput().getName());
        FeedItemViewPage page = new FeedItemViewPage((FormEditor)this);
        try {
            this.addPage((IFormPage)page);
        }
        catch (PartInitException e) {
            FeedUIPlugin.getDefault().log("Error while adding FeedItemViewPage to FeedItemView", (Exception)((Object)e));
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        MarkupItemViewInput newInput = (MarkupItemViewInput)input;
        Object objectInput = newInput.getInput();
        if (objectInput instanceof Channel[]) {
            this.fChannels = (Channel[])objectInput;
            FeedManager.getDefault().addChannelListener(this.fChannelListener);
            this.updateBusyState();
        } else {
            FeedManager.getDefault().removeChannelListener(this.fChannelListener);
            this.setBusy(false);
        }
    }

    public void doSaveAs() {
    }

    private void updateBusyState() {
        if (this.fChannels != null) {
            Channel[] channelArray = this.fChannels;
            int n = this.fChannels.length;
            int n2 = 0;
            while (n2 < n) {
                Channel channel = channelArray[n2];
                if (channel.isLoading()) {
                    this.setBusy(true);
                    return;
                }
                ++n2;
            }
        }
        this.setBusy(false);
    }

    private void setBusy(final boolean isBusy) {
        FoundationUIJob uijob = new FoundationUIJob(Messages.FeedItemView_CHANGING_BUSY_STATE){

            protected IStatus runProtectedInUI(IProgressMonitor monitor) throws Exception {
                ScrolledForm form;
                IManagedForm headerForm = FeedItemView.this.getHeaderForm();
                if (headerForm != null && (form = headerForm.getForm()) != null) {
                    form.setBusy(isBusy);
                }
                return Status.OK_STATUS;
            }
        };
        uijob.setSystem(true);
        uijob.schedule();
    }

    public void dispose() {
        FeedManager.getDefault().removeChannelListener(this.fChannelListener);
        super.dispose();
    }

    public void setFocus() {
        IFormPage page = this.getActivePageInstance();
        if (page != null) {
            page.setFocus();
        }
        Channel[] channelArray = this.fChannels;
        int n = this.fChannels.length;
        int n2 = 0;
        while (n2 < n) {
            Channel channel = channelArray[n2];
            channel.addUsed((Channel.IFeedReadType)FeedReadType.NEWS_FOCUSED, new Date());
            ++n2;
        }
    }
}

