/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.itemview;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.ColorDefinitions;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.feed.ui.internal.itemview.Messages;
import com.ibm.team.foundation.common.internal.util.Dates;
import com.ibm.team.foundation.rcp.core.IDateProvider;
import com.ibm.team.foundation.rcp.core.ILinkProvider;
import com.ibm.team.foundation.rcp.core.IReadStateTracker;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.JFacePlugin;
import com.ibm.team.jface.itemview.IItemViewerLabelProvider;
import com.ibm.team.jface.itemview.ItemViewerLabel;
import com.ibm.team.jface.itemview.MarkupItemView;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import com.ibm.team.repository.common.util.NLS;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.RGB;

public class DefaultItemViewLabelProvider
implements IItemViewerLabelProvider {
    private final DateFormat fDateTimeFormat = DateFormat.getDateTimeInstance((int)0, (int)3);

    public void updateLabel(ItemViewerLabel label, Object element) {
        IAdaptable adapter;
        IReadStateTracker tracker;
        RGB colorLabel;
        ImageDescriptor id;
        GenericAggregationBin bin;
        GenericAggregationBin genericAggregationBin = bin = element instanceof GenericAggregationBin ? (GenericAggregationBin)element : null;
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        IDomainAdapter domainAdapter = DomainAdapterUtils.getDomainAdapter((Object)element);
        IDomainAdapter.Info info = new IDomainAdapter.Info();
        info.isEmbeddeble = true;
        if (domainAdapter == null) {
            JFacePlugin.getDefault().log("Could not find a DomainAdapter for: " + element, null);
            label.setTitle(NLS.bind((String)Messages.DefaultItemViewLabelProvider_MISSING_DOMAINADAPTER, (Object)element, (Object[])new Object[0]));
            return;
        }
        String title = domainAdapter.generateTitle(element);
        if (bin != null && bin.getSize() > 1) {
            title = NLS.bind((String)Messages.DefaultItemViewLabelProvider_NEWS_BIN, (Object)bin.getSize(), (Object[])new Object[]{title});
        }
        label.setTitle(title);
        ILinkProvider linkProvider = MarkupItemView.getLinkProvider((Object)element);
        label.setLink(linkProvider != null ? linkProvider.getLink() : null);
        IDateProvider dateProvider = MarkupItemView.getDateProvider((Object)element);
        label.setDate(dateProvider != null ? dateProvider.getDate() : null);
        String category = null;
        if (element instanceof NewsItem) {
            category = ((NewsItem)element).getCategory();
            id = FeedUIPlugin.getCategoryImageDescriptor(category);
            if (id == null) {
                id = ImagePool.NEWS;
            }
        } else {
            id = FeedUIPlugin.getObjectImageDescriptor(element);
        }
        if (id != null) {
            URL image = FeedUIPlugin.createURL(id);
            if (image != null && "bundleentry".equals(image.getProtocol())) {
                try {
                    image = FileLocator.toFileURL((URL)image);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            label.setImage(image);
        }
        if (category != null) {
            label.setImageTooltip(NLS.bind((String)Messages.DefaultItemViewLabelProvider_CATEGORY, (Object)category, (Object[])new Object[0]));
        }
        if (element instanceof NewsItem) {
            NewsItem newsItem = (NewsItem)element;
            String relation = ClientFeedUtils.getInstance().getRelation(newsItem);
            id = FeedUIPlugin.getSubjectRelationShipImageDescriptor(relation);
            label.setSecondaryImage(FeedUIPlugin.createURL(id));
            if (relation == null) {
                relation = "unknown";
            }
            label.setSecondaryImageTooltip(NLS.bind((String)Messages.DefaultItemViewLabelProvider_RELATION, (Object)relation, (Object[])new Object[0]));
        }
        label.setDescription(this.getDescription(domainAdapter, bin, element, label, info));
        int fontStyle = 1;
        if (element instanceof NewsItem && (colorLabel = this.getLabel((NewsItem)element)) != null) {
            label.setColor(colorLabel);
        }
        if (element instanceof IReadStateTracker && ((IReadStateTracker)element).isMarkedRead()) {
            fontStyle &= 0xFFFFFFFE;
        } else if (element instanceof IAdaptable && (tracker = (IReadStateTracker)(adapter = (IAdaptable)element).getAdapter(IReadStateTracker.class)) != null && tracker.isMarkedRead()) {
            fontStyle &= 0xFFFFFFFE;
        }
        label.setFontStyle(fontStyle);
    }

    private RGB getLabel(NewsItem item) {
        String str;
        String[] parts;
        Object object = item.getCustomField("com.ibm.team.feed.core.LabelNewsNotifier");
        if (object != null && (parts = (str = (String)object).split(",")).length == 3) {
            return new RGB(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2]));
        }
        String relation = ClientFeedUtils.getInstance().getRelation(item);
        if ("owner".equals(relation)) {
            return ColorDefinitions.fgMyColor;
        }
        if (item.getChannel() != null) {
            return ColorDefinitions.convertToRGB(item.getChannel().getColor());
        }
        return null;
    }

    private String getDescription(IDomainAdapter domainAdapter, GenericAggregationBin bin, Object element, ItemViewerLabel label, IDomainAdapter.Info info) {
        StringBuffer part = new StringBuffer();
        ArrayList<Object> items = new ArrayList<Object>();
        if (bin != null) {
            items.addAll(bin.getItems());
        } else {
            items.add(element);
        }
        Object[] sortedItems = items.toArray();
        Arrays.sort(sortedItems, new Comparator(){

            public int compare(Object o1, Object o2) {
                Date date1 = MarkupItemView.getDateProvider((Object)o1).getDate();
                Date date2 = MarkupItemView.getDateProvider((Object)o2).getDate();
                return Dates.compareTo((Date)date2, (Date)date1);
            }
        });
        int i = 0;
        while (i < sortedItems.length) {
            Object item = sortedItems[i];
            if (sortedItems.length > 1) {
                part.append(i > 0 ? "<br/>" : "");
                this.renderTimelineDateBox(part, MarkupItemView.getDateProvider((Object)item).getDate());
            }
            domainAdapter.generateContentAsHTML(label.getCSS(), part, item, info);
            ++i;
        }
        return part.toString();
    }

    private void renderTimelineDateBox(StringBuffer strBuf, Date d) {
        strBuf.append("<div class=\"timelineBoxSubTitle\" style=\"font-weight: bold;\">" + this.fDateTimeFormat.format(d) + "</div>");
        strBuf.append("<div class=\"timelineBoxSeparator1\" style=\"margin-left: 0px;\"><img src=\"" + JazzResources.createResourceURL((String)"com.ibm.team.jface", (String)"icons/html/spacer.gif") + "\" height=\"1\" /></div>\n");
        strBuf.append("<div class=\"timelineBoxSeparator2\" style=\"margin-left: 0px;\"><img src=\"" + JazzResources.createResourceURL((String)"com.ibm.team.jface", (String)"icons/html/spacer.gif") + "\" height=\"1\" /></div>\n");
    }
}

