/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.internal.dashboard.ColorRegistry;
import java.util.Enumeration;
import java.util.Hashtable;
import org.eclipse.jface.resource.ColorDescriptor;
import org.eclipse.jface.resource.CompositeImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ViewerLabel;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;

public class SecondColumnImageDecorator
extends DecoratingLabelProvider {
    private Hashtable fImgCache = new Hashtable();
    private ILabelProvider fLabelProvider;
    private ILabelDecorator fWrappedLabelDecorator;
    private ILabelProvider fWrappedSecondColumnImageProvider;
    private boolean isMac = "carbon".equals(SWT.getPlatform());
    private ResourceManager fResourceManager;

    public SecondColumnImageDecorator(ILabelProvider provider, ILabelProvider secondColumnImageProvider, ILabelDecorator decorator) {
        super(provider, decorator);
        this.fWrappedLabelDecorator = decorator;
        this.fLabelProvider = provider;
        this.fWrappedSecondColumnImageProvider = secondColumnImageProvider;
        this.fResourceManager = new LocalResourceManager(JFaceResources.getResources());
    }

    public void dispose() {
        Enumeration elements = this.fImgCache.elements();
        while (elements.hasMoreElements()) {
            Image element = (Image)elements.nextElement();
            element.dispose();
        }
        this.fLabelProvider.dispose();
        this.fWrappedLabelDecorator.dispose();
        this.fWrappedSecondColumnImageProvider.dispose();
        this.fResourceManager.dispose();
    }

    private String toCacheEntry(Image img1, Image img2) {
        StringBuffer str = new StringBuffer();
        str.append(img1.hashCode());
        str.append(img2.hashCode());
        return str.toString();
    }

    protected void updateForDecorationReady(ViewerLabel settings, Object element) {
        Color background;
        Color color = background = this.isMac ? null : JazzResources.getColor((ResourceManager)this.fResourceManager, (ColorDescriptor)ColorRegistry.getDefault().getColorDescriptor((Object)"TEAM_CENTRAL_BACKGROUND"));
        if (!this.isMac && background != null) {
            settings.setBackground(background);
        }
        if (this.fLabelProvider instanceof ITableColorProvider) {
            ITableColorProvider colorProvider = (ITableColorProvider)this.fLabelProvider;
            settings.setForeground(colorProvider.getForeground(element, 0));
        }
        if (this.fLabelProvider instanceof ITableFontProvider) {
            settings.setFont(((ITableFontProvider)this.fLabelProvider).getFont(element, 0));
        }
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem) {
            String cacheKey;
            final Image firstColImg = this.fWrappedLabelDecorator.decorateImage(this.fLabelProvider.getImage(element), element);
            if (background != null) {
                firstColImg.setBackground(background);
            }
            final Image secondColImg = this.fWrappedSecondColumnImageProvider.getImage(element);
            if (background != null) {
                secondColImg.setBackground(background);
            }
            if (!this.fImgCache.containsKey(cacheKey = this.toCacheEntry(firstColImg, secondColImg))) {
                CompositeImageDescriptor aggregatedImageDesc = new CompositeImageDescriptor(){

                    protected void drawCompositeImage(int width, int height) {
                        this.drawImage(firstColImg.getImageData(), 0, 0);
                        this.drawImage(secondColImg.getImageData(), 16, 0);
                    }

                    protected Point getSize() {
                        return new Point(32, 16);
                    }
                };
                Image aggregatedImage = aggregatedImageDesc.createImage();
                this.fImgCache.put(cacheKey, aggregatedImage);
            }
            settings.setImage((Image)this.fImgCache.get(cacheKey));
        } else {
            settings.setImage(this.fLabelProvider.getImage(element));
        }
    }
}

