/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.ColorDefinitions;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.core.HistoryBin;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.OverlayIcon;
import com.ibm.team.jface.itemview.MarkupUtil;
import java.util.Date;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.osgi.util.TextProcessor;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.PlatformUI;

public class NewsLabelProvider
extends LabelProvider
implements ITableFontProvider,
ITableColorProvider {
    private static final String NEW_ITEM_INDICATOR = "*";
    private ResourceManager fResources;
    private Image fDefaultNewsIcon;
    private final boolean fUseReducedColors = "org.eclipse.ui.ide.systemDefault".equals(PlatformUI.getWorkbench().getThemeManager().getCurrentTheme().getId());

    public NewsLabelProvider() {
        this.fResources = new LocalResourceManager(JFaceResources.getResources());
        this.fDefaultNewsIcon = JazzResources.getImageWithDefault((ResourceManager)this.fResources, (ImageDescriptor)ImagePool.NEWS);
    }

    public void dispose() {
        this.fResources.dispose();
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public Font getFont(Object element, int columnIndex) {
        NewsItem item;
        boolean unread;
        if (element == null) {
            return null;
        }
        GenericAggregationBin bin = null;
        if (element instanceof GenericAggregationBin) {
            bin = (GenericAggregationBin)element;
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        boolean bl = unread = !(item = (NewsItem)element).isIsRead() || bin != null && bin.containsUnread();
        if (unread) {
            return (Font)this.fResources.get((DeviceResourceDescriptor)JFaceResources.getFontDescriptor((String)"").withStyle(1));
        }
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        NewsItem item;
        Color label;
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem && (label = this.getLabel(item = (NewsItem)element)) != null) {
            return label;
        }
        return null;
    }

    Color getDateForegroundColor() {
        if (this.fUseReducedColors) {
            return this.fResources.getDevice().getSystemColor(24);
        }
        return this.fResources.getDevice().getSystemColor(16);
    }

    boolean useCustomOwnerDraw() {
        return !this.fUseReducedColors;
    }

    private Color getLabel(NewsItem item) {
        String str;
        String[] parts;
        if (this.fUseReducedColors) {
            return this.fResources.getDevice().getSystemColor(24);
        }
        Object object = item.getCustomField("com.ibm.team.feed.core.LabelNewsNotifier");
        if (object != null && (parts = (str = (String)object).split(",")).length == 3) {
            return JazzResources.getColor((ResourceManager)this.fResources, (RGB)new RGB(Integer.parseInt(parts[0]), Integer.parseInt(parts[1]), Integer.parseInt(parts[2])));
        }
        String relation = ClientFeedUtils.getInstance().getRelation(item);
        if ("owner".equals(relation)) {
            return JazzResources.getColor((ResourceManager)this.fResources, (RGB)ColorDefinitions.fgMyColor);
        }
        Channel channel = item.getChannel();
        if (channel != null) {
            return this.fResources.createColor(ColorDefinitions.convertToRGB(channel.getColor()));
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem) {
            NewsItem item = (NewsItem)element;
            String title = item.getTitle();
            if (title != null && title.startsWith(NEW_ITEM_INDICATOR)) {
                ImageDescriptor base = FeedUIPlugin.getCategoryImageDescriptor(item.getCategory());
                ImageDescriptor overlay = ImagePool.NEW_TICK;
                ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[2];
                imageDescriptorArray[1] = overlay;
                OverlayIcon icon = new OverlayIcon(base, imageDescriptorArray, 131200);
                return JazzResources.getImage((ResourceManager)this.fResources, (ImageDescriptor)icon, (Image)this.fDefaultNewsIcon);
            }
            return JazzResources.getImage((ResourceManager)this.fResources, (ImageDescriptor)FeedUIPlugin.getCategoryImageDescriptor(item.getCategory()), (Image)this.fDefaultNewsIcon);
        }
        return super.getImage(element);
    }

    public String getText(Object element) {
        return this.internalGetText(element, !this.fUseReducedColors);
    }

    public String getText(Object element, boolean styled) {
        return this.internalGetText(element, styled);
    }

    private String internalGetText(Object element, boolean styled) {
        if (element instanceof GenericAggregationBin) {
            Object mostRecentElement = ((GenericAggregationBin)element).getMostRecent();
            int aggCount = ((GenericAggregationBin)element).getSize();
            if (aggCount > 1) {
                if (styled) {
                    return "<light>[" + aggCount + "]</light> " + this.getText(mostRecentElement);
                }
                return "[" + aggCount + "] " + this.getText(mostRecentElement);
            }
            return this.getText(mostRecentElement, styled);
        }
        if (element instanceof NewsItem) {
            NewsItem item = (NewsItem)element;
            Date itemDate = item.getPublishDate();
            StringBuilder itemText = new StringBuilder();
            String title = ((NewsItem)element).getTitle();
            if (title == null) {
                title = Messages.NewsLabelProvider_NO_TITLE;
            } else {
                if (title.startsWith(NEW_ITEM_INDICATOR)) {
                    title = title.substring(NEW_ITEM_INDICATOR.length());
                }
                if (title.contains("<") || title.contains(">") || title.contains("&")) {
                    title = XMLString.createFromXMLText((String)title).getPlainText();
                }
                title = MarkupUtil.normalizeString((String)title);
            }
            itemText.append(TextProcessor.process((String)title, (String)"()"));
            if (itemDate != null) {
                if (styled) {
                    itemText.append("  <light>").append(HistoryBin.formatDif((Date)itemDate, (boolean)false, (boolean)true)).append("</light>");
                } else {
                    itemText.append("  ").append(HistoryBin.formatDif((Date)itemDate, (boolean)false, (boolean)true));
                }
            }
            return itemText.toString();
        }
        return super.getText(element);
    }
}

