/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.jface.GenericAggregationBin;
import java.util.Date;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;

public class NewsFilter
extends ViewerFilter {
    public static final int MAX_COUNT_ON_FILTER_BY_NUMBER = 5;
    private boolean fFilterByNumber;
    private boolean fFilterByState;
    private ChannelManager fChannelManager;

    private boolean isChannelFiltered(String channelUrl) {
        return !this.fChannelManager.isChannelSelected(channelUrl);
    }

    public boolean isFilterByNumber() {
        return this.fFilterByNumber;
    }

    public boolean isFilterByState() {
        return this.fFilterByState;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        GenericAggregationBin bin = null;
        if (element instanceof GenericAggregationBin) {
            bin = (GenericAggregationBin)element;
        }
        if (element instanceof GenericAggregationBin) {
            element = ((GenericAggregationBin)element).getMostRecent();
        }
        if (element instanceof NewsItem) {
            NewsItem item = (NewsItem)element;
            Date itemDate = item.getPublishDate();
            if (this.isChannelFiltered(item.getChannel().getUrl())) {
                return false;
            }
            if (item.isIsRead() && this.fFilterByState && (bin == null || !bin.containsUnread())) {
                return false;
            }
            if (itemDate == null) {
                return true;
            }
        }
        return false;
    }

    public void setFilterByNumber(boolean filterByNumber) {
        this.fFilterByNumber = filterByNumber;
    }

    public void setFilterByState(boolean filterByState) {
        this.fFilterByState = filterByState;
    }

    public void setSelectedChannels(ChannelManager selectedChannels) {
        this.fChannelManager = selectedChannels;
    }
}

