/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.feed.ui.internal.dashboard.NewsTableViewer;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.dashboard.ISectionSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Display;

public class NewsContentProvider
implements IStructuredContentProvider {
    private HashMap<String, GenericAggregationBin> fAggBins;
    private INewsListener fNewsListener;
    private final ISectionSite fSectionSite;
    private Viewer fViewer;
    private final ChannelManager fChannelManager;

    public NewsContentProvider(ISectionSite sectionSite, ChannelManager channelManager) {
        this.fSectionSite = sectionSite;
        this.fChannelManager = channelManager;
        this.initNewsListener();
    }

    private void addNewsToBin(NewsItem item) {
        String itemKey = this.generateKey(item);
        if (item != null && this.fAggBins.containsKey(itemKey)) {
            GenericAggregationBin bin = this.fAggBins.get(itemKey);
            bin.add((Object)item);
        } else {
            GenericAggregationBin bin = new GenericAggregationBin();
            bin.add((Object)item);
            this.fAggBins.put(itemKey, bin);
        }
    }

    private GenericAggregationBin[] aggregateEvents(NewsItem[] items) {
        if (this.fAggBins == null) {
            this.fAggBins = new HashMap();
        }
        int i = 0;
        while (i < items.length) {
            NewsItem item = items[i];
            if (item != null) {
                this.addNewsToBin(item);
            }
            ++i;
        }
        return this.fAggBins.values().toArray(new GenericAggregationBin[this.fAggBins.size()]);
    }

    public void dispose() {
        FeedManager.getDefault().removeNewsListener(this.fNewsListener);
    }

    public Object[] getElements(Object inputElement) {
        if (inputElement instanceof GenericAggregationBin[]) {
            return (GenericAggregationBin[])inputElement;
        }
        HashSet channelUrls = this.fChannelManager.getSelectedChannelUrls();
        ArrayList<NewsItem> newsItems = new ArrayList<NewsItem>();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            newsItems.addAll(Arrays.asList(channel.getItems()));
        }
        this.removeUnusedBins(newsItems);
        return this.aggregateEvents(newsItems.toArray(new NewsItem[newsItems.size()]));
    }

    private void removeUnusedBins(List newsItems) {
        if (this.fAggBins == null) {
            return;
        }
        HashSet<String> usedLinks = new HashSet<String>();
        for (NewsItem newsItem : newsItems) {
            usedLinks.add(this.generateKey(newsItem));
        }
        HashSet<String> keys = new HashSet<String>(this.fAggBins.keySet());
        for (String link : keys) {
            if (usedLinks.contains(link)) continue;
            this.fAggBins.remove(link);
        }
    }

    private String generateKey(NewsItem item) {
        return String.valueOf(item.getLink()) + item.getCategory();
    }

    private void initNewsListener() {
        this.fNewsListener = new INewsListener(){

            public void newsReceived(final NewsEvent event) {
                TableViewer viewer;
                if (NewsContentProvider.this.fViewer instanceof TableViewer && !(viewer = (TableViewer)NewsContentProvider.this.fViewer).getTable().isDisposed()) {
                    viewer.getTable().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!viewer.getTable().isDisposed()) {
                                ISelection selection = viewer.getSelection();
                                NewsItem[] items = event.getAddedNews();
                                int i = 0;
                                while (i < items.length) {
                                    NewsItem item = items[i];
                                    if (NewsContentProvider.this.fChannelManager.isChannelSelected(item.getChannel())) {
                                        NewsContentProvider.this.addNewsToBin(item);
                                    }
                                    ++i;
                                }
                                viewer.refresh();
                                viewer.getTable().redraw();
                                if (viewer instanceof NewsTableViewer && !selection.isEmpty()) {
                                    ((NewsTableViewer)viewer).setSelectionToWidget(selection, true);
                                }
                                NewsContentProvider.this.fSectionSite.onContentChange();
                            }
                        }
                    });
                }
            }

            public void newsRemoved(final NewsEvent event) {
                if (NewsContentProvider.this.fViewer instanceof TableViewer) {
                    final TableViewer viewer = (TableViewer)NewsContentProvider.this.fViewer;
                    FoundationUIJob job = new FoundationUIJob(Messages.NewsContentProvider_REFRESH_SECTION_AFTER_DELETE){

                        public IStatus runProtectedInUI(IProgressMonitor monitor) {
                            boolean blockedSlideout = false;
                            if (!(monitor.isCanceled() || viewer.getControl().isDisposed() || viewer.getControl().getDisplay().isDisposed())) {
                                NewsItem[] items = event.getRemovedNews();
                                int tableItems = viewer.getTable().getItemCount();
                                try {
                                    int i = 0;
                                    while (i < items.length) {
                                        GenericAggregationBin aggBin;
                                        NewsItem item = items[i];
                                        if (NewsContentProvider.this.fChannelManager.isChannelSelected(event.getChannel()) && (aggBin = NewsContentProvider.this.removeNewsItemFromBin(item)) != null && !viewer.getControl().isDisposed()) {
                                            if (viewer instanceof NewsTableViewer) {
                                                if (items.length >= tableItems && event.isUserInitiated()) {
                                                    ((NewsTableViewer)viewer).setBlockSlideoutOnce(true);
                                                    blockedSlideout = true;
                                                }
                                                viewer.remove((Object)aggBin);
                                            } else {
                                                viewer.remove((Object)aggBin);
                                            }
                                        }
                                        ++i;
                                    }
                                }
                                finally {
                                    if (blockedSlideout && viewer instanceof NewsTableViewer) {
                                        ((NewsTableViewer)viewer).setBlockSlideoutOnce(false);
                                    }
                                    if (!viewer.getControl().isDisposed()) {
                                        NewsContentProvider.this.fSectionSite.onContentChange();
                                    }
                                }
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    job.setSystem(true);
                    job.schedule();
                }
            }

            public void newsStateChanged(final NewsEvent event) {
                TableViewer viewer;
                Display display;
                if (NewsContentProvider.this.fViewer == null || NewsContentProvider.this.fViewer.getControl().isDisposed()) {
                    return;
                }
                if (NewsContentProvider.this.fViewer instanceof TableViewer && !(display = (viewer = (TableViewer)NewsContentProvider.this.fViewer).getTable().getDisplay()).isDisposed()) {
                    display.asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (!viewer.getTable().isDisposed()) {
                                NewsItem[] changedItems = event.getChangedNews();
                                ArrayList objToUpdate = new ArrayList(changedItems.length);
                                int i = 0;
                                while (i < changedItems.length) {
                                    NewsItem item = changedItems[i];
                                    if (NewsContentProvider.this.fChannelManager.isChannelSelected(item.getChannel())) {
                                        String itemKey = NewsContentProvider.this.generateKey(item);
                                        if (NewsContentProvider.this.fAggBins.containsKey(itemKey)) {
                                            objToUpdate.add(NewsContentProvider.this.fAggBins.get(itemKey));
                                        }
                                    }
                                    ++i;
                                }
                                if (!objToUpdate.isEmpty()) {
                                    if (objToUpdate.size() <= 10) {
                                        viewer.update(objToUpdate.toArray(), new String[]{"filter"});
                                    } else {
                                        viewer.refresh();
                                    }
                                }
                            }
                            NewsContentProvider.this.fSectionSite.onContentChange();
                        }
                    });
                }
            }
        };
        FeedManager.getDefault().addNewsListener(this.fNewsListener);
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.fViewer = viewer;
        if (this.fAggBins != null) {
            this.fAggBins.clear();
        }
    }

    private GenericAggregationBin removeNewsItemFromBin(NewsItem item) {
        String itemKey = this.generateKey(item);
        if (this.fAggBins.containsKey(itemKey)) {
            GenericAggregationBin aggBin = this.fAggBins.get(itemKey);
            aggBin.remove((Object)item);
            if (aggBin.getSize() == 0) {
                this.fAggBins.remove(itemKey);
                return aggBin;
            }
        }
        return null;
    }
}

