/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal.dashboard;

import com.ibm.team.feed.core.ChannelAdapter;
import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.ClientFeedUtils;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.IChannelListener;
import com.ibm.team.feed.core.INewsListener;
import com.ibm.team.feed.core.INewsManagerListener;
import com.ibm.team.feed.core.NewsEvent;
import com.ibm.team.feed.core.internal.ChannelManager;
import com.ibm.team.feed.core.internal.throttle.FeedReadType;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.EditFeedAction;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.HelpContextIds;
import com.ibm.team.feed.ui.internal.OpenFeedsAggregatedAction;
import com.ibm.team.feed.ui.internal.OpenNewsAction;
import com.ibm.team.feed.ui.internal.dashboard.FeedSectionConfigurationDialog;
import com.ibm.team.feed.ui.internal.dashboard.FeedSectionState;
import com.ibm.team.feed.ui.internal.dashboard.Messages;
import com.ibm.team.feed.ui.internal.dashboard.NewsContentProvider;
import com.ibm.team.feed.ui.internal.dashboard.NewsLabelProvider;
import com.ibm.team.feed.ui.internal.dashboard.NewsModel;
import com.ibm.team.feed.ui.internal.dashboard.NewsTableViewer;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.foundation.rcp.ui.dnd.DragSupport;
import com.ibm.team.foundation.rcp.ui.internal.util.Utils;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIUtils;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.JazzResources;
import com.ibm.team.jface.NoScrollbarsTable;
import com.ibm.team.jface.dashboard.ISectionListener;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.dashboard.Section;
import com.ibm.team.jface.dashboard.SectionLabel;
import com.ibm.team.jface.internal.ItemViewAdvisorManager;
import com.ibm.team.jface.internal.ItemViewUIAdvisor;
import com.ibm.team.jface.internal.dashboard.views.SectionPart;
import com.ibm.team.jface.itemview.ItemViewerFilter;
import com.ibm.team.jface.itemview.ItemViewerSorter;
import com.ibm.team.jface.itemview.NotifyingFilterSet;
import com.ibm.team.jface.util.ConvertingSelectionProvider;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.IItemType;
import com.ibm.team.repository.common.UUID;
import com.ibm.team.repository.common.util.NLS;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorDecorator;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFontDecorator;
import org.eclipse.jface.viewers.IFontProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.DropTargetAdapter;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.HTMLTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.TextLayout;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.contexts.IContextActivation;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerActivation;
import org.eclipse.ui.handlers.IHandlerService;

public class FeedSection
extends Section
implements ISectionListener {
    private static final String EVENT_LOG_ID = "com.ibm.magnolia.rss.ui.eventSection";
    private static final String CONTEXT_ID = "com.ibm.team.feed.ui.EventLogContext";
    private static final String MARK_ALL_READ_ACTION_ID = "com.ibm.team.feed.ui.MarkAllReadEventLogAction";
    private static final String MARK_READ_ACTION_ID = "com.ibm.team.feed.ui.MarkReadEventLogAction";
    private static final String MARK_READ_AND_NEXT_UNREAD_ACTION_ID = "com.ibm.team.feed.ui.MarkReadAndSelectNextUnreadAction";
    private static final String RELOAD_ALL_ACTION_ID = "com.ibm.team.feed.ui.ReloadAllFeedsAction";
    private static final String DELETE_ACTION_ID = "org.eclipse.ui.edit.delete";
    private static final String PREF_SELECTED_CHANNELS = "PREF_SELECTED_CHANNELS";
    private static final String PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP = "PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP";
    private static final String PREF_MARK_READ_ON_HOVER_TOOLTIP = "PREF_MARK_READ_ON_HOVER_TOOLTIP";
    private static final String PREF_MARK_READ_ON_FOCUS_TOOLTIP = "PREF_MARK_READ_ON_FOCUS_TOOLTIP";
    private static final String PREF_MARK_READ_AFTER = "PREF_MARK_READ_AFTER";
    private static final String PREF_SORTER_ID = "PREF_SORTER_ID";
    private static final String MEMENTO_FILTERS = "MEMENTO_FILTERS";
    private static final String PREF_FILTER_ID = "PREF_FILTER_ID";
    private static final String PREF_SHOW_RELATIONSHIP = "PREF_SHOW_RELATIONSHIP";
    private static boolean fgIsMac = "carbon".equals(SWT.getPlatform());
    private static final String PARAM_FEED_CATEGORY = "feedCategory";
    private static final String PARAM_ITEM_LABEL = "itemLabel";
    private String fItemLabel = Messages.FeedSection_NEWS;
    private NoScrollbarsTable fCustomScrollTable;
    private boolean fIsExpanded;
    private boolean fShowSubjectRelationShipIndicator;
    private INewsListener fNewsListener;
    private NewsModel fNewsModel;
    private SectionLabel fTeaserLabel;
    private NewsTableViewer fViewer;
    private INewsManagerListener fNewsManagerListener;
    private NewsContentProvider fContentProvider;
    private FeedSectionState fState;
    private StackLayout fStack;
    private Composite fEmpty;
    private Composite fContainer;
    private boolean fDisposed;
    private ChannelAdapter fChannelListener;
    private boolean fIsEventSection;
    private Action fCopyAction;
    private Action fSelectAllAction;
    private Action fDeleteAction;
    private Action fPropertiesAction;
    private Action fMarkAllReadAction;
    private Action fDisabledAction;
    private Action fMarkReadAndNextUnreadAction;
    private Action fToggleReadAction;
    private Action fReloadAllAction;
    private Clipboard fClipboard;
    private IContextService fContextService;
    private IHandlerService fHandlerService;
    private static IContextActivation fgLastContextActivation;
    private static List<IHandlerActivation> fgHandlerActivations;

    static {
        fgHandlerActivations = new ArrayList<IHandlerActivation>();
    }

    public void init(ISectionSite sectionSite, IMemento memento) {
        super.init(sectionSite, memento);
        String parameterValue = sectionSite.getParameterValue(PARAM_FEED_CATEGORY);
        this.fShowSubjectRelationShipIndicator = this.fIsEventSection = "com.ibm.team.feed.core.SystemFeed".equals(parameterValue);
        this.loadContributions();
        this.loadState(memento);
        this.registerListeners();
        this.fClipboard = new Clipboard(sectionSite.getViewSite().getShell().getDisplay());
        this.fContextService = (IContextService)sectionSite.getViewSite().getService(IContextService.class);
        this.fHandlerService = (IHandlerService)sectionSite.getViewSite().getService(IHandlerService.class);
        this.createActions();
    }

    private void createActions() {
        this.fCopyAction = new Action(""){

            public void run() {
                IStructuredSelection selection;
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed() && !(selection = (IStructuredSelection)FeedSection.this.fViewer.getSelection()).isEmpty()) {
                    List list = selection.toList();
                    StringBuilder textBuffer = new StringBuilder();
                    StringBuilder htmlBuffer = new StringBuilder();
                    for (Object obj : list) {
                        if (obj instanceof GenericAggregationBin) {
                            obj = ((GenericAggregationBin)obj).getMostRecent();
                        }
                        if (!(obj instanceof NewsItem)) continue;
                        NewsItem newsItem = (NewsItem)obj;
                        if (newsItem.getTitle() != null) {
                            if (textBuffer.length() > 0) {
                                textBuffer.append("\n");
                            }
                            textBuffer.append(XMLString.createFromXMLText((String)newsItem.getTitle()).getPlainText());
                        }
                        if (newsItem.getLink() == null || newsItem.getTitle() == null) continue;
                        if (htmlBuffer.length() > 0) {
                            htmlBuffer.append("<br>");
                        }
                        htmlBuffer.append("<a href=\"").append(newsItem.getLink()).append("\">").append(XMLString.createFromXMLText((String)newsItem.getTitle()).getPlainText()).append("</a>");
                    }
                    FeedSection.this.fClipboard.setContents(new Object[]{textBuffer.toString(), Utils.escapeForHTMLTransfer((String)htmlBuffer.toString())}, new Transfer[]{TextTransfer.getInstance(), HTMLTransfer.getInstance()});
                }
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.fSelectAllAction = new Action(""){

            public void run() {
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    ((Table)FeedSection.this.fViewer.getControl()).selectAll();
                }
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.fDeleteAction = new Action(Messages.FeedSection_DELETE){

            public void run() {
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    FeedSection.this.deleteSelectedNewsItems();
                }
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.fDeleteAction.setId(DELETE_ACTION_ID);
        this.fDeleteAction.setActionDefinitionId(DELETE_ACTION_ID);
        this.fPropertiesAction = new Action(""){

            public void run() {
                FeedSection.this.onConfigure();
            }

            public boolean isEnabled() {
                return true;
            }
        };
        this.fMarkAllReadAction = new Action(Messages.FeedSection_MARK_ALL_READ){

            public void run() {
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    FeedSection.this.markAllNewsRead();
                }
            }
        };
        this.fMarkAllReadAction.setId(MARK_ALL_READ_ACTION_ID);
        this.fMarkAllReadAction.setActionDefinitionId(MARK_ALL_READ_ACTION_ID);
        this.fToggleReadAction = new Action(Messages.FeedSection_TOGGLE_READ_STATE){

            public boolean isEnabled() {
                return true;
            }

            public void run() {
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    boolean read = true;
                    Iterator iterator = ((IStructuredSelection)FeedSection.this.fViewer.getSelection()).iterator();
                    while (read && iterator.hasNext()) {
                        GenericAggregationBin selectedBin = (GenericAggregationBin)iterator.next();
                        boolean bl = read = read && !selectedBin.containsUnread();
                    }
                    FeedSection.this.updateReadStateOnSelection(!read);
                }
            }
        };
        this.fToggleReadAction.setId(MARK_READ_ACTION_ID);
        this.fToggleReadAction.setActionDefinitionId(MARK_READ_ACTION_ID);
        this.fMarkReadAndNextUnreadAction = new Action(Messages.FeedSection_MARK_READ_SELECT_NEXT_UNREAD){

            public boolean isEnabled() {
                return true;
            }

            public void run() {
                if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    GenericAggregationBin nextUnread;
                    FeedSection.this.updateReadStateOnSelection(true);
                    Table table = FeedSection.this.fViewer.getTable();
                    int selIndex = table.getSelectionIndex();
                    if (selIndex < 0) {
                        selIndex = 0;
                    }
                    if ((nextUnread = this.findNextUnread(table, selIndex)) == null) {
                        nextUnread = this.findPreviousUnread(table, selIndex);
                    }
                    if (nextUnread != null) {
                        FeedSection.this.fViewer.setSelection((ISelection)new StructuredSelection((Object)nextUnread), true);
                    } else {
                        FeedSection.this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
                    }
                }
            }

            private GenericAggregationBin findNextUnread(Table table, int index) {
                int i = index;
                while (i < table.getItemCount()) {
                    Object data = table.getItem(i).getData();
                    if (data instanceof GenericAggregationBin && ((GenericAggregationBin)data).containsUnread()) {
                        return (GenericAggregationBin)data;
                    }
                    ++i;
                }
                return null;
            }

            private GenericAggregationBin findPreviousUnread(Table table, int index) {
                int i = index;
                while (i >= 0 && i < table.getItemCount()) {
                    Object data = table.getItem(i).getData();
                    if (data instanceof GenericAggregationBin && ((GenericAggregationBin)data).containsUnread()) {
                        return (GenericAggregationBin)data;
                    }
                    --i;
                }
                return null;
            }
        };
        this.fMarkReadAndNextUnreadAction.setId(MARK_READ_AND_NEXT_UNREAD_ACTION_ID);
        this.fMarkReadAndNextUnreadAction.setActionDefinitionId(MARK_READ_AND_NEXT_UNREAD_ACTION_ID);
        this.fReloadAllAction = new Action(Messages.FeedSection_RELOAD_ALL_FEEDS){

            public void run() {
                if (FeedSection.this.fNewsModel != null) {
                    FeedSection.this.fNewsModel.reloadAll(true);
                }
            }
        };
        this.fReloadAllAction.setId(RELOAD_ALL_ACTION_ID);
        this.fReloadAllAction.setActionDefinitionId(RELOAD_ALL_ACTION_ID);
        this.fDisabledAction = new Action(""){

            public boolean isEnabled() {
                return false;
            }
        };
    }

    public void refreshContent() {
        if (this.fNewsModel != null) {
            this.fNewsModel.reloadAll(true);
        }
    }

    private IItemHandle getItemHandle(final NewsItem item) {
        final IItemHandle[] handle = new IItemHandle[1];
        SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

            public void handleException(Throwable e) {
                if (e instanceof Exception) {
                    FeedUIPlugin.getDefault().log(e.getMessage(), (Exception)e);
                }
            }

            public void run() throws Exception {
                IItemType itemType;
                String repoUrl = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "repositoryURL");
                String publicRepoUrl = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "publicUri");
                String itemId = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "itemId");
                String typeNamespace = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "typeNamespace");
                String typeName = item.getCustomAttribute("http://www.ibm.com/jazz/0.1.0/syndication", "typeName");
                if (repoUrl != null && itemId != null && typeNamespace != null && typeName != null && (itemType = IItemType.IRegistry.INSTANCE.getItemType(typeName, typeNamespace)) != null) {
                    ITeamRepository repository = ClientURIUtils.findTeamRepository((URI)URI.create(repoUrl));
                    if (repository == null && publicRepoUrl != null) {
                        repository = ClientURIUtils.findTeamRepository((URI)URI.create(publicRepoUrl));
                    }
                    if (repository != null) {
                        handle[0] = itemType.createItemHandle((Object)repository, UUID.valueOf((String)itemId), null);
                    }
                }
            }
        });
        return handle[0];
    }

    public void createContent(Composite parent) {
        this.fStack = new StackLayout();
        parent.setLayout((Layout)this.fStack);
        this.fContainer = new Composite(parent, 0);
        this.fContainer.setBackground(parent.getBackground());
        this.fContainer.setLayout((Layout)new FillLayout());
        if (fgIsMac) {
            Table newsTable = new Table(this.fContainer, 98306);
            this.fViewer = new NewsTableViewer(this.getSectionSite(), newsTable);
        } else {
            this.fCustomScrollTable = new NoScrollbarsTable(this.fContainer, 98306);
            this.fCustomScrollTable.getTable().setBackground(this.fContainer.getBackground());
            this.fViewer = new NewsTableViewer(this.getSectionSite(), this.fCustomScrollTable.getTable());
        }
        new DragSupport(this.fViewer.getControl()){

            public ISelection getSelection() {
                return FeedSection.this.fViewer.getSelection();
            }

            protected ISelection convertSelection(ISelection selection) {
                return FeedSection.this.internalConvertSelection(selection);
            }

            protected void dragFinished(DragSourceEvent event) {
                super.dragFinished(event);
                FeedSection.this.fViewer.setBlockSlideoutOnce();
            }
        };
        this.hookDropSupport(this.fViewer.getControl());
        NewsLabelProvider provider = new NewsLabelProvider();
        if (provider.useCustomOwnerDraw()) {
            this.hookCustomOwnerDrawn(provider);
        } else {
            this.fViewer.setLabelProvider((IBaseLabelProvider)provider);
        }
        this.fContentProvider = new NewsContentProvider(this.getSectionSite(), this.fState.getChannelManager());
        this.fViewer.setContentProvider((IContentProvider)this.fContentProvider);
        if (this.fState.getConfigurer() != null) {
            List sorters = this.fState.getConfigurer().getSorters();
            for (ItemViewerSorter sorter : sorters) {
                if (!this.fState.getPreferredSorterId().equals(sorter.getId())) continue;
                this.fViewer.setSorter(sorter.getViewerSorter());
                break;
            }
        }
        if (this.fState.getConfigurer() != null) {
            List filters = this.fState.getConfigurer().getFilters();
            for (ItemViewerFilter filter : filters) {
                if (!this.fState.getPreferredFilterIds().contains(filter.getId())) continue;
                this.fViewer.addFilter(filter.getViewerFilter());
            }
        }
        this.fNewsModel = new NewsModel();
        this.fViewer.setInput(this.fNewsModel);
        this.getSectionSite().addSelectionProvider((ISelectionProvider)this.fViewer);
        this.fViewer.setSelection((ISelection)StructuredSelection.EMPTY);
        this.updateMarkReadOnOpen(this.fState.isEnableMarkReadOnSlideout());
        this.createContextMenu(this.fViewer);
        this.hookListeners();
        this.fEmpty = new Composite(parent, 0);
        this.fEmpty.setLayout((Layout)new FillLayout());
        ((FillLayout)this.fEmpty.getLayout()).marginHeight = 5;
        ((FillLayout)this.fEmpty.getLayout()).marginWidth = 5;
        this.fEmpty.setBackground(parent.getBackground());
        this.hookDropSupport((Control)this.fEmpty);
        Link link = new Link(this.fEmpty, 16384);
        link.setBackground(this.fEmpty.getBackground());
        link.setText(NLS.bind((String)Messages.FeedSection_POPULATE_SECTION_CONFIGURATION_DIALOG, (Object)"config", (Object[])new Object[0]));
        link.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if ("config".equals(e.text)) {
                    FeedSection.this.onConfigure();
                }
            }
        });
        this.hookDropSupport((Control)link);
        this.fViewer.getTable().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                FeedSection.this.bindActions();
            }

            public void focusLost(FocusEvent e) {
                FeedSection.this.unbindActions();
            }
        });
        this.fViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Date now = new Date();
                List<NewsItem> selectedNewsItems = this.getNewsItems(event.getSelection());
                for (Channel channel : this.getChannels()) {
                    channel.addUsed((Channel.IFeedReadType)FeedReadType.VIEW_FOCUSED, now);
                    boolean containsASelectedNewsItem = false;
                    for (NewsItem newsItem : selectedNewsItems) {
                        if (!channel.contains(newsItem)) continue;
                        containsASelectedNewsItem = true;
                    }
                    if (!containsASelectedNewsItem) continue;
                    channel.addUsed((Channel.IFeedReadType)FeedReadType.NEWS_FOCUSED, now);
                }
            }

            private List<NewsItem> getNewsItems(ISelection selection) {
                ArrayList<NewsItem> newsItems = new ArrayList<NewsItem>();
                if (selection instanceof IStructuredSelection) {
                    IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                    for (Object element : structuredSelection.toList()) {
                        if (!(element instanceof GenericAggregationBin)) continue;
                        GenericAggregationBin bin = (GenericAggregationBin)element;
                        List items = bin.getItems();
                        for (Object item : items) {
                            if (!(item instanceof NewsItem)) continue;
                            newsItems.add((NewsItem)item);
                        }
                    }
                }
                return newsItems;
            }

            private Set<Channel> getChannels() {
                HashSet channelURLs = FeedSection.this.getChannelManager().getSelectedChannelUrls();
                HashSet<Channel> channels = new HashSet<Channel>();
                for (String channelURL : channelURLs) {
                    Channel channel = FeedManager.getDefault().getChannel(channelURL);
                    if (channel != null) {
                        channels.add(channel);
                        continue;
                    }
                    FeedUIPlugin.getDefault().log(new Status(4, "com.ibm.team.feed.ui", String.format("Expected to find the channel with channel URL \"%s\" but one could not be found.", channelURL), null));
                }
                return channels;
            }
        });
        HelpContextIds.hookHelpListener((Control)parent, "com.ibm.team.feed.ui.feed_section");
    }

    private IStructuredSelection internalConvertSelection(ISelection selection) {
        IStructuredSelection structSel = (IStructuredSelection)selection;
        ArrayList<Object> convertedSel = new ArrayList<Object>(structSel.size());
        List list = structSel.toList();
        for (Object entry : list) {
            Object mostRecent;
            if (!(entry instanceof GenericAggregationBin) || !((mostRecent = ((GenericAggregationBin)entry).getMostRecent()) instanceof NewsItem)) continue;
            NewsItem item = (NewsItem)mostRecent;
            IItemHandle handle = this.getItemHandle(item);
            if (handle != null && !convertedSel.contains(handle)) {
                convertedSel.add(handle);
                continue;
            }
            if (handle != null) continue;
            try {
                URI uri = new URI(item.getLink());
                URIReference ref = new URIReference(XMLString.createFromXMLText((String)item.getTitle()).getPlainText(), XMLString.createFromXMLText((String)item.getTitle()).getPlainText(), uri);
                if (convertedSel.contains(ref)) continue;
                convertedSel.add(ref);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return new StructuredSelection(convertedSel);
    }

    private void hookDropSupport(Control control) {
        DropTarget target = new DropTarget(control, 22);
        target.setTransfer(new Transfer[]{LocalSelectionTransfer.getTransfer()});
        target.addDropListener((DropTargetListener)new DropTargetAdapter(){

            public void drop(DropTargetEvent event) {
                ISelection selection = LocalSelectionTransfer.getTransfer().getSelection();
                FeedSection.this.onDrop(selection);
            }

            public void dropAccept(DropTargetEvent event) {
            }

            public void dragOver(DropTargetEvent event) {
                List draggedChannels = FeedSection.this.getChannels(LocalSelectionTransfer.getTransfer().getSelection());
                if (draggedChannels.isEmpty()) {
                    event.detail = 0;
                } else {
                    boolean valid = false;
                    for (Channel channel : draggedChannels) {
                        if (FeedSection.this.fState.getChannelManager().isChannelSelected(channel)) continue;
                        valid = true;
                        break;
                    }
                    event.detail = valid ? 4 : 0;
                }
            }
        });
    }

    private void onDrop(ISelection selection) {
        List<Channel> channels = this.getChannels(selection);
        for (Channel channel : channels) {
            if (this.fState.getChannelManager().isChannelSelected(channel)) continue;
            this.fState.changeChannelSelection(channel, true);
        }
    }

    private List<Channel> getChannels(ISelection selection) {
        Object[] elements = ((IStructuredSelection)selection).toArray();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        Object[] objectArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            if (element instanceof Channel) {
                channels.add((Channel)element);
            }
            ++n2;
        }
        return channels;
    }

    private void updateMenuEnablement(int unreadItems) {
        if (this.fTeaserLabel != null && !this.fTeaserLabel.isDisposed()) {
            this.fMarkAllReadAction.setEnabled(unreadItems != 0);
        }
    }

    private void updateStackLayout() {
        if (this.fStack != null && this.fViewer != null && !this.fDisposed) {
            Composite top = null;
            top = this.fState.getChannelManager().getSelectedChannelUrls().size() == 0 ? this.fEmpty : this.fContainer;
            if (top != this.fStack.topControl) {
                this.fStack.topControl = top;
                this.fStack.topControl.getParent().layout();
            }
        }
    }

    private void hookListeners() {
        this.fViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                FeedSection.this.updateReadStateOnSelection(selection, true);
                List elements = selection.toList();
                for (Object element : elements) {
                    Object mostRecent;
                    GenericAggregationBin bin = (GenericAggregationBin)element;
                    if (bin == null || !((mostRecent = bin.getMostRecent()) instanceof NewsItem)) continue;
                    new OpenNewsAction(FeedSection.this.getSectionSite(), (NewsItem)mostRecent).run();
                }
            }
        });
        this.fState.addFilterSelectionChangedListener(new NotifyingFilterSet.IFilterSelectionChangedListener(){

            public void filterSelectionChanged(Collection enabledFilters, Collection disabledFilters) {
                if (FeedSection.this.fIsExpanded && FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                    List filters;
                    for (String filterid : enabledFilters) {
                        filters = FeedSection.this.fState.getConfigurer().getFilters();
                        for (ItemViewerFilter filter : filters) {
                            if (!filter.getId().equals(filterid)) continue;
                            FeedSection.this.fViewer.addFilter(filter.getViewerFilter());
                        }
                    }
                    for (String filterid : disabledFilters) {
                        filters = FeedSection.this.fState.getConfigurer().getFilters();
                        for (ItemViewerFilter filter : filters) {
                            if (!filter.getId().equals(filterid)) continue;
                            FeedSection.this.fViewer.removeFilter(filter.getViewerFilter());
                        }
                    }
                    FeedSection.this.updateSectionHeader();
                    FeedSection.this.getSectionSite().onContentChange();
                }
            }
        });
        this.fState.addFeedSectionStateListener(new FeedSectionState.FeedSectionStateListener(){

            @Override
            public void preferredSorterIdChanged(String newState) {
                List sorters = FeedSection.this.fState.getConfigurer().getSorters();
                for (ItemViewerSorter sorter : sorters) {
                    if (!sorter.getId().equals(newState)) continue;
                    FeedSection.this.fViewer.setSorter(sorter.getViewerSorter());
                    break;
                }
            }

            @Override
            public void channelSelectionChanged(Channel channel, boolean selected) {
                FeedSection.this.inputChanged();
            }
        });
    }

    private void hookCustomOwnerDrawn(final NewsLabelProvider provider) {
        LabelProvider nooplabelProvider = new LabelProvider(){

            public String getText(Object element) {
                return Boolean.toString(((GenericAggregationBin)element).containsUnread());
            }
        };
        this.fViewer.setLabelProvider((IBaseLabelProvider)nooplabelProvider);
        final Display display = this.fViewer.getControl().getDisplay();
        final Table table = (Table)this.fViewer.getControl();
        Color fgGray = provider.getDateForegroundColor();
        LocalResourceManager resources = new LocalResourceManager(JFaceResources.getResources(), (Control)table);
        final TextLayout textLayout = new TextLayout((Device)display);
        int orientation = table.getStyle() & 0x6000000;
        textLayout.setOrientation(orientation);
        table.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                textLayout.dispose();
                provider.dispose();
            }
        });
        Listener paintListener = new Listener((ResourceManager)resources, fgGray, textLayout){
            private final /* synthetic */ ResourceManager val$resources;
            private final /* synthetic */ Color val$fgGray;
            private final /* synthetic */ TextLayout val$textLayout;
            {
                this.val$resources = resourceManager;
                this.val$fgGray = color;
                this.val$textLayout = textLayout;
            }

            public void handleEvent(Event event) {
                if (!FeedSection.this.fIsExpanded) {
                    return;
                }
                if (event.type == 40) {
                    event.detail &= 0xFFFFFFEF;
                    return;
                }
                TableItem item = (TableItem)event.item;
                Object element = item.getData();
                if (element == null) {
                    return;
                }
                Image image = provider.getImage(element);
                Image subImage = null;
                if (FeedSection.this.fShowSubjectRelationShipIndicator) {
                    NewsItem newsItem = (NewsItem)((GenericAggregationBin)element).getMostRecent();
                    String relation = ClientFeedUtils.getInstance().getRelation(newsItem);
                    subImage = JazzResources.getImageWithDefault((ResourceManager)this.val$resources, (ImageDescriptor)FeedUIPlugin.getSubjectRelationShipImageDescriptor(relation));
                }
                String text = provider.getText(element);
                Color fgc = null;
                Color fgc2 = null;
                if ((event.detail & 2) == 0) {
                    if (provider instanceof ITableColorProvider) {
                        fgc = provider.getForeground(element, 0);
                    }
                    if (fgc == null && provider instanceof IColorDecorator) {
                        fgc = ((IColorDecorator)provider).decorateForeground(element);
                    }
                    if (fgc == null && provider instanceof IColorProvider) {
                        fgc = ((IColorProvider)provider).getForeground(element);
                    }
                    fgc2 = this.val$fgGray;
                } else {
                    fgc = fgc2 = event.gc.getForeground();
                }
                Font font = null;
                if (provider instanceof ITableFontProvider) {
                    font = provider.getFont(element, 0);
                }
                if (font == null && provider instanceof IFontDecorator) {
                    font = ((IFontDecorator)provider).decorateFont(element);
                }
                if (font == null && provider instanceof IFontProvider) {
                    font = ((IFontProvider)provider).getFont(element);
                }
                event.gc.setFont(font);
                TextStyle normal = new TextStyle(event.gc.getFont(), fgc, null);
                TextStyle light = new TextStyle(event.gc.getFont(), fgc2, null);
                FeedSection.this.parse(this.val$textLayout, text, normal, light);
                Rectangle textLayoutBounds = this.val$textLayout.getBounds();
                int GAP = 4;
                switch (event.type) {
                    case 41: {
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            event.height = Math.max(event.height, rect.height + 2);
                            event.width += rect.width;
                            if (subImage != null) {
                                Rectangle rect2 = subImage.getBounds();
                                event.height = Math.max(event.height, rect2.height + 2);
                                event.width += rect2.width;
                            }
                            event.width += 4;
                        }
                        event.width += textLayoutBounds.width;
                        event.height = Math.max(event.height, textLayoutBounds.height + 2);
                        break;
                    }
                    case 42: {
                        int x = event.x;
                        if (image != null) {
                            Rectangle rect = image.getBounds();
                            int offset = Math.max(0, (event.height - rect.height) / 2);
                            event.gc.drawImage(image, x, event.y + offset);
                            x += rect.width;
                            if (subImage != null) {
                                Rectangle rect2 = subImage.getBounds();
                                int offset2 = Math.max(0, (event.height - rect2.height) / 2);
                                event.gc.drawImage(subImage, x, event.y + offset2);
                                x += rect2.width;
                            }
                            x += 4;
                        }
                        int offset = Math.max(0, (event.height - textLayoutBounds.height) / 2);
                        this.val$textLayout.draw(event.gc, x, event.y + offset);
                    }
                }
            }
        };
        table.addListener(41, paintListener);
        table.addListener(42, paintListener);
        table.addListener(40, paintListener);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                if (e.childID != -1) {
                    TableItem item = (TableItem)display.findWidget((Widget)table, (long)e.childID);
                    if (item == null && e.childID >= 0 && e.childID < table.getItemCount()) {
                        item = table.getItem(e.childID);
                    }
                    if (item != null && item.getData() != null) {
                        e.result = provider.getText(item.getData(), false);
                    }
                }
            }
        });
    }

    private void parse(TextLayout textLayout, String text, TextStyle normal, TextStyle light) {
        if (text == null || text.length() == 0) {
            textLayout.setText("");
            textLayout.setStyle(normal, 0, 0);
            return;
        }
        StringBuffer sb = new StringBuffer();
        int l = text.length();
        int i = 0;
        while (i < l) {
            char c = text.charAt(i);
            if (c == '<') {
                if (text.indexOf("<light>", i) == i) {
                    i += "<light>".length() - 1;
                } else if (text.indexOf("</light>", i) == i) {
                    i += "</light>".length() - 1;
                } else {
                    sb.append(c);
                }
            } else {
                sb.append(c);
            }
            ++i;
        }
        textLayout.setText(sb.toString());
        int current = 0;
        int start = 0;
        TextStyle st = normal;
        i = 0;
        while (i < l) {
            char c = text.charAt(i);
            if (c == '<') {
                if (text.indexOf("<light>", i) == i) {
                    if (i > start) {
                        textLayout.setStyle(st, start, current);
                    }
                    i += "<light>".length() - 1;
                    start = current;
                    st = light;
                } else if (text.indexOf("</light>", i) == i) {
                    if (i > start) {
                        textLayout.setStyle(st, start, current);
                    }
                    i += "</light>".length() - 1;
                    start = current;
                    st = normal;
                } else {
                    ++current;
                }
            } else {
                ++current;
            }
            ++i;
        }
        if (current > start) {
            textLayout.setStyle(st, start, current);
        }
    }

    private void createContextMenu(final NewsTableViewer viewer) {
        final MenuManager menuMgr = new MenuManager(){

            protected void update(boolean force, boolean recursive) {
                Menu menu;
                super.update(force, recursive);
                if (!viewer.getControl().isDisposed() && (menu = this.getMenu()) != null && menu.getItemCount() > 0) {
                    menu.setDefaultItem(menu.getItem(0));
                }
            }
        };
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                Object channel;
                NewsItem newsItem;
                IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
                GenericAggregationBin bin = (GenericAggregationBin)selection.getFirstElement();
                if (bin == null) {
                    newsItem = null;
                    HashSet urls = FeedSection.this.fState.getChannelManager().getSelectedChannelUrls();
                    channel = urls.isEmpty() ? null : FeedManager.getDefault().getChannel((String)urls.iterator().next());
                } else {
                    newsItem = (NewsItem)bin.getMostRecent();
                    channel = newsItem.getChannel();
                }
                boolean isEventFeed = channel != null ? "com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory()) : false;
                OpenNewsAction openNewsAction = new OpenNewsAction(FeedSection.this.getSectionSite(), (IStructuredSelection)viewer.getSelection());
                menuMgr.add((IAction)openNewsAction);
                if (newsItem == null) {
                    openNewsAction.setEnabled(false);
                }
                menuMgr.add((IAction)new Action((Channel)channel){
                    private final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    public String getText() {
                        return Messages.FeedSection_OPEN_FEED;
                    }

                    public boolean isEnabled() {
                        return this.val$channel != null;
                    }

                    public void run() {
                        FeedSection.this.sectionOpened();
                    }
                });
                menuMgr.add((IContributionItem)new Separator());
                menuMgr.add((IAction)new Action((Channel)channel){
                    private final /* synthetic */ Channel val$channel;
                    {
                        this.val$channel = channel;
                    }

                    public String getText() {
                        if (this.val$channel != null) {
                            return Messages.FeedSection_EDIT_FEED;
                        }
                        return Messages.FeedSection_EDIT;
                    }

                    public boolean isEnabled() {
                        return this.val$channel != null;
                    }

                    public void run() {
                        StructuredSelection sel = new StructuredSelection((Object)this.val$channel);
                        new EditFeedAction((IStructuredSelection)sel, FeedSection.this.getSectionSite().getViewSite().getShell()).run(null);
                    }
                });
                menuMgr.add((IAction)FeedSection.this.fToggleReadAction);
                boolean read = true;
                Iterator iterator = selection.iterator();
                while (read && iterator.hasNext()) {
                    GenericAggregationBin selectedBin = (GenericAggregationBin)iterator.next();
                    boolean bl = read = read && !selectedBin.containsUnread();
                }
                if (isEventFeed) {
                    FeedSection.this.fToggleReadAction.setText(read ? Messages.FeedSection_MARK_EVENT_UNREAD : Messages.FeedSection_MARK_EVENT_READ);
                } else {
                    FeedSection.this.fToggleReadAction.setText(read ? Messages.FeedSection_MARK_NEWS_UNREAD : Messages.FeedSection_MARK_NEWS_READ);
                }
                menuMgr.add((IAction)FeedSection.this.fMarkReadAndNextUnreadAction);
                menuMgr.add((IAction)FeedSection.this.fDeleteAction);
                FoundationUIUtils.contributeObjectActions((IWorkbenchPart)FeedSection.this.getSectionSite().getViewSite().getPart(), (IMenuManager)menuMgr, (ISelectionProvider)new ConvertingSelectionProvider((ISelectionProvider)viewer){

                    protected ISelection convertFrom(ISelection viewerSelection) {
                        return FeedSection.this.internalConvertSelection(viewer.getSelection());
                    }
                });
                manager.add((IContributionItem)new Separator("additions"));
            }
        });
        viewer.getControl().setMenu(menuMgr.createContextMenu(viewer.getControl()));
        this.getSectionSite().getViewSite().registerContextMenu(menuMgr, (ISelectionProvider)viewer);
    }

    public void createTeaser(Composite parent) {
        GridLayout grid = new GridLayout(2, false);
        grid.marginHeight = 0;
        grid.marginWidth = 1;
        grid.horizontalSpacing = 1;
        grid.marginTop = 1;
        parent.setLayout((Layout)grid);
        this.fTeaserLabel = new SectionLabel(parent, 131072);
        this.fTeaserLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, true, true));
        LocalResourceManager resourceManager = new LocalResourceManager(JFaceResources.getResources(), (Control)this.fTeaserLabel);
        this.fTeaserLabel.setForeground(JazzResources.getColor((ResourceManager)resourceManager, (RGB)new RGB(80, 80, 80)));
        Font f = JFaceResources.getDefaultFont();
        FontData[] defFont = f.getFontData();
        int i = 0;
        while (i < defFont.length) {
            defFont[i].setHeight(defFont[i].getHeight() - 1);
            ++i;
        }
        this.fTeaserLabel.setFont(JazzResources.getFont((ResourceManager)resourceManager, (FontDescriptor)FontDescriptor.createFrom((FontData[])defFont), (Font)f));
        Menu filterMenu = this.getSectionSite().getSectionMenu();
        ActionContributionItem item = new ActionContributionItem((IAction)this.fMarkAllReadAction);
        item.fill(filterMenu, -1);
        item = new ActionContributionItem((IAction)this.fReloadAllAction);
        item.fill(filterMenu, -1);
        if (this.fIsEventSection) {
            new MenuItem(filterMenu, 2);
            final MenuItem toggleSubjectRelationship = new MenuItem(filterMenu, 32);
            toggleSubjectRelationship.setText(Messages.FeedSection_SHOW_RELATIONSHIP);
            toggleSubjectRelationship.setSelection(this.fShowSubjectRelationShipIndicator);
            toggleSubjectRelationship.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    FeedSection.this.fShowSubjectRelationShipIndicator = toggleSubjectRelationship.getSelection();
                    FeedSection.this.fViewer.getTable().redraw();
                    FeedSection.this.fViewer.getTable().update();
                }
            });
        }
        new MenuItem(filterMenu, 2);
        MenuItem configMenuItem = new MenuItem(filterMenu, 0);
        configMenuItem.setText(Messages.FeedSection_CONFIGURE);
        configMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeedSection.this.onConfigure();
            }
        });
        this.updateSectionHeader();
        this.registerFocusHandler(parent);
        HelpContextIds.hookHelpListener((Control)parent.getParent(), "com.ibm.team.feed.ui.feed_section");
    }

    private void registerFocusHandler(Composite candidate) {
        while (candidate != null) {
            if (candidate instanceof SectionPart) {
                candidate.addListener(26, new Listener(){

                    public void handleEvent(Event event) {
                        FeedSection.this.onSectionActivate();
                    }
                });
                break;
            }
            candidate = candidate.getParent();
        }
    }

    private void onSectionActivate() {
        this.bindActions();
    }

    private void bindActions() {
        this.deactivateHandlers();
        if (fgLastContextActivation != null && !fgLastContextActivation.getContextId().equals(CONTEXT_ID)) {
            this.deactivateContext();
        }
        if (fgLastContextActivation == null) {
            this.activateContext();
        }
        this.bindGlobalActions();
        this.activateHandlers();
    }

    private void unbindActions() {
        this.unbindGlobalActions();
        this.deactivateContext();
        this.deactivateHandlers();
    }

    private void bindGlobalActions() {
        IActionBars actions = this.getSectionSite().getViewSite().getActionBars();
        actions.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.fCopyAction);
        actions.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), (IAction)this.fSelectAllAction);
        actions.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.fDeleteAction);
        actions.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.fDisabledAction);
        actions.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.fDisabledAction);
        actions.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), (IAction)this.fPropertiesAction);
    }

    private void unbindGlobalActions() {
        IActionBars actions = this.getSectionSite().getViewSite().getActionBars();
        actions.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
        actions.setGlobalActionHandler(ActionFactory.SELECT_ALL.getId(), null);
        actions.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
        actions.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
        actions.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
        actions.setGlobalActionHandler(ActionFactory.PROPERTIES.getId(), null);
    }

    private void activateContext() {
        fgLastContextActivation = this.fContextService.activateContext(CONTEXT_ID);
    }

    private void deactivateContext() {
        if (fgLastContextActivation != null) {
            this.fContextService.deactivateContext(fgLastContextActivation);
            fgLastContextActivation = null;
        }
    }

    private void activateHandlers() {
        fgHandlerActivations.add(this.fHandlerService.activateHandler(this.fMarkAllReadAction.getId(), (IHandler)new ActionHandler((IAction)this.fMarkAllReadAction)));
        fgHandlerActivations.add(this.fHandlerService.activateHandler(this.fToggleReadAction.getId(), (IHandler)new ActionHandler((IAction)this.fToggleReadAction)));
        fgHandlerActivations.add(this.fHandlerService.activateHandler(this.fMarkReadAndNextUnreadAction.getId(), (IHandler)new ActionHandler((IAction)this.fMarkReadAndNextUnreadAction)));
        fgHandlerActivations.add(this.fHandlerService.activateHandler(this.fReloadAllAction.getId(), (IHandler)new ActionHandler((IAction)this.fReloadAllAction)));
    }

    private void deactivateHandlers() {
        this.fHandlerService.deactivateHandlers(fgHandlerActivations);
        fgHandlerActivations.clear();
    }

    private void onConfigure() {
        Shell shell = this.getSectionSite().getViewSite().getShell();
        FeedSectionConfigurationDialog.show(shell, this.fState, this.getSectionSite().getName());
        HashSet urls = this.fState.getChannelManager().getSelectedChannelUrls();
        for (String url : urls) {
            Channel channel = FeedManager.getDefault().getChannel(url);
            if (channel == null || !channel.isLoading()) continue;
            this.getSectionSite().setBusy(true);
            break;
        }
        this.updateMarkReadOnOpen(this.fState.isEnableMarkReadOnSlideout());
    }

    private void updateMarkReadOnOpen(boolean enable) {
        if (this.fViewer == null || this.fViewer.getTable().isDisposed()) {
            return;
        }
        if (enable) {
            ViewerFilter[] filters;
            ViewerFilter[] viewerFilterArray = filters = this.fViewer.getFilters();
            int n = filters.length;
            int n2 = 0;
            while (n2 < n) {
                ViewerFilter filter = viewerFilterArray[n2];
                if (filter instanceof ItemViewUIAdvisor.ReadItemsFilter || filter instanceof ItemViewerFilter.WrappingFilter && ((ItemViewerFilter.WrappingFilter)filter).getWrapped() instanceof ItemViewUIAdvisor.ReadItemsFilter) {
                    enable = false;
                    break;
                }
                ++n2;
            }
        }
        this.fViewer.getSlideoutSupport().setMarkReadOnOpen(enable);
    }

    private void inputChanged() {
        this.getSectionSite().getViewSite().getShell().getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                    public void handleException(Throwable exception) {
                        if (exception instanceof Exception) {
                            FeedUIPlugin.getDefault().log(exception.getMessage(), (Exception)exception);
                        }
                    }

                    public void run() throws Exception {
                        if (FeedSection.this.fIsExpanded) {
                            FeedSection.this.fViewer.setInput(FeedSection.this.fNewsModel);
                            FeedSection.this.fViewer.refresh();
                            FeedSection.this.getSectionSite().onContentChange();
                        }
                        FeedSection.this.updateSectionHeader();
                    }
                });
            }
        });
    }

    public void dispose() {
        this.fDisposed = true;
        this.unregisterListeners();
        this.unbindActions();
        if (this.fCustomScrollTable != null) {
            this.fCustomScrollTable.dispose();
        }
        if (this.fViewer != null) {
            this.fViewer.dispose();
        }
        if (this.fContentProvider != null) {
            this.fContentProvider.dispose();
        }
        this.fState.getChannelManager().dispose();
        this.fClipboard.dispose();
    }

    protected ChannelManager getChannelManager() {
        return this.fState.getChannelManager();
    }

    public Point getDefaultContentSize() {
        Table table = this.fViewer.getTable();
        if (this.fViewer != null && table.getItemCount() > 0) {
            return new Point(-1, table.getItemHeight() * 5 + (fgIsMac && table.getHorizontalBar() != null ? table.getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getMinimalContentSize() {
        Table table = this.fViewer.getTable();
        if (this.fViewer != null && table.getItemCount() > 0) {
            return new Point(-1, table.getItemHeight() * 2 + (fgIsMac && table.getHorizontalBar() != null ? table.getHorizontalBar().getSize().y : 0));
        }
        return new Point(-1, -1);
    }

    public Point getPreferredContentSize(int wHint, int hHint) {
        Table table = this.fViewer.getTable();
        if (this.fViewer != null && table.getItemCount() > 0) {
            return new Point(wHint, table.getItemCount() * table.getItemHeight() + (fgIsMac && table.getHorizontalBar() != null ? table.getHorizontalBar().getSize().y : 0));
        }
        return new Point(wHint, hHint);
    }

    private void loadState(IMemento memento) {
        if (memento == null) {
            List filters = this.fState.getConfigurer().getFilters();
            for (ItemViewerFilter filter : filters) {
                if (!filter.isEnabledByDefault()) continue;
                this.fState.getPreferredFilterIds().add(filter.getId());
            }
            return;
        }
        if (memento.getString(PREF_MARK_READ_ON_FOCUS_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnFocus(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_FOCUS_TOOLTIP)));
        }
        if (memento.getString(PREF_MARK_READ_ON_HOVER_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnHover(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_HOVER_TOOLTIP)));
        }
        if (memento.getString(PREF_MARK_READ_AFTER) != null) {
            this.fState.setMarkReadAfter(Integer.valueOf(memento.getString(PREF_MARK_READ_AFTER)));
        }
        if (memento.getString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP) != null) {
            this.fState.setEnableMarkReadOnSlideout(Boolean.valueOf(memento.getString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP)));
        }
        if (memento.getString(PREF_SORTER_ID) != null) {
            this.fState.setPreferredSorterId(memento.getString(PREF_SORTER_ID));
        }
        IMemento[] selectedFilters = this.getSectionMemento().getChildren(MEMENTO_FILTERS);
        int i = 0;
        while (i < selectedFilters.length) {
            IMemento childMemento = selectedFilters[i];
            this.fState.getPreferredFilterIds().add(childMemento.getString(PREF_FILTER_ID));
            ++i;
        }
        IMemento[] channelFilters = memento.getChildren(PREF_SELECTED_CHANNELS);
        int i2 = 0;
        while (i2 < channelFilters.length) {
            if (channelFilters[i2].getTextData() != null) {
                Channel channel = FeedManager.getDefault().getChannel(channelFilters[i2].getTextData());
                if (channel == null) {
                    channel = FeedManager.getDefault().getChannelWithPreviousUrl(channelFilters[i2].getTextData());
                }
                if (channel != null) {
                    this.fState.getChannelManager().selectChannel(channel);
                }
            }
            ++i2;
        }
        if (this.fIsEventSection && memento.getString(PREF_SHOW_RELATIONSHIP) != null) {
            this.fShowSubjectRelationShipIndicator = Boolean.valueOf(memento.getString(PREF_SHOW_RELATIONSHIP));
        }
    }

    public void saveState(IMemento memento) {
        memento.putString(PREF_MARK_READ_ON_HOVER_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnHover()));
        memento.putString(PREF_MARK_READ_ON_SLIDEOUT_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnSlideout()));
        memento.putString(PREF_MARK_READ_AFTER, Integer.toString(this.fState.getMarkReadAfter()));
        memento.putString(PREF_MARK_READ_ON_FOCUS_TOOLTIP, Boolean.toString(this.fState.isEnableMarkReadOnFocus()));
        memento.putString(PREF_SORTER_ID, this.fState.getPreferredSorterId());
        if (this.fState.getPreferredFilterIds().size() > 0) {
            Iterator iter = this.fState.getPreferredFilterIds().iterator();
            while (iter.hasNext()) {
                IMemento filters = memento.createChild(MEMENTO_FILTERS);
                String filterId = (String)iter.next();
                filters.putString(PREF_FILTER_ID, filterId);
            }
        }
        for (String url : this.fState.getChannelManager().getSelectedChannelUrls()) {
            memento.createChild(PREF_SELECTED_CHANNELS).putTextData(url);
        }
        memento.putString(PREF_SHOW_RELATIONSHIP, Boolean.toString(this.fShowSubjectRelationShipIndicator));
    }

    private void registerListeners() {
        this.getSectionSite().addSectionListener((ISectionListener)this);
        this.fNewsManagerListener = new INewsManagerListener(){
            private String fPreviousRemovedSelectedFeedUrl;

            public void channelAdded(ChannelEvent event) {
                Channel channel = event.getChannel();
                String previousUrl = channel.getPreviousURL();
                SectionPart.SectionSite sectionSite = (SectionPart.SectionSite)FeedSection.this.getSectionSite();
                String category = sectionSite.getParameterValue(FeedSection.PARAM_FEED_CATEGORY);
                boolean showFeed = false;
                if (previousUrl != null && previousUrl.equals(this.fPreviousRemovedSelectedFeedUrl)) {
                    showFeed = true;
                } else if (category != null && category.equals(channel.getCategory())) {
                    if ("com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory())) {
                        if (FeedSection.EVENT_LOG_ID.equals(sectionSite.getId())) {
                            showFeed = true;
                        }
                    } else {
                        showFeed = true;
                    }
                }
                if (showFeed) {
                    FeedSection.this.fState.changeChannelSelection(event.getChannel(), true);
                    FeedSection.this.getSectionSite().setBusy(channel.isLoading());
                }
                this.fPreviousRemovedSelectedFeedUrl = null;
            }

            public void channelRemoved(ChannelEvent event) {
                if (event.getChannel() != null) {
                    if (FeedSection.this.fState.getChannelManager().isChannelSelected(event.getChannel())) {
                        this.fPreviousRemovedSelectedFeedUrl = event.getChannel().getUrl();
                    }
                    FeedSection.this.fState.changeChannelSelection(event.getChannel(), false);
                }
            }
        };
        FeedManager.getDefault().addNewsManagerListener(this.fNewsManagerListener);
        this.fNewsListener = new INewsListener(){

            public void newsReceived(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }

            public void newsRemoved(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }

            public void newsStateChanged(NewsEvent event) {
                FeedSection.this.updateSectionHeader();
            }
        };
        this.fState.getChannelManager().setNewsListener(this.fNewsListener);
        this.fChannelListener = new ChannelAdapter(){

            public void channelStatusChanged(ChannelEvent event) {
                Channel channel = event.getChannel();
                if (FeedSection.this.fState.getChannelManager().isChannelSelected(channel)) {
                    FeedSection.this.getSectionSite().setBusy(channel.isLoading());
                }
            }
        };
        FeedManager.getDefault().addChannelListener((IChannelListener)this.fChannelListener);
    }

    private void unregisterListeners() {
        this.getSectionSite().removeSectionListener((ISectionListener)this);
        FeedManager.getDefault().removeNewsManagerListener(this.fNewsManagerListener);
        FeedManager.getDefault().removeChannelListener((IChannelListener)this.fChannelListener);
    }

    private void loadContributions() {
        this.fState = new FeedSectionState(ItemViewAdvisorManager.getConfigurer());
        this.fState.setPreferredSorterId(this.fState.getConfigurer().getDefaultSorter().getId());
        String itemLabel = this.getSectionSite().getParameterValue(PARAM_ITEM_LABEL);
        if (itemLabel != null && itemLabel.length() > 0) {
            this.fItemLabel = itemLabel;
        }
        if (this.getSectionMemento() == null) {
            String category = this.getSectionSite().getParameterValue(PARAM_FEED_CATEGORY);
            Channel[] channels = FeedManager.getDefault().getChannels();
            int i = 0;
            while (i < channels.length) {
                Channel channel = channels[i];
                if (category == null && channel.getCategory() == null || category != null && category.equals(channel.getCategory())) {
                    this.fState.getChannelManager().selectChannel(channel);
                }
                ++i;
            }
        }
    }

    public boolean isExpanded() {
        return this.fIsExpanded;
    }

    public void sectionCollapsed() {
        this.fIsExpanded = false;
        this.updateSectionHeader();
    }

    public void sectionExpanded() {
        this.fIsExpanded = true;
        this.updateSectionHeader();
    }

    public void sectionMaximized(boolean isContentClipped) {
        if (!fgIsMac && isContentClipped && this.fCustomScrollTable != null && !this.fCustomScrollTable.isDisposed()) {
            this.fCustomScrollTable.showVerticalScrollBarsOnce();
        }
    }

    public void sectionResized() {
    }

    public void setFocus() {
        if (this.fIsExpanded) {
            if (fgIsMac && ((Table)this.fViewer.getControl()).getSelectionCount() > 0) {
                this.fViewer.getControl().setFocus();
            } else if (this.fCustomScrollTable != null && this.fCustomScrollTable.getTable().getSelectionCount() > 0) {
                this.fCustomScrollTable.getTable().setFocus();
            }
        }
    }

    private void deleteSelectedNewsItems() {
        IStructuredSelection selection = (IStructuredSelection)this.fViewer.getSelection();
        ArrayList<Object> itemsToDelete = new ArrayList<Object>(selection.size());
        for (Object obj : selection) {
            if (obj instanceof GenericAggregationBin) {
                GenericAggregationBin bin = (GenericAggregationBin)obj;
                List items = bin.getItems();
                for (Object item : items) {
                    if (!(item instanceof NewsItem)) continue;
                    itemsToDelete.add((NewsItem)item);
                }
                continue;
            }
            if (!(obj instanceof NewsItem)) continue;
            itemsToDelete.add((NewsItem)obj);
        }
        ArrayList<NewsItem> itemsToDeleteFromOtherChannels = new ArrayList<NewsItem>(selection.size());
        HashSet channelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            NewsItem[] channelItems = channel.getItems();
            block3: for (NewsItem newsItem : itemsToDelete) {
                if (newsItem.getChannel() == null || newsItem.getChannel().equals((Object)channel)) continue;
                NewsItem[] newsItemArray = channelItems;
                int n = channelItems.length;
                int n2 = 0;
                while (n2 < n) {
                    NewsItem channelItem = newsItemArray[n2];
                    if (channelItem.equals((Object)newsItem)) {
                        itemsToDeleteFromOtherChannels.add(channelItem);
                        continue block3;
                    }
                    ++n2;
                }
            }
        }
        itemsToDelete.addAll(itemsToDeleteFromOtherChannels);
        FeedManager.getDefault().deleteNewsItems(itemsToDelete.toArray(new NewsItem[itemsToDelete.size()]));
    }

    private void updateReadStateOnSelection(boolean markRead) {
        this.updateReadStateOnSelection((IStructuredSelection)this.fViewer.getSelection(), markRead);
    }

    private void updateReadStateOnSelection(IStructuredSelection selection, boolean markRead) {
        ArrayList<Object> itemsToUpdate = new ArrayList<Object>();
        if (!markRead) {
            for (Object obj : selection) {
                if (!(obj instanceof GenericAggregationBin)) continue;
                itemsToUpdate.add(((GenericAggregationBin)obj).getMostRecent());
            }
        } else {
            for (Object obj : selection) {
                if (!(obj instanceof GenericAggregationBin)) continue;
                GenericAggregationBin bin = (GenericAggregationBin)obj;
                List items = bin.getItems();
                for (Object element : items) {
                    if (!(element instanceof NewsItem)) continue;
                    itemsToUpdate.add(element);
                }
            }
        }
        FeedManager.getDefault().setRead(itemsToUpdate.toArray(new NewsItem[itemsToUpdate.size()]), markRead);
    }

    private void markAllNewsRead() {
        TableItem[] items;
        ArrayList<NewsItem> itemsToMarkRead = new ArrayList<NewsItem>();
        TableItem[] tableItemArray = items = this.fViewer.getTable().getItems();
        int n = items.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            Object data = item.getData();
            if (data instanceof GenericAggregationBin) {
                GenericAggregationBin bin = (GenericAggregationBin)data;
                List binItems = bin.getItems();
                for (Object binItem : binItems) {
                    if (!(binItem instanceof NewsItem) || ((NewsItem)binItem).isIsRead()) continue;
                    itemsToMarkRead.add((NewsItem)binItem);
                }
            }
            ++n2;
        }
        FeedManager.getDefault().setRead(itemsToMarkRead.toArray(new NewsItem[itemsToMarkRead.size()]), true);
    }

    private void updateSectionHeader() {
        HashSet selectedChannelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        final int unread = FeedManager.getDefault().countUnreadNews(new ArrayList(selectedChannelUrls), true);
        if (this.fTeaserLabel != null && !this.fTeaserLabel.isDisposed() && !this.fTeaserLabel.getDisplay().isDisposed()) {
            this.fTeaserLabel.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!FeedSection.this.fTeaserLabel.isDisposed() && !FeedSection.this.fTeaserLabel.getDisplay().isDisposed()) {
                        int visibleUnreadNews = unread;
                        if (FeedSection.this.fViewer != null && !FeedSection.this.fViewer.getControl().isDisposed()) {
                            visibleUnreadNews = FeedSection.this.countVisibleUnreadNews();
                        }
                        if (!FeedSection.this.fIsExpanded) {
                            if (visibleUnreadNews != 0) {
                                FeedSection.this.fTeaserLabel.setText(NLS.bind((String)Messages.FeedSection_UNREAD_COUNT, (Object)visibleUnreadNews, (Object[])new Object[0]));
                            } else {
                                FeedSection.this.fTeaserLabel.setText("");
                            }
                            FeedSection.this.getSectionSite().layoutTeaser();
                        } else {
                            if (visibleUnreadNews != 0) {
                                FeedSection.this.fTeaserLabel.setText(NLS.bind((String)Messages.FeedSection_UNREAD_NEWS_INDICATOR, (Object)FeedSection.this.fItemLabel, (Object[])new Object[]{visibleUnreadNews}));
                            } else {
                                FeedSection.this.fTeaserLabel.setText("");
                            }
                            FeedSection.this.getSectionSite().layoutTeaser();
                        }
                        FeedSection.this.updateStackLayout();
                        FeedSection.this.updateMenuEnablement(visibleUnreadNews);
                    }
                }
            });
        }
    }

    private int countVisibleUnreadNews() {
        Object[] visibleItems;
        int unreadCount = 0;
        HashSet channelUrls = this.fState.getChannelManager().getSelectedChannelUrls();
        ArrayList<NewsItem> newsItems = new ArrayList<NewsItem>();
        for (String channelUrl : channelUrls) {
            Channel channel = FeedManager.getDefault().getChannel(channelUrl);
            if (channel == null) continue;
            newsItems.addAll(Arrays.asList(channel.getItems()));
        }
        HashMap<String, GenericAggregationBin> bins = new HashMap<String, GenericAggregationBin>();
        for (NewsItem newsitem : newsItems) {
            GenericAggregationBin bin = (GenericAggregationBin)bins.get(newsitem.getLink());
            if (bin == null) {
                bin = new GenericAggregationBin();
                bins.put(newsitem.getLink(), bin);
            }
            bin.add((Object)newsitem);
        }
        Collection values = bins.values();
        GenericAggregationBin[] binArray = values.toArray(new GenericAggregationBin[values.size()]);
        Object[] objectArray = visibleItems = this.fViewer.getFilteredChildren(binArray);
        int n = visibleItems.length;
        int n2 = 0;
        while (n2 < n) {
            Object item = objectArray[n2];
            if (item instanceof NewsItem && !((NewsItem)item).isIsRead()) {
                ++unreadCount;
            } else if (item instanceof GenericAggregationBin && ((GenericAggregationBin)item).containsUnread()) {
                ++unreadCount;
            }
            ++n2;
        }
        return unreadCount;
    }

    public void sectionOpened() {
        ChannelManager cm = this.getChannelManager();
        HashSet selectedChannelUrls = cm.getSelectedChannelUrls();
        String[] channelUrls = selectedChannelUrls.toArray(new String[selectedChannelUrls.size()]);
        Channel[] channels = new Channel[channelUrls.length];
        int i = 0;
        while (i < channelUrls.length) {
            channels[i] = FeedManager.getDefault().getChannel(channelUrls[i]);
            ++i;
        }
        ISectionSite site = this.getSectionSite();
        String id = ((SectionPart.SectionSite)site).getId();
        String name = site.getName();
        IWorkbenchPage page = site.getViewSite().getPage();
        OpenFeedsAggregatedAction action = new OpenFeedsAggregatedAction(id, channels, page, name, this.fState.getPreferredSorterId(), this.fState.getPreferredFilterIds());
        action.run(null);
    }
}

