/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.NewsContextProvider;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.Hyperlinks;
import com.ibm.team.jface.GenericAggregationBin;
import com.ibm.team.jface.dashboard.ISectionSite;
import com.ibm.team.jface.preview.DomainAdapterUtils;
import com.ibm.team.jface.preview.IDomainAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewSite;

public class OpenNewsAction
extends Action {
    private ISectionSite fSectionSite;
    private List<NewsItem> fNewsItems;

    public OpenNewsAction(ISectionSite sectionSite, NewsItem newsItem) {
        this.fNewsItems = Collections.singletonList(newsItem);
        this.fSectionSite = sectionSite;
    }

    public OpenNewsAction(ISectionSite sectionSite, IStructuredSelection selection) {
        this.fNewsItems = new ArrayList<NewsItem>(selection.size());
        List list = selection.toList();
        for (Object object : list) {
            Object mostRecent;
            if (object instanceof NewsItem) {
                this.fNewsItems.add((NewsItem)object);
                continue;
            }
            if (!(object instanceof GenericAggregationBin) || !((mostRecent = ((GenericAggregationBin)object).getMostRecent()) instanceof NewsItem)) continue;
            this.fNewsItems.add((NewsItem)mostRecent);
        }
        this.fSectionSite = sectionSite;
    }

    public String getText() {
        return Messages.OpenNewsAction_OPEN;
    }

    public void run() {
        for (NewsItem newsitem : this.fNewsItems) {
            String link = newsitem.getLink();
            if (link == null || link.length() == 0) {
                return;
            }
            IDomainAdapter adapter = DomainAdapterUtils.getDomainAdapter(this.fNewsItems);
            if (adapter != null) {
                adapter.markAsRead(this.fNewsItems, 0);
            }
            try {
                Hyperlinks.open((URI)new URI(link), (ContextProvider)new NewsContextProvider(newsitem, (Object)this.fSectionSite.getViewSite().getPage()));
            }
            catch (URISyntaxException e) {
                if (link.contains(" ")) {
                    String encodedLink = link.replace(" ", "%20");
                    try {
                        Hyperlinks.open((URI)new URI(encodedLink), (ContextProvider)new NewsContextProvider(newsitem, (Object)this.fSectionSite.getViewSite().getPage()));
                    }
                    catch (URISyntaxException e1) {
                        this.handleError(e);
                    }
                    continue;
                }
                this.handleError(e);
            }
        }
    }

    private void handleError(URISyntaxException e) {
        IViewSite viewSite = this.fSectionSite.getViewSite();
        Shell shell = viewSite != null ? viewSite.getShell() : null;
        String msg = Messages.OpenNewsAction_UNEXPECTED_ERROR;
        ErrorDialog.openError((Shell)shell, (String)Messages.OpenNewsAction_PROBLEM_ON_OPEN, (String)msg, (IStatus)new Status(4, "com.ibm.team.feed.ui", -1, msg, (Throwable)e));
    }
}

