/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.FeedUI;
import com.ibm.team.feed.ui.internal.ImagePool;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.jface.itemview.MarkupItemViewInput;
import com.ibm.team.repository.common.util.NLS;
import java.util.Date;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class OpenFeedAction
implements IObjectActionDelegate {
    private IStructuredSelection fSelection;
    private IWorkbenchPage fPage;
    private DateFormat fDateFormat = DateFormat.getDateInstance();

    public OpenFeedAction() {
    }

    public OpenFeedAction(IStructuredSelection selection, IWorkbenchPage page) {
        this.fSelection = selection;
        this.fPage = page;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.fPage = targetPart.getSite().getPage();
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.fSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : null;
    }

    public void run(IAction action) {
        Object[] objects = this.fSelection.toArray();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (object instanceof Channel) {
                this.openItemView((Channel)object);
            }
            ++i;
        }
    }

    private void openItemView(Channel channel) {
        String id = String.valueOf(channel.hashCode());
        String name = channel.getTitle();
        MarkupItemViewInput input = new MarkupItemViewInput((Object)new Channel[]{channel}, name, id, true);
        if ("com.ibm.team.feed.core.SystemFeed".equals(channel.getCategory())) {
            input.setImageDescriptor(ImagePool.EVENTS);
        }
        String title = NLS.bind((String)Messages.OpenFeedAction_TIMELINE, (Object)name, (Object[])new Object[0]);
        String status = Messages.OpenFeedAction_NO_ITEMS;
        Date firstItemDate = null;
        Date lastItemDate = null;
        NewsItem[] items = channel.getItems();
        int j = 0;
        while (j < items.length) {
            NewsItem item = items[j];
            if (firstItemDate == null || firstItemDate != null && firstItemDate.after(item.getPublishDate())) {
                firstItemDate = item.getPublishDate();
            }
            if (lastItemDate == null || lastItemDate != null && lastItemDate.before(item.getPublishDate())) {
                lastItemDate = item.getPublishDate();
            }
            ++j;
        }
        if (firstItemDate != null && lastItemDate != null) {
            status = NLS.bind((String)Messages.OpenFeedAction_DATE_FROM_TO, (Object)this.fDateFormat.format(firstItemDate), (Object[])new Object[]{this.fDateFormat.format(lastItemDate)});
        }
        input.setTitle(title);
        input.setStatusLabel(status);
        FeedUI.openItemView(this.fPage, input);
    }
}

