/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.icu.text.DateFormat;
import com.ibm.team.feed.core.model.NewsItem;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.jface.itemview.MarkupUtil;
import com.ibm.team.jface.preview.HTMLGenerator;
import com.ibm.team.repository.common.util.NLS;
import java.util.HashMap;

public class NewsHTMLGenerator
extends HTMLGenerator {
    private static final String NEW_ITEM_INDICATOR = "*";
    private static DateFormat fDateTimeFormat = DateFormat.getDateTimeInstance((int)2, (int)2);
    private static final String GENERAL_CSS = "GENERAL_NEWS_CSS";
    private final NewsItem fNewsItem;

    public NewsHTMLGenerator(NewsItem newsItem) {
        this.fNewsItem = newsItem;
    }

    protected void createControl(HTMLGenerator.Composite composite) {
        if (this.getInfo().isEmbeddeble) {
            HTMLGenerator.Container div = new HTMLGenerator.Container((HTMLGenerator)this, composite);
            div.setCSSClass("item");
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)div, this.fNewsItem.getDescription() != null ? this.fNewsItem.getDescription() : Messages.NewsHTMLGenerator_NEWS_EMPTY_DESCRIPTION);
        } else {
            HTMLGenerator.Container teaser = new HTMLGenerator.Container((HTMLGenerator)this, composite);
            teaser.setCSSClass("teaser");
            if (!this.getInfo().isHoverTooltip) {
                HTMLGenerator.Link link = new HTMLGenerator.Link((HTMLGenerator)this, (HTMLGenerator.Composite)teaser, this.fNewsItem.getLink());
                String titleVal = this.fNewsItem.getTitle();
                if (titleVal != null && titleVal.startsWith(NEW_ITEM_INDICATOR)) {
                    titleVal = titleVal.substring(NEW_ITEM_INDICATOR.length()).trim();
                }
                HTMLGenerator.Label title = new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)link, !this.getInfo().isHoverTooltip ? titleVal : NLS.bind((String)"<strong>{0}</strong>", (Object)titleVal, (Object[])new Object[0]));
                title.setFont(null, -1, false, true);
            }
            HTMLGenerator.Container div = new HTMLGenerator.Container((HTMLGenerator)this, (HTMLGenerator.Composite)teaser);
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)div, NLS.bind((String)Messages.NewsHTMLGenerator_ON_DATE, (Object)fDateTimeFormat.format(this.fNewsItem.getPublishDate()), (Object[])new Object[0]));
            new HTMLGenerator.Label((HTMLGenerator)this, (HTMLGenerator.Composite)div, this.fNewsItem.getDescription() != null ? this.fNewsItem.getDescription() : Messages.NewsHTMLGenerator_NEWS_EMPTY_DESCRIPTION);
            div.setCSSClass("item");
        }
    }

    protected void generateHead(HashMap map) {
        if (map.containsKey(GENERAL_CSS)) {
            return;
        }
        StringBuffer css = new StringBuffer();
        css.append("<style type=\"text/css\">");
        css.append("body { overflow: auto; margin: 5; }\n");
        css.append(".{ ").append(MarkupUtil.getGlobalFont()).append(" } ");
        css.append("div.item { margin: 0px; padding-top: 2px; padding-bottom: 2px; ").append(MarkupUtil.getDefaultFont()).append(" } ");
        css.append("div.teaser { ").append(MarkupUtil.getDefaultFont()).append(" } ");
        css.append("table { ").append(MarkupUtil.getDefaultFont()).append(" border-collapse: collapse; }");
        css.append("td { padding-left: 10px; padding-right: 10px; }");
        css.append("th { padding-left: 10px; padding-right: 10px; text-align: left; }");
        css.append("table.changes { border: 1px solid rgb(200,200,200);").append(MarkupUtil.getDefaultFont()).append(" border-collapse: collapse; margin-top: 3px;}");
        css.append("table.changes td { border: 1px solid rgb(200,200,200); vertical-align: top; padding: 3px; }");
        css.append("table.changes th { border: 1px solid rgb(200,200,200); padding: 3px; text-align: left; }");
        if (this.getInfo().isHoverTooltip) {
            css.append("a:link { text-decoration: none; color: black; } ");
            css.append("a:visited { color: black; text-decoration: none; } ");
        } else {
            css.append("a:link { color: #0000FF; text-decoration: none; }");
            css.append("a:visited { color: #0000FF; text-decoration: none; }\n");
        }
        css.append("a:hover { color: #000080; text-decoration: underline; } ");
        css.append("del {\n");
        css.append("  background-color: rgb(255,229,229);\n");
        css.append("}\n");
        css.append("ins {\n");
        css.append("  background-color: rgb(229,242,229);\n");
        css.append("}\n");
        css.append("</style>");
        map.put(GENERAL_CSS, css.toString());
    }
}

