/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.foundation.common.text.XMLString;
import com.ibm.team.repository.common.util.NLS;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPropertyPage;
import org.eclipse.ui.dialogs.PropertyPage;

public class FeedStatusPropertyPage
extends PropertyPage
implements IWorkbenchPropertyPage {
    private IAdaptable fElement;

    public FeedStatusPropertyPage() {
        this.noDefaultAndApplyButton();
    }

    protected Control createContents(Composite parent) {
        Composite control = new Composite(parent, 0);
        control.setLayout((Layout)new GridLayout(1, false));
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.fElement instanceof Channel) {
            XMLString xmlStr;
            GridData gridData;
            Channel feed = (Channel)this.fElement;
            if (feed.getDescription() != null) {
                Label descriptionLabel = new Label(control, 0);
                descriptionLabel.setText(Messages.FeedStatusPropertyPage_DESCRIPTION);
                descriptionLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
                Label descriptionValueLabel = new Label(control, 64);
                gridData = new GridData(768);
                gridData.widthHint = this.convertWidthInCharsToPixels(60);
                descriptionValueLabel.setLayoutData((Object)gridData);
                xmlStr = XMLString.createFromXMLText((String)feed.getDescription());
                descriptionValueLabel.setText(xmlStr.getPlainText());
            }
            if (feed.getDescription() != null) {
                new Label(control, 0);
            }
            Label errorLabel = new Label(control, 0);
            errorLabel.setText(Messages.FeedStatusPropertyPage_STATUS);
            errorLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.dialogfont"));
            Label errorValueLabel = new Label(control, 64);
            gridData = new GridData(768);
            gridData.widthHint = this.convertWidthInCharsToPixels(60);
            errorValueLabel.setLayoutData((Object)gridData);
            if (feed.getLastError() != null) {
                xmlStr = XMLString.createFromXMLText((String)feed.getLastError());
                errorValueLabel.setText(NLS.bind((String)Messages.FeedStatusPropertyPage_LOADING_FAILED, (Object)xmlStr.getPlainText(), (Object[])new Object[0]));
            } else {
                errorValueLabel.setText(Messages.FeedStatusPropertyPage_DEFAULT_OK_STATUS);
            }
        }
        return control;
    }

    public void setElement(IAdaptable element) {
        super.setElement(element);
        this.fElement = element;
    }
}

