/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.feed.ui.internal.OpenFeedsAction;
import com.ibm.team.foundation.common.URIReference;
import com.ibm.team.foundation.rcp.core.hyperlinks.ContextProvider;
import com.ibm.team.foundation.rcp.core.hyperlinks.HyperlinkHandler;
import com.ibm.team.foundation.rcp.ui.util.FoundationUIJob;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLEncoder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class FeedHyperlinkHandler
extends HyperlinkHandler {
    public boolean handles(URI uri) {
        try {
            return this.getChannel(uri) != null;
        }
        catch (UnsupportedEncodingException e) {
            return false;
        }
    }

    public boolean links(Object object) {
        return object instanceof Channel;
    }

    public URIReference createHyperlink(Object object, IProgressMonitor monitor) {
        if (object instanceof Channel) {
            Channel channel = (Channel)object;
            try {
                String description = channel.getDescription();
                if (description == null) {
                    description = channel.getTitle();
                }
                return new URIReference(channel.getTitle(), description, Channel.class.getName(), new URI(this.encode(channel.getUrl())));
            }
            catch (URISyntaxException e) {
                FeedUIPlugin.getDefault().log("Error creating URIReference for channel", e);
            }
            catch (UnsupportedEncodingException e) {
                FeedUIPlugin.getDefault().log("Error creating URIReference for channel", e);
            }
        }
        return super.createHyperlink(object, monitor);
    }

    private String encode(String url) throws UnsupportedEncodingException {
        return url.replace("{$user}", URLEncoder.encode("{$user}", "utf-8"));
    }

    private String decode(String url) throws UnsupportedEncodingException {
        return url.replace(URLEncoder.encode("{$user}", "utf-8"), "{$user}");
    }

    public IStatus open2(final URI uri, final ContextProvider provider, IProgressMonitor monitor) {
        FoundationUIJob job = new FoundationUIJob(Messages.FeedHyperlinkHandler_OPENING_FEED){

            public IStatus runProtectedInUI(IProgressMonitor monitor) {
                try {
                    Channel channel = FeedHyperlinkHandler.this.getChannel(uri);
                    StructuredSelection selection = new StructuredSelection((Object)channel);
                    IWorkbenchPart activePart = this.getActivePart(provider);
                    OpenFeedsAction openFeedsAction = new OpenFeedsAction();
                    if (activePart != null) {
                        openFeedsAction.setActivePart(null, activePart);
                    }
                    openFeedsAction.selectionChanged(null, (ISelection)selection);
                    openFeedsAction.run(null);
                    return Status.OK_STATUS;
                }
                catch (UnsupportedEncodingException e) {
                    return new Status(4, "com.ibm.team.feed.ui", Messages.FeedHyperlinkHandler_ERROR_OPENING_FEED, (Throwable)e);
                }
            }

            private IWorkbenchPart getActivePart(ContextProvider provider2) {
                IWorkbenchPage[] pages;
                IWorkbenchWindow window = null;
                IWorkbench workbench = PlatformUI.getWorkbench();
                if (provider2 == null) {
                    window = workbench.getActiveWorkbenchWindow();
                } else {
                    Object uiContext = provider2.findUIContext();
                    if (uiContext instanceof IWorkbenchWindow) {
                        window = (IWorkbenchWindow)uiContext;
                    } else if (uiContext instanceof Shell) {
                        IWorkbenchWindow[] workbenchWindows;
                        IWorkbenchWindow[] iWorkbenchWindowArray = workbenchWindows = workbench.getWorkbenchWindows();
                        int n = workbenchWindows.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IWorkbenchWindow workbenchWindow = iWorkbenchWindowArray[n2];
                            if (workbenchWindow.getShell().equals(uiContext)) {
                                window = workbenchWindow;
                                break;
                            }
                            ++n2;
                        }
                    } else {
                        window = workbench.getActiveWorkbenchWindow();
                    }
                }
                if (window == null) {
                    return null;
                }
                IWorkbenchPage page = window.getActivePage();
                if (page == null && (pages = window.getPages()).length > 0) {
                    page = pages[0];
                }
                if (page == null) {
                    return null;
                }
                IWorkbenchPart part = page.getActivePart();
                return part;
            }
        };
        job.schedule();
        try {
            job.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return Status.OK_STATUS;
    }

    public boolean resolves(URI uri) {
        return this.handles(uri);
    }

    public Object resolve(URI uri, ContextProvider provider, IProgressMonitor monitor) throws CoreException {
        try {
            return this.getChannel(uri);
        }
        catch (UnsupportedEncodingException e) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.team.feed.ui", Messages.FeedHyperlinkHandler_ERROR_RESOLVING_FEED, (Throwable)e));
        }
    }

    private Channel getChannel(URI uri) throws UnsupportedEncodingException {
        String uriString = this.decode(uri.toString());
        Channel channel = FeedManager.getDefault().getChannel(uriString);
        if (channel == null) {
            channel = FeedManager.getDefault().getChannelWithPreviousUrl(uriString);
        }
        return channel;
    }
}

