/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.ChannelEvent;
import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import com.ibm.team.feed.core.model.FeedFactory;
import com.ibm.team.feed.ui.internal.ColorDefinitions;
import com.ibm.team.feed.ui.internal.FeedUIPlugin;
import com.ibm.team.feed.ui.internal.HelpContextIds;
import com.ibm.team.feed.ui.internal.Messages;
import com.ibm.team.foundation.client.internal.util.ClientURIUtils;
import com.ibm.team.repository.common.util.NLS;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;

public class EditFeedComposite {
    private static final int DEFAULT_MIN_POLL_INTERVAL = 180;
    private static final int MIN_POLL_INTERVAL = EditFeedComposite.getMinimumPollInterval();
    private static final String DEFAULT_TITLE = Messages.EditFeedComposite_FEED_DEFAULT_TITLE;
    public static final String AUTHMETHOD = "Basic";
    public static final String PASSWORD = "com.ibm.team.foundation.authentication.password";
    public static final String REALM = "";
    public static final String USERNAME = "com.ibm.team.foundation.authentication.userid";
    private Button fAuthCheck;
    private int fColor = 2;
    private Button fColorButton;
    private Menu fColorMenu;
    private Text fPassInput;
    private String fPassword;
    private String fTitle;
    private Text fTitleInput;
    private int fUpdateIntervalInSeconds = 0;
    private int fServerMinUpdateInterval = 0;
    private Spinner fUpdateSpinner;
    private String fUrl;
    private Text fUrlInput;
    private Text fUserInput;
    private String fUsername;
    boolean fForceFeedDownload;
    boolean fOverrideServerConfiguration = false;
    private Button fForceFeedDownloadInput;
    private Button fOverrideServerConfigurationInput;
    private Button fAgeLimitCheck;
    private long fAgeLimit;
    private Spinner fAgeLimitSpinner;
    private Button fUpdateCheck;
    private Button fItemLimitCheck;
    private int fItemLimit;
    private Spinner fItemLimitSpinner;
    private Shell fShell;
    private Channel fChannel;
    private boolean isNew;
    private boolean fIsValid = false;
    private String fMessage = "";
    private ModifyListener fModifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent e) {
            boolean newvalid = EditFeedComposite.this.validate();
            if (EditFeedComposite.this.fIsValid != newvalid) {
                EditFeedComposite.this.fIsValid = newvalid;
                EditFeedComposite.this.fValidationListener.validationChanged(EditFeedComposite.this.fIsValid, EditFeedComposite.this.fMessage);
            }
        }
    };
    private IValidationListener fValidationListener;

    public EditFeedComposite(IValidationListener listener) {
        this.fValidationListener = listener;
    }

    public void init(Channel channel) {
        this.fIsValid = true;
        if (channel == null) {
            this.isNew = true;
            this.fChannel = FeedFactory.eINSTANCE.createChannel();
        } else {
            this.isNew = false;
            this.fChannel = channel;
        }
        String url = this.fChannel.getUrl();
        String title = this.fChannel.getTitle();
        int updateInterval = this.fChannel.getUpdateInterval();
        int serverMinimumUpdateInterval = this.fChannel.getServerMinimumUpdateIntervalInSeconds();
        int color = this.fChannel.getColor();
        boolean forceDownload = this.fChannel.isForceDownload();
        int itemlimit = this.fChannel.getItemLimit();
        long agelimit = this.fChannel.getAgeLimit();
        boolean overrideServerConfiguration = this.fChannel.getOverrideServerConfiguration();
        String username = null;
        String password = null;
        this.setUrl(url);
        this.setTitle(title);
        this.setUsername(username);
        this.setPassword(password);
        this.setColor(color);
        this.setUpdateInterval(updateInterval);
        this.setServerMinUpdateInterval(serverMinimumUpdateInterval);
        this.setForceFeedDownload(forceDownload);
        this.setItemLimit(itemlimit);
        this.setAgeLimit(agelimit);
        this.setOverrideServerConfiguration(overrideServerConfiguration);
    }

    public boolean save() {
        this.updateFields();
        if (this.isNew || !this.fChannel.getUrl().equals(this.getUrl())) {
            final Channel updatedChannel = FeedFactory.eINSTANCE.createChannel();
            this.updateTitle(updatedChannel);
            updatedChannel.setUrl(this.getUrl());
            updatedChannel.setUpdateInterval(this.getUpdateIntervalInSeconds(), Channel.TimeUnit.SECONDS);
            updatedChannel.setColor(this.getColor());
            updatedChannel.setForceDownload(this.getForceFeedDownload());
            updatedChannel.setAgeLimit(this.getAgeLimit());
            updatedChannel.setItemLimit(this.getItemLimit());
            updatedChannel.setOverrideServerConfiguration(this.getOverrideServerConfiguration());
            if (!this.isNew) {
                updatedChannel.setLastError(this.fChannel.getLastError());
            }
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    String url = updatedChannel.getUrl();
                    if (url.contains("{$user}")) {
                        url = url.replace("{$user}", EditFeedComposite.REALM);
                    }
                    if (ClientURIUtils.findTeamRepository((URI)new URI(url)) != null) {
                        updatedChannel.setCategory("com.ibm.team.feed.core.SystemFeed");
                    }
                }

                public void handleException(Throwable exception) {
                }
            });
            this.updateCredentials(updatedChannel, this.getUsername(), this.getPassword());
            if (this.isNew) {
                FeedManager.getDefault().addChannel(updatedChannel);
                this.fChannel = updatedChannel;
            } else {
                FeedManager.getDefault().editChannel(this.fChannel, updatedChannel);
                this.fChannel = updatedChannel;
            }
        } else {
            this.updateCredentials(this.fChannel, this.getUsername(), this.getPassword());
            this.updateTitle(this.fChannel);
            if (this.fChannel.getColor() != this.getColor()) {
                this.fChannel.setColor(this.getColor());
            }
            if (this.fChannel.getUpdateInterval(Channel.TimeUnit.SECONDS) != this.getUpdateIntervalInSeconds()) {
                this.fChannel.setUpdateInterval(this.getUpdateIntervalInSeconds(), Channel.TimeUnit.SECONDS);
            }
            if (this.fChannel.isForceDownload() != this.getForceFeedDownload()) {
                this.fChannel.setForceDownload(this.getForceFeedDownload());
            }
            if (this.fChannel.getOverrideServerConfiguration() != this.getOverrideServerConfiguration()) {
                this.fChannel.setOverrideServerConfiguration(this.getOverrideServerConfiguration());
            }
            if (this.fChannel.getAgeLimit() != this.getAgeLimit()) {
                this.fChannel.setAgeLimit(this.getAgeLimit());
            }
            if (this.fChannel.getItemLimit() != this.getItemLimit()) {
                this.fChannel.setItemLimit(this.getItemLimit());
            }
            FeedManager.getDefault().fireChannelEditedEvent(new ChannelEvent(this.fChannel, true));
        }
        this.fChannel.setExplicitRefresh(true);
        FeedManager.getDefault().loadNews(this.fChannel);
        return true;
    }

    Channel getChannel() {
        return this.fChannel;
    }

    public Control createContents(final Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.fShell = composite.getShell();
        composite.setLayout((Layout)new GridLayout(1, false));
        ((GridLayout)composite.getLayout()).marginWidth = 0;
        ((GridLayout)composite.getLayout()).marginHeight = 0;
        GridData compositeGridData = new GridData(4, 4, true, true);
        composite.setLayoutData((Object)compositeGridData);
        Group generalGroup = new Group(composite, 0);
        generalGroup.setText(Messages.EditFeedComposite_GROUP_GENERAL);
        generalGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        generalGroup.setLayout((Layout)new GridLayout(2, false));
        Label urlLabel = new Label((Composite)generalGroup, 0);
        urlLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        urlLabel.setText(Messages.EditFeedComposite_FEED_LINK);
        this.fUrlInput = new Text((Composite)generalGroup, 2048);
        GridData urldata = new GridData(4, 1, true, false);
        urldata.widthHint = 300;
        this.fUrlInput.setLayoutData((Object)urldata);
        if (this.fUrl != null) {
            this.fUrlInput.setText(this.fUrl);
        } else {
            String defaultUrlValue = "http://";
            this.fUrlInput.setText(defaultUrlValue);
            this.fUrlInput.setSelection(defaultUrlValue.length());
        }
        this.fUrlInput.addModifyListener(this.fModifyListener);
        Label titleLabel = new Label((Composite)generalGroup, 0);
        titleLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        titleLabel.setText(Messages.EditFeedComposite_FEED_TITLE);
        this.fTitleInput = new Text((Composite)generalGroup, 2048);
        this.fTitleInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fTitleInput.setText(this.fTitle != null ? this.fTitle : REALM);
        if (DEFAULT_TITLE.equals(this.fTitle)) {
            this.fTitleInput.setForeground(Display.getCurrent().getSystemColor(15));
        }
        this.fTitleInput.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DEFAULT_TITLE.equals(EditFeedComposite.this.fTitleInput.getText())) {
                    EditFeedComposite.this.fTitleInput.setForeground(Display.getCurrent().getSystemColor(15));
                } else {
                    EditFeedComposite.this.fTitleInput.setForeground(parent.getForeground());
                }
            }
        });
        this.fTitleInput.addFocusListener(new FocusListener(){

            public void focusGained(FocusEvent e) {
                if (DEFAULT_TITLE.equals(EditFeedComposite.this.fTitleInput.getText())) {
                    EditFeedComposite.this.fTitleInput.setText(EditFeedComposite.REALM);
                }
            }

            public void focusLost(FocusEvent e) {
                if (EditFeedComposite.this.fTitleInput.getText() == null || EditFeedComposite.this.fTitleInput.getText().length() == 0) {
                    EditFeedComposite.this.fTitleInput.setText(DEFAULT_TITLE);
                }
            }
        });
        Group authGroup = new Group(composite, 0);
        authGroup.setText(Messages.EditFeedComposite_FEED_AUTHENTICATION);
        authGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        authGroup.setLayout((Layout)new GridLayout(2, false));
        this.fAuthCheck = new Button((Composite)authGroup, 32);
        this.fAuthCheck.setText(Messages.EditFeedComposite_FEED_REQUIRES_AUTHENTICATION);
        this.fAuthCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fAuthCheck.setSelection(this.fUsername != null && !this.fUsername.equals(REALM));
        Label userLabel = new Label((Composite)authGroup, 0);
        userLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        userLabel.setText(Messages.EditFeedComposite_USERNAME);
        this.fUserInput = new Text((Composite)authGroup, 2048);
        this.fUserInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fUserInput.setText(this.fUsername != null ? this.fUsername : REALM);
        this.fUserInput.setEnabled(this.fAuthCheck.getSelection());
        Label passLabel = new Label((Composite)authGroup, 0);
        passLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        passLabel.setText(Messages.EditFeedComposite_PASSWORD);
        this.fPassInput = new Text((Composite)authGroup, 0x400800);
        this.fPassInput.setLayoutData((Object)new GridData(4, 1, true, false));
        this.fPassInput.setText(this.fPassword != null ? this.fPassword : REALM);
        this.fPassInput.setEnabled(this.fAuthCheck.getSelection());
        this.fAuthCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditFeedComposite.this.fUserInput.setEnabled(EditFeedComposite.this.fAuthCheck.getSelection());
                EditFeedComposite.this.fPassInput.setEnabled(EditFeedComposite.this.fAuthCheck.getSelection());
            }
        });
        final Group settingsGroup = new Group(composite, 0);
        settingsGroup.setText(Messages.EditFeedComposite_SETTINGS);
        settingsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        settingsGroup.setLayout((Layout)new GridLayout(2, false));
        this.fUpdateCheck = new Button((Composite)settingsGroup, 32);
        this.fUpdateCheck.setText(Messages.EditFeedComposite_UPDATE_FEED_AUTOMATICALLY);
        this.fUpdateCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fUpdateCheck.setSelection(this.fUpdateIntervalInSeconds != 0);
        this.fUpdateCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditFeedComposite.this.fUpdateSpinner.setEnabled(EditFeedComposite.this.fUpdateCheck.getSelection());
            }
        });
        Label updateLabel = new Label((Composite)settingsGroup, 0);
        updateLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        updateLabel.setText(Messages.EditFeedComposite_UPDATE_INTERVAL);
        this.fUpdateSpinner = new Spinner((Composite)settingsGroup, 2048);
        this.fUpdateSpinner.setMaximum(9999);
        this.fUpdateSpinner.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.fUpdateSpinner.setSelection(this.getUpdateIntervalInSeconds() != 0 ? this.getUpdateIntervalInSeconds() : this.getEffectiveMinimumPollInterval());
        this.fUpdateSpinner.setEnabled(this.getUpdateIntervalInSeconds() != 0);
        this.fUpdateSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int selection = EditFeedComposite.this.fUpdateSpinner.getSelection();
                EditFeedComposite.this.validateAndSetUpdateInterval(selection);
            }
        });
        Label colorLabel = new Label((Composite)settingsGroup, 0);
        colorLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        colorLabel.setText(Messages.EditFeedComposite_DISPLAY_COLOR);
        this.fColorButton = new Button((Composite)settingsGroup, 0);
        this.fColorButton.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.fColorButton.setImage(this.createColorImage(ColorDefinitions.convertToRGB(this.fColor)));
        this.fColorButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (EditFeedComposite.this.fColorButton.getImage() != null) {
                    EditFeedComposite.this.fColorButton.getImage().dispose();
                }
                EditFeedComposite.this.fColorMenu.dispose();
            }
        });
        this.fColorMenu = new Menu((Control)this.fColorButton);
        List<ColorDefinitions.ColorDefinition> feedColors = ColorDefinitions.fgColors;
        for (final ColorDefinitions.ColorDefinition feedColor : feedColors) {
            final MenuItem menuItem = new MenuItem(this.fColorMenu, 8);
            menuItem.setImage(this.createColorImage(feedColor.getRGB()));
            menuItem.setText(feedColor.getName());
            menuItem.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    if (menuItem.getImage() != null) {
                        menuItem.getImage().dispose();
                    }
                }
            });
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    EditFeedComposite.this.fColor = feedColor.toInt();
                    Image oldImage = EditFeedComposite.this.fColorButton.getImage();
                    EditFeedComposite.this.fColorButton.setImage(EditFeedComposite.this.createColorImage(feedColor.getRGB()));
                    if (oldImage != null) {
                        oldImage.dispose();
                    }
                }
            });
        }
        new MenuItem(this.fColorMenu, 2);
        MenuItem moreItem = new MenuItem(this.fColorMenu, 8);
        moreItem.setText(Messages.EditFeedComposite_MORE);
        moreItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ColorDialog dialog = new ColorDialog(EditFeedComposite.this.getShell(), 0);
                dialog.setRGB(ColorDefinitions.convertToRGB(EditFeedComposite.this.fColor));
                RGB rgb = dialog.open();
                if (rgb != null) {
                    EditFeedComposite.this.fColor = ColorDefinitions.convertToInt(rgb);
                    Image oldImage = EditFeedComposite.this.fColorButton.getImage();
                    EditFeedComposite.this.fColorButton.setImage(EditFeedComposite.this.createColorImage(rgb));
                    if (oldImage != null) {
                        oldImage.dispose();
                    }
                }
            }
        });
        this.fColorButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Rectangle rect = EditFeedComposite.this.fColorButton.getBounds();
                Point pt = new Point(rect.x, rect.y + rect.height);
                pt = settingsGroup.toDisplay(pt);
                EditFeedComposite.this.fColorMenu.setLocation(pt.x, pt.y);
                EditFeedComposite.this.fColorMenu.setVisible(true);
            }
        });
        this.fForceFeedDownloadInput = new Button((Composite)settingsGroup, 32);
        this.fForceFeedDownloadInput.setText(Messages.EditFeedComposite_RELOAD_FEED_ON_STARTUP);
        this.fForceFeedDownloadInput.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.fForceFeedDownloadInput.setSelection(this.fForceFeedDownload);
        this.fOverrideServerConfigurationInput = new Button((Composite)settingsGroup, 32);
        this.fOverrideServerConfigurationInput.setText(Messages.EditFeedComposite_OVERRIDE_SERVER_CONFIGURATION);
        this.fOverrideServerConfigurationInput.setLayoutData((Object)new GridData(1, 0x1000000, true, false, 2, 1));
        this.fOverrideServerConfigurationInput.setSelection(this.fOverrideServerConfiguration);
        this.fOverrideServerConfigurationInput.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditFeedComposite.this.fOverrideServerConfiguration = EditFeedComposite.this.fOverrideServerConfigurationInput.getSelection();
                int updateInterval = EditFeedComposite.this.fUpdateSpinner.getSelection();
                EditFeedComposite.this.validateAndSetUpdateInterval(updateInterval);
            }
        });
        Group limitGroup = new Group(composite, 0);
        limitGroup.setText(Messages.EditFeedComposite_NEWS_LIMITS);
        limitGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        limitGroup.setLayout((Layout)new GridLayout(2, false));
        this.fItemLimitCheck = new Button((Composite)limitGroup, 32);
        this.fItemLimitCheck.setText(Messages.EditFeedComposite_NEWS_LIMIT_MAX_NUMBER);
        this.fItemLimitCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fItemLimitCheck.setSelection(this.fUsername != null && !this.fUsername.equals(REALM));
        this.fItemLimitCheck.setSelection(this.fItemLimit != -1);
        this.fItemLimitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditFeedComposite.this.fItemLimitSpinner.setEnabled(EditFeedComposite.this.fItemLimitCheck.getSelection());
            }
        });
        Label itemLimitLabel = new Label((Composite)limitGroup, 0);
        itemLimitLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        itemLimitLabel.setText(Messages.EditFeedComposite_MAX_NEWS_ITEMS);
        this.fItemLimitSpinner = new Spinner((Composite)limitGroup, 2048);
        this.fItemLimitSpinner.setMinimum(0);
        this.fItemLimitSpinner.setMaximum(9999);
        this.fItemLimitSpinner.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.fItemLimitSpinner.setSelection(this.fItemLimit);
        this.fItemLimitSpinner.setEnabled(this.fItemLimitCheck.getSelection());
        this.fAgeLimitCheck = new Button((Composite)limitGroup, 32);
        this.fAgeLimitCheck.setText(Messages.EditFeedComposite_NEWS_LIMIT_MAX_AGE);
        this.fAgeLimitCheck.setLayoutData((Object)new GridData(4, 1, true, false, 2, 1));
        this.fAgeLimitCheck.setSelection(this.fUsername != null && !this.fUsername.equals(REALM));
        this.fAgeLimitCheck.setSelection(this.fAgeLimit != -1L);
        this.fAgeLimitCheck.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditFeedComposite.this.fAgeLimitSpinner.setEnabled(EditFeedComposite.this.fAgeLimitCheck.getSelection());
            }
        });
        Label ageLimitLabel = new Label((Composite)limitGroup, 0);
        ageLimitLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        ageLimitLabel.setText(Messages.EditFeedComposite_DAYS_TO_KEEP_NEWS);
        this.fAgeLimitSpinner = new Spinner((Composite)limitGroup, 2048);
        this.fAgeLimitSpinner.setMinimum(0);
        this.fAgeLimitSpinner.setMaximum(9999);
        this.fAgeLimitSpinner.setLayoutData((Object)new GridData(1, 0x1000000, true, false));
        this.fAgeLimitSpinner.setSelection((int)this.fAgeLimit / 86400000);
        this.fAgeLimitSpinner.setEnabled(this.fAgeLimitCheck.getSelection());
        this.validate();
        Dialog.applyDialogFont((Control)composite);
        HelpContextIds.hookHelpListener((Control)composite, "com.ibm.team.feed.ui.feed_configuration_dialog");
        return composite;
    }

    private void validateAndSetUpdateInterval(int updateIntervalInSeconds) {
        if (updateIntervalInSeconds != 0 && updateIntervalInSeconds < this.getEffectiveMinimumPollInterval()) {
            if (updateIntervalInSeconds < MIN_POLL_INTERVAL) {
                this.fValidationListener.validationChanged(false, NLS.bind((String)Messages.EditFeedComposite_UPDATE_INTERVAL_WARNING, (Object)MIN_POLL_INTERVAL, (Object[])new Object[0]));
            } else if (updateIntervalInSeconds < this.fServerMinUpdateInterval) {
                this.fValidationListener.validationChanged(false, NLS.bind((String)Messages.EditFeedComposite_UPDATE_INTERVAL_WARNING_SERVER_MINIMUM, (Object)this.fServerMinUpdateInterval, (Object[])new Object[0]));
            } else {
                FeedUIPlugin.getDefault().log(String.format("Internal error: the update interval '%s' was expected to be less than '%s' and less than '%s'.", updateIntervalInSeconds, MIN_POLL_INTERVAL, this.fServerMinUpdateInterval), new Exception());
            }
        } else {
            this.fValidationListener.validationChanged(true, null);
            this.fUpdateIntervalInSeconds = updateIntervalInSeconds;
        }
    }

    protected void updateFields() {
        this.fUrl = this.fUrlInput.getText();
        if (this.fUrl != null) {
            this.fUrl = this.fUrl.trim();
        }
        this.fTitle = this.fTitleInput.getText();
        if (this.fTitle != null) {
            this.fTitle = this.fTitle.trim();
        }
        this.fItemLimit = this.fItemLimitCheck.getSelection() ? this.fItemLimitSpinner.getSelection() : -1;
        this.fAgeLimit = this.fAgeLimitCheck.getSelection() ? (long)this.fAgeLimitSpinner.getSelection() * 24L * 3600L * 1000L : -1L;
        this.fUsername = this.fUserInput.getText();
        this.fPassword = this.fPassInput.getText();
        this.fForceFeedDownload = this.fForceFeedDownloadInput.getSelection();
        this.fUpdateIntervalInSeconds = this.fUpdateSpinner.getSelection();
        this.fOverrideServerConfiguration = this.fOverrideServerConfigurationInput.getSelection();
    }

    private boolean validate() {
        this.updateFields();
        boolean abort = false;
        if (this.fUrl == null || this.fUrl.equals(REALM)) {
            this.fMessage = Messages.EditFeedComposite_URL_MISSING;
            abort = true;
        }
        if (this.channelExists(this.fUrl) && (this.isNew || !this.fUrl.equals(this.fChannel.getUrl()))) {
            this.fMessage = Messages.EditFeedComposite_FEED_ALREADY_EXISTS;
            abort = true;
        }
        try {
            new URL(this.fUrl);
        }
        catch (MalformedURLException e) {
            this.fMessage = Messages.EditFeedComposite_INVALID_URL;
            abort = true;
        }
        if (abort) {
            this.fUrlInput.setFocus();
            return false;
        }
        this.fMessage = null;
        return true;
    }

    public boolean isValid() {
        return this.fIsValid;
    }

    public int getColor() {
        return this.fColor;
    }

    public String getPassword() {
        return this.fPassword;
    }

    public String getTitle() {
        return this.fTitle;
    }

    public int getUpdateIntervalInSeconds() {
        if (!this.fUpdateCheck.getSelection()) {
            return 0;
        }
        return this.fUpdateIntervalInSeconds;
    }

    public String getUrl() {
        return this.fUrl;
    }

    public String getUsername() {
        return this.fUsername;
    }

    public boolean getForceFeedDownload() {
        return this.fForceFeedDownload;
    }

    public boolean getOverrideServerConfiguration() {
        return this.fOverrideServerConfiguration;
    }

    public void setOverrideServerConfiguration(boolean overrideServerConfiguration) {
        this.fOverrideServerConfiguration = overrideServerConfiguration;
    }

    public void setForceFeedDownload(boolean forceFeedDownload) {
        this.fForceFeedDownload = forceFeedDownload;
    }

    public void setColor(int color) {
        this.fColor = color;
    }

    public void setPassword(String password) {
        this.fPassword = password;
    }

    public void setTitle(String title) {
        this.fTitle = title == null || title.length() == 0 ? DEFAULT_TITLE : title;
    }

    public void setUpdateInterval(int updateInterval) {
        this.fUpdateIntervalInSeconds = updateInterval;
        if (this.fUpdateIntervalInSeconds < 0) {
            this.fUpdateIntervalInSeconds *= -1;
        } else if (this.fUpdateIntervalInSeconds > 0) {
            this.fUpdateIntervalInSeconds *= 60;
        }
    }

    public void setServerMinUpdateInterval(int serverMinUpdateInterval) {
        this.fServerMinUpdateInterval = serverMinUpdateInterval;
    }

    public void setUrl(String url) {
        this.fUrl = url;
    }

    public void setUsername(String username) {
        this.fUsername = username;
    }

    public long getAgeLimit() {
        return this.fAgeLimit;
    }

    public int getItemLimit() {
        return this.fItemLimit;
    }

    private Image createColorImage(RGB rgb) {
        Color borderColor = this.getShell().getDisplay().getSystemColor(16);
        Color color = new Color((Device)this.getShell().getDisplay(), rgb);
        RGB unused = new RGB(1, 1, 1);
        ImageData data = new ImageData(16, 16, 2, new PaletteData(new RGB[]{rgb, borderColor.getRGB(), unused, unused}));
        data.transparentPixel = 3;
        Arrays.fill(data.data, (byte)-1);
        Image image = new Image((Device)this.getShell().getDisplay(), data);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color);
        gc.setForeground(borderColor);
        gc.fillRectangle(3, 3, 10, 10);
        gc.drawRectangle(3, 3, 10, 10);
        gc.dispose();
        color.dispose();
        return image;
    }

    private Shell getShell() {
        return this.fShell;
    }

    private void updateCredentials(Channel channel, String username, String password) {
    }

    private void updateTitle(Channel channel) {
        String title = this.getTitle();
        if (title == null || title.length() == 0 || DEFAULT_TITLE.equals(title)) {
            title = Messages.EditFeedComposite_LOADING;
        }
        channel.setTitle(title.trim());
    }

    private boolean channelExists(String url) {
        Channel[] channels = FeedManager.getDefault().getChannels();
        int i = 0;
        while (i < channels.length) {
            if (channels[i].getUrl().equals(url)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void setAgeLimit(long ageLimit) {
        this.fAgeLimit = ageLimit;
    }

    public void setItemLimit(int itemLimit) {
        this.fItemLimit = itemLimit;
    }

    private static int getMinimumPollInterval() {
        String minPollInterval = Platform.getDebugOption((String)"com.ibm.team.feed.ui/feedMinPollInterval");
        if (minPollInterval != null) {
            try {
                return Integer.parseInt(minPollInterval);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 180;
    }

    private int getEffectiveMinimumPollInterval() {
        if (this.fOverrideServerConfiguration || this.fServerMinUpdateInterval < MIN_POLL_INTERVAL) {
            return MIN_POLL_INTERVAL;
        }
        return this.fServerMinUpdateInterval;
    }

    public static interface IValidationListener {
        public void validationChanged(boolean var1, String var2);
    }
}

