/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.ui.internal.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.graphics.RGB;

public class ColorDefinitions {
    public static final RGB fgMyColor = new RGB(0, 0, 128);
    public static final List<ColorDefinition> fgColors = new ArrayList<ColorDefinition>(15);

    static {
        fgColors.add(new ColorDefinition(new RGB(0, 0, 0), Messages.ColorDefinitions_BLACK));
        fgColors.add(new ColorDefinition(new RGB(145, 145, 145), Messages.ColorDefinitions_GRAY));
        fgColors.add(new ColorDefinition(new RGB(120, 106, 102), Messages.ColorDefinitions_WARM_GRAY));
        fgColors.add(new ColorDefinition(new RGB(69, 79, 95), Messages.ColorDefinitions_PANES_GRAY));
        fgColors.add(new ColorDefinition(new RGB(20, 70, 135), Messages.ColorDefinitions_NAVY_BLUE));
        fgColors.add(new ColorDefinition(new RGB(10, 100, 191), Messages.ColorDefinitions_BLUE));
        fgColors.add(new ColorDefinition(new RGB(16, 146, 158), Messages.ColorDefinitions_TEAL_GREEN));
        fgColors.add(new ColorDefinition(new RGB(0, 158, 98), Messages.ColorDefinitions_SEA_GREEN));
        fgColors.add(new ColorDefinition(new RGB(110, 153, 49), Messages.ColorDefinitions_GRASS_GREEN));
        fgColors.add(new ColorDefinition(new RGB(186, 145, 0), Messages.ColorDefinitions_OCHRE_GREEN));
        fgColors.add(new ColorDefinition(new RGB(218, 129, 3), Messages.ColorDefinitions_ORANGE));
        fgColors.add(new ColorDefinition(new RGB(225, 86, 19), Messages.ColorDefinitions_FIRE_ORANGE));
        fgColors.add(new ColorDefinition(new RGB(199, 80, 80), Messages.ColorDefinitions_SOFT_RED));
        fgColors.add(new ColorDefinition(new RGB(178, 50, 143), Messages.ColorDefinitions_VIOLET));
        fgColors.add(new ColorDefinition(new RGB(92, 50, 132), Messages.ColorDefinitions_INDIGO));
    }

    public static RGB convertToRGB(int value) {
        if (value < 0) {
            return new RGB((value *= -1) & 0xFF, value >> 8 & 0xFF, value >> 16 & 0xFF);
        }
        switch (value) {
            case 9: {
                return new RGB(0, 0, 255);
            }
            case 10: {
                return new RGB(0, 0, 128);
            }
            case 3: {
                return new RGB(255, 0, 0);
            }
            case 11: {
                return new RGB(255, 0, 255);
            }
            case 12: {
                return new RGB(128, 0, 128);
            }
            case 5: {
                return new RGB(0, 255, 0);
            }
            case 6: {
                return new RGB(0, 128, 0);
            }
            case 7: {
                return new RGB(255, 255, 0);
            }
            case 8: {
                return new RGB(128, 128, 0);
            }
            case 15: {
                return new RGB(192, 192, 192);
            }
            case 16: {
                return new RGB(128, 128, 128);
            }
        }
        return new RGB(0, 0, 0);
    }

    public static int convertToInt(RGB rgb) {
        return -(rgb.blue << 16 | rgb.green << 8 | rgb.red);
    }

    public static class ColorDefinition {
        private final RGB fRGB;
        private String fName;

        public ColorDefinition(int val) {
            this(ColorDefinitions.convertToRGB(val));
        }

        public ColorDefinition(RGB rgb) {
            this(rgb, null);
        }

        public ColorDefinition(RGB rgb, String name) {
            this.fRGB = rgb;
            this.fName = name;
        }

        public String getName() {
            return this.fName;
        }

        public RGB getRGB() {
            return this.fRGB;
        }

        public int toInt() {
            return ColorDefinitions.convertToInt(this.fRGB);
        }
    }
}

