/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.feed.ui.internal;

import com.ibm.team.feed.core.FeedManager;
import com.ibm.team.feed.core.model.Channel;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;

public class ChannelLabelDecorator
extends LabelProvider
implements ILightweightLabelDecorator {
    private static final String USER_PARAM = "user=";
    private static final int HOST = 0;
    private static final int USER = 1;
    private static final int COUNT = 2;

    public void decorate(Object element, IDecoration decoration) {
        if (element instanceof Channel) {
            String[] decorationslots = new String[3];
            Channel channel = (Channel)element;
            Channel[] channels = FeedManager.getDefault().getChannels();
            StringBuffer suffix = new StringBuffer();
            int count = 0;
            int idx = 0;
            boolean needIdx = false;
            try {
                URI channeluri = new URI(channel.getUrl());
                String query = channeluri.getQuery();
                Channel[] channelArray = channels;
                int n = channels.length;
                int n2 = 0;
                while (n2 < n) {
                    Channel other = channelArray[n2];
                    if (other == channel) {
                        idx = count;
                    } else if (other.getTitle().equals(String.valueOf(channel.getTitle()) + suffix.toString())) {
                        ++count;
                        URI otheruri = new URI(other.getUrl());
                        if (channeluri.getHost() != null && !channeluri.getHost().equals(otheruri.getHost())) {
                            if (decorationslots[0] == null) {
                                decorationslots[0] = channeluri.getHost();
                            }
                        } else if (query != null && otheruri.getQuery() != null) {
                            int channelUserIdx;
                            if (decorationslots[1] == null && (channelUserIdx = query.indexOf(USER_PARAM)) > -1) {
                                int endidx = query.indexOf("&", channelUserIdx + 1);
                                if (endidx == -1) {
                                    endidx = query.length();
                                }
                                decorationslots[1] = this.decode(query, channelUserIdx + USER_PARAM.length(), endidx);
                            }
                        } else {
                            needIdx = true;
                        }
                    }
                    ++n2;
                }
                if (needIdx) {
                    decorationslots[2] = String.valueOf(idx);
                }
                int i = 0;
                while (i < decorationslots.length) {
                    if (decorationslots[i] != null) {
                        suffix.append(" [").append(decorationslots[i]).append("]");
                    }
                    ++i;
                }
                decoration.addSuffix(suffix.toString());
            }
            catch (URISyntaxException uRISyntaxException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
    }

    private String decode(String query, int channelUserIdx, int endidx) throws UnsupportedEncodingException {
        String user = query.substring(channelUserIdx, endidx);
        return URLDecoder.decode(user, "UTF-8");
    }
}

