/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.wizards;

import com.ibm.team.enterprise.common.common.utils.StringMatcher;
import com.ibm.team.enterprise.common.ui.util.Utils;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionContext;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionLabelHelper;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.LanguageDefinitionSelectionDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.filesystem.client.FileSystemException;
import com.ibm.team.filesystem.client.IMetadataProperties;
import com.ibm.team.filesystem.client.IOperationFactory;
import com.ibm.team.filesystem.client.IShare;
import com.ibm.team.filesystem.client.IShareable;
import com.ibm.team.filesystem.client.ISharingDescriptor;
import com.ibm.team.filesystem.client.operations.ChangePropertiesDilemmaHandler;
import com.ibm.team.filesystem.client.operations.IChangePropertiesOperation;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.LayoutConstants;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;

public class AssignLanguageDefinitionWizard
extends Wizard {
    private static final int SIZING_TEXT_FIELD_WIDTH = 250;
    private LanguageDefinitionSelectionAndFilterPage fLanguageDefinitionPage;
    private SummaryPage fSummaryPage;
    private BrowsePage fBrowsePage;
    private IStructuredSelection fSelection;
    private List<IShareable> fFiles;
    private static final String PATTERN_DELIMITER = ",";
    private static final String DEFAULT_EXCLUDE_FILTERS = ".*,*.properties,*.xml";
    private List<StringMatcher> fFilters;

    public AssignLanguageDefinitionWizard(IWorkbench workbench) {
        this.setWindowTitle(Messages.AssignLanguageDefinitionWizard_TITLE);
        this.setNeedsProgressMonitor(true);
    }

    public void setSelection(IStructuredSelection selection) {
        this.fSelection = selection;
    }

    public void addPages() {
        this.fLanguageDefinitionPage = new LanguageDefinitionSelectionAndFilterPage();
        this.addPage((IWizardPage)this.fLanguageDefinitionPage);
        this.fBrowsePage = new BrowsePage();
        this.addPage((IWizardPage)this.fBrowsePage);
        this.fSummaryPage = new SummaryPage();
        this.addPage((IWizardPage)this.fSummaryPage);
    }

    public boolean performFinish() {
        block6: {
            if (!this.fLanguageDefinitionPage.fBrowseFilesButton.getSelection()) break block6;
            this.fFiles = this.fBrowsePage.gatherCheckedShareableFiles();
            this.updateLanguageDefinitionProperty();
            return true;
        }
        try {
            this.fFiles = this.extractSelectedShareableFiles((IProgressMonitor)new NullProgressMonitor());
            this.updateLanguageDefinitionProperty();
            return true;
        }
        catch (FileSystemException e) {
            ZDefUIPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (CoreException e) {
            ZDefUIPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (InvocationTargetException e) {
            ZDefUIPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        catch (InterruptedException e) {
            ZDefUIPlugin.log(e);
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
        }
        return false;
    }

    private void updateLanguageDefinitionProperty() throws InvocationTargetException, InterruptedException {
        this.getContainer().run(true, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor progress) throws InvocationTargetException, InterruptedException {
                for (IShareable shareable : AssignLanguageDefinitionWizard.this.fFiles) {
                    try {
                        IChangePropertiesOperation operation = IOperationFactory.instance.getChangePropertiesOperation(new ChangePropertiesDilemmaHandler());
                        IMetadataProperties metadataProperties = shareable.getMetadataProperties(progress);
                        Map currentProperties = metadataProperties.getCurrentProperties();
                        HashMap<String, String> newProperties = new HashMap<String, String>();
                        newProperties.putAll(currentProperties);
                        newProperties.put("team.enterprise.language.definition", ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fLanguageDefinitionUUID);
                        operation.setProperties(shareable, newProperties);
                        operation.run(progress);
                    }
                    catch (FileSystemException e) {
                        e.printStackTrace();
                    }
                    catch (TeamRepositoryException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }

    private List<IShareable> extractSelectedShareableFiles(IProgressMonitor monitor) throws FileSystemException, CoreException {
        ArrayList<IShareable> shared = new ArrayList<IShareable>(this.fSelection.size());
        String patternString = null;
        if (!this.fLanguageDefinitionPage.fApplyAllButton.getSelection()) {
            patternString = this.fLanguageDefinitionPage.fIncludeFilterButton.getSelection() ? this.fLanguageDefinitionPage.fIncludeFilterField.getText() : this.fLanguageDefinitionPage.fExcludeFilterField.getText();
        }
        if (patternString != null) {
            StringTokenizer t = new StringTokenizer(patternString, PATTERN_DELIMITER);
            this.fFilters = new ArrayList<StringMatcher>();
            while (t.hasMoreElements()) {
                this.fFilters.add(new StringMatcher(t.nextToken(), true, false));
            }
        }
        List selList = this.fSelection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            this.extractShareableFilesFromResource((IResource)obj, shared, progress);
        }
        return shared;
    }

    private List<IProject> extractSelectedShareableProjects(IProgressMonitor monitor) throws FileSystemException, CoreException {
        ArrayList<IProject> selectedSharedProjects = new ArrayList<IProject>(this.fSelection.size());
        List selList = this.fSelection.toList();
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor, (int)selList.size());
        for (Object obj : selList) {
            this.extractShareableProjectsFromResource((IResource)obj, selectedSharedProjects, progress);
        }
        return selectedSharedProjects;
    }

    private void extractShareableFilesFromResource(IResource resource, List<IShareable> shared, SubMonitor progress) throws FileSystemException, CoreException {
        IMetadataProperties metadataProperties;
        String langDefUUID;
        IResource child;
        IShareable shareable = null;
        if (resource instanceof IFile) {
            String fileName;
            IFile file = (IFile)resource;
            if (this.fLanguageDefinitionPage.fApplyAllButton.getSelection()) {
                shareable = (IShareable)resource.getAdapter(IShareable.class);
            } else if (this.fLanguageDefinitionPage.fIncludeFilterButton.getSelection()) {
                fileName = file.getName();
                if (this.isFiltered(fileName)) {
                    shareable = (IShareable)resource.getAdapter(IShareable.class);
                }
            } else if (this.fLanguageDefinitionPage.fExcludeFilterButton.getSelection() && !this.isFiltered(fileName = file.getName())) {
                shareable = (IShareable)resource.getAdapter(IShareable.class);
            }
        } else if (resource instanceof IFolder) {
            IFolder folder = (IFolder)resource;
            IResource[] iResourceArray = folder.members();
            int n = iResourceArray.length;
            int n2 = 0;
            while (n2 < n) {
                child = iResourceArray[n2];
                this.extractShareableFilesFromResource(child, shared, progress);
                ++n2;
            }
        } else if (resource instanceof IProject) {
            IProject project = (IProject)resource;
            IResource[] iResourceArray = project.members();
            int n = iResourceArray.length;
            int n3 = 0;
            while (n3 < n) {
                child = iResourceArray[n3];
                this.extractShareableFilesFromResource(child, shared, progress);
                ++n3;
            }
        }
        if (shareable == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) {
            return;
        }
        if (!com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.Utils.isZFile(resource)) {
            return;
        }
        if (this.fLanguageDefinitionPage.fExcludeAssignedButton.getSelection() && (langDefUUID = (String)(metadataProperties = shareable.getMetadataProperties(null)).getCurrentProperties().get("team.enterprise.language.definition")) != null && !langDefUUID.trim().equals("")) {
            return;
        }
        if (!shared.contains(shareable)) {
            shared.add(shareable);
        }
    }

    private void extractShareableProjectsFromResource(IResource resource, List<IProject> sharedProjects, SubMonitor progress) throws FileSystemException, CoreException {
        IShareable shareable = null;
        IProject project = resource.getProject();
        shareable = (IShareable)project.getAdapter(IShareable.class);
        if (shareable == null || shareable.getShare((IProgressMonitor)progress.newChild(1)) == null) {
            return;
        }
        if (!sharedProjects.contains(project)) {
            sharedProjects.add(project);
        }
    }

    private boolean isFiltered(String fileName) {
        for (StringMatcher filter : this.fFilters) {
            if (!filter.match(fileName)) continue;
            return true;
        }
        return false;
    }

    private class BrowsePage
    extends WizardPage
    implements ICheckStateListener {
        private CheckboxTreeViewer fBrowseTreeViewer;
        private BrowseTreeContentProvider fContentProvider;
        private String fLanguageDefinitionName;

        protected BrowsePage() {
            super(Messages.AssignLanguageDefinitionWizard_BrowsePage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_BrowsePage_TITLE);
            this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_BrowsePage_DESCRIPTION, (Object)""));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.wizard_assignld_selectfiles");
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(768));
            ((GridData)label.getLayoutData()).horizontalSpan = 2;
            label.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_Table_Description);
            this.fBrowseTreeViewer = new CheckboxTreeViewer(composite, 2048);
            this.fBrowseTreeViewer.setLabelProvider((IBaseLabelProvider)new LanguageDefinitionLabelProvider(AssignLanguageDefinitionWizard.this){

                @Override
                LanguageDefinitionLabelHelper getLabelHelper(final Object element) {
                    return new LanguageDefinitionLabelHelper(){

                        public void labelAvailable(String label, String langDefUUID) {
                            if (!BrowsePage.this.fBrowseTreeViewer.getTree().isDisposed()) {
                                fUUIDToLabelMap.put(langDefUUID, label);
                                BrowsePage.this.fBrowseTreeViewer.refresh(element);
                            }
                        }
                    };
                }
            });
            this.fContentProvider = new BrowseTreeContentProvider();
            this.fBrowseTreeViewer.setContentProvider((IContentProvider)this.fContentProvider);
            this.fBrowseTreeViewer.setFilters(new ViewerFilter[]{new ViewerFilter(){

                public boolean select(Viewer viewer, Object parentElement, Object element) {
                    try {
                        return com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.Utils.isZFileOrZFileContainer(element);
                    }
                    catch (CoreException e) {
                        return true;
                    }
                }
            }});
            this.fBrowseTreeViewer.addCheckStateListener((ICheckStateListener)this);
            int NUM_COLUMNS = 2;
            GridDataFactory.fillDefaults().grab(true, true).hint(150, 150).applyTo((Control)this.fBrowseTreeViewer.getTree());
            Composite buttons = this.createButtonComposite(composite);
            GridLayoutFactory.fillDefaults().generateLayout(buttons);
            GridLayoutFactory.fillDefaults().numColumns(2).generateLayout(composite);
            this.setControl((Control)composite);
        }

        private Composite createButtonComposite(Composite composite) {
            Composite buttons = new Composite(composite, 0);
            Button selectAllButton = new Button(buttons, 8);
            selectAllButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_SelectAllLabel);
            selectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    Object[] elements;
                    BrowsePage.this.fBrowseTreeViewer.setGrayedElements(new Object[0]);
                    Object[] objectArray = elements = BrowsePage.this.fContentProvider.getElements("root");
                    int n = elements.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object element = objectArray[n2];
                        BrowsePage.this.fBrowseTreeViewer.setSubtreeChecked(element, true);
                        ++n2;
                    }
                    BrowsePage.this.setPageComplete(true);
                }
            });
            Button deselectAllButton = new Button(buttons, 8);
            deselectAllButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_DeselectAllLabel);
            deselectAllButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BrowsePage.this.fBrowseTreeViewer.setGrayedElements(new Object[0]);
                    BrowsePage.this.fBrowseTreeViewer.setCheckedElements(new Object[0]);
                    BrowsePage.this.setPageComplete(false);
                }
            });
            new Label(buttons, 0);
            Button selectAllUnassignedButton = new Button(buttons, 8);
            selectAllUnassignedButton.setText(Messages.AssignLanguageDefinitionWizard_BrowsePage_SelectAllUnassigned);
            selectAllUnassignedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        BrowsePage.this.checkAllUnassignedElements();
                    }
                    catch (Exception e1) {
                        ZDefUIPlugin.log(e1);
                        MessageDialog.openError((Shell)BrowsePage.this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                    }
                }
            });
            return buttons;
        }

        protected void checkAllUnassignedElements() throws Exception {
            Object[] elements;
            Object[] objectArray = elements = this.fContentProvider.getElements("root");
            int n = elements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                this.checkUnassigned(element);
                ++n2;
            }
        }

        private void checkUnassigned(Object element) throws Exception {
            if (element instanceof IFile) {
                IShareable shareable = (IShareable)((IFile)element).getAdapter(IShareable.class);
                IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
                if (langDefUUID == null || langDefUUID.trim().equals("")) {
                    this.fBrowseTreeViewer.setChecked(element, true);
                    this.updateCheckedState(element, true);
                }
            } else {
                IResource[] iResourceArray = ((IContainer)element).members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource member = iResourceArray[n2];
                    this.checkUnassigned(member);
                    ++n2;
                }
            }
        }

        public void updateProjectSelection(final List<IProject> projects, final String langDefLabel) {
            this.fLanguageDefinitionName = langDefLabel;
            if (this.fBrowseTreeViewer.getInput() == null) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        BrowsePage.this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_BrowsePage_DESCRIPTION, (Object)langDefLabel));
                        BrowsePage.this.fContentProvider.setRootProjects(projects);
                        BrowsePage.this.fBrowseTreeViewer.setInput((Object)"root");
                    }
                });
            }
            this.setPageComplete(this.fBrowseTreeViewer.getCheckedElements().length > 0);
        }

        public void checkStateChanged(CheckStateChangedEvent event) {
            boolean isChecked = event.getChecked();
            Object element = event.getElement();
            this.updateCheckedState(element, isChecked);
        }

        private void updateCheckedState(Object element, boolean isChecked) {
            this.updateElementAndChildren(element, isChecked);
            this.updateAncestors(((IResource)element).getParent(), isChecked, false);
            int count = this.fBrowseTreeViewer.getCheckedElements().length;
            this.setPageComplete(count > 0);
        }

        private void updateElementAndChildren(Object element, boolean check) {
            this.fBrowseTreeViewer.setGrayed(element, false);
            this.fBrowseTreeViewer.setChecked(element, check);
            Object[] objectArray = ((BrowseTreeContentProvider)this.fBrowseTreeViewer.getContentProvider()).getChildren(element);
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object child = objectArray[n2];
                this.updateElementAndChildren(child, check);
                ++n2;
            }
        }

        private void updateAncestors(Object element, boolean check, boolean gray) {
            if (element == null) {
                return;
            }
            if (gray) {
                check = true;
            } else {
                Object[] objectArray = ((BrowseTreeContentProvider)this.fBrowseTreeViewer.getContentProvider()).getChildren(element);
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object child = objectArray[n2];
                    if (this.fBrowseTreeViewer.getGrayed(child) || check != this.fBrowseTreeViewer.getChecked(child)) {
                        check = true;
                        gray = true;
                        break;
                    }
                    ++n2;
                }
            }
            this.fBrowseTreeViewer.setChecked(element, check);
            this.fBrowseTreeViewer.setGrayed(element, gray);
            this.updateAncestors(((IResource)element).getParent(), check, gray);
        }

        public IWizardPage getNextPage() {
            AssignLanguageDefinitionWizard.this.fSummaryPage.updateSummary(this.gatherCheckedShareableFiles(), this.fLanguageDefinitionName);
            return AssignLanguageDefinitionWizard.this.fSummaryPage;
        }

        private List<IShareable> gatherCheckedShareableFiles() {
            Object[] checkedElements;
            ArrayList<IShareable> files = new ArrayList<IShareable>();
            Object[] objectArray = checkedElements = this.fBrowseTreeViewer.getCheckedElements();
            int n = checkedElements.length;
            int n2 = 0;
            while (n2 < n) {
                Object element = objectArray[n2];
                if (element instanceof IFile) {
                    files.add((IShareable)((IFile)element).getAdapter(IShareable.class));
                }
                ++n2;
            }
            return files;
        }

        class BrowseTreeContentProvider
        implements ITreeContentProvider {
            private List<IProject> fRootProjects;

            BrowseTreeContentProvider() {
            }

            public void setRootProjects(List<IProject> rootProjects) {
                this.fRootProjects = rootProjects;
            }

            public Object[] getChildren(Object element) {
                if (element instanceof IFile) {
                    return new Object[0];
                }
                if (element instanceof IContainer) {
                    try {
                        return ((IContainer)element).members();
                    }
                    catch (CoreException e) {
                        ZDefUIPlugin.log(e);
                        MessageDialog.openError((Shell)BrowsePage.this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                    }
                }
                return null;
            }

            public Object getParent(Object element) {
                return ((IResource)element).getParent();
            }

            public boolean hasChildren(Object element) {
                return !(element instanceof IFile);
            }

            public Object[] getElements(Object element) {
                if (this.fRootProjects != null) {
                    return this.fRootProjects.toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer arg0, Object arg1, Object arg2) {
            }
        }
    }

    class LanguageDefinitionLabelProvider
    extends LabelProvider {
        protected Map<String, String> fUUIDToLabelMap = new HashMap<String, String>();
        private Image fProjectImage;
        private Image fFolderImage;
        private Image fFileImage;

        LanguageDefinitionLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IShareable) {
                IShareable shareable = (IShareable)element;
                try {
                    IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                    final String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
                    if (langDefUUID == null || langDefUUID.trim().equals("")) {
                        return shareable.getLocalPath().toString();
                    }
                    if (this.fUUIDToLabelMap.containsKey(langDefUUID)) {
                        return String.valueOf(shareable.getLocalPath().toString()) + " (" + this.fUUIDToLabelMap.get(langDefUUID) + ")";
                    }
                    LanguageDefinitionLabelHelper labelHelper = this.getLabelHelper(element);
                    IShare share = shareable.getShare(null);
                    final ISharingDescriptor desc = share.getSharingDescriptor();
                    ISystemDefinitionContext context = new ISystemDefinitionContext(){

                        public ITeamRepository getTeamRepository() {
                            return Utils.getTeamRepository((ISharingDescriptor)desc);
                        }

                        public IProjectAreaHandle getProjectArea() {
                            return null;
                        }

                        public String getSystemDefinitionUUID() {
                            return langDefUUID;
                        }
                    };
                    labelHelper.getLanguageDefinitionLabelInBackground(context);
                    return String.valueOf(shareable.getLocalPath().toString()) + " (" + Messages.AssignLanguageDefinitionWizard_BrowsePage_PENDING + ")";
                }
                catch (FileSystemException e) {
                    return ((IFile)element).getName();
                }
            }
            if (element instanceof IFile) {
                IShareable shareable = (IShareable)((IFile)element).getAdapter(IShareable.class);
                try {
                    IMetadataProperties metadataProperties = shareable.getMetadataProperties(null);
                    final String langDefUUID = (String)metadataProperties.getCurrentProperties().get("team.enterprise.language.definition");
                    if (langDefUUID == null || langDefUUID.trim().equals("")) {
                        return ((IFile)element).getName();
                    }
                    if (this.fUUIDToLabelMap.containsKey(langDefUUID)) {
                        return String.valueOf(((IFile)element).getName()) + " (" + this.fUUIDToLabelMap.get(langDefUUID) + ")";
                    }
                    LanguageDefinitionLabelHelper labelHelper = this.getLabelHelper(element);
                    IShare share = shareable.getShare(null);
                    final ISharingDescriptor desc = share.getSharingDescriptor();
                    ISystemDefinitionContext context = new ISystemDefinitionContext(){

                        public ITeamRepository getTeamRepository() {
                            return Utils.getTeamRepository((ISharingDescriptor)desc);
                        }

                        public IProjectAreaHandle getProjectArea() {
                            return null;
                        }

                        public String getSystemDefinitionUUID() {
                            return langDefUUID;
                        }
                    };
                    labelHelper.getLanguageDefinitionLabelInBackground(context);
                    return String.valueOf(((IFile)element).getName()) + " (" + Messages.AssignLanguageDefinitionWizard_BrowsePage_PENDING + ")";
                }
                catch (FileSystemException e) {
                    return ((IFile)element).getName();
                }
            }
            if (element instanceof IResource) {
                return ((IResource)element).getName();
            }
            return element.toString();
        }

        public Image getImage(Object element) {
            if (element instanceof IFile) {
                if (this.fFileImage == null) {
                    this.fFileImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FILE");
                }
                return this.fFileImage;
            }
            if (element instanceof IFolder) {
                if (this.fFolderImage == null) {
                    this.fFolderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }
                return this.fFolderImage;
            }
            if (element instanceof IProject) {
                if (this.fProjectImage == null) {
                    this.fProjectImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_PROJECT");
                }
                return this.fProjectImage;
            }
            return null;
        }

        LanguageDefinitionLabelHelper getLabelHelper(Object element) {
            return null;
        }
    }

    private class LanguageDefinitionSelectionAndFilterPage
    extends WizardPage {
        Text fLanguageDefinitionField;
        String fLanguageDefinitionUUID;
        Button fApplyAllButton;
        Button fIncludeFilterButton;
        Button fExcludeFilterButton;
        Button fBrowseFilesButton;
        Text fIncludeFilterField;
        Text fExcludeFilterField;
        Button fExcludeAssignedButton;
        Button fExcludeHiddenButton;

        protected LanguageDefinitionSelectionAndFilterPage() {
            super(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_TITLE);
            this.setDescription(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_DESCRIPTION);
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            this.initializeDialogUnits((Control)parent);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.wizard_assignld_selectld");
            composite.setLayout((Layout)new GridLayout());
            composite.setLayoutData((Object)new GridData(1808));
            Composite subGroup = new Composite(composite, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 3;
            subGroup.setLayout((Layout)layout);
            subGroup.setLayoutData((Object)new GridData(768));
            this.createLanguageDefinitionGroup(subGroup);
            this.createFilterGroup(subGroup);
            this.createExcludeAlreadyAssignedGroup(subGroup);
            this.setPageComplete(this.validate());
            this.setControl((Control)composite);
        }

        private final void createLanguageDefinitionGroup(Composite subGroup) {
            Label label = new Label(subGroup, 0);
            label.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_LANGUAGE_DEFINITION_LABEL);
            this.fLanguageDefinitionField = new Text(subGroup, 2048);
            GridData data = new GridData(768);
            data.widthHint = 250;
            this.fLanguageDefinitionField.setLayoutData((Object)data);
            this.fLanguageDefinitionField.setFont(subGroup.getFont());
            this.fLanguageDefinitionField.setEditable(false);
            Button button = new Button(subGroup, 0);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    try {
                        ISystemDefinition langDef;
                        IResource resource = (IResource)AssignLanguageDefinitionWizard.this.fSelection.getFirstElement();
                        IShareable shareable = (IShareable)resource.getAdapter(IShareable.class);
                        IShare share = shareable.getShare(null);
                        ISharingDescriptor desc = share.getSharingDescriptor();
                        ITeamRepository repository = Utils.getTeamRepository((ISharingDescriptor)desc);
                        LanguageDefinitionSelectionDialog dialog = new LanguageDefinitionSelectionDialog(LanguageDefinitionSelectionAndFilterPage.this.getShell(), repository, null, IZosLanguageDefinition.ITEM_TYPE);
                        if (dialog.open() == 0 && (langDef = dialog.getSelectedSystemDefinition()) != null) {
                            LanguageDefinitionSelectionAndFilterPage.this.fLanguageDefinitionUUID = langDef.getItemId().getUuidValue();
                            LanguageDefinitionSelectionAndFilterPage.this.fLanguageDefinitionField.setText(langDef.getName());
                            AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                            LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                        }
                    }
                    catch (TeamRepositoryException exception) {
                        exception.printStackTrace();
                    }
                }
            });
            button.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_BROWSE_LABEL);
        }

        private final void createExcludeAlreadyAssignedGroup(Composite subGroup) {
            this.fExcludeAssignedButton = new Button(subGroup, 32);
            this.fExcludeAssignedButton.setSelection(true);
            this.fExcludeAssignedButton.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_ASSIGNED_LABEL);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.fExcludeAssignedButton.setLayoutData((Object)data);
        }

        private final void createExcludeHiddenGroup(Composite subGroup) {
            this.fExcludeHiddenButton = new Button(subGroup, 32);
            this.fExcludeHiddenButton.setSelection(true);
            this.fExcludeHiddenButton.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_HIDDEN_LABEL);
            GridData data = new GridData(768);
            data.horizontalSpan = 3;
            this.fExcludeHiddenButton.setLayoutData((Object)data);
        }

        private final void createFilterGroup(Composite subGroup) {
            Label label = new Label(subGroup, 64);
            label.setText("");
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            label.setLayoutData((Object)gridData);
            Group applyGroup = new Group(subGroup, 0);
            GridDataFactory.fillDefaults().grab(true, false).span(3, 1).applyTo((Control)applyGroup);
            applyGroup.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_FILTER_GROUP_LABEL);
            this.fApplyAllButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_APPLY_ALL_LABEL, 16400);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fApplyAllButton.setLayoutData((Object)gridData);
            this.fIncludeFilterButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_INCLUDE_FILTER_LABEL, 16400);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fIncludeFilterButton.setLayoutData((Object)gridData);
            this.fIncludeFilterField = new Text((Composite)applyGroup, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fIncludeFilterField.setLayoutData((Object)gridData);
            this.fIncludeFilterField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                    LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.fIncludeFilterField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_INCLUDE_FILTER_LABEL;
                }
            });
            Text text = new Text((Composite)applyGroup, 72);
            text.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_PATTERN_LABEL);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
            this.fExcludeFilterButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_FILTER_LABEL, 16400);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fExcludeFilterButton.setLayoutData((Object)gridData);
            this.fExcludeFilterField = new Text((Composite)applyGroup, 2052);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fExcludeFilterField.setLayoutData((Object)gridData);
            this.fExcludeFilterField.setText(AssignLanguageDefinitionWizard.DEFAULT_EXCLUDE_FILTERS);
            this.fExcludeFilterField.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(LanguageDefinitionSelectionAndFilterPage.this.validate());
                    LanguageDefinitionSelectionAndFilterPage.this.getWizard().getContainer().updateButtons();
                }
            });
            this.fExcludeFilterField.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

                public void getName(AccessibleEvent e) {
                    e.result = Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_EXCLUDE_FILTER_LABEL;
                }
            });
            text = new Text((Composite)applyGroup, 72);
            text.setText(Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_PATTERN_LABEL);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            text.setLayoutData((Object)gridData);
            this.fBrowseFilesButton = this.createRadioButton((Composite)applyGroup, Messages.AssignLanguageDefinitionWizard_LanguageDefinitionSelectionAndFilterPage_BROWSE_FILES_LABEL, 16400);
            gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.fBrowseFilesButton.setLayoutData((Object)gridData);
            this.fApplyAllButton.setSelection(true);
            this.handleRadioUpdate(false);
            GridLayoutFactory.fillDefaults().numColumns(3).margins(LayoutConstants.getMargins()).generateLayout((Composite)applyGroup);
        }

        private Button createRadioButton(Composite parent, String label, int style) {
            Button radioButton = new Button(parent, style);
            radioButton.setText(label);
            radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    LanguageDefinitionSelectionAndFilterPage.this.handleRadioUpdate(true);
                }
            });
            return radioButton;
        }

        private void handleRadioUpdate(boolean wizardInitialized) {
            this.fIncludeFilterField.setEnabled(this.fIncludeFilterButton.getSelection());
            this.fExcludeFilterField.setEnabled(this.fExcludeFilterButton.getSelection());
            AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage.setPageComplete(this.validate());
            if (wizardInitialized) {
                this.getWizard().getContainer().updateButtons();
                if (this.fBrowseFilesButton.getSelection()) {
                    this.fExcludeAssignedButton.setSelection(false);
                    this.fExcludeAssignedButton.setEnabled(false);
                } else {
                    this.fExcludeAssignedButton.setEnabled(true);
                }
            }
        }

        private boolean validate() {
            if (AssignLanguageDefinitionWizard.this.fLanguageDefinitionPage != null) {
                if (((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fLanguageDefinitionField.getText().equals("")) {
                    return false;
                }
                if (((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fIncludeFilterButton.getSelection() && ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fIncludeFilterField.getText().equals("")) {
                    return false;
                }
                if (((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fExcludeFilterButton.getSelection() && ((AssignLanguageDefinitionWizard)AssignLanguageDefinitionWizard.this).fLanguageDefinitionPage.fExcludeFilterField.getText().equals("")) {
                    return false;
                }
            }
            return true;
        }

        public IWizardPage getNextPage() {
            if (this.fBrowseFilesButton.getSelection()) {
                try {
                    AssignLanguageDefinitionWizard.this.fBrowsePage.updateProjectSelection(AssignLanguageDefinitionWizard.this.extractSelectedShareableProjects((IProgressMonitor)new NullProgressMonitor()), this.fLanguageDefinitionField.getText());
                }
                catch (FileSystemException e) {
                    ZDefUIPlugin.log(e);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                }
                catch (CoreException e) {
                    ZDefUIPlugin.log(e);
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
                }
                return AssignLanguageDefinitionWizard.this.fBrowsePage;
            }
            try {
                AssignLanguageDefinitionWizard.this.fSummaryPage.updateSummary(AssignLanguageDefinitionWizard.this.extractSelectedShareableFiles((IProgressMonitor)new NullProgressMonitor()), this.fLanguageDefinitionField.getText());
                AssignLanguageDefinitionWizard.this.fBrowsePage.setPageComplete(true);
            }
            catch (FileSystemException e) {
                ZDefUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
            }
            catch (CoreException e) {
                ZDefUIPlugin.log(e);
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredTitle, (String)Messages.AssignLanguageDefinitionWizard_ProblemOccurredDescription);
            }
            return AssignLanguageDefinitionWizard.this.fSummaryPage;
        }
    }

    private class SummaryPage
    extends WizardPage {
        private Table matchBox;
        private TableViewer fSummaryTableViewer;

        protected SummaryPage() {
            super(Messages.AssignLanguageDefinitionWizard_SummaryPage_PAGETITLE);
            this.setTitle(Messages.AssignLanguageDefinitionWizard_SummaryPage_TITLE);
            this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_SummaryPage_DESCRIPTION, (Object)""));
        }

        public void createControl(Composite parent) {
            Composite composite = new Composite(parent, 0);
            composite.setFont(parent.getFont());
            PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "com.ibm.team.build.ui.wizard_assignld_summary");
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            composite.setLayout((Layout)layout);
            composite.setLayoutData((Object)new GridData(4, 4, true, true));
            Label label = new Label(composite, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setText(Messages.AssignLanguageDefinitionWizard_SummaryPage_Table_Description);
            this.matchBox = new Table(composite, 2048);
            GridData data = new GridData(1808);
            data.heightHint = 50;
            data.horizontalSpan = 1;
            this.matchBox.setLayoutData((Object)data);
            this.fSummaryTableViewer = new TableViewer(this.matchBox);
            this.fSummaryTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
            this.fSummaryTableViewer.setLabelProvider((IBaseLabelProvider)new LanguageDefinitionLabelProvider(AssignLanguageDefinitionWizard.this){

                @Override
                LanguageDefinitionLabelHelper getLabelHelper(final Object element) {
                    return new LanguageDefinitionLabelHelper(){

                        public void labelAvailable(String label, String langDefUUID) {
                            if (!SummaryPage.this.fSummaryTableViewer.getTable().isDisposed()) {
                                fUUIDToLabelMap.put(langDefUUID, label);
                                SummaryPage.this.fSummaryTableViewer.refresh(element);
                            }
                        }
                    };
                }
            });
            this.setPageComplete(true);
            this.setControl((Control)composite);
        }

        public void updateSummary(final List<IShareable> files, final String langDefLabel) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    SummaryPage.this.setDescription(NLS.bind((String)Messages.AssignLanguageDefinitionWizard_SummaryPage_DESCRIPTION, (Object)langDefLabel));
                    SummaryPage.this.matchBox.removeAll();
                    if (files.size() == 0) {
                        TableItem tableItem = new TableItem(SummaryPage.this.matchBox, 0);
                        tableItem.setText(Messages.AssignLanguageDefinitionWizard_SummaryPage_NO_MATCHES);
                    } else {
                        SummaryPage.this.fSummaryTableViewer.setInput((Object)files);
                    }
                }
            });
        }

        class ListContentProvider
        implements IStructuredContentProvider {
            ListContentProvider() {
            }

            public Object[] getElements(Object inputElement) {
                if (inputElement instanceof List) {
                    return ((List)inputElement).toArray();
                }
                return null;
            }

            public void dispose() {
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }
        }
    }
}

