/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils;

import com.ibm.team.enterprise.common.common.ZComponentNature;
import com.ibm.team.enterprise.common.common.ZHfsComponentNature;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.DDConflict;
import com.ibm.team.jface.util.UIUpdaterJob;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class Utils {
    static {
        new Utils();
    }

    private Utils() {
    }

    public static boolean isSmpeEnabled(ITeamRepository teamRepository) {
        ComputeSmpeEnabled job = new ComputeSmpeEnabled(teamRepository);
        job.schedule();
        try {
            job.join();
            return job.getIsSmpeEnabled();
        }
        catch (InterruptedException e) {
            return false;
        }
    }

    public static boolean isZComponentProject(Object element) throws CoreException {
        return element != null && element instanceof IProject && ((IProject)element).hasNature(ZComponentNature.ID);
    }

    public static boolean isZHfsComponentProject(Object element) throws CoreException {
        return element != null && element instanceof IProject && ((IProject)element).hasNature(ZHfsComponentNature.ID);
    }

    public static boolean isZFile(Object element) throws CoreException {
        return element != null && element instanceof IFile && Utils.isZFolder(((IFile)element).getParent());
    }

    public static boolean isZFolder(Object element) throws CoreException {
        return element != null && element instanceof IFolder && Utils.isZSourceFolder(((IFolder)element).getParent());
    }

    public static boolean isZSourceFolder(Object element) throws CoreException {
        IFolder folder;
        boolean flag = false;
        if (element != null && element instanceof IFolder && (folder = (IFolder)element).getParent() == folder.getProject() && Utils.isZComponentProject(folder.getProject()) && folder.getName().equals("zOSsrc")) {
            flag = true;
        }
        return flag;
    }

    public static boolean isZProjectResource(Object element) throws CoreException {
        if (element instanceof IProject) {
            return Utils.isZComponentProject(element);
        }
        if (element instanceof IResource) {
            return Utils.isZComponentProject(((IResource)element).getProject());
        }
        return false;
    }

    public static boolean isZFileOrZFileContainer(Object element) throws CoreException {
        return Utils.isZFile(element) || Utils.isZFolder(element) || Utils.isZComponentProject(element) || Utils.isZSourceFolder(element);
    }

    public static DDConflict validateConcats(List<IConcatenation> dds) {
        if (dds == null || dds.isEmpty()) {
            return new DDConflict();
        }
        HashMap<IConcatenation, String> ddMap = new HashMap<IConcatenation, String>(dds.size());
        for (IConcatenation dd : dds) {
            ddMap.put(dd, dd.getName());
        }
        for (IConcatenation dd : ddMap.keySet()) {
            HashMap copyMap = new HashMap(ddMap);
            copyMap.remove(dd);
            if (!copyMap.containsValue(dd.getName())) continue;
            if (dd.getCondition() == null || dd.getCondition().isEmpty()) {
                return new DDConflict(false, dd.getName());
            }
            for (IConcatenation copyDd : copyMap.keySet()) {
                if (!dd.getName().equals(copyDd.getName()) || copyDd.getCondition() != null && !copyDd.getCondition().isEmpty()) continue;
                return new DDConflict(false, dd.getName());
            }
        }
        return new DDConflict();
    }

    public static DDConflict validateDDNames(List<IDDAllocation> dds) {
        if (dds == null || dds.isEmpty()) {
            return new DDConflict();
        }
        HashMap<IDDAllocation, String> ddMap = new HashMap<IDDAllocation, String>(dds.size());
        for (IDDAllocation dd : dds) {
            ddMap.put(dd, dd.getName());
        }
        for (IDDAllocation dd : ddMap.keySet()) {
            HashMap copyMap = new HashMap(ddMap);
            copyMap.remove(dd);
            if (!copyMap.containsValue(dd.getName())) continue;
            if (dd.getCondition() == null || dd.getCondition().isEmpty()) {
                return new DDConflict(false, dd.getName());
            }
            for (IDDAllocation copyDd : copyMap.keySet()) {
                if (!dd.getName().equals(copyDd.getName()) || copyDd.getCondition() != null && !copyDd.getCondition().isEmpty()) continue;
                return new DDConflict(false, dd.getName());
            }
        }
        return new DDConflict();
    }

    private static class ComputeSmpeEnabled
    extends UIUpdaterJob {
        private boolean isEnabled;
        private final ITeamRepository teamRepository;

        public ComputeSmpeEnabled(ITeamRepository teamRepository) {
            super("");
            this.teamRepository = teamRepository;
        }

        public IStatus runInBackground(IProgressMonitor monitor) {
            try {
                this.isEnabled = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.teamRepository).isSMPEEnabled(null);
            }
            catch (TeamRepositoryException e) {
                this.isEnabled = false;
            }
            return Status.OK_STATUS;
        }

        public boolean getIsSmpeEnabled() {
            return this.isEnabled;
        }
    }
}

