/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.langdef.LanguageDefinitionsNodeEE;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.langdef.TranslatorsNodeEE;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractLanguageDefinitionItemEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractSystemDefinitionEditorZos;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.GeneralTranslatorEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.TranslatorEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.internal.impl.ZosTranslator;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class TranslatorEditor
extends AbstractSystemDefinitionEditorZos {
    private ScrolledForm fForm;
    private TranslatorEditorInput fEditorInput;
    private GeneralTranslatorEditorPage genPage;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (TranslatorEditorInput)input;
        this.fTeamRepository = this.fEditorInput.getTeamRepository();
        this.fIsNewSystemDefinition = this.fEditorInput.isNewSystemDefinition();
        this.fSystemDefinition = (ISystemDefinition)this.fEditorInput.getSystemDefinition().getWorkingCopy();
        this.configuration = this.getConfiguration();
    }

    protected Image getHeaderTitleImage() {
        if (this.fSystemDefinition.isArchived()) {
            return ZDefUIPlugin.getImage("icons/obj16/translator_arch_obj.gif");
        }
        return ZDefUIPlugin.getImage("icons/obj16/translator_obj.gif");
    }

    protected String getHeaderTitleText() {
        return Messages.TranslatorEditor_TITLE;
    }

    protected String getHelpId() {
        return "com.ibm.team.build.ui.editor_translator";
    }

    protected void handleRefreshComplete() {
        this.fSystemDefinitionIdText.removeModifyListener(this.fIdModifiedListener);
        this.fSystemDefinitionIdText.setText(this.fSystemDefinition.getName());
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.updatePageWorkingCopies((ITranslator)this.fSystemDefinition);
        this.handleArchived();
        for (Object page : this.pages) {
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (this.fForm != null) {
            this.fForm.reflow(true);
        }
        this.setPartName();
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
    }

    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.TranslatorEditor_SAVING_MESSAGE, 2);
        try {
            ZosTranslator tl;
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
            if (this.fSystemDefinition instanceof ZosTranslator && (tl = (ZosTranslator)this.fSystemDefinition).getCallMethod() == 3) {
                tl.getConcatenations().clear();
                tl.getDDAllocations().clear();
            }
            ISystemDefinitionHandle savedHandle = client.saveSystemDefinition(this.fSystemDefinition, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete(savedHandle, true, monitor);
            this.fSystemDefinition = (ISystemDefinition)systemDefinition.getWorkingCopy();
            this.fEditorInput.initializeEditorInput(this.fSystemDefinition);
            this.updatePageWorkingCopies((ITranslator)this.fSystemDefinition);
            if (this.fIsNewSystemDefinition || this.fNameChanged) {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                TranslatorsNodeEE translatorsNode = null;
                if (node instanceof LanguageDefinitionsNodeEE) {
                    translatorsNode = ((LanguageDefinitionsNodeEE)node).getTranslatorsNode();
                }
                if (translatorsNode != null) {
                    this.refreshSystemDefinitionNode(translatorsNode);
                } else {
                    this.refreshSystemDefinitionNode(node);
                }
            } else {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                TranslatorsNodeEE translatorsNode = null;
                if (node instanceof LanguageDefinitionsNodeEE) {
                    translatorsNode = ((LanguageDefinitionsNodeEE)node).getTranslatorsNode();
                }
                if (translatorsNode != null) {
                    translatorsNode.refreshNode(systemDefinition);
                } else {
                    this.refreshSystemDefinitionNode(node);
                }
            }
            this.fNameChanged = false;
            this.fIsNewSystemDefinition = false;
        }
        finally {
            monitor.done();
        }
    }

    public void refreshSystemDefinitionItem(IProgressMonitor monitor) {
        if (!this.fIsNewSystemDefinition) {
            this.fSystemDefinition = this.fEditorInput.getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
                this.fSystemDefinition = (ISystemDefinition)client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.fSystemDefinition, true, monitor).getWorkingCopy();
                if (this.genPage != null) {
                    this.genPage.setWorkingCopy(this.fSystemDefinition);
                }
                this.setWorkingCopyForHistory();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    protected void updatePageWorkingCopies(ITranslator translator) {
        for (Object page : this.pages) {
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            editorPage.setWorkingCopy((ISystemDefinition)translator);
        }
    }

    protected void addPages() {
        try {
            this.genPage = new GeneralTranslatorEditorPage("translator", Messages.TranslatorEditor_GENERAL_TAB);
            this.genPage.initialize(this);
            this.genPage.setConfiguration(this.configuration);
            this.genPage.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.genPage);
        }
        catch (PartInitException exception) {
            ZDefUIPlugin.log(exception);
        }
        this.addHistoryPage();
    }

    protected boolean validate() {
        boolean isValid = true;
        if (this.fSystemDefinitionIdText.getText().trim().equals("")) {
            this.addErrorMessage(this.fSystemDefinitionIdText, Messages.TranslatorEditor_ID_MUST_NOT_BE_EMPTY, (Control)this.fSystemDefinitionIdText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fSystemDefinitionIdText, (Control)this.fSystemDefinitionIdText);
        }
        for (Object page : this.pages) {
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            if (editorPage.validate()) continue;
            isValid = false;
        }
        return isValid;
    }
}

