/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.internal.common.ui.EnterpriseExtensionsDomainRegistry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.LanguageDefinitionEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.TranslatorEditorInput;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.common.TeamRepositoryException;

public class SystemDefinitionEditorInputFactory {
    public static final String TAN_PATH_ZOS_DATA_SET_DEFINITIONS = "SystemDefinitions/ZOS35/DataSetDefinitions";
    public static final String TAN_PATH_ZOS_LANGUAGE_DEFINITIONS = "SystemDefinitions/ZOS35/LanguageDefinitions";

    private SystemDefinitionEditorInputFactory() {
    }

    public static AbstractEditorInput getSystemDefinitionEditorInput(ISystemDefinition definition, IProjectAreaHandle projectAreaHandle) throws TeamRepositoryException {
        EnterpriseExtensionsDomainRegistry eeRegistry = EnterpriseExtensionsDomainRegistry.getInstance();
        if (definition instanceof IZosLanguageDefinition) {
            return new LanguageDefinitionEditorInput((ISystemDefinition)((IZosLanguageDefinition)definition), projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_ZOS_LANGUAGE_DEFINITIONS));
        }
        if (definition instanceof IDataSetDefinition) {
            return new DataSetDefinitionEditorInput((ISystemDefinition)((IDataSetDefinition)definition), projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_ZOS_DATA_SET_DEFINITIONS));
        }
        if (definition instanceof IZosTranslator) {
            return new TranslatorEditorInput((ISystemDefinition)((IZosTranslator)definition), projectAreaHandle, (AbstractEnterpriseExtensionsNode)eeRegistry.getEnterpriseExtensionsNode(projectAreaHandle, TAN_PATH_ZOS_LANGUAGE_DEFINITIONS));
        }
        return null;
    }
}

