/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.ui.domain.AbstractEnterpriseExtensionsNode;
import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IPackagingItemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosLanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.ui.ILanguageExtensionEditorPage;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractEditorInput;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.editors.LanguageExtensionEditorFactory;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.langdef.LanguageDefinitionsNodeEE;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractLanguageDefinitionItemEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractSystemDefinitionEditorZos;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.GeneralLanguageDefinitionEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.LanguageDefinitionEditorInput;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ScannerLanguageDefinitionEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.Utils;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class LanguageDefinitionEditor
extends AbstractSystemDefinitionEditorZos {
    private ScrolledForm fForm;
    private boolean smpeEnabled = false;
    private final AbstractSystemDefinitionEditor fEditor;
    private LanguageDefinitionEditorInput fEditorInput;
    private GeneralLanguageDefinitionEditorPage genEd;
    private ScannerLanguageDefinitionEditorPage scannerEd;
    private Map<String, String> fTranslatorCache = new HashMap<String, String>();
    private List<ILanguageExtensionEditorPage> languageExtensionEditorPageList;

    public LanguageDefinitionEditor() {
        this.fEditor = this;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.fEditorInput = (LanguageDefinitionEditorInput)input;
        this.fTeamRepository = this.fEditorInput.getTeamRepository();
        this.fIsNewSystemDefinition = this.fEditorInput.isNewSystemDefinition();
        this.fSystemDefinition = (ISystemDefinition)this.fEditorInput.getSystemDefinition().getWorkingCopy();
        this.smpeEnabled = Utils.isSmpeEnabled(this.fTeamRepository);
        if (!this.smpeEnabled && this.fSystemDefinition instanceof IZosLanguageDefinition && ((IZosLanguageDefinition)this.fSystemDefinition).hasSmpePackaging()) {
            throw new PartInitException(NLS.bind((String)Messages.LanguageDefinitionEditor_SmpeEnabled_Required, (Object)this.fSystemDefinition.getName()));
        }
        this.handleSaveRequired();
    }

    protected void createContextMenu(Form form) {
        IMenuManager menuMgr = form.getMenuManager();
        menuMgr.add((IContributionItem)new Separator("additions"));
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(this.getMenuListener());
    }

    protected void createHeaderContents(IManagedForm headerForm) {
        if (this.smpeEnabled) {
            this.createContextMenu(headerForm.getForm().getForm());
        }
        super.createHeaderContents(headerForm);
    }

    protected Image getHeaderTitleImage() {
        if (this.fSystemDefinition.isArchived()) {
            return ZDefUIPlugin.getImage("icons/obj16/langdef_arch_obj.gif");
        }
        return ZDefUIPlugin.getImage("icons/obj16/langdef_obj.gif");
    }

    protected String getHeaderTitleText() {
        return Messages.LanguageDefinitionEditor_LANGUAGE_DEFINITION_EDITOR_TITLE;
    }

    protected String getHelpId() {
        if (this.getCurrentPage() == 1) {
            return "com.ibm.team.build.ui.editor_languagedefinitionscanners";
        }
        return "com.ibm.team.build.ui.editor_languagedefinitiongeneral";
    }

    protected IAction getMenuActionAddSmpeExtension() {
        return new Action(Messages.LanguageDefinitionEditor_Action_Add_SmpeExtension){

            public void runWithEvent(Event event) {
                if (LanguageDefinitionEditor.this.findPage("languageExtensionSmpe") == null) {
                    ILanguageExtensionEditorPage extensionEditorPage = LanguageExtensionEditorFactory.getInstance().getLanguageExtensionEditor("languageExtensionSmpe", "zos");
                    if (extensionEditorPage != null && extensionEditorPage.isVisible(LanguageDefinitionEditor.this.fTeamRepository)) {
                        try {
                            extensionEditorPage.initialize(LanguageDefinitionEditor.this.fEditor);
                            extensionEditorPage.setWorkingCopy(LanguageDefinitionEditor.this.fSystemDefinition);
                            LanguageDefinitionEditor.this.setActivePage(LanguageDefinitionEditor.this.addPage((IFormPage)extensionEditorPage));
                        }
                        catch (PartInitException exception) {
                            ZDefUIPlugin.log(exception);
                        }
                    }
                    LanguageDefinitionEditor.this.fDirty = true;
                    LanguageDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }

            public void run() {
                this.runWithEvent(null);
            }
        };
    }

    protected IAction getMenuActionRemoveSmpeExtention() {
        return new Action(Messages.LanguageDefinitionEditor_Action_Remove_SmpeExtention){

            public void runWithEvent(Event event) {
                IFormPage extensionEditorPage = LanguageDefinitionEditor.this.findPage("languageExtensionSmpe");
                if (extensionEditorPage != null) {
                    ((ILanguageExtensionEditorPage)extensionEditorPage).removeExtension();
                    LanguageDefinitionEditor.this.removePage(LanguageDefinitionEditor.this.pages.indexOf(extensionEditorPage));
                    LanguageDefinitionEditor.this.fDirty = true;
                    LanguageDefinitionEditor.this.fireDirtyPropertyChangeEvent();
                }
            }

            public void run() {
                this.runWithEvent(null);
            }
        };
    }

    protected IMenuListener getMenuListener() {
        return new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                manager.add(LanguageDefinitionEditor.this.getMenuActionAddSmpeExtension());
                manager.add(LanguageDefinitionEditor.this.getMenuActionRemoveSmpeExtention());
            }
        };
    }

    protected void handleRefreshComplete() {
        this.fSystemDefinitionIdText.removeModifyListener(this.fIdModifiedListener);
        this.fSystemDefinitionIdText.setText(this.fSystemDefinition.getName());
        this.fSystemDefinitionIdText.addModifyListener(this.fIdModifiedListener);
        this.updatePageWorkingCopies((ILanguageDefinition)this.fSystemDefinition);
        this.definePages((ILanguageDefinition)this.fSystemDefinition);
        this.removePages((ILanguageDefinition)this.fSystemDefinition);
        this.handleArchived();
        for (Object page : this.pages) {
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            editorPage.refresh();
            IManagedForm managedForm = editorPage.getManagedForm();
            if (managedForm == null) continue;
            managedForm.reflow(true);
        }
        if (this.fForm != null) {
            this.fForm.reflow(true);
        }
        this.setPartName();
        this.fDirty = false;
        this.fireDirtyPropertyChangeEvent();
    }

    protected boolean handleSaveRequired() {
        IZosLanguageDefinition languageDefinition = (IZosLanguageDefinition)this.fSystemDefinition;
        if (languageDefinition.isSaveRequired()) {
            this.setDirty(true);
            languageDefinition.setSaveRequired(false);
            return true;
        }
        return false;
    }

    protected void postSave(boolean saveSucceeded) {
        if (saveSucceeded) {
            this.setPartName();
            this.setDirty(false);
            this.scannerEd.refreshViewerInput();
            this.genEd.refreshViewerInput();
        }
    }

    protected void performSave(IProgressMonitor monitor) throws TeamRepositoryException {
        monitor.beginTask(Messages.LanguageDefinitionEditor_SAVING_MESSAGE, 3);
        try {
            ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
            boolean extensionRemoved = false;
            boolean hadExtension = this.smpeEnabled && this.fEditorInput.getSystemDefinition() instanceof IZosLanguageDefinition && ((IZosLanguageDefinition)this.fEditorInput.getSystemDefinition()).hasSmpePackaging();
            boolean hasExtension = this.smpeEnabled && this.fSystemDefinition instanceof IZosLanguageDefinition && ((IZosLanguageDefinition)this.fSystemDefinition).hasSmpePackaging();
            IPackagingItemDefinitionHandle itemHandle = null;
            if (hadExtension && !hasExtension) {
                extensionRemoved = true;
                itemHandle = ((IZosLanguageDefinition)this.fEditorInput.getSystemDefinition()).getSmpePackaging();
            }
            ISystemDefinitionHandle savedHandle = client.saveSystemDefinition(this.fSystemDefinition, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (extensionRemoved) {
                client.deleteSystemDefinition((ISystemDefinitionHandle)itemHandle, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            }
            ISystemDefinition systemDefinition = client.fetchSystemDefinitionComplete(savedHandle, true, monitor);
            this.fSystemDefinition = (ISystemDefinition)systemDefinition.getWorkingCopy();
            this.fEditorInput.initializeEditorInput(this.fSystemDefinition);
            this.updatePageWorkingCopies((ILanguageDefinition)this.fSystemDefinition);
            if (this.fIsNewSystemDefinition || this.fNameChanged) {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                this.refreshSystemDefinitionNode(node);
            } else {
                AbstractEnterpriseExtensionsNode node = ((AbstractEditorInput)this.getEditorInput()).getNode();
                if (node instanceof LanguageDefinitionsNodeEE) {
                    LanguageDefinitionsNodeEE nodeEE = (LanguageDefinitionsNodeEE)node;
                    nodeEE.refreshNode(systemDefinition);
                }
            }
            this.fNameChanged = false;
            this.fIsNewSystemDefinition = false;
        }
        finally {
            monitor.done();
        }
    }

    public void refreshSystemDefinitionItem(IProgressMonitor monitor) {
        if (!this.fIsNewSystemDefinition) {
            this.fSystemDefinition = this.fEditorInput.getSystemDefinition();
            try {
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getTeamRepository());
                this.fSystemDefinition = (ISystemDefinition)client.fetchSystemDefinitionComplete((ISystemDefinitionHandle)this.fSystemDefinition, true, monitor).getWorkingCopy();
                this.updatePageWorkingCopies((ILanguageDefinition)this.fSystemDefinition);
                this.setWorkingCopyForHistory();
            }
            catch (TeamRepositoryException e) {
                e.printStackTrace();
            }
        }
    }

    protected void definePages(ILanguageDefinition definition) {
        for (ILanguageExtensionEditorPage languageExtensionEditorPage : this.languageExtensionEditorPageList) {
            if (languageExtensionEditorPage == null || this.pages.contains(languageExtensionEditorPage)) continue;
            languageExtensionEditorPage.initialize((AbstractSystemDefinitionEditor)this);
            if (!languageExtensionEditorPage.isVisible() || !languageExtensionEditorPage.isRequired(this.fSystemDefinition)) continue;
            try {
                languageExtensionEditorPage.setWorkingCopy(this.fSystemDefinition);
                this.addPage(this.pages.size() - 1, (IFormPage)languageExtensionEditorPage);
            }
            catch (PartInitException exception) {
                ZDefUIPlugin.log(exception);
            }
        }
    }

    protected void removePages(ILanguageDefinition definition) {
        for (Object page : new Vector(this.pages)) {
            ILanguageExtensionEditorPage languageExtensionEditorPage;
            if (!(page instanceof ILanguageExtensionEditorPage) || (languageExtensionEditorPage = (ILanguageExtensionEditorPage)page).isVisible() && languageExtensionEditorPage.isRequired(this.fSystemDefinition)) continue;
            this.removePage(this.pages.indexOf(page));
        }
    }

    protected void updatePageWorkingCopies(ILanguageDefinition definition) {
        if (this.genEd != null) {
            this.genEd.setWorkingCopy((ISystemDefinition)definition);
        }
        if (this.scannerEd != null) {
            this.scannerEd.setWorkingCopy((ISystemDefinition)definition);
        }
        for (Object page : this.pages) {
            if (!(page instanceof ILanguageExtensionEditorPage)) continue;
            ILanguageExtensionEditorPage extensionPage = (ILanguageExtensionEditorPage)page;
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            if (!extensionPage.isVisible() || !extensionPage.isRequired(this.fSystemDefinition)) continue;
            editorPage.setWorkingCopy((ISystemDefinition)definition);
        }
    }

    protected void addPages() {
        try {
            this.genEd = new GeneralLanguageDefinitionEditorPage("general", Messages.LanguageDefinitionEditor_GENERAL_TAB);
            this.genEd.initialize(this);
            this.genEd.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.genEd);
            this.scannerEd = new ScannerLanguageDefinitionEditorPage("scanners", Messages.LanguageDefinitionEditor_SCANNERS_TAB);
            this.scannerEd.initialize(this);
            this.scannerEd.setWorkingCopy(this.fSystemDefinition);
            this.addPage((IFormPage)this.scannerEd);
            this.languageExtensionEditorPageList = LanguageExtensionEditorFactory.getInstance().getLanguageExtensionEditors("zos");
            for (ILanguageExtensionEditorPage languageExtensionEditorPage : this.languageExtensionEditorPageList) {
                if (languageExtensionEditorPage == null || !languageExtensionEditorPage.isVisible(this.fTeamRepository) || !languageExtensionEditorPage.isRequired(this.fSystemDefinition)) continue;
                languageExtensionEditorPage.initialize((AbstractSystemDefinitionEditor)this);
                languageExtensionEditorPage.setWorkingCopy(this.fSystemDefinition);
                this.addPage((IFormPage)languageExtensionEditorPage);
            }
        }
        catch (PartInitException exception) {
            ZDefUIPlugin.log(exception);
        }
        this.addHistoryPage();
    }

    protected void pageChange(int newPageIndex) {
        if (newPageIndex == 1) {
            this.scannerEd.refreshDependencyTypesControl();
        }
        super.pageChange(newPageIndex);
    }

    protected boolean validate() {
        boolean isValid = true;
        if (this.fSystemDefinitionIdText.getText().trim().equals("")) {
            this.addErrorMessage(this.fSystemDefinitionIdText, Messages.LanguageDefinitionEditor_ID_MUST_NOT_BE_EMPTY, (Control)this.fSystemDefinitionIdText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fSystemDefinitionIdText, (Control)this.fSystemDefinitionIdText);
        }
        for (Object page : this.pages) {
            AbstractLanguageDefinitionItemEditorPage editorPage = (AbstractLanguageDefinitionItemEditorPage)((Object)page);
            if (editorPage.validate()) continue;
            isValid = false;
        }
        return isValid;
    }

    public Map<String, String> getTranslatorCache() {
        return this.fTranslatorCache;
    }

    public void setTranslatorCache(Map<String, String> fTranslatorCache) {
        this.fTranslatorCache = fTranslatorCache;
    }
}

