/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.helper.HFSPathModeHelper;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.HFSDD;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.HFSFileType;
import com.ibm.team.enterprise.systemdefinition.common.model.HFSPathDisp;
import com.ibm.team.enterprise.systemdefinition.common.model.HFSPathOpts;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import java.math.BigInteger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class HFSPropertiesDialog
extends TitleAreaDialog {
    private Text modPermText;
    private Label pathmodText;
    private Button[] permissionsButtons = new Button[12];
    private Button[] optionsButtons = new Button[HFSPathOpts.VALUES.size()];
    private Button normalKeepButton;
    private Button normalDeleteButton;
    private Button abnormalKeepButton;
    private Button abnormalDeleteButton;
    private Button textFileButton;
    private Button binaryFileButton;
    private String fmodPerm;
    private BigInteger pathModeBI = new BigInteger("0");
    private HFSDD hfsDD;

    protected HFSPropertiesDialog(Shell parentShell, HFSDD hfsDD) {
        super(parentShell);
        this.hfsDD = hfsDD;
        this.setShellStyle(this.getShellStyle());
    }

    protected Control createDialogArea(Composite parent) {
        Composite fComposite = (Composite)super.createDialogArea(parent);
        Composite dialogComposite = new Composite(fComposite, 0);
        dialogComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogComposite);
        this.setTitle(Messages.HFSPropertiesDialog_TITLE);
        this.setMessage(NLS.bind((String)Messages.HFSPropertiesDialog_INFO, (Object)(this.hfsDD.getPath() == null ? "" : this.hfsDD.getPath())));
        Group permissionspGroup = new Group(dialogComposite, 0);
        permissionspGroup.setText(Messages.HFSPropertiesDialog_PERMISSIONS_LABEL);
        permissionspGroup.setLayout((Layout)new GridLayout(4, false));
        permissionspGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        permissionspGroup.setToolTipText(Messages.HFSPropertiesDialog_PERMISSIONS_TOOLTIP);
        Label empty2 = new Label((Composite)permissionspGroup, 0);
        empty2.setText(Messages.HFSPropertiesDialog_TYPE_LABEL);
        empty2.setLayoutData((Object)new GridData(16384, 4, true, false));
        Label readLabel = new Label((Composite)permissionspGroup, 0);
        readLabel.setText(Messages.HFSPropertiesDialog_READ_LABEL);
        readLabel.setLayoutData((Object)new GridData(16384, 4, true, true));
        Label writeLabel = new Label((Composite)permissionspGroup, 0);
        writeLabel.setText(Messages.HFSPropertiesDialog_WRITE_LABEL);
        writeLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        Label execLabel = new Label((Composite)permissionspGroup, 0);
        execLabel.setText(Messages.HFSPropertiesDialog_EXECUTE_LABEL);
        execLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        Label userLabel = new Label((Composite)permissionspGroup, 0);
        userLabel.setText(Messages.HFSPropertiesDialog_USER_LABEL);
        userLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        int bitPos = HFSPathModeHelper.getBitValue((int)0);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)1);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)2);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        Label groupLabel = new Label((Composite)permissionspGroup, 0);
        groupLabel.setText(Messages.HFSPropertiesDialog_GROUP_LABEL);
        groupLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        bitPos = HFSPathModeHelper.getBitValue((int)4);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)5);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)6);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        Label otherLabel = new Label((Composite)permissionspGroup, 0);
        otherLabel.setText(Messages.HFSPropertiesDialog_OTHERS_LABEL);
        otherLabel.setLayoutData((Object)new GridData(16384, 4, true, false));
        bitPos = HFSPathModeHelper.getBitValue((int)8);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)9);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)10);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        bitPos = HFSPathModeHelper.getBitValue((int)12);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        this.permissionsButtons[bitPos].setText(Messages.HFSPropertiesDialog_SETUID_LABEL);
        bitPos = HFSPathModeHelper.getBitValue((int)13);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        this.permissionsButtons[bitPos].setText(Messages.HFSPropertiesDialog_SETGID_LABEL);
        bitPos = HFSPathModeHelper.getBitValue((int)14);
        this.permissionsButtons[bitPos] = this.createPermissionsButton(permissionspGroup, bitPos);
        this.permissionsButtons[bitPos].setText(Messages.HFSPropertiesDialog_STIKYBIT_LABEL);
        Label empty21 = new Label((Composite)permissionspGroup, 0);
        empty21.setText("");
        empty21.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        Label modPermLabel = new Label((Composite)permissionspGroup, 0);
        modPermLabel.setText(Messages.HFSPropertiesDialog_PATHPERM_LABEL);
        modPermLabel.setLayoutData((Object)new GridData(131072, 0x1000000, true, false));
        this.modPermText = new Text((Composite)permissionspGroup, 2048);
        this.modPermText.setLayoutData((Object)new GridData(16384, 0x1000000, true, false));
        this.modPermText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                HFSPropertiesDialog.this.fmodPerm = HFSPropertiesDialog.this.modPermText.getText();
                if (HFSPropertiesDialog.this.fmodPerm.length() > 0) {
                    try {
                        HFSPropertiesDialog.this.pathModeBI = new BigInteger(HFSPropertiesDialog.this.fmodPerm, 8);
                        int i = 0;
                        while (i < 12) {
                            boolean state = HFSPropertiesDialog.this.pathModeBI.testBit(i);
                            HFSPropertiesDialog.this.permissionsButtons[i].setSelection(state);
                            ++i;
                        }
                        HFSPropertiesDialog.this.hfsDD.setPathPerm(HFSPropertiesDialog.this.fmodPerm);
                    }
                    catch (NumberFormatException e) {
                        HFSPropertiesDialog.this.hfsDD.setPathPerm(null);
                    }
                }
                HFSPropertiesDialog.this.validate(false);
            }
        });
        Group optionsGroup = new Group(dialogComposite, 0);
        optionsGroup.setText(Messages.HFSPropertiesDialog_OPTIONS_LABEL);
        optionsGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 3));
        optionsGroup.setLayout((Layout)new GridLayout(1, false));
        optionsGroup.setToolTipText(Messages.HFSPropertiesDialog_OPTIONS_TOOLTIP);
        int i = 0;
        while (i < HFSPathOpts.VALUES.size()) {
            this.optionsButtons[i] = this.createOptionsButton(optionsGroup, i);
            this.optionsButtons[i].setData((Object)HFSPathOpts.get((int)i));
            ++i;
        }
        Group dispGroup = new Group(dialogComposite, 0);
        dispGroup.setText(Messages.HFSPropertiesDialog_DISP_LABEL);
        dispGroup.setLayout((Layout)new GridLayout(3, false));
        dispGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        dispGroup.setToolTipText(Messages.HFSPropertiesDialog_DISP_TOOLTIP);
        Label empty = new Label((Composite)dispGroup, 0);
        empty.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        Label normalLabel = new Label((Composite)dispGroup, 0);
        normalLabel.setText(Messages.HFSPropertiesDialog_NORMAL_LABEL);
        normalLabel.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        Label abnormalLabel = new Label((Composite)dispGroup, 0);
        abnormalLabel.setText(Messages.HFSPropertiesDialog_ABNORMAL_LABEL);
        abnormalLabel.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        Label labelKeep = new Label((Composite)dispGroup, 0);
        labelKeep.setText(Messages.HFSPropertiesDialog_KEEP_LABEL);
        labelKeep.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.normalKeepButton = new Button((Composite)dispGroup, 32);
        this.normalKeepButton.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.normalKeepButton.addSelectionListener(this.normalKeepButtonListener());
        this.abnormalKeepButton = new Button((Composite)dispGroup, 32);
        this.abnormalKeepButton.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.abnormalKeepButton.addSelectionListener(this.abnormalKeepButtonListener());
        Label labelDelete = new Label((Composite)dispGroup, 0);
        labelDelete.setText(Messages.HFSPropertiesDialog_DELETE_LABEL);
        labelDelete.setLayoutData((Object)new GridData(16384, 4, true, false));
        this.normalDeleteButton = new Button((Composite)dispGroup, 32);
        this.normalDeleteButton.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.normalDeleteButton.addSelectionListener(this.normalDeleteButtonListener());
        this.abnormalDeleteButton = new Button((Composite)dispGroup, 32);
        this.abnormalDeleteButton.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.abnormalDeleteButton.addSelectionListener(this.abnormalDeleteButtonListener());
        Group typeGroup = new Group(dialogComposite, 0);
        typeGroup.setText(Messages.HFSPropertiesDialog_FILEDATA_LABEL);
        typeGroup.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        typeGroup.setLayout((Layout)new GridLayout(2, false));
        this.textFileButton = this.createFileDataButton(typeGroup, Messages.HFSPropertiesDialog_TEXT_LABEL, 16);
        this.binaryFileButton = this.createFileDataButton(typeGroup, Messages.HFSPropertiesDialog_BINARY_LABEL, 16);
        typeGroup.setToolTipText(Messages.HFSPropertiesDialog_FILEDATA_TOOLTIP);
        empty.setLayoutData((Object)new GridData(0x1000000, 4, true, false));
        this.initWidgetValues();
        HFSPropertiesDialog.applyDialogFont((Control)fComposite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_ddallocation");
        return fComposite;
    }

    protected SelectionListener getFileDataListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.textFileButton.getSelection()) {
                    HFSPropertiesDialog.this.hfsDD.setFileType(HFSFileType.get((int)0));
                } else {
                    HFSPropertiesDialog.this.hfsDD.setFileType(HFSFileType.get((int)1));
                }
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    protected SelectionListener getPermissionsListener(final int value) {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.permissionsButtons[value].getSelection()) {
                    HFSPropertiesDialog.this.pathModeBI = HFSPropertiesDialog.this.pathModeBI.setBit(value);
                } else {
                    HFSPropertiesDialog.this.pathModeBI = HFSPropertiesDialog.this.pathModeBI.clearBit(value);
                }
                String octalValue = HFSPropertiesDialog.this.pathModeBI.toString(8);
                HFSPropertiesDialog.this.modPermText.setText(octalValue);
                HFSPropertiesDialog.this.hfsDD.setPathPerm(octalValue);
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    protected SelectionListener getOptionsListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                HFSPropertiesDialog.this.hfsDD.unsetPathOpts();
                int i = 0;
                while (i < HFSPathOpts.VALUES.size()) {
                    if (HFSPropertiesDialog.this.optionsButtons[i].getSelection()) {
                        StringHelper ish = ModelFactory.eINSTANCE.createStringHelper();
                        ish.setValue(HFSPathOpts.get((int)i).getLiteral());
                        HFSPropertiesDialog.this.hfsDD.getPathOpts().add(ish);
                    }
                    ++i;
                }
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    private Button createOptionsButton(Group optionsGroup, int option) {
        HFSPathOpts pathOpts = HFSPathOpts.get((int)option);
        String label = pathOpts.getLiteral();
        Button res = new Button((Composite)optionsGroup, 32);
        res.setLayoutData((Object)new GridData(4, 4, true, false));
        if (label != null) {
            res.setText(label);
        }
        res.addSelectionListener(this.getOptionsListener());
        return res;
    }

    private Button createPermissionsButton(Group optionsGroup, int pos) {
        Button res = new Button((Composite)optionsGroup, 32);
        res.setLayoutData((Object)new GridData(16384, 4, true, false));
        res.addSelectionListener(this.getPermissionsListener(pos));
        return res;
    }

    private Button createFileDataButton(Group optionsGroup, String label, int type) {
        Button res = new Button((Composite)optionsGroup, type);
        res.setLayoutData((Object)new GridData(4, 4, true, false));
        if (label != null) {
            res.setText(label);
        }
        res.addSelectionListener(this.getFileDataListener());
        return res;
    }

    public void initWidgetValues() {
        switch (this.hfsDD.getPathDisp().getValue()) {
            case 1: {
                this.normalDeleteButton.setSelection(true);
                break;
            }
            case 5: {
                this.abnormalDeleteButton.setSelection(true);
                break;
            }
            case 3: {
                this.normalDeleteButton.setSelection(true);
                this.abnormalKeepButton.setSelection(true);
                break;
            }
            case 7: {
                this.normalDeleteButton.setSelection(true);
                this.abnormalDeleteButton.setSelection(true);
                break;
            }
            case 0: {
                this.normalKeepButton.setSelection(true);
                break;
            }
            case 4: {
                this.abnormalKeepButton.setSelection(true);
                break;
            }
            case 6: {
                this.normalKeepButton.setSelection(true);
                this.abnormalKeepButton.setSelection(true);
                break;
            }
            case 2: {
                this.normalKeepButton.setSelection(true);
                this.abnormalDeleteButton.setSelection(true);
            }
        }
        HFSFileType type = this.hfsDD.getFileType();
        if (type != null) {
            if (type.getValue() == 1) {
                this.binaryFileButton.setSelection(true);
            }
            if (type.getValue() == 0) {
                this.textFileButton.setSelection(true);
            }
        }
        for (IStringHelper s : this.hfsDD.getPathOpts()) {
            HFSPathOpts current = HFSPathOpts.getByName((String)s.getValue());
            this.optionsButtons[current.getValue()].setSelection(true);
        }
        String perm = this.hfsDD.getPathPerm();
        for (Integer i : HFSPathModeHelper.getBitPosList((String)perm)) {
            this.permissionsButtons[i].setSelection(true);
        }
        this.modPermText.setText(perm == null ? "" : perm);
    }

    protected void validate(boolean suppressErrorMessage) {
        if (suppressErrorMessage) {
            this.setErrorMessage(null);
        }
        String errorMessage = null;
        if (this.hfsDD.getPathPerm() == null) {
            errorMessage = NLS.bind((String)Messages.HFSPropertiesDialog_INVALID_PERMISSION, (Object)this.fmodPerm);
        }
        if (errorMessage == null) {
            this.setErrorMessage(null);
            this.setMessage(NLS.bind((String)Messages.HFSPropertiesDialog_INFO, (Object)this.hfsDD.getPath()));
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(errorMessage == null);
        }
    }

    private HFSPathDisp getPathDisp() {
        if (this.normalKeepButton.getSelection()) {
            if (this.abnormalKeepButton.getSelection()) {
                return HFSPathDisp.get((int)6);
            }
            if (this.abnormalDeleteButton.getSelection()) {
                return HFSPathDisp.get((int)2);
            }
            return HFSPathDisp.get((int)0);
        }
        if (this.normalDeleteButton.getSelection()) {
            if (this.abnormalKeepButton.getSelection()) {
                return HFSPathDisp.get((int)3);
            }
            if (this.abnormalDeleteButton.getSelection()) {
                return HFSPathDisp.get((int)7);
            }
            return HFSPathDisp.get((int)1);
        }
        if (this.abnormalKeepButton.getSelection()) {
            return HFSPathDisp.get((int)4);
        }
        if (this.abnormalDeleteButton.getSelection()) {
            return HFSPathDisp.get((int)5);
        }
        return null;
    }

    protected SelectionListener normalKeepButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.normalKeepButton.getSelection() && HFSPropertiesDialog.this.normalDeleteButton.getSelection()) {
                    HFSPropertiesDialog.this.normalDeleteButton.setSelection(false);
                }
                HFSPathDisp hpd = HFSPropertiesDialog.this.getPathDisp();
                HFSPropertiesDialog.this.hfsDD.setPathDisp(hpd);
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    private SelectionListener abnormalKeepButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.abnormalKeepButton.getSelection() && HFSPropertiesDialog.this.abnormalDeleteButton.getSelection()) {
                    HFSPropertiesDialog.this.abnormalDeleteButton.setSelection(false);
                }
                HFSPathDisp hpd = HFSPropertiesDialog.this.getPathDisp();
                HFSPropertiesDialog.this.hfsDD.setPathDisp(hpd);
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    private SelectionListener normalDeleteButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.normalDeleteButton.getSelection() && HFSPropertiesDialog.this.normalKeepButton.getSelection()) {
                    HFSPropertiesDialog.this.normalKeepButton.setSelection(false);
                }
                HFSPathDisp hpd = HFSPropertiesDialog.this.getPathDisp();
                HFSPropertiesDialog.this.hfsDD.setPathDisp(hpd);
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }

    private SelectionListener abnormalDeleteButtonListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (HFSPropertiesDialog.this.abnormalDeleteButton.getSelection() && HFSPropertiesDialog.this.abnormalKeepButton.getSelection()) {
                    HFSPropertiesDialog.this.abnormalKeepButton.setSelection(false);
                }
                HFSPathDisp hpd = HFSPropertiesDialog.this.getPathDisp();
                HFSPropertiesDialog.this.hfsDD.setPathDisp(hpd);
                HFSPropertiesDialog.this.validate(false);
            }
        };
    }
}

