/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.common.common.IEnterpriseConfiguration;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSOutput;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.Activator;
import com.ibm.team.enterprise.systemdefinition.ui.IGenericListener;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.CreateOutputDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.CreateVariableDialog;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetAnnotationModel;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetProblemAnnotation;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetSourceViewerConfiguration;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetTranslatorListener;
import com.ibm.team.enterprise.systemdefinition.ui.viewers.AntSnippetViewer;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractLanguageDefinitionItemEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationsControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DDAllocationsControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataDefinitionEntryLabelHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionSelectionDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.DDConflict;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.utils.Utils;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.ITranslatorType;
import com.ibm.team.enterprise.zos.systemdefinition.common.TranslatorTypeRegistry;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.jface.tooltip.TooltipSupport;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class GeneralTranslatorEditorPage
extends AbstractLanguageDefinitionItemEditorPage {
    private Button fAddOutputButton;
    private Button fRemoveOutputButton;
    private Button fEditOutputButton;
    private Button fAddVariableButton;
    private Button fBrowseButton;
    private Button fCallMethodAntScriptButton;
    private Button fCallMethodBuildfileButton;
    private Button fCallMethodCalledProgramButton;
    private Button fCallMethodISPFTSOButton;
    private Button fDownVariableButton;
    private Button fEditVariableButton;
    private Button fISPFButton;
    private Button fISPFLogCompact;
    private Button fISPFLogConsolidateAlways;
    private Button fISPFLogConsolidateInherited;
    private Button fISPFLogConsolidateNever;
    private Button fISPFLogConsolidateOnSuccess;
    private Button fISPFLogPublishAlways;
    private Button fISPFLogPublishInherited;
    private Button fISPFLogPublishNever;
    private Button fISPFLogPublishOnError;
    private Button fLinkEditCheckbox;
    private Button fNonImpactingCheckbox;
    private Button fRemoveVariableButton;
    private Button fTSOButton;
    private Button fUpVariableButton;
    private Composite buildfileOptionsComposite;
    private Composite datasetComposite;
    private Composite fParent;
    private Label buildFileLabel;
    private Label buildReturnPropsLabel;
    private Label buildTargetsLabel;
    private Label fDDListLabel;
    private Label fDefaultCompileOptsLabel;
    private Label fISPFLogConsolidateLabel;
    private Label fISPFLogPublishLabel;
    private Label fISPFTSOCommandLabel;
    private Label fTranslatorDataDefinitionLabel;
    private Section fGeneralSection;
    private Section fCallMethodSection;
    private Section fDataSetSection;
    private Section fVariablesSection;
    private Section fAntSubSection;
    private Section fOutputsSection;
    private TableViewer fOutputTableViewer;
    private TableViewer fVariableTableViewer;
    private Text buildFileSectionLabel;
    private Text buildFileText;
    private Text buildReturnPropsText;
    private Text buildTargetsText;
    private Text concatsLabel;
    private Text ddAllocsLabel;
    private Text fDDList;
    private Text fDefaultCompileOptsText;
    private Text fDescriptionText;
    private Text fISPFTSOCommandText;
    private Text fMaxRCText;
    private Text fTranslatorDataDefinitionText;
    private ConcatenationsControl fConcatsControl;
    private DDAllocationsControl fDDAllocationsControl;
    private FormToolkit fToolkit;
    private AntSnippetListener fSnippetListener;
    private AntSnippetViewer fAntSnippetViewer;
    private IZosTranslator fTranslatorWorkingCopy;
    private IEnterpriseConfiguration configuration;
    private MappingValidation validator;
    private boolean dontSetDirty;
    private int previousCallMethod;
    private Button contributedTypeButton;
    private final IGenericListener fConcatsListener = this.getConcatenationsListener();
    private final IGenericListener fDatasetDefsListener = this.getConcatenationsListener();
    private Composite compositeISPFTSO;
    private Composite programOptionsComposite;

    public GeneralTranslatorEditorPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fParent = parent;
        parent.setLayout((Layout)new FormLayout());
        this.createTranslatorSection(parent);
    }

    public void setConfiguration(IEnterpriseConfiguration configuration) {
        this.configuration = configuration;
        this.validator = new MappingValidation(this.configuration);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition item) {
        this.fTranslatorWorkingCopy = (IZosTranslator)item;
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                GeneralTranslatorEditorPage.this.handleSetWorkingCopyAsync();
            }
        });
    }

    private void handleSetWorkingCopyAsync() {
        if (this.fConcatsControl != null && !this.datasetComposite.isDisposed()) {
            this.fConcatsControl.setConcatenations(this.fTranslatorWorkingCopy.getConcatenations());
            this.fConcatsControl.setDDAllocations(this.fTranslatorWorkingCopy.getDDAllocations());
        }
        if (this.fDDAllocationsControl != null && !this.datasetComposite.isDisposed()) {
            this.fDDAllocationsControl.setDDAllocations(this.fTranslatorWorkingCopy.getDDAllocations());
            this.fDDAllocationsControl.setConcatenations(this.fTranslatorWorkingCopy.getConcatenations());
        }
        if (this.fAntSnippetViewer != null) {
            this.fAntSnippetViewer.setInput((Object)this.fTranslatorWorkingCopy);
        }
        if (this.fOutputTableViewer != null && !this.fOutputTableViewer.getControl().isDisposed()) {
            this.fOutputTableViewer.setInput((Object)this.fTranslatorWorkingCopy.getHFSOutputs());
        }
        this.previousCallMethod = this.fTranslatorWorkingCopy.getCallMethod();
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (!this.validateMaxRC()) {
            isValid = false;
        }
        if (!this.validateCallMethod()) {
            isValid = false;
        }
        if (!this.validateDefaultOptions()) {
            isValid = false;
        }
        if (!this.validateBuildFile()) {
            isValid = false;
        }
        if (!this.validateConcats()) {
            isValid = false;
        }
        if (!this.validateDDNames()) {
            isValid = false;
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateMaxRC() {
        boolean isValid = true;
        if (this.fMaxRCText != null && (this.fMaxRCText.getText().trim().isEmpty() || !this.isInteger(this.fMaxRCText.getText().trim()))) {
            this.addErrorMessage((Object)this.fMaxRCText, NLS.bind((String)Messages.GeneralTranslatorEditorPage_ERROR_MUST_BE_INTEGER, (Object)0, (Object)Integer.MAX_VALUE), (Control)this.fMaxRCText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fMaxRCText, (Control)this.fMaxRCText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateCallMethod() {
        boolean isValid = true;
        this.removeErrorMessage(this.fTranslatorDataDefinitionText, (Control)this.fTranslatorDataDefinitionText);
        this.removeErrorMessage(this.fISPFTSOCommandText, (Control)this.fISPFTSOCommandText);
        this.removeErrorMessage(this.fAntSnippetViewer, this.fAntSnippetViewer.getControl());
        if (this.fCallMethodCalledProgramButton.getSelection()) {
            if (this.fTranslatorDataDefinitionText.getText().trim().isEmpty()) {
                this.addErrorMessage((Object)this.fTranslatorDataDefinitionText, Messages.GeneralTranslatorEditorPage_DATA_SET_DEF_REQUIRED, (Control)this.fTranslatorDataDefinitionText);
                isValid = false;
            }
        } else if (this.fCallMethodISPFTSOButton.getSelection()) {
            if (this.fISPFTSOCommandText.getText().trim().isEmpty()) {
                this.addErrorMessage((Object)this.fISPFTSOCommandText, Messages.GeneralTranslatorEditorPage_ISPF_TSO_COMMAND_REQUIRED, (Control)this.fISPFTSOCommandText);
                isValid = false;
            }
        } else if (this.fCallMethodAntScriptButton.getSelection()) {
            if (this.fAntSnippetViewer.getInput() != null && this.fAntSnippetViewer.getTextWidget().getText().isEmpty()) {
                this.addErrorMessage((Object)this.fAntSnippetViewer, Messages.GeneralTranslatorEditorPage_AntSnippetMissingError, this.fAntSnippetViewer.getControl());
                isValid = false;
            } else {
                isValid = this.validateAntSnippet();
            }
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateDefaultOptions() {
        this.removeErrorMessage(this.fDefaultCompileOptsText, (Control)this.fDefaultCompileOptsText);
        if (this.fLinkEditCheckbox.getSelection() && !this.hasDefaultOption("SSI(@{ssi_info})", this.fDefaultCompileOptsText.getText())) {
            this.addWarningMessage(this.fDefaultCompileOptsText, Messages.GeneralTranslatorEditorPage_SSI_MISSING_WARNING, (Control)this.fDefaultCompileOptsText);
        }
        return true;
    }

    private boolean validateBuildFile() {
        boolean isOK = true;
        this.removeErrorMessage(this.fCallMethodSection, (Control)this.fCallMethodSection);
        this.removeErrorMessage(this.buildFileText, (Control)this.buildFileText);
        if (this.fCallMethodBuildfileButton.getSelection()) {
            if (this.buildFileText.getText().trim().isEmpty()) {
                this.addErrorMessage((Object)this.buildFileText, Messages.GeneralTranslatorEditorPage_BUILDFILE_MISSING_ERROR, (Control)this.buildFileText);
                isOK = false;
            }
        } else if (this.previousCallMethod == 4) {
            this.addWarningMessage(this.fCallMethodSection, Messages.GeneralTranslatorEditorPage_CHANGED_HFS_CALLMETHOD_WARNING, (Control)this.fCallMethodSection);
        }
        return isOK;
    }

    private boolean validateAntSnippet() {
        this.removeErrorMessage(this.fAntSnippetViewer, this.fAntSnippetViewer.getControl());
        if (this.fAntSnippetViewer != null && this.fCallMethodAntScriptButton.getSelection()) {
            AntSnippetAnnotationModel antModel;
            List problems;
            IAnnotationModel model;
            if (!this.fAntSnippetViewer.isScriptValid() && (model = Activator.getDefault().getDocumentProvider().getAnnotationModel((Object)this.fTranslatorWorkingCopy)) instanceof AntSnippetAnnotationModel && (problems = (antModel = (AntSnippetAnnotationModel)model).getSnippetAnnotations()) != null && !problems.isEmpty()) {
                StringBuilder errorMessage = null;
                errorMessage = problems.size() > 1 ? new StringBuilder(NLS.bind((String)Messages.GeneralTranslatorEditorPage_AntSnippetErrorsMessage, (Object)problems.size())) : new StringBuilder(Messages.GeneralTranslatorEditorPage_AntSnippetErrorMessage);
                if (errorMessage != null) {
                    for (AntSnippetProblemAnnotation problem : problems) {
                        errorMessage.append(System.lineSeparator());
                        errorMessage.append(problem.getText());
                    }
                    this.addErrorMessage((Object)this.fAntSnippetViewer, errorMessage.toString(), this.fAntSnippetViewer.getControl());
                }
                this.setPageErrorIndicator(true);
                return false;
            }
            return this.fAntSnippetViewer.isScriptValid();
        }
        return true;
    }

    private boolean validateConcats() {
        boolean isValid = true;
        DDConflict ddc = Utils.validateConcats(this.fTranslatorWorkingCopy.getConcatenations());
        if (!ddc.isValid()) {
            this.addErrorMessage((Object)this.concatsLabel, NLS.bind((String)Messages.GeneralTranslatorEditorPage_ERROR_DUPLICATE_DD, (Object)ddc.getDdName()), (Control)this.concatsLabel);
            isValid = false;
        } else {
            this.removeErrorMessage(this.concatsLabel, (Control)this.concatsLabel);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateDDNames() {
        boolean isValid = true;
        DDConflict ddc = Utils.validateDDNames(this.fTranslatorWorkingCopy.getDDAllocations());
        if (!ddc.isValid()) {
            this.addErrorMessage((Object)this.ddAllocsLabel, NLS.bind((String)Messages.GeneralTranslatorEditorPage_ERROR_DUPLICATE_DD, (Object)ddc.getDdName()), (Control)this.ddAllocsLabel);
            isValid = false;
        } else {
            this.removeErrorMessage(this.ddAllocsLabel, (Control)this.ddAllocsLabel);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean hasDefaultOption(String option, String options) {
        String tempOption = option.toLowerCase().trim();
        String tempOptions = options.toLowerCase().trim();
        int index = tempOptions.indexOf(tempOption);
        if (index == -1) {
            return false;
        }
        if (index != 0) {
            return tempOptions.charAt(index - 1) == ',';
        }
        if (index + tempOption.length() < tempOptions.length()) {
            return tempOptions.charAt(index + tempOption.length()) == ',';
        }
        return true;
    }

    private boolean isInteger(String number) {
        try {
            int i = Integer.parseInt(number);
            return i >= 0;
        }
        catch (NumberFormatException exception) {
            return false;
        }
    }

    protected void createTranslatorSection(Composite parent) {
        this.dontSetDirty = true;
        this.createGeneralSection(parent);
        this.createCallMethodSection(parent);
        this.createDataSetSection(parent);
        this.createVariablesSection(parent);
        this.createOutputsSection(parent);
        this.handleCallMethodUpdate();
        this.dontSetDirty = false;
    }

    private void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 256);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fGeneralSection.setLayoutData((Object)data);
        this.fGeneralSection.setLayout((Layout)new GridLayout());
        this.fGeneralSection.setText(Messages.GeneralTranslatorEditorPage_GENERAL_HEADER);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new GridData(4, 4));
        GridLayout layout = new GridLayout(3, false);
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fGeneralSection.setClient((Control)composite);
        Label label = this.fToolkit.createLabel(composite, Messages.GeneralTranslatorEditorPage_DESCRIPTION_LABEL);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)label, Messages.GeneralTranslatorEditorPage_DESCRIPTION_TOOLTIP, false);
        GridDataFactory.swtDefaults().align(1, 1).applyTo((Control)label);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fTranslatorWorkingCopy.getDescription(), 2626);
        GridDataFactory.fillDefaults().span(2, -1).hint(-1, 60).grab(true, false).applyTo((Control)this.fDescriptionText);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setDescription(GeneralTranslatorEditorPage.this.fDescriptionText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fNonImpactingCheckbox, Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION, false);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.fNonImpactingCheckbox);
        this.fNonImpactingCheckbox.setSelection(this.fTranslatorWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setNonImpacting(GeneralTranslatorEditorPage.this.fNonImpactingCheckbox.getSelection());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
    }

    private void createCallMethodSection(Composite parent) {
        this.fCallMethodSection = this.fToolkit.createSection(parent, 322);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fCallMethodSection.setEnabled(false);
        }
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.fGeneralSection, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100);
        this.fCallMethodSection.setLayoutData((Object)formData);
        this.fCallMethodSection.setLayout((Layout)new GridLayout(1, false));
        this.fCallMethodSection.setText(Messages.GeneralTranslatorEditorPage_CALL_METHOD_GROUP_LABEL);
        Composite composite = this.fToolkit.createComposite((Composite)this.fCallMethodSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(composite);
        this.fCallMethodSection.setClient((Control)composite);
        this.fCallMethodCalledProgramButton = this.createCallMethodButton(composite, Messages.GeneralTranslatorEditorPage_CALLED_PROGRAM_LABEL, 16);
        GridDataFactory.fillDefaults().span(2, -1).indent(3, -1).applyTo((Control)this.fCallMethodCalledProgramButton);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 0) {
            this.fCallMethodCalledProgramButton.setSelection(true);
        }
        this.programOptionsComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).applyTo((Control)this.programOptionsComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(this.programOptionsComposite);
        this.fTranslatorDataDefinitionLabel = this.fToolkit.createLabel(this.programOptionsComposite, Messages.GeneralTranslatorEditorPage_TRANSLATOR_DATADEF_LABEL);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fTranslatorDataDefinitionLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fTranslatorDataDefinitionLabel, Messages.GeneralTranslatorEditorPage_TRANSLATOR_DATADEF_TOOLTIP, false);
        this.fTranslatorDataDefinitionText = this.fToolkit.createText(this.programOptionsComposite, "");
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fTranslatorDataDefinitionText);
        this.fTranslatorDataDefinitionText.setEditable(false);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fTranslatorDataDefinitionText, Messages.GeneralTranslatorEditorPage_TRANSLATOR_DATADEF_TOOLTIP, false);
        this.updateDataDefinitionText();
        this.fBrowseButton = this.fToolkit.createButton(this.programOptionsComposite, Messages.GeneralTranslatorEditorPage_BROWSE_BUTTON_WITH_ELLIPSIS, 8);
        GridDataFactory.fillDefaults().grab(false, false).applyTo((Control)this.fBrowseButton);
        this.fBrowseButton.addSelectionListener(this.getBrowseButtonSelectionListener());
        this.fDefaultCompileOptsLabel = this.fToolkit.createLabel(this.programOptionsComposite, Messages.GeneralTranslatorEditorPage_DEFAULT_COMPILE_OPTS_LABEL);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fDefaultCompileOptsLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fDefaultCompileOptsLabel, Messages.GeneralTranslatorEditorPage_DEFAULT_COMPILE_OPTS_TOOLTIP, false);
        this.fDefaultCompileOptsText = this.fToolkit.createText(this.programOptionsComposite, null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).applyTo((Control)this.fDefaultCompileOptsText);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fDefaultCompileOptsText, Messages.GeneralTranslatorEditorPage_DEFAULT_COMPILE_OPTS_TOOLTIP, false);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 0) {
            this.fDefaultCompileOptsText.setText(this.fTranslatorWorkingCopy.getDefaultOptions());
        }
        this.fDefaultCompileOptsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setDefaultOptions(GeneralTranslatorEditorPage.this.fDefaultCompileOptsText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validateDefaultOptions();
            }
        });
        this.fDDListLabel = this.fToolkit.createLabel(this.programOptionsComposite, Messages.GeneralTranslatorEditorPage_DD_NAMES_LIST_LABEL);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fDDListLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fDDListLabel, Messages.GeneralTranslatorEditorPage_DD_NAMES_LIST_TOOLTIP, false);
        this.fDDList = this.fToolkit.createText(this.programOptionsComposite, null);
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).applyTo((Control)this.fDDList);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fDDList, Messages.GeneralTranslatorEditorPage_DD_NAMES_LIST_TOOLTIP, false);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 0) {
            this.fDDList.setText(this.fTranslatorWorkingCopy.getDdNameList());
        }
        this.fDDList.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setDdNameList(GeneralTranslatorEditorPage.this.fDDList.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.fLinkEditCheckbox = this.fToolkit.createButton(this.programOptionsComposite, Messages.GeneralTranslatorEditorPage_LINKEDIT_LABEL, 0x800020);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, false).indent(20, -1).applyTo((Control)this.fLinkEditCheckbox);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fLinkEditCheckbox, Messages.GeneralTranslatorEditorPage_LINKEDIT_TOOLTIP, false);
        this.fLinkEditCheckbox.setSelection(this.fTranslatorWorkingCopy.isLinkEdit());
        this.fLinkEditCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setLinkEdit(GeneralTranslatorEditorPage.this.fLinkEditCheckbox.getSelection());
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validateDefaultOptions();
            }
        });
        this.fCallMethodISPFTSOButton = this.createCallMethodButton(composite, Messages.GeneralTranslatorEditorPage_ISPF_TSO_LABEL, 16);
        GridDataFactory.fillDefaults().span(2, -1).indent(3, -1).applyTo((Control)this.fCallMethodISPFTSOButton);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 1 || this.fTranslatorWorkingCopy.getCallMethod() == 2) {
            this.fCallMethodISPFTSOButton.setSelection(true);
        }
        this.compositeISPFTSO = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().span(2, -1).applyTo((Control)this.compositeISPFTSO);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.compositeISPFTSO);
        Composite compositeISPFTSORadio = this.fToolkit.createComposite(this.compositeISPFTSO);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, 0).grab(true, false).span(2, 1).applyTo((Control)compositeISPFTSORadio);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(compositeISPFTSORadio);
        this.fISPFButton = this.createISPFTSOButton(compositeISPFTSORadio, Messages.GeneralTranslatorEditorPage_ISPF_LABEL, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFButton);
        this.fTSOButton = this.createISPFTSOButton(compositeISPFTSORadio, Messages.GeneralTranslatorEditorPage_TSO_LABEL, 16);
        GridDataFactory.fillDefaults().applyTo((Control)this.fTSOButton);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 2) {
            this.fTSOButton.setSelection(true);
        } else {
            this.fISPFButton.setSelection(true);
        }
        this.fISPFTSOCommandLabel = this.fToolkit.createLabel(this.compositeISPFTSO, Messages.GeneralTranslatorEditorPage_ISPF_TSO_COMMAND_MEMBER_LABEL);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fISPFTSOCommandLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fISPFTSOCommandLabel, Messages.GeneralTranslatorEditorPage_ISPF_TSO_COMMAND_MEMBER_TOOLTIP, false);
        String ispfTSOCommandText = "";
        if (this.fTranslatorWorkingCopy.getCallMethod() == 1 || this.fTranslatorWorkingCopy.getCallMethod() == 2) {
            ispfTSOCommandText = this.fTranslatorWorkingCopy.getCommandMember();
        }
        this.fISPFTSOCommandText = this.fToolkit.createText(this.compositeISPFTSO, ispfTSOCommandText, 256);
        this.fISPFTSOCommandText.setTextLimit(250);
        GridData gridData = new GridData();
        gridData.grabExcessHorizontalSpace = false;
        gridData.horizontalAlignment = 4;
        gridData.grabExcessVerticalSpace = false;
        gridData.verticalAlignment = 4;
        gridData.widthHint = 100;
        this.fISPFTSOCommandText.setLayoutData((Object)gridData);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fISPFTSOCommandText, Messages.GeneralTranslatorEditorPage_ISPF_TSO_COMMAND_MEMBER_TOOLTIP, false);
        this.fISPFTSOCommandText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCommandMember(GeneralTranslatorEditorPage.this.fISPFTSOCommandText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validate();
            }
        });
        this.fISPFLogPublishLabel = this.fToolkit.createLabel(this.compositeISPFTSO, Messages.GeneralTranslatorEditorPage_ISPF_LOG_PUBLISH_TYPE);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fISPFLogPublishLabel);
        Composite ispfPublishTypeComposite = this.fToolkit.createComposite(this.compositeISPFTSO);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ispfPublishTypeComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(ispfPublishTypeComposite);
        this.fISPFLogPublishInherited = this.createISPFPublishTypeButton(ispfPublishTypeComposite, Messages.DDAllocationDialog_PUBLISH_INHERIT_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_PUBLISH_INHERIT_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogPublishInherited);
        this.fISPFLogPublishNever = this.createISPFPublishTypeButton(ispfPublishTypeComposite, Messages.DDAllocationDialog_PUBLISH_NEVER_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_PUBLISH_NEVER_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogPublishNever);
        this.fISPFLogPublishAlways = this.createISPFPublishTypeButton(ispfPublishTypeComposite, Messages.DDAllocationDialog_PUBLISH_ALWAYS_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_PUBLISH_ALWAYS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogPublishAlways);
        this.fISPFLogPublishOnError = this.createISPFPublishTypeButton(ispfPublishTypeComposite, Messages.DDAllocationDialog_PUBLISH_ON_ERROR_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_PUBLISH_ON_ERROR_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogPublishOnError);
        this.fISPFLogConsolidateLabel = this.fToolkit.createLabel(this.compositeISPFTSO, Messages.GeneralTranslatorEditorPage_ISPF_LOG_CONSOLIDATE);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).applyTo((Control)this.fISPFLogConsolidateLabel);
        Composite ispfConsolidateComposite = this.fToolkit.createComposite(this.compositeISPFTSO);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)ispfConsolidateComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(ispfConsolidateComposite);
        this.fISPFLogConsolidateInherited = this.createISPFConsolidateButton(ispfConsolidateComposite, Messages.DDAllocationDialog_CONSOLIDATE_INHERIT_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_CONSOLIDATE_INHERIT_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogConsolidateInherited);
        this.fISPFLogConsolidateNever = this.createISPFConsolidateButton(ispfConsolidateComposite, Messages.DDAllocationDialog_CONSOLIDATE_NEVER_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_CONSOLIDATE_NEVER_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogConsolidateNever);
        this.fISPFLogConsolidateAlways = this.createISPFConsolidateButton(ispfConsolidateComposite, Messages.DDAllocationDialog_CONSOLIDATE_ALWAYS_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_CONSOLIDATE_ALWAYS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogConsolidateAlways);
        this.fISPFLogConsolidateOnSuccess = this.createISPFConsolidateButton(ispfConsolidateComposite, Messages.DDAllocationDialog_CONSOLIDATE_ON_SUCCESS_LABEL, Messages.GeneralTranslatorEditorPage_ISPF_LOG_CONSOLIDATE_ON_SUCCESS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fISPFLogConsolidateOnSuccess);
        this.fISPFLogCompact = this.fToolkit.createButton(this.compositeISPFTSO, Messages.GeneralTranslatorEditorPage_ISPF_LOG_COMPACT, 32);
        GridDataFactory.fillDefaults().align(1, 0x1000000).indent(20, -1).span(2, 1).applyTo((Control)this.fISPFLogCompact);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fISPFLogCompact, Messages.GeneralTranslatorEditorPage_ISPF_LOG_COMPACT_TOOLTIP, false);
        this.fISPFLogCompact.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setISPFLogCompact(GeneralTranslatorEditorPage.this.fISPFLogCompact.getSelection());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        switch (this.fTranslatorWorkingCopy.getISPFLogPublishType()) {
            case 2: {
                this.fISPFLogPublishAlways.setSelection(true);
                break;
            }
            case 0: {
                this.fISPFLogPublishNever.setSelection(true);
                break;
            }
            case 3: {
                this.fISPFLogPublishOnError.setSelection(true);
                break;
            }
            default: {
                this.fISPFLogPublishInherited.setSelection(true);
            }
        }
        switch (this.fTranslatorWorkingCopy.getISPFLogConsolidate()) {
            case 2: {
                this.fISPFLogConsolidateAlways.setSelection(true);
                break;
            }
            case 1: {
                this.fISPFLogConsolidateNever.setSelection(true);
                break;
            }
            case 3: {
                this.fISPFLogConsolidateOnSuccess.setSelection(true);
                break;
            }
            default: {
                this.fISPFLogConsolidateInherited.setSelection(true);
            }
        }
        this.fISPFLogCompact.setSelection(this.fTranslatorWorkingCopy.isISPFLogCompact());
        this.updateISPFGatewayLogEnablement();
        this.fCallMethodAntScriptButton = this.createCallMethodButton(composite, Messages.GeneralTranslatorEditorPage_ANT_LABEL, 16);
        GridDataFactory.fillDefaults().align(1, 1).span(1, -1).indent(3, -1).applyTo((Control)this.fCallMethodAntScriptButton);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 3) {
            this.fCallMethodAntScriptButton.setSelection(true);
        }
        this.createAntScriptSubSection(composite);
        this.createBuildFileSubSection(composite);
        Label maxLabel = this.fToolkit.createLabel(composite, Messages.GeneralTranslatorEditorPage_MAX_RC_LABEL);
        GridDataFactory.fillDefaults().indent(3, -1).applyTo((Control)maxLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)maxLabel, Messages.GeneralTranslatorEditorPage_MAX_RC_TOOLTIP, false);
        this.fMaxRCText = this.fToolkit.createText(composite, Integer.toString(this.fTranslatorWorkingCopy.getMaxRC()));
        GridDataFactory.fillDefaults().grab(true, false).indent(3, -1).applyTo((Control)this.fMaxRCText);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fMaxRCText, Messages.GeneralTranslatorEditorPage_MAX_RC_TOOLTIP, false);
        this.fMaxRCText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralTranslatorEditorPage.this.validateMaxRC()) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setMaxRC(new Integer(GeneralTranslatorEditorPage.this.fMaxRCText.getText().trim()).intValue());
                }
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
    }

    private void createBuildFileSubSection(Composite parent) {
        this.fCallMethodBuildfileButton = this.createCallMethodButton(parent, Messages.GeneralTranslatorEditorPage_CALLED_BUILDFILE_LABEL, 16);
        GridDataFactory.fillDefaults().span(2, -1).indent(3, -1).applyTo((Control)this.fCallMethodBuildfileButton);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 4) {
            this.fCallMethodBuildfileButton.setSelection(true);
        }
        this.buildfileOptionsComposite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).indent(15, -1).applyTo((Control)this.buildfileOptionsComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).equalWidth(false).applyTo(this.buildfileOptionsComposite);
        this.buildFileSectionLabel = new Text(this.buildfileOptionsComposite, 8);
        this.buildFileSectionLabel.setText(Messages.GeneralTranslatorEditorPage_CALLED_BUILDFILE_PROMPT);
        this.buildFileSectionLabel.setForeground(this.getEditor().getToolkit().getColors().getColor("org.eclipse.ui.forms.TITLE"));
        GridDataFactory.fillDefaults().span(2, -1).indent(0, -1).grab(true, false).applyTo((Control)this.buildFileSectionLabel);
        this.createBuildFileWidgets(this.buildfileOptionsComposite);
        this.createBuildTargetWidgets(this.buildfileOptionsComposite);
    }

    protected void createBuildFileWidgets(Composite parent) {
        this.buildFileLabel = this.fToolkit.createLabel(parent, Messages.GeneralTranslatorEditorPage_BUILD_FILE_LABEL);
        String defaultText = this.fTranslatorWorkingCopy.getCallMethod() == 4 ? this.fTranslatorWorkingCopy.getCommandMember() : "";
        this.buildFileText = this.fToolkit.createText(parent, defaultText);
        GridDataFactory.fillDefaults().span(1, -1).indent(3, -1).applyTo((Control)this.buildFileText);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.buildFileText, Messages.GeneralTranslatorEditorPage_BUILD_FILE_TOOLTIP, true);
        this.buildFileText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCommandMember(GeneralTranslatorEditorPage.this.buildFileText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validate();
            }
        });
    }

    protected void createBuildTargetWidgets(Composite parent) {
        this.buildTargetsLabel = this.fToolkit.createLabel(parent, Messages.GeneralTranslatorEditorPage_BUILD_FILE_TARGETS_LABEL);
        String defaultTargetText = this.fTranslatorWorkingCopy.getCallMethod() == 4 ? this.fTranslatorWorkingCopy.getDdNameList() : "";
        this.buildTargetsText = this.fToolkit.createText(parent, defaultTargetText);
        GridDataFactory.fillDefaults().span(1, -1).indent(3, -1).applyTo((Control)this.buildTargetsText);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.buildTargetsText, Messages.GeneralTranslatorEditorPage_BUILD_FILE_TARGETS_TOOLTIP, true);
        this.buildTargetsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setDdNameList(GeneralTranslatorEditorPage.this.buildTargetsText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.buildReturnPropsLabel = this.fToolkit.createLabel(parent, Messages.GeneralTranslatorEditorPage_BUILD_FILE_RETURN_LABEL);
        if (this.fTranslatorWorkingCopy.getCallMethod() == 4) {
            this.buildTargetsText.setText(this.fTranslatorWorkingCopy.getDdNameList());
        }
        String defaultReturnText = this.fTranslatorWorkingCopy.getCallMethod() == 4 ? this.fTranslatorWorkingCopy.getDefaultOptions() : "";
        this.buildReturnPropsText = this.fToolkit.createText(parent, defaultReturnText);
        GridDataFactory.fillDefaults().span(1, -1).indent(3, -1).applyTo((Control)this.buildReturnPropsText);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.buildReturnPropsText, Messages.GeneralTranslatorEditorPage_BUILD_FILE_RETURN_TOOLTIP, true);
        this.buildReturnPropsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setDefaultOptions(GeneralTranslatorEditorPage.this.buildReturnPropsText.getText().trim());
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
    }

    public static void addTooltipWithWrapping(Control control, final String tooltip, boolean isFocusable) {
        new TooltipSupport(control, isFocusable, false, true){

            protected String getMarkup(Object element, boolean isFocus) {
                return tooltip;
            }

            public Object getElement(Control control, int x, int y) {
                Object o = super.getElement(control, x, y);
                if (o == null) {
                    o = control;
                }
                return o;
            }
        };
    }

    private void createAntScriptSubSection(Composite parent) {
        this.fAntSubSection = this.fToolkit.createSection(parent, 258);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fAntSubSection.setEnabled(false);
        }
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.fAntSubSection);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(10, -1).applyTo((Composite)this.fAntSubSection);
        this.fAntSubSection.setText(Messages.GeneralTranslatorEditorPage_ANT_LABEL_STAR);
        Composite container = this.fToolkit.createComposite((Composite)this.fAntSubSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)container);
        GridLayoutFactory.fillDefaults().numColumns(1).spacing(10, -1).applyTo(container);
        this.fAntSubSection.setClient((Control)container);
        this.fAntSnippetViewer = new AntSnippetViewer(container, 68354, Activator.getDefault().getDocumentProvider());
        this.fAntSnippetViewer.configure((SourceViewerConfiguration)new AntSnippetSourceViewerConfiguration(this.fAntSnippetViewer));
        Control control = this.fAntSnippetViewer.getControl();
        GridData data = new GridData(4, 4, true, true);
        data.heightHint = this.fAntSnippetViewer.getTextWidget().getLineHeight() * 10;
        control.setLayoutData((Object)data);
    }

    private void createDataSetSection(Composite parent) {
        this.fDataSetSection = this.fToolkit.createSection(parent, 322);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fDataSetSection.setEnabled(false);
        }
        FormData formData = new FormData();
        formData.top = new FormAttachment((Control)this.fCallMethodSection, 10);
        formData.left = new FormAttachment(0, 10);
        formData.right = new FormAttachment(100);
        this.fDataSetSection.setLayoutData((Object)formData);
        this.fDataSetSection.setLayout((Layout)new GridLayout(1, false));
        this.fDataSetSection.setText(Messages.GeneralTranslatorEditorPage_DatasetProperties);
        this.datasetComposite = this.fToolkit.createComposite((Composite)this.fDataSetSection);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)this.datasetComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).spacing(10, -1).applyTo(this.datasetComposite);
        this.fDataSetSection.setClient((Control)this.datasetComposite);
        Composite composite = this.fToolkit.createComposite(this.datasetComposite);
        GridDataFactory.fillDefaults().grab(true, true).align(4, 4).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(composite);
        this.concatsLabel = new Text(composite, 72);
        this.concatsLabel.setText(Messages.GeneralTranslatorEditorPage_CONCATS_LABEL);
        GridDataFactory.fillDefaults().span(3, -1).indent(3, 5).applyTo((Control)this.concatsLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.concatsLabel, Messages.GeneralTranslatorEditorPage_CONCATS_TOOLTIP, false);
        this.fConcatsControl = new ConcatenationsControl(composite, this.fToolkit, null, this.getTeamRepository(), this.isEditable(), this.getSystemDefinitionCache(), this.validator);
        this.fConcatsControl.addListener(this.fConcatsListener);
        this.ddAllocsLabel = new Text(composite, 72);
        this.ddAllocsLabel.setText(Messages.GeneralTranslatorEditorPage_DD_ALLOCATIONS_LABEL);
        GridDataFactory.fillDefaults().span(3, -1).indent(3, 5).applyTo((Control)this.ddAllocsLabel);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.ddAllocsLabel, Messages.GeneralTranslatorEditorPage_DD_ALLOCATIONS_TOOLTIP, false);
        this.fDDAllocationsControl = new DDAllocationsControl(composite, this.fToolkit, null, this.fTranslatorWorkingCopy.getVariables(), this.getTeamRepository(), this.isEditable(), this.getSystemDefinitionCache(), this.validator);
        this.fDDAllocationsControl.addListener(this.fDatasetDefsListener);
        boolean enabled = this.fCallMethodAntScriptButton == null || this.fCallMethodBuildfileButton == null || !this.fCallMethodBuildfileButton.getSelection() && !this.fCallMethodAntScriptButton.getSelection();
        this.fDataSetSection.setEnabled(enabled);
        this.fDataSetSection.setExpanded(enabled);
        this.createContributedTranslatorTypesWidget(composite);
    }

    private void createVariablesSection(Composite parent) {
        this.fVariablesSection = this.fToolkit.createSection(parent, 450);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fVariablesSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fDataSetSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fVariablesSection.setLayoutData((Object)data);
        this.fVariablesSection.setLayout((Layout)new GridLayout(1, false));
        this.fVariablesSection.setText(Messages.GeneralTranslatorEditorPage_Variables);
        this.fVariablesSection.setDescription(Messages.GeneralTranslatorEditorPage_VariablesTableTooltip);
        Composite composite = this.fToolkit.createComposite((Composite)this.fVariablesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fVariablesSection.setClient((Control)composite);
        this.createVariableTable(composite);
    }

    private void createOutputsSection(Composite parent) {
        this.fOutputsSection = this.fToolkit.createSection(parent, 450);
        if (this.fTranslatorWorkingCopy != null && this.fTranslatorWorkingCopy.isArchived()) {
            this.fOutputsSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fVariablesSection, 10);
        data.left = new FormAttachment(0, 10);
        data.right = new FormAttachment(100);
        this.fOutputsSection.setLayoutData((Object)data);
        this.fOutputsSection.setLayout((Layout)new GridLayout(1, false));
        this.fOutputsSection.setText(Messages.GeneralTranslatorEditorPage_Outputs);
        this.fOutputsSection.setDescription(Messages.GeneralTranslatorEditorPage_OutputsTableTooltip);
        Composite composite = this.fToolkit.createComposite((Composite)this.fOutputsSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        composite.setLayout((Layout)new GridLayout(4, false));
        this.fOutputsSection.setClient((Control)composite);
        this.createOutputTable(composite);
        boolean enabled = this.fCallMethodCalledProgramButton == null || this.fCallMethodISPFTSOButton == null || !this.fCallMethodCalledProgramButton.getSelection() && !this.fCallMethodISPFTSOButton.getSelection();
        this.fOutputsSection.setEnabled(enabled);
        this.fOutputsSection.setExpanded(enabled);
    }

    private Button createISPFPublishTypeButton(Composite parent, String text, String tooltip, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = GeneralTranslatorEditorPage.this.fISPFLogPublishAlways.getSelection() ? 2 : (GeneralTranslatorEditorPage.this.fISPFLogPublishNever.getSelection() ? 0 : (GeneralTranslatorEditorPage.this.fISPFLogPublishOnError.getSelection() ? 3 : 1));
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setISPFLogPublishType(value);
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.updateISPFGatewayLogEnablement();
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, false);
        return radioButton;
    }

    private void updateISPFGatewayLogEnablement() {
        boolean isISPForTSO = this.fCallMethodISPFTSOButton.getSelection();
        boolean isNeverPublish = this.fISPFLogPublishNever.getSelection();
        this.fISPFLogPublishLabel.setEnabled(isISPForTSO);
        this.fISPFLogPublishAlways.setEnabled(isISPForTSO);
        this.fISPFLogPublishNever.setEnabled(isISPForTSO);
        this.fISPFLogPublishInherited.setEnabled(isISPForTSO);
        this.fISPFLogPublishOnError.setEnabled(isISPForTSO);
        this.fISPFLogConsolidateAlways.setEnabled(isISPForTSO && !isNeverPublish);
        this.fISPFLogConsolidateInherited.setEnabled(isISPForTSO && !isNeverPublish);
        this.fISPFLogConsolidateLabel.setEnabled(isISPForTSO && !isNeverPublish);
        this.fISPFLogConsolidateNever.setEnabled(isISPForTSO && !isNeverPublish);
        this.fISPFLogConsolidateOnSuccess.setEnabled(isISPForTSO && !isNeverPublish);
        this.fISPFLogCompact.setEnabled(isISPForTSO && !isNeverPublish);
    }

    private Button createISPFConsolidateButton(Composite parent, String text, String tooltip, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = 0;
                if (GeneralTranslatorEditorPage.this.fISPFLogConsolidateAlways.getSelection()) {
                    value = 2;
                } else if (GeneralTranslatorEditorPage.this.fISPFLogConsolidateNever.getSelection()) {
                    value = 1;
                } else if (GeneralTranslatorEditorPage.this.fISPFLogConsolidateOnSuccess.getSelection()) {
                    value = 3;
                }
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setISPFLogConsolidate(value);
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, false);
        return radioButton;
    }

    private Button createCallMethodButton(Composite parent, String text, int style) {
        Button button = this.fToolkit.createButton(parent, text, style);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralTranslatorEditorPage.this.fCallMethodCalledProgramButton.getSelection()) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(0);
                } else if (GeneralTranslatorEditorPage.this.fCallMethodISPFTSOButton.getSelection()) {
                    if (GeneralTranslatorEditorPage.this.fTSOButton.getSelection()) {
                        GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(2);
                    } else {
                        GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(1);
                    }
                } else if (GeneralTranslatorEditorPage.this.fCallMethodAntScriptButton.getSelection()) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(3);
                } else {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(4);
                }
                GeneralTranslatorEditorPage.this.handleCallMethodUpdate();
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validate();
                GeneralTranslatorEditorPage.this.previousCallMethod = GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getCallMethod();
            }
        });
        return button;
    }

    private Button createISPFTSOButton(Composite parent, String text, int style) {
        Button button = this.fToolkit.createButton(parent, text, style);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (GeneralTranslatorEditorPage.this.fTSOButton.getSelection()) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(2);
                } else if (GeneralTranslatorEditorPage.this.fISPFButton.getSelection()) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setCallMethod(1);
                }
                GeneralTranslatorEditorPage.this.setDirty(true);
                GeneralTranslatorEditorPage.this.validate();
            }
        });
        return button;
    }

    private void handleCallMethodUpdate() {
        boolean enabled;
        boolean programSelected = this.fCallMethodCalledProgramButton.getSelection();
        if (!programSelected) {
            this.fTranslatorDataDefinitionText.setText("");
            this.fDefaultCompileOptsText.setText("");
            this.fDDList.setText("");
            this.fLinkEditCheckbox.setSelection(false);
            this.fTranslatorWorkingCopy.setDataSetDefinition(null);
            this.fTranslatorWorkingCopy.setDefaultOptions(null);
            this.fTranslatorWorkingCopy.setDdNameList(null);
            this.fTranslatorWorkingCopy.setLinkEdit(false);
        }
        this.fTranslatorDataDefinitionLabel.setEnabled(programSelected);
        this.fTranslatorDataDefinitionText.setEnabled(programSelected);
        this.fLinkEditCheckbox.setEnabled(programSelected);
        this.fBrowseButton.setEnabled(programSelected);
        this.fDefaultCompileOptsText.setEnabled(programSelected);
        this.fDefaultCompileOptsLabel.setEnabled(programSelected);
        this.fDDList.setEnabled(programSelected);
        this.fDDListLabel.setEnabled(programSelected);
        boolean ispfTSOSelected = this.fCallMethodISPFTSOButton.getSelection();
        if (!ispfTSOSelected) {
            this.fTranslatorWorkingCopy.setCommandMember(null);
            this.fTranslatorWorkingCopy.setISPFLogPublishType(1);
            this.fTranslatorWorkingCopy.setISPFLogConsolidate(1);
            this.fTranslatorWorkingCopy.setISPFLogCompact(false);
            this.fISPFButton.setSelection(true);
            this.fISPFTSOCommandText.setText("");
            this.fISPFLogPublishInherited.setSelection(true);
            this.fISPFLogPublishAlways.setSelection(false);
            this.fISPFLogPublishNever.setSelection(false);
            this.fISPFLogPublishOnError.setSelection(false);
            this.fISPFLogConsolidateInherited.setSelection(true);
            this.fISPFLogConsolidateAlways.setSelection(false);
            this.fISPFLogConsolidateNever.setSelection(false);
            this.fISPFLogConsolidateOnSuccess.setSelection(false);
            this.fISPFLogCompact.setSelection(false);
        }
        this.fISPFTSOCommandText.setEnabled(ispfTSOSelected);
        this.fISPFTSOCommandLabel.setEnabled(ispfTSOSelected);
        this.fISPFButton.setEnabled(ispfTSOSelected);
        this.fTSOButton.setEnabled(ispfTSOSelected);
        this.updateISPFGatewayLogEnablement();
        boolean antSnippetSelected = this.fCallMethodAntScriptButton.getSelection();
        if (!antSnippetSelected) {
            this.fTranslatorWorkingCopy.setAntSnippet("");
        }
        this.fAntSubSection.setEnabled(antSnippetSelected);
        this.fAntSubSection.setExpanded(antSnippetSelected);
        boolean buildFileSelected = this.fCallMethodBuildfileButton.getSelection();
        if (!buildFileSelected) {
            this.fTranslatorWorkingCopy.setCommandMember(null);
            this.fTranslatorWorkingCopy.setDdNameList(null);
            this.fTranslatorWorkingCopy.setDefaultOptions(null);
            this.buildFileText.setText("");
            this.buildTargetsText.setText("");
            this.buildReturnPropsText.setText("");
        }
        this.buildFileSectionLabel.setEnabled(buildFileSelected);
        this.buildFileText.setEnabled(buildFileSelected);
        this.buildFileLabel.setEnabled(buildFileSelected);
        this.buildTargetsText.setEnabled(buildFileSelected);
        this.buildTargetsLabel.setEnabled(buildFileSelected);
        this.buildReturnPropsText.setEnabled(buildFileSelected);
        this.buildReturnPropsLabel.setEnabled(buildFileSelected);
        if (this.fDataSetSection != null) {
            enabled = programSelected || ispfTSOSelected;
            this.fDataSetSection.setEnabled(enabled);
            this.fDataSetSection.setExpanded(enabled);
        }
        if (this.fOutputsSection != null) {
            enabled = antSnippetSelected || buildFileSelected;
            this.fOutputsSection.setEnabled(enabled);
            this.fOutputsSection.setExpanded(enabled);
        }
        if (!antSnippetSelected) {
            if (this.fSnippetListener != null) {
                this.fAntSnippetViewer.removeScriptChangeListener((AntSnippetTranslatorListener)this.fSnippetListener);
                this.fAntSnippetViewer.getTextWidget().removeModifyListener((ModifyListener)this.fSnippetListener);
            }
        } else {
            if (this.fSnippetListener == null) {
                this.fSnippetListener = new AntSnippetListener();
            }
            this.fAntSnippetViewer.addScriptChangeListener((AntSnippetTranslatorListener)this.fSnippetListener);
            this.fAntSnippetViewer.getTextWidget().addModifyListener((ModifyListener)this.fSnippetListener);
        }
        if (buildFileSelected) {
            this.buildFileText.setText(this.buildFileText.getText());
            this.buildTargetsText.setText(this.buildTargetsText.getText());
            this.buildReturnPropsText.setText(this.buildReturnPropsText.getText());
        } else if (antSnippetSelected) {
            if (this.fAntSnippetViewer.getInput() != null) {
                this.fAntSnippetViewer.getTextWidget().setText(this.fAntSnippetViewer.getTextWidget().getText());
            }
        } else if (ispfTSOSelected) {
            this.fISPFTSOCommandText.setText(this.fISPFTSOCommandText.getText());
        } else if (programSelected) {
            this.fDefaultCompileOptsText.setText(this.fDefaultCompileOptsText.getText());
            this.fDDList.setText(this.fDDList.getText());
        }
    }

    @Override
    public void setActive(boolean active) {
        super.setActive(active);
        this.getManagedForm().reflow(true);
    }

    private void createContributedTranslatorTypesWidget(Composite composite) {
        List<ITranslatorType> types = this.getTranslatorTypes();
        if (types.size() != 0) {
            final ITranslatorType t = types.get(0);
            this.contributedTypeButton = this.fToolkit.createButton(composite, t.getLabel(), 32);
            GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.contributedTypeButton, t.getTooltip(), false);
            List setTypes = this.fTranslatorWorkingCopy.getSpecialTypes();
            for (IStringHelper s : setTypes) {
                if (!s.getValue().equals(t.getId())) continue;
                this.contributedTypeButton.setSelection(true);
                break;
            }
            GridData data = new GridData();
            data.horizontalSpan = 3;
            this.contributedTypeButton.setLayoutData((Object)data);
            this.contributedTypeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    List setTypes = GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getSpecialTypes();
                    setTypes.clear();
                    if (GeneralTranslatorEditorPage.this.contributedTypeButton.getSelection()) {
                        StringHelper helper = ModelFactory.eINSTANCE.createStringHelper();
                        helper.setValue(t.getId());
                        setTypes.add(helper);
                    }
                    GeneralTranslatorEditorPage.this.setDirty(true);
                }
            });
        }
    }

    private SelectionListener getBrowseButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralTranslatorEditorPage.this.editDataDefinition();
            }
        };
    }

    @Override
    public void setDirty(boolean isDirty) {
        if (!this.dontSetDirty) {
            super.setDirty(isDirty);
        }
    }

    protected IGenericListener getConcatenationsListener() {
        return new IGenericListener(){

            public void contentsModified() {
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        };
    }

    private void editDataDefinition() {
        try {
            ISystemDefinition dsdef;
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.fParent.getShell(), this.getTeamRepository(), null, this.getDataSetDefFilter(), Messages.GeneralTranslatorEditorPage_TRANSLATOR_DSDEF_HELP, true, this.getSystemDefinitionCache());
            if (dialog.open() == 0 && (dsdef = dialog.getSelectedSystemDefinition()) instanceof IDataSetDefinition) {
                this.fTranslatorWorkingCopy.setDataSetDefinition((IDataSetDefinitionHandle)((IDataSetDefinition)dsdef));
                this.updateDataDefinitionText();
                this.setDirty(true);
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private ViewerFilter getDataSetDefFilter() {
        return new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (!(element instanceof IDataSetDefinition)) {
                    return true;
                }
                IDataSetDefinition dsd = (IDataSetDefinition)element;
                if (dsd.getUsageType() != 3) {
                    return false;
                }
                return dsd.getDsMember() != null && !dsd.getDsMember().isEmpty();
            }
        };
    }

    private void updateDataDefinitionText() {
        if (this.fTranslatorWorkingCopy.getDataSetDefinition() != null) {
            this.fTranslatorDataDefinitionText.setText(Messages.GeneralTranslatorEditorPage_PENDING);
            DataDefinitionEntryLabelHelper labelHelper = this.getLabelHelper();
            DataDefinitionEntry dde = ModelFactory.eINSTANCE.createDataDefinitionEntry();
            dde.setKind("com.ibm.teamz.langdef.entry.data_definition");
            dde.setValue(this.fTranslatorWorkingCopy.getDataSetDefinition().getItemId().getUuidValue());
            IModeledDataDefinitionEntryContext context = this.getDataDefinitionEntryContext((com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry)dde);
            labelHelper.getDataDefinitionEntryValueLabelInBackground(context);
        }
    }

    protected DataDefinitionEntryLabelHelper getLabelHelper() {
        return new DataDefinitionEntryLabelHelper(this.getSystemDefinitionCache()){

            @Override
            public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!GeneralTranslatorEditorPage.this.fTranslatorDataDefinitionText.isDisposed()) {
                    GeneralTranslatorEditorPage.this.fTranslatorDataDefinitionText.setText(label);
                    GeneralTranslatorEditorPage.this.validate();
                }
            }
        };
    }

    protected IModeledDataDefinitionEntryContext getDataDefinitionEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        return new IModeledDataDefinitionEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry getModeledEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return GeneralTranslatorEditorPage.this.getTeamRepository();
            }

            @Override
            public IDataDefinitionEntry getEntry() {
                return null;
            }
        };
    }

    private void createVariableTable(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, false).indent(5, 3).applyTo((Control)tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnHeaders = new String[]{Messages.GeneralTranslatorEditorPage_NameCol, Messages.GeneralTranslatorEditorPage_ValueCol};
        int[] columnWeights = new int[]{50, 50};
        TableColumnLayout tcl = new TableColumnLayout();
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        ((GridData)tableComposite.getLayoutData()).heightHint = table.getItemHeight() * 10;
        tableComposite.setLayout((Layout)tcl);
        this.fVariableTableViewer = new TableViewer(table);
        this.fVariableTableViewer.setContentProvider((IContentProvider)new VariableContentProvider());
        this.fVariableTableViewer.setLabelProvider((IBaseLabelProvider)new VariableLabelProvider());
        this.fVariableTableViewer.setInput((Object)this.fTranslatorWorkingCopy.getVariables());
        if (this.isEditable()) {
            this.fVariableTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    GeneralTranslatorEditorPage.this.updateVariableButtonEnablement();
                }
            });
            this.fVariableTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IVariable) {
                        IVariable variable = (IVariable)element;
                        GeneralTranslatorEditorPage.this.editVariable(variable);
                    }
                }
            });
        }
        Composite buttonBar = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fAddVariableButton = this.fToolkit.createButton(buttonBar, Messages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fAddVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                CreateVariableDialog dialog = new CreateVariableDialog(GeneralTranslatorEditorPage.this.getSite().getShell(), null, GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables(), Messages.GeneralTranslatorEditorPage_CreateVariableTitle, Messages.GeneralTranslatorEditorPage_CreateVariableDescription);
                if (dialog.open() == 0) {
                    IVariable newVariable = dialog.getVariable();
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().add(newVariable);
                    GeneralTranslatorEditorPage.this.fVariableTableViewer.getContentProvider().inputChanged((Viewer)GeneralTranslatorEditorPage.this.fVariableTableViewer, null, (Object)GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables());
                    GeneralTranslatorEditorPage.this.fVariableTableViewer.refresh();
                    GeneralTranslatorEditorPage.this.fVariableTableViewer.setSelection((ISelection)new StructuredSelection((Object)newVariable));
                    GeneralTranslatorEditorPage.this.updateVariableButtonEnablement();
                    GeneralTranslatorEditorPage.this.setDirty(true);
                }
            }
        });
        this.fEditVariableButton = this.fToolkit.createButton(buttonBar, Messages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GeneralTranslatorEditorPage.this.fVariableTableViewer.getSelection();
                IVariable variable = (IVariable)selection.getFirstElement();
                if (variable != null) {
                    GeneralTranslatorEditorPage.this.editVariable(variable);
                }
            }
        });
        this.fRemoveVariableButton = this.fToolkit.createButton(buttonBar, Messages.REMOVE_BUTTON_LABEL, 8);
        this.fRemoveVariableButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                ISelection selection = GeneralTranslatorEditorPage.this.fVariableTableViewer.getSelection();
                for (Object remove : (IStructuredSelection)selection) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().remove(remove);
                    GeneralTranslatorEditorPage.this.fVariableTableViewer.remove(remove);
                }
                GeneralTranslatorEditorPage.this.fVariableTableViewer.getContentProvider().inputChanged((Viewer)GeneralTranslatorEditorPage.this.fVariableTableViewer, null, (Object)GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables());
                GeneralTranslatorEditorPage.this.fVariableTableViewer.refresh();
                GeneralTranslatorEditorPage.this.updateVariableButtonEnablement();
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.fUpVariableButton = this.fToolkit.createButton(buttonBar, Messages.UP_BUTTON_LABEL, 8);
        this.fUpVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                IStructuredSelection selection = (IStructuredSelection)GeneralTranslatorEditorPage.this.fVariableTableViewer.getSelection();
                IVariable variable = (IVariable)selection.getFirstElement();
                int index = GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().indexOf(variable);
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().remove(variable);
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().add(index - 1, variable);
                GeneralTranslatorEditorPage.this.fVariableTableViewer.getContentProvider().inputChanged((Viewer)GeneralTranslatorEditorPage.this.fVariableTableViewer, null, (Object)GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables());
                GeneralTranslatorEditorPage.this.fVariableTableViewer.refresh();
                GeneralTranslatorEditorPage.this.updateVariableButtonEnablement();
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.fDownVariableButton = this.fToolkit.createButton(buttonBar, Messages.DOWN_BUTTON_LABEL, 8);
        this.fDownVariableButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)GeneralTranslatorEditorPage.this.fVariableTableViewer.getSelection();
                IVariable variable = (IVariable)selection.getFirstElement();
                int index = GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().indexOf(variable);
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().remove(variable);
                GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables().add(index + 1, variable);
                GeneralTranslatorEditorPage.this.fVariableTableViewer.getContentProvider().inputChanged((Viewer)GeneralTranslatorEditorPage.this.fVariableTableViewer, null, (Object)GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getVariables());
                GeneralTranslatorEditorPage.this.fVariableTableViewer.refresh();
                GeneralTranslatorEditorPage.this.updateVariableButtonEnablement();
                GeneralTranslatorEditorPage.this.setDirty(true);
            }
        });
        this.updateVariableButtonEnablement();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddVariableButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEditVariableButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveVariableButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fUpVariableButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDownVariableButton);
    }

    private void createOutputTable(Composite parent) {
        Composite composite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().grab(true, true).hint(1, -1).applyTo((Control)composite);
        GridLayoutFactory.fillDefaults().applyTo(composite);
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, false).indent(5, 3).applyTo((Control)tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        String[] columnHeaders = new String[]{Messages.GeneralTranslatorEditorPage_OutputsCol, Messages.GeneralTranslatorEditorPage_Outputs_Condition_Col, Messages.GeneralTranslatorEditorPage_Outputs_DeployType_Col};
        int[] columnWeights = new int[]{50, 25, 25};
        TableColumnLayout tcl = new TableColumnLayout();
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        ((GridData)tableComposite.getLayoutData()).heightHint = table.getItemHeight() * 5;
        tableComposite.setLayout((Layout)tcl);
        this.fOutputTableViewer = new TableViewer(table);
        this.fOutputTableViewer.setContentProvider((IContentProvider)new OutputContentProvider());
        this.fOutputTableViewer.setLabelProvider((IBaseLabelProvider)new OutputLabelProvider());
        this.fOutputTableViewer.setInput((Object)this.fTranslatorWorkingCopy.getHFSOutputs());
        if (this.isEditable()) {
            this.fOutputTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    GeneralTranslatorEditorPage.this.updateOutputButtonEnablement();
                }
            });
            this.fOutputTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ISelection selection = event.getSelection();
                    if (!(selection instanceof IStructuredSelection)) {
                        return;
                    }
                    Object element = ((IStructuredSelection)selection).getFirstElement();
                    if (element instanceof IHFSOutput) {
                        IHFSOutput output = (IHFSOutput)element;
                        GeneralTranslatorEditorPage.this.editOutput(output);
                    }
                }
            });
        }
        Composite buttonBar = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fAddOutputButton = this.fToolkit.createButton(buttonBar, Messages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fAddOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                CreateOutputDialog dialog = new CreateOutputDialog(GeneralTranslatorEditorPage.this.getSite().getShell(), null, GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getHFSOutputs(), Messages.GeneralTranslatorEditorPage_CreateOutputTitle, Messages.GeneralTranslatorEditorPage_CreateOutputDescription);
                if (dialog.open() == 0) {
                    IHFSOutput newOutput = dialog.getOutput();
                    List<IHFSOutput> currentList = ((OutputContentProvider)GeneralTranslatorEditorPage.this.fOutputTableViewer.getContentProvider()).getOutputList();
                    if (currentList != null) {
                        currentList.add(newOutput);
                        GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getHFSOutputs().add(newOutput);
                    }
                    GeneralTranslatorEditorPage.this.fOutputTableViewer.refresh();
                    GeneralTranslatorEditorPage.this.setDirty(true);
                }
            }
        });
        this.fEditOutputButton = this.fToolkit.createButton(buttonBar, Messages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                IHFSOutput initialVariable = null;
                Object tableSelection = ((StructuredSelection)GeneralTranslatorEditorPage.this.fOutputTableViewer.getSelection()).getFirstElement();
                if (tableSelection instanceof IHFSOutput) {
                    initialVariable = (IHFSOutput)tableSelection;
                }
                if (initialVariable != null) {
                    GeneralTranslatorEditorPage.this.editOutput(initialVariable);
                }
            }
        });
        this.fRemoveOutputButton = this.fToolkit.createButton(buttonBar, Messages.REMOVE_BUTTON_LABEL, 8);
        this.fRemoveOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent event) {
            }

            public void widgetSelected(SelectionEvent event) {
                List<IHFSOutput> outputList;
                ISelection selection = GeneralTranslatorEditorPage.this.fOutputTableViewer.getSelection();
                ArrayList<IHFSOutput> toRemove = new ArrayList<IHFSOutput>(((IStructuredSelection)selection).size());
                for (Object o : (IStructuredSelection)selection) {
                    if (!(o instanceof IHFSOutput)) continue;
                    toRemove.add((IHFSOutput)o);
                }
                if (!toRemove.isEmpty() && (outputList = ((OutputContentProvider)GeneralTranslatorEditorPage.this.fOutputTableViewer.getContentProvider()).getOutputList()).removeAll(toRemove)) {
                    GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.getHFSOutputs().removeAll(toRemove);
                    GeneralTranslatorEditorPage.this.fOutputTableViewer.refresh();
                    GeneralTranslatorEditorPage.this.updateOutputButtonEnablement();
                    GeneralTranslatorEditorPage.this.setDirty(true);
                }
            }
        });
        this.updateOutputButtonEnablement();
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddOutputButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEditOutputButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveOutputButton);
    }

    private void updateVariableButtonEnablement() {
        if (this.fEditVariableButton == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fVariableTableViewer.getSelection();
        boolean haveData = !this.fTranslatorWorkingCopy.getVariables().isEmpty();
        this.fAddVariableButton.setEnabled(true);
        this.fEditVariableButton.setEnabled(haveData && selection.size() == 1);
        this.fRemoveVariableButton.setEnabled(haveData && !selection.isEmpty());
        if (selection.isEmpty() || selection.size() != 1) {
            this.fUpVariableButton.setEnabled(false);
            this.fDownVariableButton.setEnabled(false);
        } else {
            Object first = selection.getFirstElement();
            int size = this.fTranslatorWorkingCopy.getVariables().size();
            int index = this.fTranslatorWorkingCopy.getVariables().indexOf(first);
            if (size == 0 || index == 0) {
                this.fUpVariableButton.setEnabled(false);
            } else {
                this.fUpVariableButton.setEnabled(true);
            }
            if (size == 0 || index == size - 1) {
                this.fDownVariableButton.setEnabled(false);
            } else {
                this.fDownVariableButton.setEnabled(true);
            }
        }
    }

    private void editVariable(IVariable variable) {
        CreateVariableDialog dialog = new CreateVariableDialog(this.getSite().getShell(), variable, this.fTranslatorWorkingCopy.getVariables(), Messages.GeneralTranslatorEditorPage_EditVariableTitle, Messages.GeneralTranslatorEditorPage_EditVariableDescription);
        if (dialog.open() == 0) {
            variable = dialog.getVariable();
            this.fVariableTableViewer.refresh();
            this.updateVariableButtonEnablement();
            this.setDirty(true);
        }
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_translator";
    }

    private void updateOutputButtonEnablement() {
        if (this.fEditOutputButton == null) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.fOutputTableViewer.getSelection();
        this.fAddOutputButton.setEnabled(true);
        this.fEditOutputButton.setEnabled(selection.size() == 1);
        this.fRemoveOutputButton.setEnabled(!selection.isEmpty());
    }

    private void editOutput(IHFSOutput output) {
        CreateOutputDialog dialog = new CreateOutputDialog(this.getSite().getShell(), output, this.fTranslatorWorkingCopy.getHFSOutputs(), Messages.GeneralTranslatorEditorPage_EditOutputTitle, Messages.GeneralTranslatorEditorPage_EditOutputDescription);
        if (dialog.open() == 0) {
            output = dialog.getOutput();
            this.fOutputTableViewer.refresh();
            this.setDirty(true);
        }
    }

    private List<ITranslatorType> getTranslatorTypes() {
        ITranslatorType[] types;
        ArrayList<ITranslatorType> validTranslatorTypes = new ArrayList<ITranslatorType>();
        ITranslatorType[] iTranslatorTypeArray = types = TranslatorTypeRegistry.getInstance().getTranslatorTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            ITranslatorType type = iTranslatorTypeArray[n2];
            if (this.isValidType(type)) {
                validTranslatorTypes.add(type);
            }
            ++n2;
        }
        return validTranslatorTypes;
    }

    private boolean isValidType(ITranslatorType type) {
        if (type.getId() == null || type.getId().isEmpty()) {
            return false;
        }
        if (type.getLabel() == null || type.getLabel().isEmpty()) {
            return false;
        }
        return type.getTooltip() != null && !type.getTooltip().isEmpty();
    }

    public void dispose() {
        if (this.fConcatsControl != null) {
            this.fConcatsControl.dispose();
        }
        if (this.fDDAllocationsControl != null) {
            this.fDDAllocationsControl.dispose();
        }
        if (this.fAntSnippetViewer != null) {
            this.fAntSnippetViewer.dispose();
        }
        super.dispose();
    }

    private class AntSnippetListener
    implements AntSnippetTranslatorListener,
    ModifyListener {
        private AntSnippetListener() {
        }

        public void antSnippetChanged() {
            GeneralTranslatorEditorPage.this.validateAntSnippet();
        }

        public void modifyText(ModifyEvent e) {
            GeneralTranslatorEditorPage.this.fTranslatorWorkingCopy.setAntSnippet(GeneralTranslatorEditorPage.this.fAntSnippetViewer.getTextWidget().getText().trim());
            GeneralTranslatorEditorPage.this.setDirty(true);
        }
    }

    class OutputContentProvider
    implements IStructuredContentProvider {
        List<IHFSOutput> outputList = null;

        OutputContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.outputList != null) {
                return this.outputList.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
            if (this.outputList != null && !this.outputList.isEmpty()) {
                this.outputList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                if (this.outputList == null) {
                    this.outputList = new ArrayList<IHFSOutput>();
                }
                if (!this.outputList.isEmpty()) {
                    this.outputList.clear();
                }
                this.outputList.addAll((Collection)newInput);
            }
        }

        public List<IHFSOutput> getOutputList() {
            return this.outputList;
        }
    }

    class OutputLabelProvider
    implements ITableLabelProvider {
        OutputLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IHFSOutput) {
                if (columnIndex == 0) {
                    return ((IHFSOutput)element).getPath();
                }
                if (columnIndex == 1) {
                    return ((IHFSOutput)element).getCondition();
                }
                if (columnIndex == 2) {
                    return ((IHFSOutput)element).getDeployType();
                }
            }
            return Messages.GeneralTranslatorEditorPage_ERROR;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class VariableContentProvider
    implements IStructuredContentProvider {
        List<IVariable> variableList = null;

        VariableContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (this.variableList != null) {
                return this.variableList.toArray();
            }
            return new Object[0];
        }

        public void dispose() {
            if (this.variableList != null && !this.variableList.isEmpty()) {
                this.variableList.clear();
            }
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            if (newInput instanceof List) {
                if (this.variableList == null) {
                    this.variableList = new ArrayList<IVariable>();
                }
                if (!this.variableList.isEmpty()) {
                    this.variableList.clear();
                }
                this.variableList.addAll((Collection)newInput);
            }
        }

        public List<IVariable> getVariableList() {
            return this.variableList;
        }
    }

    class VariableLabelProvider
    implements ITableLabelProvider {
        VariableLabelProvider() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (element instanceof IVariable) {
                if (columnIndex == 0) {
                    return ((IVariable)element).getName();
                }
                return ((IVariable)element).getValue();
            }
            return Messages.GeneralTranslatorEditorPage_ERROR;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

