/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.ScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.TranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDependencyType;
import com.ibm.team.enterprise.systemdefinition.common.model.ILanguageDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IScopedProperty;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.ITranslatorEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslator;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosTranslatorHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.ui.ITranslatorEntryConsumer;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.ScopedPropertyDialog;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.TranslatorEntryDialog;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.enterprise.systemdefinition.ui.util.ScopedPropertiesLabelProvider;
import com.ibm.team.enterprise.systemdefinition.ui.util.TranslatorEntryLabelProvider;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.domain.actions.EditSystemDefinitionActionDelegate;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractLanguageDefinitionItemEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.LanguageDefinitionEditor;
import com.ibm.team.process.common.IProjectArea;
import com.ibm.team.process.common.IProjectAreaHandle;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.IItemHandle;
import com.ibm.team.repository.common.NotLoggedInException;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.accessibility.Accessible;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public class GeneralLanguageDefinitionEditorPage
extends AbstractLanguageDefinitionItemEditorPage
implements ITranslatorEntryConsumer {
    private final String[] languageConstants = new String[]{"ASM", "BIN", "BND", "C", "CPP", "EASY", "COB", "JCL", "LNK", "PLI", "OTH"};
    private final String[] languageStrings = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_ASSEMBLER, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_BINARY, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_BIND, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_C, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_CPP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_CAEASYTRIEVE, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_COBOL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_JCL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_LINKEDIT, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_PLI, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.LANGUAGE_OTHER};
    protected static final String[] SUBSYSTEM_STRINGS = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.SUBSYSTEM_CICS, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.SUBSYSTEM_DB2, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.SUBSYSTEM_IMS};
    private FormToolkit fToolkit;
    private Composite fParent;
    private Section fGeneralSection;
    private Section fTranslatorsSection;
    private Section fPropertiesSection;
    protected Text fDescriptionText;
    protected Text fFileExtensionsText;
    protected Combo fLanguageCodeCombo;
    protected Button fNonImpactingCheckbox;
    protected Button fDontCalculateImpactsCheckbox;
    protected Button fConsolidateLogsCheckbox;
    private TableViewer fTranslatorsViewer;
    private TableViewer fPropertiesViewer;
    private ILanguageDefinition fLanguageDefinitionWorkingCopy;
    private ISelectionChangedListener fTranslatorTableListener = new ISelectionChangedListener(){

        public void selectionChanged(SelectionChangedEvent event) {
            GeneralLanguageDefinitionEditorPage.this.updateButtonEnablement();
        }
    };
    private static final int ADD_BUTTON = 0;
    private static final int EDIT_BUTTON = 1;
    private static final int REMOVE_BUTTON = 2;
    private static final int UP_BUTTON = 3;
    private static final int DOWN_BUTTON = 4;
    private static final int PROPERTIES_OFFSET = 5;
    private Button[] buttons = new Button[10];

    public GeneralLanguageDefinitionEditorPage(String elementId, String title) {
        super(elementId, title);
    }

    @Override
    public void createContent(Composite parent, FormToolkit toolkit) {
        this.fToolkit = toolkit;
        this.fParent = parent;
        this.resolveSystemDefinitionCaches();
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 10;
        parent.setLayout((Layout)formLayout);
        this.createGeneralSection(parent);
        this.createTranslatorsSection(parent);
        this.createPropertiesSection(parent);
    }

    @Override
    public void setWorkingCopy(ISystemDefinition definition) {
        this.fLanguageDefinitionWorkingCopy = (ILanguageDefinition)definition;
    }

    @Override
    public boolean validate() {
        boolean isValid = true;
        if (!this.validateLanguage()) {
            isValid = false;
        }
        if (!this.validateFileExtension()) {
            isValid = false;
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateLanguage() {
        boolean isValid = true;
        if (this.fLanguageCodeCombo.getText().trim().equals("")) {
            this.addErrorMessage((Object)this.fLanguageCodeCombo, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_LANGUAGE_REQUIRED, (Control)this.fLanguageCodeCombo);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fLanguageCodeCombo, (Control)this.fLanguageCodeCombo);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    private boolean validateFileExtension() {
        boolean isValid = true;
        String extension = this.fFileExtensionsText.getText().trim();
        String[] exts = extension.trim().split(",");
        boolean passed = true;
        String[] stringArray = exts;
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String e = stringArray[n2];
            if (!Pattern.matches("[a-zA-Z0-9]*", e.trim())) {
                passed = false;
                break;
            }
            ++n2;
        }
        if (!passed) {
            this.addErrorMessage((Object)this.fFileExtensionsText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_INVALID_FILE_EXTENSION, (Control)this.fFileExtensionsText);
            isValid = false;
        } else {
            this.removeErrorMessage(this.fFileExtensionsText, (Control)this.fFileExtensionsText);
        }
        this.setPageErrorIndicator(!isValid);
        return isValid;
    }

    protected void createGeneralSection(Composite parent) {
        this.fGeneralSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fGeneralSection.setEnabled(false);
        }
        FormData fdata = new FormData();
        fdata.top = new FormAttachment(0);
        fdata.left = new FormAttachment(0);
        fdata.right = new FormAttachment(50);
        this.fGeneralSection.setLayoutData((Object)fdata);
        this.fGeneralSection.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_GENERAL_HEADER);
        this.fGeneralSection.setDescription(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_GENERAL_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fGeneralSection);
        composite.setLayoutData((Object)new TableWrapData(256, 256));
        TableWrapLayout layout = new TableWrapLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 10;
        composite.setLayout((Layout)layout);
        this.fGeneralSection.setClient((Control)composite);
        Label l = this.fToolkit.createLabel(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_LANGUAGE_CODE_LABEL);
        l.setToolTipText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_LANGUAGE_CODE_TOOLTIP);
        this.fLanguageCodeCombo = new Combo(composite, 12);
        this.fLanguageCodeCombo.setItems(this.languageStrings);
        this.fLanguageCodeCombo.select(this.getLanguageIndex(this.fLanguageDefinitionWorkingCopy.getLanguageCode()));
        TableWrapData data = new TableWrapData(256, 128, 1, 1);
        this.fLanguageCodeCombo.setLayoutData((Object)data);
        this.fLanguageCodeCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.handleLanguageSelected();
            }
        });
        this.createSpacer(this.fToolkit, composite, 5, 2);
        Label label = this.fToolkit.createLabel(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_FILE_EXTENSIONS_LABEL);
        label.setToolTipText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_FILE_EXTENSIONS_TOOLTIP);
        this.fFileExtensionsText = this.fToolkit.createText(composite, SystemDefinitionUtil.joinStringHelper((List)this.fLanguageDefinitionWorkingCopy.getDefaultPatterns(), (String)","));
        data = new TableWrapData(256, 128, 1, 1);
        this.fFileExtensionsText.setLayoutData((Object)data);
        this.createSpacer(this.fToolkit, composite, 1, 1);
        Text descriptionLabel = new Text(composite, 72);
        descriptionLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_FILE_EXTENSIONS_HELP);
        descriptionLabel.setLayoutData((Object)new TableWrapData(256));
        descriptionLabel.setForeground(Display.getDefault().getSystemColor(16));
        this.fFileExtensionsText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (GeneralLanguageDefinitionEditorPage.this.validateFileExtension()) {
                    GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.getDefaultPatterns().clear();
                    GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.getDefaultPatterns().addAll(SystemDefinitionUtil.splitStringHelper((String)GeneralLanguageDefinitionEditorPage.this.fFileExtensionsText.getText().trim(), (String)","));
                }
                GeneralLanguageDefinitionEditorPage.this.setDirty(true);
            }
        });
        this.createSpacer(this.fToolkit, composite, 5, 2);
        label = this.fToolkit.createLabel(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_DESCRIPTION_LABEL);
        label.setToolTipText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_DESCRIPTION_TOOLTIP);
        this.fDescriptionText = this.fToolkit.createText(composite, this.fLanguageDefinitionWorkingCopy.getDescription(), 2626);
        data = new TableWrapData(256, 128, 1, 1);
        data.heightHint = 60;
        this.fDescriptionText.setLayoutData((Object)data);
        this.fDescriptionText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.setDescription(GeneralLanguageDefinitionEditorPage.this.fDescriptionText.getText().trim());
                GeneralLanguageDefinitionEditorPage.this.setDirty(true);
            }
        });
        this.fNonImpactingCheckbox = this.fToolkit.createButton(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.SystemDefinitionEditorPage_NON_IMPACT_LABEL, 32);
        this.fNonImpactingCheckbox.setToolTipText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.SystemDefinitionEditorPage_NON_IMPACT_DESCRIPTION);
        data = new TableWrapData(256, 128, 1, 2);
        this.fNonImpactingCheckbox.setLayoutData((Object)data);
        this.fNonImpactingCheckbox.setSelection(this.fLanguageDefinitionWorkingCopy.isNonImpacting());
        this.fNonImpactingCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.setNonImpacting(GeneralLanguageDefinitionEditorPage.this.fNonImpactingCheckbox.getSelection());
                GeneralLanguageDefinitionEditorPage.this.setDirty(true);
            }
        });
        this.fDontCalculateImpactsCheckbox = this.fToolkit.createButton(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_DONT_CALCULATE_IMPACTS_LABEL, 32);
        this.fDontCalculateImpactsCheckbox.setToolTipText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_DONT_CALCULATE_IMPACTS_TOOLTIP);
        data = new TableWrapData(256, 128, 1, 2);
        this.fDontCalculateImpactsCheckbox.setLayoutData((Object)data);
        this.fDontCalculateImpactsCheckbox.setSelection(!this.fLanguageDefinitionWorkingCopy.isCalculateImpacts());
        this.fDontCalculateImpactsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.setCalculateImpacts(!GeneralLanguageDefinitionEditorPage.this.fDontCalculateImpactsCheckbox.getSelection());
                GeneralLanguageDefinitionEditorPage.this.setDirty(true);
            }
        });
        this.fConsolidateLogsCheckbox = this.fToolkit.createButton(composite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_CONSOLIDATE_LOGS_LABEL, 32);
        data = new TableWrapData(256, 128, 1, 2);
        this.fConsolidateLogsCheckbox.setLayoutData((Object)data);
        this.fConsolidateLogsCheckbox.setSelection(this.fLanguageDefinitionWorkingCopy.isConsolidateLogs());
        this.fConsolidateLogsCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.setConsolidateLogs(GeneralLanguageDefinitionEditorPage.this.fConsolidateLogsCheckbox.getSelection());
                GeneralLanguageDefinitionEditorPage.this.setDirty(true);
            }
        });
    }

    private int getLanguageIndex(String languageCode) {
        int i = 0;
        while (i < this.languageConstants.length) {
            if (this.languageConstants[i].equals(languageCode)) break;
            ++i;
        }
        return i;
    }

    private void handleLanguageSelected() {
        int i = this.fLanguageCodeCombo.getSelectionIndex();
        this.fLanguageDefinitionWorkingCopy.setLanguageCode(this.languageConstants[i]);
        this.validateLanguage();
        this.setDirty(true);
    }

    protected void createTranslatorsSection(Composite parent) {
        this.fTranslatorsSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fTranslatorsSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment(0);
        data.left = new FormAttachment((Control)this.fGeneralSection);
        data.right = new FormAttachment(100);
        data.bottom = new FormAttachment((Control)this.fGeneralSection, 0, 1024);
        this.fTranslatorsSection.setLayoutData((Object)data);
        this.fTranslatorsSection.setLayout((Layout)new GridLayout(1, false));
        this.fTranslatorsSection.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_HEADER);
        this.fTranslatorsSection.setDescription(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fTranslatorsSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fToolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.grabExcessVerticalSpace = true;
        Table table = this.fToolkit.createTable(tableComposite, 66304);
        table.setHeaderVisible(true);
        gridData.heightHint = table.getItemHeight() * 10;
        gridData.widthHint = 100;
        tableComposite.setLayoutData((Object)gridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_TABLE_COLUMN_TRANSLATOR);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_TABLE_COLUMN_CONDITION);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(50, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_TABLE_COLUMN_STEPNAME);
        tableComposite.setLayout((Layout)tableLayout);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible a = (Accessible)e.getSource();
                if (a.getControl() instanceof Table && ((Table)a.getControl()).getItemCount() == 0) {
                    e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ALL_TRANSLATORS_DESCRIPTION;
                }
            }
        });
        this.fTranslatorsViewer = new TableViewer(table);
        this.fTranslatorsViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fTranslatorsViewer.setLabelProvider((IBaseLabelProvider)new TranslatorEntryLabelProvider(this.fTranslatorsViewer, (ITeamRepository)this.fLanguageDefinitionWorkingCopy.getOrigin(), this.fLanguageDefinitionWorkingCopy.getProjectArea(), (ITranslatorEntryConsumer)this));
        this.fTranslatorsViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
        this.fTranslatorsViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        if (this.isEditable()) {
            this.fTranslatorsViewer.addOpenListener(this.getOpenListener());
        }
        this.createButtonBar(composite, this.fTranslatorsViewer);
        this.fTranslatorsSection.setClient((Control)composite);
    }

    protected IOpenListener getOpenListener() {
        return new IOpenListener(){
            ITranslator translator = null;

            public void open(OpenEvent event) {
                ITranslatorEntry translatorEntry;
                IStructuredSelection selection = (IStructuredSelection)GeneralLanguageDefinitionEditorPage.this.fTranslatorsViewer.getSelection();
                if (selection.size() == 1 && (translatorEntry = GeneralLanguageDefinitionEditorPage.this.getSelectedTranslatorEntry()).getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.translator")) {
                    String translatorUUID = translatorEntry.getValue();
                    try {
                        this.translator = null;
                        this.fetchTranslator(translatorUUID);
                        if (this.translator != null) {
                            EditSystemDefinitionActionDelegate.run((ISystemDefinition)this.translator, GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.getProjectArea(), GeneralLanguageDefinitionEditorPage.this.getSite().getPage(), true, true);
                        }
                    }
                    catch (IllegalArgumentException e) {
                        e.printStackTrace();
                    }
                }
            }

            private void fetchTranslator(final String translatorUUID) {
                Job fetchTranslatorEditorJob = new Job(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_FetchTranslatorJob){

                    protected IStatus run(IProgressMonitor monitor) {
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)GeneralLanguageDefinitionEditorPage.this.getTeamRepository());
                        try {
                            translator = (ITranslator)client.findSystemDefinitionComplete(translatorUUID, null, IZosTranslator.ITEM_TYPE, monitor);
                        }
                        catch (IllegalArgumentException e) {
                            e.printStackTrace();
                        }
                        catch (NotLoggedInException e) {
                            ITeamRepository teamRepository = (ITeamRepository)GeneralLanguageDefinitionEditorPage.this.fLanguageDefinitionWorkingCopy.getOrigin();
                            try {
                                teamRepository.login(monitor);
                                if (teamRepository.loggedIn()) {
                                    this.fetchTranslator(translatorUUID);
                                }
                            }
                            catch (TeamRepositoryException e1) {
                                e1.printStackTrace();
                            }
                        }
                        catch (TeamRepositoryException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                fetchTranslatorEditorJob.schedule();
                try {
                    fetchTranslatorEditorJob.join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    private void updateButtonEnablement() {
        TableViewer[] tableViewerArray = new TableViewer[]{this.fTranslatorsViewer, this.fPropertiesViewer};
        int n = tableViewerArray.length;
        int n2 = 0;
        while (n2 < n) {
            List workingList;
            TableViewer tv = tableViewerArray[n2];
            IStructuredSelection selection = (IStructuredSelection)tv.getSelection();
            int offset = 0;
            if (tv.equals(this.fPropertiesViewer)) {
                offset = 5;
                workingList = this.fLanguageDefinitionWorkingCopy.getScopedProperties();
            } else {
                workingList = this.fLanguageDefinitionWorkingCopy.getTranslators();
            }
            if (!selection.isEmpty()) {
                int size = selection.size();
                Object first = selection.getFirstElement();
                this.buttons[offset + 2].setEnabled(true);
                this.buttons[offset + 1].setEnabled(true);
                if (workingList.indexOf(first) == 0) {
                    this.buttons[offset + 3].setEnabled(false);
                } else {
                    this.buttons[offset + 3].setEnabled(true);
                }
                if (workingList.indexOf(first) + size == workingList.size()) {
                    this.buttons[offset + 4].setEnabled(false);
                } else {
                    this.buttons[offset + 4].setEnabled(true);
                }
            } else {
                this.buttons[offset + 4].setEnabled(false);
                this.buttons[offset + 3].setEnabled(false);
                this.buttons[offset + 2].setEnabled(false);
                this.buttons[offset + 1].setEnabled(false);
            }
            ++n2;
        }
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return this.fTranslatorTableListener;
    }

    private void createButtonBar(Composite parent, final TableViewer tableViewer) {
        int offset = 0;
        if (tableViewer.equals(this.fPropertiesViewer)) {
            offset = 5;
        }
        Composite buttonBar = this.fToolkit.createComposite(parent);
        buttonBar.setLayoutData((Object)new GridData(131072, 4, false, true));
        buttonBar.setLayout((Layout)new GridLayout(1, false));
        this.buttons[offset + 0] = this.fToolkit.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_ADD_BUTTON, 8);
        this.buttons[offset + 0].setEnabled(true);
        if (offset != 5) {
            this.buttons[offset + 0].setData("name", (Object)"add.translator.button");
        }
        this.buttons[offset + 0].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.addEntry(tableViewer);
            }
        });
        this.buttons[offset + 1] = this.fToolkit.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_EDIT_BUTTON, 8);
        this.buttons[offset + 1].setEnabled(false);
        this.buttons[offset + 1].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.editEntry(tableViewer);
            }
        });
        this.buttons[offset + 2] = this.fToolkit.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_REMOVE_BUTTON, 8);
        this.buttons[offset + 2].setEnabled(false);
        this.buttons[offset + 2].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.removeSelectedEntries(tableViewer);
            }
        });
        this.buttons[offset + 3] = this.fToolkit.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_UP_BUTTON, 8);
        this.buttons[offset + 3].setEnabled(false);
        this.buttons[offset + 3].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.moveEntries(true, tableViewer);
            }
        });
        this.buttons[offset + 4] = this.fToolkit.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_DOWN_BUTTON, 8);
        this.buttons[offset + 4].setEnabled(false);
        this.buttons[offset + 4].addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                GeneralLanguageDefinitionEditorPage.this.moveEntries(false, tableViewer);
            }
        });
        this.setButtonLayoutData(this.buttons[offset + 0], this.buttons[offset + 1], this.buttons[offset + 2], this.buttons[offset + 3], this.buttons[offset + 4]);
    }

    private void setButtonLayoutData(Button ... buttons) {
        GC gc = new GC((Drawable)buttons[0]);
        gc.setFont(buttons[0].getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int maxWidth = Dialog.convertHorizontalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        Button[] buttonArray = buttons;
        int n = buttons.length;
        int n2 = 0;
        while (n2 < n) {
            Button b = buttonArray[n2];
            Point minSize = b.computeSize(-1, -1, true);
            maxWidth = Math.max(maxWidth, minSize.x);
            ++n2;
        }
        Button[] buttonArray2 = buttons;
        int n3 = buttons.length;
        n = 0;
        while (n < n3) {
            Button b = buttonArray2[n];
            GridData gridData = new GridData(128);
            gridData.widthHint = maxWidth;
            b.setLayoutData((Object)gridData);
            ++n;
        }
    }

    private void addEntry(TableViewer tableViewer) {
        if (tableViewer == this.fTranslatorsViewer) {
            try {
                IProjectArea projArea = null;
                projArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fLanguageDefinitionWorkingCopy.getProjectArea(), 0, null);
                TranslatorEntry translatorEntry = ModelFactory.eINSTANCE.createTranslatorEntry();
                TranslatorEntryDialog dialog = this.getTranslatorEntryDialog((ITranslatorEntry)translatorEntry, Messages.ADD_TRANSLATOR_TITLE, projArea);
                if (dialog.open() == 0) {
                    String translatorEntryValue = dialog.getTranslatorEntryValue();
                    Map<String, String> translatorCache = this.getTranslatorCache();
                    translatorEntry.setKind(dialog.getTranslatorEntryKind());
                    translatorEntry.setValue(translatorEntryValue);
                    translatorEntry.setCondition(dialog.getTranslatorEntryCondition());
                    translatorEntry.setStepName(dialog.getTranslatorEntryStepName());
                    this.fLanguageDefinitionWorkingCopy.getTranslators().add(translatorEntry);
                    if (!translatorCache.containsKey(translatorEntryValue)) {
                        translatorCache.put(translatorEntryValue, dialog.getTranslatorEntryName());
                    }
                    this.fTranslatorsViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorsViewer.refresh();
                    this.fTranslatorsViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getTranslators().indexOf(translatorEntry));
                    this.setDirty(true);
                }
            }
            catch (TeamRepositoryException ex) {
                ex.printStackTrace();
            }
        } else if (tableViewer == this.fPropertiesViewer) {
            ScopedProperty property = ModelFactory.eINSTANCE.createScopedProperty();
            ScopedPropertyDialog dialog = new ScopedPropertyDialog(this.fParent.getShell(), (IScopedProperty)property, Messages.ADD_SCOPED_PROPERTY_TITLE, this.fLanguageDefinitionWorkingCopy.getScopedProperties());
            if (dialog.open() == 0) {
                this.fLanguageDefinitionWorkingCopy.getScopedProperties().add(property);
                this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                this.fPropertiesViewer.refresh();
                this.fPropertiesViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getScopedProperties().indexOf(property));
                this.setDirty(true);
            }
        }
    }

    private void editEntry(TableViewer tableViewer) {
        try {
            if (tableViewer.equals(this.fTranslatorsViewer) && this.getSelectedTranslatorEntry() != null) {
                IProjectArea projArea;
                String title;
                ITranslatorEntry translatorEntry = this.getSelectedTranslatorEntry();
                TranslatorEntryDialog dialog = this.getTranslatorEntryDialog(translatorEntry, title = Messages.EDIT_TRANSLATOR_TITLE, projArea = (IProjectArea)this.getTeamRepository().itemManager().fetchCompleteItem((IItemHandle)this.fLanguageDefinitionWorkingCopy.getProjectArea(), 0, null));
                if (dialog.open() == 0) {
                    String translatorEntryValue = dialog.getTranslatorEntryValue();
                    Map<String, String> translatorCache = this.getTranslatorCache();
                    translatorEntry.setKind(dialog.getTranslatorEntryKind());
                    translatorEntry.setValue(translatorEntryValue);
                    translatorEntry.setCondition(dialog.getTranslatorEntryCondition());
                    translatorEntry.setStepName(dialog.getTranslatorEntryStepName());
                    if (!translatorCache.containsKey(translatorEntryValue)) {
                        translatorCache.put(translatorEntryValue, dialog.getTranslatorEntryName());
                    }
                    this.fTranslatorsViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorsViewer.refresh();
                    this.fTranslatorsViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getTranslators().indexOf(translatorEntry));
                    this.setDirty(true);
                }
            } else if (tableViewer == this.fPropertiesViewer) {
                IScopedProperty property = (IScopedProperty)((IStructuredSelection)this.fPropertiesViewer.getSelection()).getFirstElement();
                ScopedProperty tmp = ModelFactory.eINSTANCE.createScopedProperty();
                tmp.setCondition(property.getCondition());
                tmp.setName(property.getName());
                tmp.setValue(property.getValue());
                String title = Messages.EDIT_SCOPED_PROPERTY_TITLE;
                ScopedPropertyDialog dialog = new ScopedPropertyDialog(this.fParent.getShell(), (IScopedProperty)tmp, title, this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                if (dialog.open() == 0) {
                    property.setCondition(tmp.getCondition());
                    property.setName(tmp.getName());
                    property.setValue(tmp.getValue());
                    this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                    this.fPropertiesViewer.refresh();
                    this.fPropertiesViewer.getTable().setSelection(this.fLanguageDefinitionWorkingCopy.getScopedProperties().indexOf(property));
                    this.setDirty(true);
                }
            }
        }
        catch (TeamRepositoryException ex) {
            ex.printStackTrace();
        }
    }

    private ITranslatorEntry getSelectedTranslatorEntry() {
        IStructuredSelection selection = (IStructuredSelection)this.fTranslatorsViewer.getSelection();
        Object element = selection.getFirstElement();
        if (element instanceof ITranslatorEntry) {
            return (ITranslatorEntry)element;
        }
        return null;
    }

    protected TranslatorEntryDialog getTranslatorEntryDialog(ITranslatorEntry transEntry, String title, IProjectArea projArea) {
        return new TranslatorEntryDialog(this.fParent.getShell(), title, transEntry, true, IZosTranslator.ITEM_TYPE, this.getTeamRepository(), (IProjectAreaHandle)projArea, this.getTranslatorCache());
    }

    private void removeSelectedEntries(TableViewer tableViewer) {
        ISelection selection;
        boolean deleteConfirmed;
        if (tableViewer == this.fTranslatorsViewer) {
            ISelection selection2;
            boolean deleteConfirmed2 = MessageDialog.openQuestion((Shell)this.fTranslatorsSection.getShell(), (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_TRANSLATOR_DELETE_CONFIRM_TITLE, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_TRANSLATOR_DELETE_CONFIRM);
            if (deleteConfirmed2 && (selection2 = this.fTranslatorsViewer.getSelection()) instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection2;
                ArrayList<ITranslatorEntry> entriesRemoved = new ArrayList<ITranslatorEntry>();
                for (ITranslatorEntry translator : structuredSelection) {
                    this.fLanguageDefinitionWorkingCopy.getTranslators().remove(translator);
                    for (IDependencyType dt : this.fLanguageDefinitionWorkingCopy.getDependencyTypes()) {
                        ArrayList<ITranslatorEntry> toRemove = new ArrayList<ITranslatorEntry>();
                        for (ITranslatorEntry te : dt.getTranslators()) {
                            if (!te.getValue().equals(translator.getValue())) continue;
                            toRemove.add(te);
                        }
                        if (!toRemove.isEmpty()) {
                            dt.getTranslators().removeAll(toRemove);
                        }
                        if (dt.getLevel() != 2 || dt.getTranslators().size() != 0) continue;
                        dt.setLevel(1);
                    }
                    entriesRemoved.add(translator);
                }
                if (!entriesRemoved.isEmpty()) {
                    this.fTranslatorsViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
                    this.fTranslatorsViewer.refresh();
                    this.setDirty(true);
                    this.updateButtonEnablement();
                }
            }
        } else if (tableViewer == this.fPropertiesViewer && (deleteConfirmed = MessageDialog.openQuestion((Shell)this.fTranslatorsSection.getShell(), (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTY_DELETE_CONFIRM_TITLE, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTY_DELETE_CONFIRM)) && (selection = this.fPropertiesViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            boolean propsRemoved = false;
            for (IScopedProperty property : structuredSelection) {
                if (!this.fLanguageDefinitionWorkingCopy.getScopedProperties().remove(property)) continue;
                propsRemoved = true;
            }
            if (propsRemoved) {
                this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
                this.fPropertiesViewer.refresh();
                this.setDirty(true);
                this.updateButtonEnablement();
            }
        }
    }

    private void moveEntries(boolean up, TableViewer tableViewer) {
        ISelection selection = tableViewer.getSelection();
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            List workingCopyList = null;
            workingCopyList = tableViewer == this.fTranslatorsViewer ? this.fLanguageDefinitionWorkingCopy.getTranslators() : this.fLanguageDefinitionWorkingCopy.getScopedProperties();
            if (up) {
                for (Object entry : structuredSelection) {
                    int orig = workingCopyList.indexOf(entry);
                    workingCopyList.remove(entry);
                    workingCopyList.add(orig - 1, entry);
                }
            } else {
                Vector move = new Vector();
                for (Object entry : structuredSelection) {
                    move.add(0, entry);
                }
                int i = 0;
                while (i < move.size()) {
                    int orig = workingCopyList.indexOf(move.get(i));
                    workingCopyList.remove(move.get(i));
                    workingCopyList.add(orig + 1, move.get(i));
                    ++i;
                }
            }
            tableViewer.refresh();
            this.setDirty(true);
            this.updateButtonEnablement();
        }
    }

    @Override
    protected String getContextHelpId() {
        return "com.ibm.team.build.ui.editor_languagedefinitiongeneral";
    }

    public void refreshViewerInput() {
        this.fTranslatorsViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getTranslators());
        this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
    }

    private void resolveSystemDefinitionCaches() {
        ITeamRepository fRepository = this.getTeamRepository();
        final LanguageDefinitionEditor fParentEditor = (LanguageDefinitionEditor)this.getEditor();
        if (fParentEditor.getTranslatorCache().isEmpty()) {
            final List translatorEntryList = this.fLanguageDefinitionWorkingCopy.getTranslators();
            SystemDefinitionJob job = new SystemDefinitionJob(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.TranslatorLabelHelper_JOB_LABEL, false, fRepository){
                private Map<String, String> fTranslatorCache;
                {
                    super($anonymous0, $anonymous1, $anonymous2);
                    this.fTranslatorCache = new HashMap<String, String>();
                }

                protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                    for (ITranslatorEntry entry : translatorEntryList) {
                        String translatorUuid;
                        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                            this.fTranslatorCache.put(entry.getValue(), entry.getValue());
                            continue;
                        }
                        String label = translatorUuid = entry.getValue();
                        if (translatorUuid.length() <= 0) continue;
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.getJobTeamRepository());
                        IZosTranslatorHandle handle = (IZosTranslatorHandle)IZosTranslator.ITEM_TYPE.createItemHandle(UUID.valueOf((String)translatorUuid), null);
                        ITranslator translator = (ITranslator)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ITranslator.NAME_PROPERTY, ITranslator.ARCHIVED_PROPERTY), monitor);
                        if (translator != null) {
                            label = translator.getName();
                            if (translator.isArchived()) {
                                label = String.valueOf(label) + Messages.SystemDefinition_ARCHIVED_SUFFIX;
                            }
                        } else {
                            label = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.TranslatorLabelHelper_ITEM_NOT_FOUND;
                        }
                        this.fTranslatorCache.put(translatorUuid, label);
                    }
                    return Status.OK_STATUS;
                }

                protected void jobFinished(IStatus status) {
                    fParentEditor.setTranslatorCache(this.fTranslatorCache);
                    Display.getDefault().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            if (GeneralLanguageDefinitionEditorPage.this.fTranslatorsViewer != null && !GeneralLanguageDefinitionEditorPage.this.fTranslatorsViewer.getControl().isDisposed()) {
                                GeneralLanguageDefinitionEditorPage.this.fTranslatorsViewer.refresh(true);
                            }
                        }
                    });
                }
            };
            job.schedule();
        }
    }

    public Map<String, String> getTranslatorCache() {
        return ((LanguageDefinitionEditor)this.getEditor()).getTranslatorCache();
    }

    protected void createPropertiesSection(Composite parent) {
        this.fPropertiesSection = this.fToolkit.createSection(parent, 384);
        if (this.fLanguageDefinitionWorkingCopy != null && this.fLanguageDefinitionWorkingCopy.isArchived()) {
            this.fPropertiesSection.setEnabled(false);
        }
        FormData data = new FormData();
        data.top = new FormAttachment((Control)this.fGeneralSection);
        data.left = new FormAttachment(0);
        data.right = new FormAttachment(100);
        this.fPropertiesSection.setLayoutData((Object)data);
        this.fPropertiesSection.setLayout((Layout)new GridLayout(1, false));
        this.fPropertiesSection.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_HEADER);
        this.fPropertiesSection.setDescription(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_DESCRIPTION);
        Composite composite = this.fToolkit.createComposite((Composite)this.fPropertiesSection);
        composite.setLayoutData((Object)new GridData(4, 4, true, true));
        this.fToolkit.setBorderStyle(2048);
        composite.setLayout((Layout)new GridLayout(2, false));
        Composite tableComposite = this.fToolkit.createComposite(composite);
        GridData gridData = new GridData(4, -1, true, false);
        gridData.grabExcessVerticalSpace = true;
        Table table = this.fToolkit.createTable(tableComposite, 66304);
        table.setHeaderVisible(true);
        gridData.heightHint = table.getItemHeight() * 10;
        gridData.widthHint = 100;
        tableComposite.setLayoutData((Object)gridData);
        TableColumnLayout tableLayout = new TableColumnLayout();
        TableColumn tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(30, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_TABLE_COLUMN_PROPERTY);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(30, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_TABLE_COLUMN_VALUE);
        tc = new TableColumn(table, 0);
        tableLayout.setColumnData((Widget)tc, (ColumnLayoutData)new ColumnWeightData(40, true));
        tc.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_TABLE_COLUMN_CONDITION);
        tableComposite.setLayout((Layout)tableLayout);
        table.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                Accessible a = (Accessible)e.getSource();
                if (a.getControl() instanceof Table && ((Table)a.getControl()).getItemCount() == 0) {
                    e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.GeneralLanguageDefinitionEditorPage_PROPERTIES_DESCRIPTION;
                }
            }
        });
        this.fPropertiesViewer = new TableViewer(table);
        this.fPropertiesViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fPropertiesViewer.setLabelProvider((IBaseLabelProvider)new ScopedPropertiesLabelProvider());
        this.fPropertiesViewer.setInput((Object)this.fLanguageDefinitionWorkingCopy.getScopedProperties());
        this.fPropertiesViewer.addSelectionChangedListener(this.getSelectionChangedListener());
        this.createButtonBar(composite, this.fPropertiesViewer);
        this.fPropertiesSection.setClient((Control)composite);
    }
}

