/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionClient;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.IResourceDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.ItemNotFoundException;
import com.ibm.team.repository.common.UUID;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.widgets.Display;

public class DataDefinitionEntryLabelHelper {
    private ISystemDefinitionCache fDefinitionCache;

    public DataDefinitionEntryLabelHelper() {
        this(null);
    }

    public DataDefinitionEntryLabelHelper(ISystemDefinitionCache definitionCache) {
        this.fDefinitionCache = definitionCache;
    }

    public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
    }

    @Deprecated
    public void labelAvailable(String label, IDataDefinitionEntry dataDefEntry) {
    }

    public void sequentialAvailable(Boolean isSequential, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
    }

    @Deprecated
    public void sequentialAvailable(Boolean isSequential, IDataDefinitionEntry dataDefEntry) {
    }

    public void getDataDefinitionEntryValueLabelInBackground(final IModeledDataDefinitionEntryContext context) {
        SystemDefinitionJob job = new SystemDefinitionJob(Messages.DataDefinitionEntryLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String dataDefUuid;
                if (context.getModeledEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(context.getModeledEntry().getValue(), context.getModeledEntry());
                    return Status.OK_STATUS;
                }
                if (context.getModeledEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && context.getModeledEntry().getValue().equals("com.ibm.teamz.langdef.entry.constant.input")) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_INPUT, context.getModeledEntry());
                    return Status.OK_STATUS;
                }
                String label = dataDefUuid = context.getModeledEntry().getValue();
                boolean isSequential = false;
                if (dataDefUuid.length() > 0) {
                    IDataSetDefinition dataDef = null;
                    UUID dataDefUuidValue = UUID.valueOf((String)dataDefUuid);
                    IDataSetDefinitionHandle handle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(dataDefUuidValue, null);
                    if (DataDefinitionEntryLabelHelper.this.fDefinitionCache != null) {
                        dataDef = (IDataSetDefinition)DataDefinitionEntryLabelHelper.this.fDefinitionCache.getSystemDefinition((ISystemDefinitionHandle)handle, monitor);
                    } else {
                        ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)context.getTeamRepository());
                        dataDef = (IDataSetDefinition)client.fetchSystemDefinition((ISystemDefinitionHandle)handle, Arrays.asList(ISystemDefinition.NAME_PROPERTY, ISystemDefinition.ARCHIVED_PROPERTY, IDataSetDefinition.DS_TYPE_PROPERTY), monitor);
                    }
                    label = dataDef.getName();
                    if (dataDef.isArchived()) {
                        label = String.valueOf(label) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX;
                    }
                    isSequential = dataDef.getDsType() == 1;
                }
                DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(label, context.getModeledEntry());
                DataDefinitionEntryLabelHelper.this.asyncSequentialAvailable((Boolean)isSequential, context.getModeledEntry());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_ITEM_NOT_FOUND, context.getModeledEntry());
                } else if (status.getSeverity() == 4) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_EXCEPTION_OCCURRED, context.getModeledEntry());
                }
            }
        };
        job.schedule();
    }

    @Deprecated
    public void getDataDefinitionEntryValueLabelInBackground(final IDataDefinitionEntryContext context) {
        SystemDefinitionJob job = new SystemDefinitionJob(Messages.DataDefinitionEntryLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                String dataDefUuid;
                if (context.getEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(context.getEntry().getValue(), context.getEntry());
                    return Status.OK_STATUS;
                }
                if (context.getEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && context.getEntry().getValue().equals("com.ibm.teamz.langdef.entry.constant.input")) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_INPUT, context.getEntry());
                    return Status.OK_STATUS;
                }
                String label = dataDefUuid = context.getEntry().getValue();
                boolean isSequential = false;
                if (dataDefUuid.length() > 0) {
                    UUID dataDefUuidValue = UUID.valueOf((String)dataDefUuid);
                    IDataSetDefinitionHandle handle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(dataDefUuidValue, null);
                    if (DataDefinitionEntryLabelHelper.this.fDefinitionCache != null) {
                        ISystemDefinition systemDefinition = DataDefinitionEntryLabelHelper.this.fDefinitionCache.getSystemDefinition((ISystemDefinitionHandle)handle, monitor);
                        if (systemDefinition instanceof IDataSetDefinition) {
                            IDataSetDefinition dataDef = (IDataSetDefinition)systemDefinition;
                            label = dataDef.isArchived() ? String.valueOf(dataDef.getName()) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX : dataDef.getName();
                            isSequential = dataDef.getDsType() == 1;
                        }
                    } else {
                        ISystemDefinitionClient client = ClientFactory.getSystemDefinitionClient((ITeamRepository)context.getTeamRepository());
                        IResourceDefinition resourceDef = client.getResourceDefinition(dataDefUuidValue, monitor);
                        if (resourceDef instanceof com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition) {
                            com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition deprecatedDataDef = (com.ibm.team.enterprise.zos.systemdefinition.common.IDataSetDefinition)resourceDef;
                            label = deprecatedDataDef.isArchived() ? String.valueOf(deprecatedDataDef.getName()) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX : deprecatedDataDef.getName();
                            isSequential = deprecatedDataDef.getDsType() == 1;
                        } else if (resourceDef instanceof IDataSetDefinition) {
                            IDataSetDefinition dataDef = (IDataSetDefinition)resourceDef;
                            label = dataDef.isArchived() ? String.valueOf(dataDef.getName()) + com.ibm.team.enterprise.systemdefinition.ui.nls.Messages.SystemDefinition_ARCHIVED_SUFFIX : dataDef.getName();
                            isSequential = dataDef.getDsType() == 1;
                        }
                    }
                }
                DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(label, context.getEntry());
                DataDefinitionEntryLabelHelper.this.asyncSequentialAvailable((Boolean)isSequential, context.getEntry());
                return Status.OK_STATUS;
            }

            protected void jobFinished(IStatus status) {
                if (status.getException() instanceof ItemNotFoundException) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_ITEM_NOT_FOUND, context.getEntry());
                } else if (status.getSeverity() == 4) {
                    DataDefinitionEntryLabelHelper.this.asyncLabelAvailable(Messages.DataDefinitionEntryLabelHelper_EXCEPTION_OCCURRED, context.getEntry());
                }
            }
        };
        job.schedule();
    }

    @Deprecated
    protected void asyncLabelAvailable(final String label, final IDataDefinitionEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataDefinitionEntryLabelHelper.this.labelAvailable(label, entry);
            }
        });
    }

    @Deprecated
    protected void asyncSequentialAvailable(final Boolean isSequential, final IDataDefinitionEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataDefinitionEntryLabelHelper.this.sequentialAvailable(isSequential, entry);
            }
        });
    }

    protected void asyncLabelAvailable(final String label, final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataDefinitionEntryLabelHelper.this.labelAvailable(label, entry);
            }
        });
    }

    protected void asyncSequentialAvailable(final Boolean isSequential, final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                DataDefinitionEntryLabelHelper.this.sequentialAvailable(isSequential, entry);
            }
        });
    }
}

