/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.DDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.ui.IGenericListener;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractCompositeSystemDefinitionControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DDAllocationDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DDAllocationLabelProvider;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.enterprise.zos.systemdefinition.common.util.ZosTranslatorUtil;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class DDAllocationsControl
extends AbstractCompositeSystemDefinitionControl {
    private static final String COLUMN_COMPACT = "compact";
    private static final String COLUMN_CONDITION = "condition";
    private static final String COLUMN_CONSOLIDATE = "consolidate";
    private static final String COLUMN_DATADEF = "datadef";
    private static final String COLUMN_DEPLOYTYPE = "deployType";
    private static final String COLUMN_KEEP = "keep";
    private static final String COLUMN_MEMBER = "member";
    private static final String COLUMN_MEMBERNAME = "membername";
    private static final String COLUMN_MOD = "mod";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_OUTPUT = "output";
    private static final String COLUMN_OUTPUTCONSUMED = "outputConsumed";
    private static final String COLUMN_PUBLISH_TYPE = "publishType";
    private final Button fAddButton;
    private final Button fCopyButton;
    private final Button fDownButton;
    private final Button fEditButton;
    private final Button fRemoveButton;
    private final Button fUpButton;
    private final ListenerList fListenerList = new ListenerList();
    private final Shell fParentShell;
    private final TableViewer fTableViewer;
    private final FormToolkit fToolkit;
    private final ITeamRepository repository;
    private final MappingValidation validator;
    private final Map<String, String> ddIdNameMap = new HashMap<String, String>();
    protected List<IConcatenation> fConcatenations;
    protected List<IDDAllocation> fDDAllocations;
    protected List<IVariable> fTranslatorVariables;
    private boolean isEditable = true;

    public DDAllocationsControl(Composite parent, FormToolkit toolkit, List<IDDAllocation> ddAllocs, List<IVariable> translatorVariables, ITeamRepository repository, boolean isEditable, ISystemDefinitionCache definitionCache, MappingValidation validator) {
        super(repository, definitionCache);
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        this.fDDAllocations = ddAllocs;
        this.fTranslatorVariables = translatorVariables;
        this.repository = repository;
        this.isEditable = isEditable;
        this.validator = validator;
        Composite tableComposite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).indent(5, 3).applyTo((Control)tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_NAME, COLUMN_DATADEF, COLUMN_MEMBER, COLUMN_MEMBERNAME, COLUMN_CONDITION, COLUMN_KEEP, COLUMN_MOD, COLUMN_OUTPUT, COLUMN_DEPLOYTYPE, COLUMN_PUBLISH_TYPE, COLUMN_CONSOLIDATE, COLUMN_COMPACT, COLUMN_OUTPUTCONSUMED};
        String[] columnHeaders = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_NAME, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_DATADEF, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_MEMBER, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUTMEMBERNAME, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_CONDITION, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_KEEP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_MOD, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUT, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUTCONSUMED, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_DEPLOYTYPE, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_PUBLISHTYPE, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_CONSOLIDATE_LOG, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_COMPACT};
        String[] columnTooltips = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_NAME_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_DATADEF_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_MEMBER_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUTMEMBERNAME_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_CONDITION_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_KEEP_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_MOD_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUT_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_OUTPUTCONSUMED_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_DEPLOYTYPE_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_PUBLISHTYPE_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_CONSOLIDATE_LOG_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_COMPACT_TOOLTIP};
        int[] columnWeights = new int[]{13, 18, 8, 14, 15, 8, 8, 8, 15, 8, 8, 8, 8};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            if (columnTooltips[i] != null) {
                column.setToolTipText(columnTooltips[i]);
            } else {
                column.setToolTipText(columnHeaders[i]);
            }
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        this.fTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new DDAllocationLabelProvider(this.fTableViewer, repository, this));
        this.resolveDDName();
        this.fTableViewer.setInput(this.fDDAllocations);
        Composite buttonBar = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fAddButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fCopyButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.COPY_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fRemoveButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.REMOVE_BUTTON_LABEL, 8);
        this.fUpButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryControl_UP_BUTTON, 8);
        this.fDownButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryControl_DOWN_BUTTON, 8);
        if (isEditable) {
            this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    DDAllocationsControl.this.handleDoubleClick(event);
                }
            });
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DDAllocationsControl.this.addDDAllocation();
                }
            });
            this.fCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDDAllocation dd = DDAllocationsControl.this.getSelectedDDAllocation();
                    if (dd != null) {
                        DDAllocationsControl.this.copyDDAllocation(dd);
                    }
                }
            });
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDDAllocation dd = DDAllocationsControl.this.getSelectedDDAllocation();
                    if (dd != null) {
                        DDAllocationsControl.this.editDDAllocation(dd);
                    }
                }
            });
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DDAllocationsControl.this.removeSelectedDDAllocations();
                }
            });
            this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDDAllocation alloc = DDAllocationsControl.this.getSelectedDDAllocation();
                    if (alloc != null) {
                        DDAllocationsControl.this.moveAllocation(alloc, true);
                    }
                }
            });
            this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IDDAllocation alloc = DDAllocationsControl.this.getSelectedDDAllocation();
                    if (alloc != null) {
                        DDAllocationsControl.this.moveAllocation(alloc, false);
                    }
                }
            });
        }
        this.updateButtonEnablement();
        this.setButtonLayoutData();
    }

    private IDDAllocation getSelectedDDAllocation() {
        IStructuredSelection selection = this.getCurrentSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IDDAllocation) {
            return (IDDAllocation)element;
        }
        return null;
    }

    protected IStructuredSelection getCurrentSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    public List<IDDAllocation> getDDAllocations() {
        return this.fDDAllocations;
    }

    public void setDDAllocations(List<IDDAllocation> dds) {
        this.fDDAllocations = dds;
        this.resolveDDName();
        this.fTableViewer.setInput(dds);
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
    }

    public void setConcatenations(List<IConcatenation> concats) {
        this.fConcatenations = concats;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                DDAllocationsControl.this.updateButtonEnablement();
            }
        };
    }

    public void addListener(IGenericListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(IGenericListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyDDAllocationsModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IGenericListener) {
                IGenericListener listener = (IGenericListener)listeners[i];
                listener.contentsModified();
            }
            ++i;
        }
    }

    private void addDDAllocation() {
        DDAllocation dd = ModelFactory.eINSTANCE.createDDAllocation();
        DataDefinitionEntry dde = ModelFactory.eINSTANCE.createDataDefinitionEntry();
        dde.setKind("com.ibm.teamz.langdef.entry.data_definition");
        dd.setDataDefinitionEntry((IDataDefinitionEntry)dde);
        DDAllocationDialog dialog = this.getDDAllocationDialog((IDDAllocation)dd, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_ADD_TITLE, true);
        if (dialog.open() == 0) {
            dde.setKind(dialog.getDataDefinitionEntryKind());
            dde.setValue(dialog.getDataDefinitionEntryValue());
            dd.setKeep(dialog.getIsKeep());
            dd.setMod(dialog.getIsMod());
            dd.setMember(dialog.getIsMember());
            dd.setName(dialog.getName());
            dd.setOutput(dialog.getIsOutput());
            dd.setUsedAsInput(dialog.getUsedAsInput());
            if (ZosTranslatorUtil.isMemberRenamed((IDDAllocation)dd)) {
                dd.setOutputName(dialog.getOutputName());
                dd.setOutputNameKind(dialog.getOutputNameKind());
            } else {
                dd.setOutputName(null);
                dd.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
                dd.setUsedAsInput(false);
            }
            dd.setPublish(dialog.getIsPublish());
            dd.setCondition(dialog.getCondition());
            dd.setDeployType(dialog.getDeployType());
            dd.setPublishType(dialog.getPublishType());
            dd.setConsolidateLog(dialog.getConsolidateLog());
            dd.setCompact(dialog.getCompact());
            dd.setHfs(dialog.getHfs());
            this.fDDAllocations.add((IDDAllocation)dd);
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
            this.notifyDDAllocationsModified();
        }
    }

    private void copyDDAllocation(IDDAllocation existingDD) {
        IDDAllocation dd = ModelFactory.eINSTANCE.copyModelDefinition(existingDD);
        dd.setName(String.valueOf(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_COPY_OF) + existingDD.getName());
        DDAllocationDialog dialog = this.getDDAllocationDialog(dd, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_COPY_TITLE, false);
        if (dialog.open() == 0) {
            DataDefinitionEntry dde = ModelFactory.eINSTANCE.createDataDefinitionEntry();
            dde.setKind(dialog.getDataDefinitionEntryKind());
            dde.setValue(dialog.getDataDefinitionEntryValue());
            dd.setKeep(dialog.getIsKeep());
            dd.setMod(dialog.getIsMod());
            dd.setMember(dialog.getIsMember());
            dd.setName(dialog.getName());
            dd.setOutput(dialog.getIsOutput());
            dd.setUsedAsInput(dialog.getUsedAsInput());
            if (ZosTranslatorUtil.isMemberRenamed((IDDAllocation)dd)) {
                dd.setOutputName(dialog.getOutputName());
                dd.setOutputNameKind(dialog.getOutputNameKind());
            } else {
                dd.setOutputName(null);
                dd.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
                dd.setUsedAsInput(false);
            }
            dd.setPublish(dialog.getIsPublish());
            dd.setCondition(dialog.getCondition());
            dd.setDeployType(dialog.getDeployType());
            dd.setPublishType(dialog.getPublishType());
            dd.setConsolidateLog(dialog.getConsolidateLog());
            dd.setCompact(dialog.getCompact());
            dd.setHfs(dialog.getHfs());
            this.fDDAllocations.add(dd);
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
            this.notifyDDAllocationsModified();
        }
    }

    private DDAllocationDialog getDDAllocationDialog(IDDAllocation dd, String title, boolean isNew) {
        return new DDAllocationDialog(this.fParentShell, title, dd, this.fDDAllocations, this.fConcatenations, this.fTranslatorVariables, this.repository, isNew, this.fSystemDefinitionCache, this.validator);
    }

    private void editDDAllocation(IDDAllocation dd) {
        DDAllocationDialog dialog = this.getDDAllocationDialog(dd, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_EDIT_TITLE, false);
        if (dialog.open() == 0) {
            DataDefinitionEntry dde = ModelFactory.eINSTANCE.createDataDefinitionEntry();
            dde.setKind(dialog.getDataDefinitionEntryKind());
            dde.setValue(dialog.getDataDefinitionEntryValue());
            dd.setDataDefinitionEntry((IDataDefinitionEntry)dde);
            dd.setKeep(dialog.getIsKeep());
            dd.setMod(dialog.getIsMod());
            dd.setMember(dialog.getIsMember());
            dd.setName(dialog.getName());
            dd.setOutput(dialog.getIsOutput());
            dd.setUsedAsInput(dialog.getUsedAsInput());
            if (ZosTranslatorUtil.isMemberRenamed((IDDAllocation)dd)) {
                dd.setOutputName(dialog.getOutputName());
                dd.setOutputNameKind(dialog.getOutputNameKind());
            } else {
                dd.setOutputName(null);
                dd.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
            }
            dd.setPublish(dialog.getIsPublish());
            dd.setCondition(dialog.getCondition());
            dd.setSequential(dialog.getIsSequential());
            dd.setDeployType(dialog.getDeployType());
            dd.setPublishType(dialog.getPublishType());
            dd.setConsolidateLog(dialog.getConsolidateLog());
            dd.setCompact(dialog.getCompact());
            dd.setHfs(dialog.getHfs());
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.notifyDDAllocationsModified();
        }
    }

    private void moveAllocation(IDDAllocation alloc, boolean up) {
        int index = this.fDDAllocations.indexOf(alloc);
        if (index != -1) {
            if (up && index == 0 || !up && index == this.fDDAllocations.size() - 1) {
                return;
            }
            this.fDDAllocations.remove(index);
            this.fDDAllocations.add(index += up ? -1 : 1, alloc);
            this.fTableViewer.refresh();
            this.notifyDDAllocationsModified();
            this.updateButtonEnablement();
        }
    }

    private void removeSelectedDDAllocations() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationControl_CONFIRM_TITLE, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IDDAllocation> entriesRemoved = new ArrayList<IDDAllocation>();
            for (IDDAllocation dd : structuredSelection) {
                this.fTableViewer.remove((Object)dd);
                this.fDDAllocations.remove(dd);
                entriesRemoved.add(dd);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updateButtonEnablement();
                this.notifyDDAllocationsModified();
            }
        }
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updateButtonEnablement() {
        if (this.fEditButton == null) {
            return;
        }
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fAddButton.setEnabled(this.isEditable);
        this.fCopyButton.setEnabled(selection.size() == 1);
        this.fEditButton.setEnabled(selection.size() == 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fUpButton.setEnabled(selection.size() == 1 && this.fDDAllocations.indexOf(selection.getFirstElement()) > 0);
        this.fDownButton.setEnabled(selection.size() == 1 && this.fDDAllocations.indexOf(selection.getFirstElement()) < this.fDDAllocations.size() - 1);
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IDDAllocation) {
            IDDAllocation dd = (IDDAllocation)element;
            this.editDDAllocation(dd);
        }
    }

    private void setButtonLayoutData() {
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fCopyButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEditButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fUpButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDownButton);
    }

    public void setEnabled(boolean b) {
        if (!b) {
            this.fAddButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        } else {
            this.updateButtonEnablement();
        }
    }

    private void resolveDDName() {
        if (this.fDDAllocations == null) {
            return;
        }
        SystemDefinitionJob job = new SystemDefinitionJob(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                for (IDDAllocation nextAlloc : DDAllocationsControl.this.fDDAllocations) {
                    IDataDefinitionEntry entry = nextAlloc.getDataDefinitionEntry();
                    if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") || entry.getKind().equals("com.ibm.teamz.langdef.entry.constant.instream") || entry.getKind().equals("com.ibm.teamz.langdef.entry.hfs") || entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && entry.getValue().equals("com.ibm.teamz.langdef.entry.constant.input")) continue;
                    String dataDefUuid = entry.getValue();
                    String label = null;
                    try {
                        if (dataDefUuid.length() > 0 && !this.ddIdExists(dataDefUuid)) {
                            IDataSetDefinition dataDef = null;
                            UUID dataDefUuidValue = UUID.valueOf((String)dataDefUuid);
                            IDataSetDefinitionHandle handle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(dataDefUuidValue, null);
                            dataDef = (IDataSetDefinition)DDAllocationsControl.this.fSystemDefinitionCache.getSystemDefinition((ISystemDefinitionHandle)handle, monitor);
                            nextAlloc.setSequential(dataDef.getDsType() == 1);
                            label = dataDef.getName();
                            if (dataDef.isArchived()) {
                                label = String.valueOf(label) + Messages.SystemDefinition_ARCHIVED_SUFFIX;
                            }
                        }
                    }
                    catch (TeamRepositoryException teamRepositoryException) {
                        // empty catch block
                    }
                    if (label == null) continue;
                    DDAllocationsControl.this.ddIdNameMap.put(entry.getValue(), label);
                }
                return Status.OK_STATUS;
            }

            private boolean ddIdExists(String ddIdKey) {
                if (DDAllocationsControl.this.ddIdNameMap != null && !DDAllocationsControl.this.ddIdNameMap.isEmpty()) {
                    return DDAllocationsControl.this.ddIdNameMap.keySet().contains(ddIdKey);
                }
                return false;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!DDAllocationsControl.this.fTableViewer.getTable().isDisposed()) {
                            DDAllocationsControl.this.fTableViewer.refresh();
                        }
                    }
                });
            }
        };
        job.schedule();
    }

    public String getDDName(IDDAllocation ddAlloc) {
        IDataDefinitionEntry entry = ddAlloc.getDataDefinitionEntry();
        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            return entry.getValue();
        }
        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && entry.getValue().equals("com.ibm.teamz.langdef.entry.constant.input")) {
            return com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryLabelHelper_INPUT;
        }
        if (entry.getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
            return com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryLabelHelper_INSTREAM;
        }
        if (entry.getKind().equals("com.ibm.teamz.langdef.entry.hfs")) {
            return ddAlloc.getHfs() == null ? "" : (ddAlloc.getHfs().getPath() == null ? "" : ddAlloc.getHfs().getPath());
        }
        String label = this.ddIdNameMap.get(entry.getValue());
        if (label == null) {
            return com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationLabelProvider_PENDING;
        }
        return label;
    }
}

