/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DDAllocationsControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataDefinitionEntryLabelHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class DDAllocationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected TableViewer fTableViewer;
    private ITeamRepository fTeamRepository;
    private DDAllocationsControl control;
    protected Map<String, String> fValueToLabelMap = new HashMap<String, String>();

    public DDAllocationLabelProvider(TableViewer tableViewer, ITeamRepository repo, DDAllocationsControl control) {
        this.fTableViewer = tableViewer;
        this.fTeamRepository = repo;
        this.control = control;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IDDAllocation dd = (IDDAllocation)element;
        switch (columnIndex) {
            case 0: {
                return dd.getName();
            }
            case 1: {
                if (this.control != null) {
                    return this.control.getDDName(dd);
                }
                return dd.getDataDefinitionEntry().getValue();
            }
            case 2: {
                if (dd.isMember()) {
                    return Messages.ConcatenationLabelProvider_YES;
                }
                return "";
            }
            case 3: {
                if (!dd.isMember()) {
                    return "";
                }
                OutputNameKind outputKind = dd.getOutputNameKind();
                if (outputKind == OutputNameKind.SAME_AS_INPUT_LITERAL) {
                    return Messages.ConcatenationLabelProvider_SAME_AS_INPUT;
                }
                if (outputKind == OutputNameKind.USE_VARIABLE_LITERAL) {
                    return "&" + dd.getOutputName();
                }
                return dd.getOutputName();
            }
            case 4: {
                return dd.getCondition() == null ? "" : dd.getCondition();
            }
            case 5: {
                if (dd.isKeep()) {
                    return Messages.ConcatenationLabelProvider_YES;
                }
                return "";
            }
            case 6: {
                if (dd.isMod()) {
                    return Messages.ConcatenationLabelProvider_YES;
                }
                return "";
            }
            case 7: {
                if (dd.isOutput()) {
                    return Messages.ConcatenationLabelProvider_YES;
                }
                return "";
            }
            case 8: {
                if (dd.isOutput()) {
                    if (dd.isUsedAsInput()) {
                        return Messages.ConcatenationLabelProvider_YES;
                    }
                    return Messages.ConcatenationLabelProvider_NO;
                }
                return "";
            }
            case 9: {
                if (!dd.isOutput()) {
                    return "";
                }
                return dd.getDeployType();
            }
            case 10: {
                switch (dd.getPublishType()) {
                    case 1: {
                        return Messages.DDAllocationDialog_PUBLISH_INHERIT_LABEL;
                    }
                    case 2: {
                        return Messages.DDAllocationDialog_PUBLISH_ALWAYS_LABEL;
                    }
                    case 3: {
                        return Messages.DDAllocationDialog_PUBLISH_ON_ERROR_LABEL;
                    }
                }
                return "";
            }
            case 11: {
                switch (dd.getConsolidateLog()) {
                    case 1: {
                        return Messages.DDAllocationDialog_CONSOLIDATE_NEVER_LABEL;
                    }
                    case 2: {
                        return Messages.DDAllocationDialog_CONSOLIDATE_ALWAYS_LABEL;
                    }
                    case 3: {
                        return Messages.DDAllocationDialog_CONSOLIDATE_ON_SUCCESS_LABEL;
                    }
                }
                return "";
            }
            case 12: {
                switch (dd.getCompact()) {
                    case 1: {
                        return Messages.ConcatenationLabelProvider_NO;
                    }
                    case 2: {
                        return Messages.ConcatenationLabelProvider_YES;
                    }
                }
                return "";
            }
        }
        return null;
    }

    protected DataDefinitionEntryLabelHelper getLabelHelper() {
        return new DataDefinitionEntryLabelHelper(this.control.getSystemDefinitionCache()){

            @Override
            public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!DDAllocationLabelProvider.this.fTableViewer.getTable().isDisposed()) {
                    DDAllocationLabelProvider.this.fValueToLabelMap.put(dataDefEntry.getValue(), label);
                    DDAllocationLabelProvider.this.fTableViewer.refresh();
                }
            }
        };
    }

    protected IModeledDataDefinitionEntryContext getDataDefinitionEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        return new IModeledDataDefinitionEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry getModeledEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return DDAllocationLabelProvider.this.fTeamRepository;
            }

            @Override
            public IDataDefinitionEntry getEntry() {
                return null;
            }
        };
    }
}

