/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.client.ClientFactory;
import com.ibm.team.enterprise.systemdefinition.client.ISystemDefinitionModelClient;
import com.ibm.team.enterprise.systemdefinition.common.MemberNamePattern;
import com.ibm.team.enterprise.systemdefinition.common.helper.ValidationHelper;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.HFSDD;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.StringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IHFSDD;
import com.ibm.team.enterprise.systemdefinition.common.model.IStringHelper;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.IVariable;
import com.ibm.team.enterprise.systemdefinition.common.model.IZosPlatformObject;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.common.model.OutputNameKind;
import com.ibm.team.enterprise.systemdefinition.common.util.SystemDefinitionUtil;
import com.ibm.team.enterprise.systemdefinition.common.util.VariableUtils;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.dialogs.VariableSelectionDialog;
import com.ibm.team.enterprise.systemdefinition.ui.editors.AbstractSystemDefinitionEditor;
import com.ibm.team.enterprise.systemdefinition.ui.helper.ConditionValidator;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.ZDefUIPlugin;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataDefinitionEntryLabelHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataSetDefinitionSelectionDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.GeneralTranslatorEditorPage;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.HFSPropertiesDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ZOSTranslatorValidator;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.fieldassist.ControlDecoration;
import org.eclipse.jface.fieldassist.FieldDecorationRegistry;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleAdapter;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

public class DDAllocationDialog
extends TitleAreaDialog {
    protected Button fBrowseButton;
    protected Button fCompactAlwaysButton;
    protected Button fCompactInheritButton;
    protected Button fCompactNeverButton;
    protected Button fConsolidateAlwaysButton;
    protected Button fConsolidateInheritButton;
    protected Button fConsolidateNeverButton;
    protected Button fConsolidateOnSuccessButton;
    protected Button fDataDefEntryInStreamButtonInput;
    protected Button fDataDefEntryKindButtonDataDef;
    protected Button fDataDefEntryKindButtonHfs;
    protected Button fDataDefEntryKindButtonInput;
    protected Button fDataDefEntryKindButtonSubParam;
    protected Button fDeployTypeBrowseButton;
    protected Button fEditDataDefEntryButton;
    protected Button fHfsOptsButton;
    protected Button fKeepButton;
    protected Button fMemberButton;
    protected Button fMemberNameButton;
    protected Button fModButton;
    protected Button fOutputButton;
    protected Button fPublishAlwaysButton;
    protected Button fPublishInheritButton;
    protected Button fPublishNeverButton;
    protected Button fPublishOnErrorButton;
    protected Button fSequentialFlagButton;
    protected Button fUsedAsInputFlagButton;
    protected Button fVariableBrowseButton;
    protected Composite fComposite;
    protected Composite publishComposite;
    protected Label fCompactLabel;
    protected Label fConsolidateLabel;
    protected Label fDeployTypeLabel;
    protected Label fExampleLabel;
    protected Label fMemberOutputNameLabel;
    protected Label fPublishLabel;
    protected ModifyListener ddNameTextListener;
    protected ModifyListener hfsTextListener;
    protected ModifyListener inStreamTextListener;
    protected ModifyListener subParamTextListener;
    protected Shell fParentShell;
    protected TabFolder tabFolder;
    protected TabItem dataSetTab;
    protected TabItem otherPropertiesTab;
    protected TabItem outputTab;
    protected TabItem publishingTab;
    protected Text fConditionalText;
    protected Text fDDNameText;
    protected Text fDataDefinitionText;
    protected Text fDeployTypeText = null;
    protected Text fHfsText;
    protected Text fInStreamText;
    protected Text fMemberOutputName;
    protected Text fSubParamText;
    private final IDDAllocation fDD;
    private final ISystemDefinitionCache definitionCache;
    private final ITeamRepository repository;
    private final MappingValidation validator;
    private final boolean isNew;
    private final String fTitle;
    private String patternErrorMessage;
    private final String EXAMPLE_OBJECT = "ORDENTR";
    private final String fOriginalName;
    private final List<IConcatenation> fExistingConcatenations;
    private final List<IDDAllocation> fExistingDDs;
    private final List<IVariable> fTranslatorVars;

    public DDAllocationDialog(Shell parentShell, String title, IDDAllocation dd, List<IDDAllocation> existingDDs, List<IConcatenation> existingConcats, List<IVariable> translatorVariables, ITeamRepository repository, boolean isNew, ISystemDefinitionCache definitionCache, MappingValidation validator) {
        super(parentShell);
        ValidationHelper.validateNotNull((String)"title", (Object)title);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fTitle = title;
        this.fParentShell = parentShell;
        this.fExistingDDs = existingDDs;
        this.fExistingConcatenations = existingConcats;
        this.fTranslatorVars = translatorVariables;
        DataDefinitionEntry dde = ModelFactory.eINSTANCE.createDataDefinitionEntry();
        this.fDD = ModelFactory.eINSTANCE.createDDAllocation();
        dde.setKind(dd.getDataDefinitionEntry().getKind());
        dde.setValue(dd.getDataDefinitionEntry().getValue());
        this.fDD.setDataDefinitionEntry((com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry)dde);
        this.fDD.setName(dd.getName());
        this.fDD.setUsedAsInput(dd.isUsedAsInput());
        this.fDD.setKeep(dd.isKeep());
        this.fDD.setMod(dd.isMod());
        this.fDD.setMember(dd.isMember());
        this.fDD.setOutput(dd.isOutput());
        this.fDD.setOutputName(dd.getOutputName());
        this.fDD.setOutputNameKind(dd.getOutputNameKind());
        this.fDD.setPublish(dd.isPublish());
        this.fDD.setDeployType(dd.getDeployType());
        this.fDD.setPublishType(dd.getPublishType());
        this.fDD.setConsolidateLog(dd.getConsolidateLog());
        this.fDD.setCompact(dd.getCompact());
        this.fDD.setCondition(dd.getCondition());
        this.fDD.setSequential(dd.isSequential());
        if (dde.getValue() != null && !dde.getValue().isEmpty()) {
            this.setSequentialInBackGround(repository, (com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry)dde, dd);
        }
        this.repository = repository;
        this.isNew = isNew;
        this.definitionCache = definitionCache;
        this.validator = validator;
        this.fOriginalName = dd.getName();
        if (dd.getHfs() != null) {
            IHFSDD currentHFS = dd.getHfs();
            HFSDD workingCopy = ModelFactory.eINSTANCE.createHFSDD();
            workingCopy.setFileType(currentHFS.getFileType());
            workingCopy.setPath(currentHFS.getPath());
            workingCopy.setPathDisp(currentHFS.getPathDisp());
            workingCopy.setPathPerm(currentHFS.getPathPerm());
            List currentOptsList = currentHFS.getPathOpts();
            List listeWorking = workingCopy.getPathOpts();
            for (IStringHelper option : currentOptsList) {
                StringHelper sh = ModelFactory.eINSTANCE.createStringHelper();
                sh.setValue(option.getValue());
                listeWorking.add(sh);
            }
            this.fDD.setHfs((IHFSDD)workingCopy);
        }
    }

    private void setSequentialInBackGround(ITeamRepository teamRepository, final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dde, final IDDAllocation dd) {
        Job job = new Job(""){

            protected IStatus run(IProgressMonitor monitor) {
                IDataSetDefinition dataDef = DDAllocationDialog.this.getDataSetDefinition(dde.getValue());
                dd.setSequential(dataDef != null && dataDef.getDsType() == 1);
                return Status.OK_STATUS;
            }
        };
        job.schedule();
    }

    protected void validate(boolean suppressErrorMessage) {
        String dsName;
        String value;
        IDataSetDefinition dsd;
        String con;
        IDataSetDefinition dataDef;
        if (suppressErrorMessage) {
            this.setMessage(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HEADER);
            this.setErrorMessage(null);
        }
        String errorMessage = null;
        String warningMessage = null;
        String proposedName = this.fDDNameText.getText().trim();
        errorMessage = proposedName == null || proposedName.isEmpty() ? com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_REQUIRED : (this.validator.isValidDDName(proposedName) != 0 ? NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationDialog_DD_NAME_INVALID, (Object)proposedName) : this.nameConflict(proposedName));
        if (errorMessage == null && this.fDD.getDataDefinitionEntry() == null) {
            errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DATA_DEF_REQUIRED;
        }
        if (errorMessage == null && (this.fDD.getDataDefinitionEntry().getValue() == null || this.fDD.getDataDefinitionEntry().getValue().trim().isEmpty())) {
            if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
                errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DATA_DEF_SELECTION_REQUIRED;
            } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_SUB_PARAM_REQUIRED;
            } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
                errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_INSTREAM_REQUIRED;
            }
        }
        if (errorMessage == null && this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            if (this.fSubParamText.getText().trim().indexOf(32) > -1) {
                errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.Common_NO_SPACES_IN_BUILD_PROPERTY;
            } else if (!AbstractSystemDefinitionEditor.isValidBuildProperty((String)this.fSubParamText.getText().trim())) {
                errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.Common_INVALID_BUILD_PROPERTY_NAME;
            }
        }
        if (errorMessage == null && this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition") && (dataDef = this.getDataSetDefinition(this.fDD.getDataDefinitionEntry().getValue())) != null && dataDef.getUsageType() == 1 && this.fDD.isOutput() && !this.fDD.isMember() && !this.fDD.isSequential()) {
            errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.Common_OUTPUT_MEMBER_COMPATIBILITY;
        }
        if (errorMessage == null && this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.hfs") && (this.fDD.getHfs() == null || this.fDD.getHfs().getPath() == null || this.fDD.getHfs().getPath().isEmpty())) {
            errorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.Common_HFS_CANNOT_BE_EMPTY;
        }
        if (errorMessage == null && this.fDeployTypeText.isEnabled()) {
            String deployText = this.fDeployTypeText.getText().trim();
            errorMessage = ZOSTranslatorValidator.getInstance().getErrorMsgVariableInDeployType(deployText, this.fTranslatorVars, false);
        }
        if (errorMessage == null && this.patternErrorMessage != null && this.fMemberNameButton.getSelection() && this.fMemberNameButton.isEnabled()) {
            errorMessage = this.patternErrorMessage;
        }
        if (errorMessage == null && this.fConditionalText != null && (con = this.fConditionalText.getText()) != null && !con.isEmpty()) {
            IStatus error = ConditionValidator.validate((String)con);
            if (error != null && error.matches(4)) {
                errorMessage = error.getMessage();
            } else if (error != null && error.matches(2)) {
                warningMessage = error.getMessage();
            }
        }
        if (errorMessage == null && this.fDD.isOutput() && this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition") && (dsd = this.getDataSetDefinition(value = this.fDD.getDataDefinitionEntry().getValue())) != null && SystemDefinitionUtil.hasAntBuildProperty((String)(dsName = dsd.getDsName()))) {
            errorMessage = NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_BUILD_PROPERTY_DISALLOWED, (Object[])new String[]{dsName, dsd.getName()});
        }
        if (errorMessage == null) {
            this.setErrorMessage(null);
            if (warningMessage != null) {
                this.setMessage(warningMessage, 2);
            } else {
                this.setMessage(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HEADER);
            }
        } else {
            this.setErrorMessage(errorMessage);
        }
        Button okButton = this.getButton(0);
        if (okButton != null) {
            okButton.setEnabled(errorMessage == null);
        }
    }

    protected Control createDialogArea(Composite parent) {
        this.fComposite = (Composite)super.createDialogArea(parent);
        Composite dialogComposite = new Composite(this.fComposite, 0);
        dialogComposite.setLayout((Layout)new GridLayout(2, false));
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)dialogComposite);
        this.setTitle(this.fTitle);
        this.setMessage(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HEADER);
        Label label = new Label(dialogComposite, 0);
        label.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_LABEL);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        label.setLayoutData((Object)gridData);
        this.fDDNameText = new Text(dialogComposite, 2052);
        gridData = new GridData(768);
        gridData.horizontalSpan = 1;
        if (this.fDD.getName() != null) {
            this.fDDNameText.setText(this.fDD.getName());
        }
        this.fDDNameText.setLayoutData((Object)gridData);
        this.ddNameTextListener = this.getNameModifiedListener();
        this.fDDNameText.addModifyListener(this.ddNameTextListener);
        this.createSpacer(dialogComposite, 5, 2);
        this.tabFolder = new TabFolder(dialogComposite, 0x800880);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 1).applyTo((Control)this.tabFolder);
        this.createTabs();
        this.initWidgetValues();
        DDAllocationDialog.applyDialogFont((Control)dialogComposite);
        this.fDDNameText.setFocus();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, "com.ibm.team.build.ui.dialog_ddallocation");
        return this.fComposite;
    }

    protected void createTabs() {
        this.createDataSetTab();
        this.createOutputTab();
        this.createPublishTab();
        this.createOtherPropertiesTab();
        this.tabFolder.setSelection(0);
    }

    protected void createDataSetTab() {
        this.dataSetTab = new TabItem(this.tabFolder, 0);
        this.dataSetTab.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DATA_SET_TAB_LABEL);
        Composite dsComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayoutFactory.fillDefaults().numColumns(3).extendedMargins(5, 5, 5, 5).applyTo(dsComposite);
        this.dataSetTab.setControl((Control)dsComposite);
        this.fDataDefEntryKindButtonDataDef = this.createKindRadioButton(dsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_DATA_DEF, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_DATA_DEF_TOOLTIP, false, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fDataDefEntryKindButtonDataDef);
        this.fDataDefinitionText = new Text(dsComposite, 2052);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDataDefinitionText);
        this.fDataDefinitionText.setEditable(false);
        this.fDataDefinitionText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_DATA_DEF;
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fDataDefinitionText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_DATA_DEF_TOOLTIP, true);
        this.fBrowseButton = new Button(dsComposite, 0);
        this.fBrowseButton.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fBrowseButton.addSelectionListener(this.getEditButtonSelectionListener());
        this.fBrowseButton.setEnabled(false);
        this.fDataDefEntryKindButtonSubParam = this.createKindRadioButton(dsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_SUB_PARAM, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_SUB_PARAM_TOOLTIP, false, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fDataDefEntryKindButtonSubParam);
        this.fSubParamText = new Text(dsComposite, 2052);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, false).applyTo((Control)this.fSubParamText);
        this.fSubParamText.setEnabled(false);
        this.fSubParamText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_SUB_PARAM;
            }
        });
        this.subParamTextListener = this.getSubParamModifiedListener();
        this.fSubParamText.addModifyListener(this.subParamTextListener);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fSubParamText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_SUB_PARAM_TOOLTIP, true);
        this.fDataDefEntryKindButtonHfs = this.createKindRadioButton(dsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HFSPATH_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HFSPATH_TOOLTIP, false, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fDataDefEntryKindButtonHfs);
        this.fHfsText = new Text(dsComposite, 2052);
        GridDataFactory.fillDefaults().applyTo((Control)this.fHfsText);
        this.fHfsText.setEnabled(false);
        this.fHfsText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HFSPATH_LABEL;
            }
        });
        this.hfsTextListener = this.getHfsListener();
        this.fHfsText.addModifyListener(this.hfsTextListener);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fHfsText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_HFSPATH_TOOLTIP, true);
        this.fHfsOptsButton = new Button(dsComposite, 0);
        this.fHfsOptsButton.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PROPERTIES_BUTTON_LABEL);
        this.fHfsOptsButton.addSelectionListener(this.getHFSPropertiesButtonSelectionListener());
        this.fHfsOptsButton.setEnabled(false);
        this.fDataDefEntryKindButtonInput = this.createKindRadioButton(dsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_INPUT, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KIND_INPUT_TOOLTIP, false, 16400);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.fDataDefEntryKindButtonInput);
        this.fDataDefEntryInStreamButtonInput = this.createKindRadioButton(dsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_INSTREAM_DD, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_INSTREAM_DD_TOOLTIP, true, 16400);
        GridDataFactory.fillDefaults().span(3, 1).grab(true, false).applyTo((Control)this.fDataDefEntryInStreamButtonInput);
        this.fInStreamText = new Text(dsComposite, 2626);
        GridDataFactory.fillDefaults().span(3, -1).hint(-1, 60).grab(true, true).applyTo((Control)this.fInStreamText);
        this.fInStreamText.setEnabled(false);
        this.fInStreamText.getAccessible().addAccessibleListener((AccessibleListener)new AccessibleAdapter(){

            public void getName(AccessibleEvent e) {
                e.result = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_INSTREAM_DD;
            }
        });
        this.inStreamTextListener = this.getInStreamListener();
        this.fInStreamText.addModifyListener(this.inStreamTextListener);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fInStreamText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_INSTREAM_DD_TOOLTIP, true);
    }

    protected void createOutputTab() {
        this.outputTab = new TabItem(this.tabFolder, 0);
        this.outputTab.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_OUTPUT_TAB_LABEL);
        Composite outputsComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).applyTo(outputsComposite);
        this.outputTab.setControl((Control)outputsComposite);
        this.fOutputButton = this.createCheckbox(outputsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_OUTPUT_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fOutputButton, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_OUTPUT_TOOLTIP, false);
        this.fOutputButton.setSelection(this.fDD.isOutput());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fOutputButton.setLayoutData((Object)gridData);
        this.fOutputButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.updateOutputControls();
                DDAllocationDialog.this.validate(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        this.fUsedAsInputFlagButton = this.createCheckbox(outputsComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_USEDASINPUT_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fUsedAsInputFlagButton, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_USEDASINPUT_TOOLTIP, false);
        this.fUsedAsInputFlagButton.setSelection(this.fDD.isUsedAsInput());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fUsedAsInputFlagButton.setLayoutData((Object)gridData);
        this.fUsedAsInputFlagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.fDD.setUsedAsInput(DDAllocationDialog.this.fUsedAsInputFlagButton.getSelection());
                DDAllocationDialog.this.validate(false);
            }
        });
        IDataSetDefinition dataDef = this.getDataSetDefinition(this.fDD.getDataDefinitionEntry().getValue());
        if (dataDef != null && dataDef.getUsageType() == 2) {
            this.fDD.setOutput(false);
            this.fOutputButton.setSelection(false);
        }
        Composite fdeployTypeComposite = new Composite(outputsComposite, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)fdeployTypeComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(fdeployTypeComposite);
        this.fDeployTypeLabel = new Label(fdeployTypeComposite, 0);
        this.fDeployTypeLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DEPLOYTYPE_LABEL);
        gridData = new GridData();
        this.fDeployTypeLabel.setLayoutData((Object)gridData);
        this.fDeployTypeText = new Text(fdeployTypeComposite, 2052);
        gridData = new GridData(768);
        this.fDeployTypeText.setLayoutData((Object)gridData);
        this.fDeployTypeText.setText(this.fDD.getDeployType() != null ? this.fDD.getDeployType() : "");
        this.fDeployTypeText.setTextLimit(25);
        this.addControlDecorator((Control)this.fDeployTypeText, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DEPLOYTYPE_DECORATORTEXT, 131072);
        this.fDeployTypeText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DDAllocationDialog.this.fDD.setDeployType(DDAllocationDialog.this.fDeployTypeText.getText().trim());
                DDAllocationDialog.this.validate(true);
            }
        });
        this.fDeployTypeBrowseButton = new Button(fdeployTypeComposite, 8);
        this.fDeployTypeBrowseButton.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fDeployTypeBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newVariableName = DDAllocationDialog.this.openVariableSelectionDialog();
                if (newVariableName != null) {
                    DDAllocationDialog.this.fDeployTypeText.setText(newVariableName);
                }
            }
        });
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)this.fDeployTypeBrowseButton);
    }

    protected void createPublishTab() {
        this.publishingTab = new TabItem(this.tabFolder, 0);
        this.publishingTab.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISHING_TAB_LABEL);
        this.publishComposite = new Composite((Composite)this.tabFolder, 0);
        GridDataFactory.fillDefaults().span(2, 1).grab(true, true).applyTo((Control)this.publishComposite);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).applyTo(this.publishComposite);
        this.publishingTab.setControl((Control)this.publishComposite);
        this.fPublishLabel = new Label(this.publishComposite, 0);
        this.fPublishLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_LABEL);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fPublishLabel, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_LABEL_TOOLTIP, false);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPublishLabel);
        Composite publishTypeComposite = new Composite(this.publishComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)publishTypeComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(publishTypeComposite);
        this.fPublishInheritButton = this.createPublishTypeRadioButton(publishTypeComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_INHERIT_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_INHERIT_LABEL_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPublishInheritButton);
        this.fPublishNeverButton = this.createPublishTypeRadioButton(publishTypeComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_NEVER_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_NEVER_LABEL_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPublishNeverButton);
        this.fPublishAlwaysButton = this.createPublishTypeRadioButton(publishTypeComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_ALWAYS_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_ALWAYS_LABEL_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPublishAlwaysButton);
        this.fPublishOnErrorButton = this.createPublishTypeRadioButton(publishTypeComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_ON_ERROR_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PUBLISH_ON_ERROR_LABEL_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fPublishOnErrorButton);
        switch (this.getDDPublishType()) {
            case 2: {
                this.fPublishAlwaysButton.setSelection(true);
                break;
            }
            case 1: {
                this.fPublishInheritButton.setSelection(true);
                break;
            }
            case 3: {
                this.fPublishOnErrorButton.setSelection(true);
                break;
            }
            default: {
                this.fPublishNeverButton.setSelection(true);
            }
        }
        this.fConsolidateLabel = new Label(this.publishComposite, 0);
        this.fConsolidateLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_LABEL);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fConsolidateLabel, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_LABEL_TOOLTIP, false);
        GridDataFactory.fillDefaults().applyTo((Control)this.fConsolidateLabel);
        Composite consolidateComposite = new Composite(this.publishComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)consolidateComposite);
        GridLayoutFactory.fillDefaults().numColumns(4).applyTo(consolidateComposite);
        this.fConsolidateInheritButton = this.createPublishConsolidationRadioButton(consolidateComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_INHERIT_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_INHERIT_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fConsolidateInheritButton);
        this.fConsolidateNeverButton = this.createPublishConsolidationRadioButton(consolidateComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_NEVER_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_NEVER_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fConsolidateNeverButton);
        this.fConsolidateAlwaysButton = this.createPublishConsolidationRadioButton(consolidateComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_ALWAYS_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_ALWAYS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fConsolidateAlwaysButton);
        this.fConsolidateOnSuccessButton = this.createPublishConsolidationRadioButton(consolidateComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_ON_SUCCESS_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONSOLIDATE_ON_SUCCESS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fConsolidateOnSuccessButton);
        switch (this.fDD.getConsolidateLog()) {
            case 2: {
                this.fConsolidateAlwaysButton.setSelection(true);
                break;
            }
            case 1: {
                this.fConsolidateNeverButton.setSelection(true);
                break;
            }
            case 3: {
                this.fConsolidateOnSuccessButton.setSelection(true);
                break;
            }
            default: {
                this.fConsolidateInheritButton.setSelection(true);
            }
        }
        this.fCompactLabel = new Label(this.publishComposite, 0);
        this.fCompactLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_LABEL);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fCompactLabel, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_LABEL_TOOLTIP, false);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCompactLabel);
        Composite compatComposite = new Composite(this.publishComposite, 0);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)compatComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).applyTo(compatComposite);
        this.fCompactInheritButton = this.createPublishCompactRadioButton(compatComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_INHERIT_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_INHERIT_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCompactInheritButton);
        this.fCompactNeverButton = this.createPublishCompactRadioButton(compatComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_NEVER_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_NEVER_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCompactNeverButton);
        this.fCompactAlwaysButton = this.createPublishCompactRadioButton(compatComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_ALWAYS_LABEL, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_COMPACT_ALWAYS_TOOLTIP, 16400);
        GridDataFactory.fillDefaults().applyTo((Control)this.fCompactAlwaysButton);
        switch (this.fDD.getCompact()) {
            case 2: {
                this.fCompactAlwaysButton.setSelection(true);
                break;
            }
            case 1: {
                this.fCompactNeverButton.setSelection(true);
                break;
            }
            default: {
                this.fCompactInheritButton.setSelection(true);
            }
        }
    }

    protected void createOtherPropertiesTab() {
        this.otherPropertiesTab = new TabItem(this.tabFolder, 0);
        this.otherPropertiesTab.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_OTHER_PROPERTIES_TAB_LABEL);
        Composite otherPropertiesComposite = new Composite((Composite)this.tabFolder, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).extendedMargins(5, 5, 5, 5).applyTo(otherPropertiesComposite);
        this.otherPropertiesTab.setControl((Control)otherPropertiesComposite);
        this.fSequentialFlagButton = this.createCheckbox(otherPropertiesComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_SEQUENTIAL_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fSequentialFlagButton, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_SEQUENTIAL_TOOLTIP, false);
        this.fSequentialFlagButton.setSelection(this.fDD.isSequential());
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fSequentialFlagButton.setLayoutData((Object)gridData);
        this.fSequentialFlagButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.fDD.setSequential(DDAllocationDialog.this.fSequentialFlagButton.getSelection());
                DDAllocationDialog.this.updateOutputNameOrPattern();
                DDAllocationDialog.this.validate(false);
            }
        });
        this.fMemberButton = this.createCheckbox(otherPropertiesComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MEMBER_LABEL, 32);
        this.fMemberButton.setSelection(this.fDD.isMember());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fMemberButton.setLayoutData((Object)gridData);
        this.fMemberButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.fDD.setMember(DDAllocationDialog.this.fMemberButton.getSelection());
                DDAllocationDialog.this.validate(false);
            }
        });
        this.fKeepButton = this.createCheckbox(otherPropertiesComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KEEP_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fKeepButton, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_KEEP_TOOLTIP, false);
        this.fKeepButton.setSelection(this.fDD.isKeep());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fKeepButton.setLayoutData((Object)gridData);
        this.fKeepButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.fDD.setKeep(DDAllocationDialog.this.fKeepButton.getSelection());
            }
        });
        this.fModButton = this.createCheckbox(otherPropertiesComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MOD_LABEL, 32);
        this.fModButton.setSelection(this.fDD.isMod());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fModButton.setLayoutData((Object)gridData);
        this.fModButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.fDD.setMod(DDAllocationDialog.this.fModButton.getSelection());
            }
        });
        this.fMemberNameButton = this.createCheckbox(otherPropertiesComposite, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MEMBERNAME_LABEL, 32);
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)this.fMemberNameButton, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MEMBERNAME_TOOLTIP, false);
        this.fMemberNameButton.setSelection(this.fDD.getOutputName() != null && !this.fDD.getOutputName().isEmpty());
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        this.fMemberNameButton.setLayoutData((Object)gridData);
        this.fMemberNameButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.updateMemberRenameControls();
                DDAllocationDialog.this.validate(false);
            }
        });
        Composite fPatternComposite = new Composite(otherPropertiesComposite, 0);
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)fPatternComposite);
        GridLayoutFactory.fillDefaults().numColumns(3).equalWidth(false).applyTo(fPatternComposite);
        this.fMemberOutputNameLabel = new Label(fPatternComposite, 0);
        this.fMemberOutputNameLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MEMBERNAMEPATTERN_LABEL);
        this.fMemberOutputNameLabel.setEnabled(this.fMemberNameButton.getSelection());
        gridData = new GridData();
        this.fMemberOutputNameLabel.setLayoutData((Object)gridData);
        this.fMemberOutputName = new Text(fPatternComposite, 2052);
        gridData = new GridData(768);
        this.fMemberOutputName.setEnabled(this.fMemberNameButton.getSelection());
        if (this.fDD.getOutputName() != null) {
            String existingPattern = this.fDD.getOutputName();
            this.fMemberOutputName.setText(this.fDD.getOutputNameKind() == OutputNameKind.USE_VARIABLE_LITERAL ? "&" + existingPattern : existingPattern);
            this.fMemberOutputName.setEnabled(true);
        }
        this.fMemberOutputName.setLayoutData((Object)gridData);
        this.fMemberOutputName.addModifyListener(this.getOutputNameModifiedListener());
        this.addControlDecorator((Control)this.fMemberOutputName, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_MEMBERNAMEPATTERN_DECORATORTEXT, 131072);
        this.fVariableBrowseButton = new Button(fPatternComposite, 8);
        this.fVariableBrowseButton.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_BROWSE_BUTTON_WITH_ELLIPSIS);
        this.fVariableBrowseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String newVariableName = DDAllocationDialog.this.openVariableSelectionDialog();
                if (newVariableName != null) {
                    DDAllocationDialog.this.fMemberOutputName.setText(newVariableName);
                }
            }
        });
        GridDataFactory.fillDefaults().indent(5, 0).applyTo((Control)this.fVariableBrowseButton);
        new Label(fPatternComposite, 0);
        this.fExampleLabel = new Label(fPatternComposite, 64);
        String dummyExampleString = NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_RenameExampleLabel, (Object)"ORDENTR", (Object)"12345678");
        this.fExampleLabel.setText(dummyExampleString);
        this.fExampleLabel.setVisible(false);
        GridDataFactory.fillDefaults().grab(true, true).span(2, 2).hint(40, 40).applyTo((Control)this.fExampleLabel);
        this.fExampleLabel.setForeground(PlatformUI.getWorkbench().getDisplay().getSystemColor(16));
        Label conditionalLabel = new Label(otherPropertiesComposite, 0);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        conditionalLabel.setText(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_CONDITION);
        conditionalLabel.setLayoutData((Object)gridData);
        this.fConditionalText = new Text(otherPropertiesComposite, 2818);
        GridDataFactory.fillDefaults().span(2, -1).hint(-1, 10).grab(true, true).applyTo((Control)this.fConditionalText);
        this.updateCondition();
        this.fConditionalText.addModifyListener(this.getConditionModifiedListener());
        Label conditionalInfoLabel = new Label(otherPropertiesComposite, 64);
        conditionalInfoLabel.setText(Messages.Common_CONDITION_INFORMATIONAL);
        conditionalInfoLabel.setForeground(Display.getCurrent().getSystemColor(16));
        GridDataFactory.fillDefaults().grab(true, false).span(2, -1).hint(100, -1).applyTo((Control)conditionalInfoLabel);
    }

    protected void updateCondition() {
        String text = "";
        if (this.fDD.getCondition() != null) {
            text = this.fDD.getCondition();
        }
        this.fConditionalText.setText(text);
    }

    private ModifyListener getConditionModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DDAllocationDialog.this.validate(false);
                DDAllocationDialog.this.fDD.setCondition(DDAllocationDialog.this.fConditionalText.getText().trim());
            }
        };
    }

    private SelectionListener getHFSPropertiesButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.editHFSProperties();
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    private SelectionListener getEditButtonSelectionListener() {
        return new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.editDataDefinition();
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    private void updateMemberRenameControls() {
        this.fMemberNameButton.setEnabled(this.fDataDefEntryKindButtonDataDef.getSelection() || this.fDataDefEntryKindButtonSubParam.getSelection());
        boolean isMemberName = this.fMemberNameButton.isEnabled() && this.fMemberNameButton.getSelection();
        this.fMemberOutputNameLabel.setEnabled(isMemberName);
        this.fMemberOutputName.setEnabled(isMemberName);
        this.fVariableBrowseButton.setEnabled(isMemberName);
        this.updateOutputNameOrPattern();
    }

    private void editHFSProperties() {
        HFSPropertiesDialog dialog;
        HFSDD workingCopy = ModelFactory.eINSTANCE.createHFSDD();
        IHFSDD currentHFS = this.fDD.getHfs();
        if (currentHFS != null) {
            workingCopy.setFileType(currentHFS.getFileType());
            workingCopy.setPath(currentHFS.getPath());
            workingCopy.setPathDisp(currentHFS.getPathDisp());
            workingCopy.setPathPerm(currentHFS.getPathPerm());
            List currentOptsList = currentHFS.getPathOpts();
            List listeWorking = workingCopy.getPathOpts();
            for (IStringHelper option : currentOptsList) {
                StringHelper sh = ModelFactory.eINSTANCE.createStringHelper();
                sh.setValue(option.getValue());
                listeWorking.add(sh);
            }
        }
        if ((dialog = new HFSPropertiesDialog(this.fComposite.getShell(), workingCopy)).open() == 0) {
            this.fDD.setHfs((IHFSDD)workingCopy);
        }
    }

    private void editDataDefinition() {
        try {
            ISystemDefinition dsdef;
            DataSetDefinitionSelectionDialog dialog = new DataSetDefinitionSelectionDialog(this.fComposite.getShell(), this.repository, null);
            if (dialog.open() == 0 && (dsdef = dialog.getSelectedSystemDefinition()) != null) {
                this.fSequentialFlagButton.setEnabled(false);
                IDataSetDefinition dataDef = this.getDataSetDefinition((ISystemDefinitionHandle)dsdef);
                this.fDD.getDataDefinitionEntry().setValue(dsdef.getItemId().getUuidValue());
                this.fDD.setSequential(dataDef.getDsType() == 1);
                this.fSequentialFlagButton.setSelection(this.fDD.isSequential());
                if (dataDef.getUsageType() == 2) {
                    this.fDD.setOutput(false);
                }
                this.fDataDefinitionText.setText(dsdef.getName());
                this.updateOutputControls();
                this.updatePublishControlEnablement();
            }
        }
        catch (TeamRepositoryException teamRepositoryException) {
            // empty catch block
        }
    }

    private Button createCheckbox(Composite composite, String text, int check) {
        Button checkBox = new Button(composite, check);
        checkBox.setText(text);
        return checkBox;
    }

    private Button createPublishTypeRadioButton(Composite parent, String text, String tooltip, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.updatePublishTypeControls();
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, false);
        return radioButton;
    }

    private Button createPublishConsolidationRadioButton(Composite parent, String text, String tooltip, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = DDAllocationDialog.this.fConsolidateAlwaysButton.getSelection() ? 2 : (DDAllocationDialog.this.fConsolidateNeverButton.getSelection() ? 1 : (DDAllocationDialog.this.fConsolidateOnSuccessButton.getSelection() ? 3 : 0));
                DDAllocationDialog.this.fDD.setConsolidateLog(value);
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, false);
        return radioButton;
    }

    private Button createPublishCompactRadioButton(Composite parent, String text, String tooltip, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int value = DDAllocationDialog.this.fCompactAlwaysButton.getSelection() ? 2 : (DDAllocationDialog.this.fCompactNeverButton.getSelection() ? 1 : 0);
                DDAllocationDialog.this.fDD.setCompact(value);
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, false);
        return radioButton;
    }

    private Button createKindRadioButton(Composite parent, String text, String tooltip, boolean isTooltipFocusable, int style) {
        Button radioButton = new Button(parent, style);
        radioButton.setText(text);
        radioButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                DDAllocationDialog.this.handleKindUpdate();
            }
        });
        GeneralTranslatorEditorPage.addTooltipWithWrapping((Control)radioButton, tooltip, isTooltipFocusable);
        return radioButton;
    }

    protected void updatePublishTypeControls() {
        if (this.fPublishAlwaysButton.getSelection()) {
            this.fDD.setPublishType(2);
            this.fDD.setPublish(true);
            this.fPublishInheritButton.setSelection(false);
            this.fPublishOnErrorButton.setSelection(false);
            this.fPublishNeverButton.setSelection(false);
        } else if (this.fPublishInheritButton.getSelection()) {
            this.fDD.setPublishType(1);
            this.fDD.setPublish(true);
            this.fPublishAlwaysButton.setSelection(false);
            this.fPublishOnErrorButton.setSelection(false);
            this.fPublishNeverButton.setSelection(false);
        } else if (this.fPublishOnErrorButton.getSelection()) {
            this.fDD.setPublishType(3);
            this.fDD.setPublish(true);
            this.fPublishAlwaysButton.setSelection(false);
            this.fPublishInheritButton.setSelection(false);
            this.fPublishNeverButton.setSelection(false);
        } else if (this.fPublishNeverButton.getSelection()) {
            this.fDD.setPublishType(0);
            this.fDD.setPublish(false);
            this.fPublishAlwaysButton.setSelection(false);
            this.fPublishInheritButton.setSelection(false);
            this.fPublishOnErrorButton.setSelection(false);
        }
    }

    protected void updatePublishControlEnablement() {
        boolean enablement = true;
        if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream") || this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant")) {
            enablement = false;
        }
        this.fPublishLabel.setEnabled(enablement);
        this.fPublishAlwaysButton.setEnabled(enablement);
        this.fPublishNeverButton.setEnabled(enablement);
        this.fPublishOnErrorButton.setEnabled(enablement);
        this.fPublishInheritButton.setEnabled(enablement);
        this.fConsolidateLabel.setEnabled(enablement);
        this.fConsolidateAlwaysButton.setEnabled(enablement);
        this.fConsolidateNeverButton.setEnabled(enablement);
        this.fConsolidateOnSuccessButton.setEnabled(enablement);
        this.fConsolidateInheritButton.setEnabled(enablement);
        this.fCompactLabel.setEnabled(enablement);
        this.fCompactAlwaysButton.setEnabled(enablement);
        this.fCompactNeverButton.setEnabled(enablement);
        this.fCompactInheritButton.setEnabled(enablement);
    }

    protected void handleKindUpdate() {
        if (this.fDD.getDataDefinitionEntry() == null) {
            this.fDD.setDataDefinitionEntry((com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry)ModelFactory.eINSTANCE.createDataDefinitionEntry());
        }
        if (this.fDataDefEntryKindButtonDataDef.getSelection()) {
            this.fDD.getDataDefinitionEntry().setKind("com.ibm.teamz.langdef.entry.data_definition");
            this.fDD.getDataDefinitionEntry().setValue("");
        } else if (this.fDataDefEntryKindButtonSubParam.getSelection()) {
            this.fDD.getDataDefinitionEntry().setKind("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable");
            this.fDD.getDataDefinitionEntry().setValue("");
        } else if (this.fDataDefEntryKindButtonInput.getSelection()) {
            this.fDD.getDataDefinitionEntry().setKind("com.ibm.team.enterprise.systemdefinition.entry.constant");
            this.fDD.getDataDefinitionEntry().setValue("com.ibm.teamz.langdef.entry.constant.input");
        } else if (this.fDataDefEntryInStreamButtonInput.getSelection()) {
            this.fDD.getDataDefinitionEntry().setKind("com.ibm.teamz.langdef.entry.constant.instream");
            this.fDD.getDataDefinitionEntry().setValue("");
        } else if (this.fDataDefEntryKindButtonHfs.getSelection()) {
            this.fDD.getDataDefinitionEntry().setKind("com.ibm.teamz.langdef.entry.hfs");
            this.fDD.getDataDefinitionEntry().setValue("");
        }
        this.updateEntryKindEnablement();
        this.updateOutputControls();
        this.updateMemberRenameControls();
        this.updatePublishControlEnablement();
        this.validate(false);
    }

    protected void initWidgetValues() {
        if (this.fDD.getDataDefinitionEntry() == null) {
            return;
        }
        if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
            this.fDataDefEntryKindButtonDataDef.setSelection(true);
            String value = this.fDD.getDataDefinitionEntry().getValue();
            if (value != null && !value.isEmpty()) {
                value = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_PENDING;
                DataDefinitionEntryLabelHelper labelHelper = this.getLabelHelper();
                IModeledDataDefinitionEntryContext context = this.getDataDefinitionEntryContext(this.fDD.getDataDefinitionEntry());
                labelHelper.getDataDefinitionEntryValueLabelInBackground(context);
            }
            this.fSequentialFlagButton.setSelection(this.fDD.isSequential());
            this.fSequentialFlagButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fDataDefEntryKindButtonSubParam.setSelection(true);
            this.fSubParamText.setText(this.fDD.getDataDefinitionEntry().getValue() == null ? "" : this.fDD.getDataDefinitionEntry().getValue());
            this.fSequentialFlagButton.setEnabled(true);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant")) {
            this.fDataDefEntryKindButtonInput.setSelection(true);
            this.fSequentialFlagButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
            this.fDataDefEntryInStreamButtonInput.setSelection(true);
            this.fInStreamText.setText(this.fDD.getDataDefinitionEntry().getValue() == null ? "" : this.fDD.getDataDefinitionEntry().getValue());
            this.fSequentialFlagButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.hfs")) {
            this.fDataDefEntryKindButtonHfs.setSelection(true);
            this.fHfsText.setText(this.fDD.getDataDefinitionEntry().getValue() == null ? "" : this.fDD.getDataDefinitionEntry().getValue());
        }
        this.updateEntryKindEnablement();
        this.updateOutputControls();
        this.updateMemberRenameControls();
    }

    protected void updateOutputControls() {
        boolean enablement = true;
        if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
            IDataSetDefinition dataDef = this.getDataSetDefinition(this.fDD.getDataDefinitionEntry().getValue());
            if (dataDef == null || dataDef.getUsageType() == 2) {
                enablement = false;
            }
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
            enablement = false;
        }
        this.fOutputButton.setEnabled(enablement);
        boolean outputSelection = this.fOutputButton.getSelection();
        this.fUsedAsInputFlagButton.setEnabled(enablement && outputSelection);
        this.fDeployTypeLabel.setEnabled(enablement && outputSelection);
        this.fDeployTypeBrowseButton.setEnabled(enablement && outputSelection);
        this.fDeployTypeText.setEnabled(enablement && outputSelection);
        this.fDD.setOutput(this.fOutputButton.isEnabled() && this.fOutputButton.getSelection());
        this.fDD.setUsedAsInput(this.fUsedAsInputFlagButton.getSelection());
        this.fDD.setDeployType(this.fDeployTypeText.isEnabled() ? this.fDeployTypeText.getText().trim() : "");
    }

    private IDataSetDefinition getDataSetDefinition(String uuidValue) {
        if (uuidValue != null && !uuidValue.isEmpty()) {
            UUID uuid = null;
            try {
                uuid = UUID.valueOf((String)uuidValue);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
            IDataSetDefinitionHandle handle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(uuid, null);
            return this.getDataSetDefinition((ISystemDefinitionHandle)handle);
        }
        return null;
    }

    private IDataSetDefinition getDataSetDefinition(ISystemDefinitionHandle handle) {
        if (handle != null) {
            try {
                if (this.definitionCache != null) {
                    return (IDataSetDefinition)this.definitionCache.getSystemDefinition(handle, null);
                }
                ISystemDefinitionModelClient client = ClientFactory.getSystemDefinitionModelClient((ITeamRepository)this.repository);
                return (IDataSetDefinition)client.fetchSystemDefinitionComplete(handle, false, null);
            }
            catch (TeamRepositoryException e) {
                ZDefUIPlugin.log(e);
            }
        }
        return null;
    }

    private ModifyListener getHfsListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DDAllocationDialog.this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.hfs")) {
                    DDAllocationDialog.this.fDD.getDataDefinitionEntry().setValue(DDAllocationDialog.this.fHfsText.getText());
                    if (DDAllocationDialog.this.fDD.getHfs() == null) {
                        DDAllocationDialog.this.fDD.setHfs((IHFSDD)ModelFactory.eINSTANCE.createHFSDD());
                    }
                    DDAllocationDialog.this.fDD.getHfs().setPath(DDAllocationDialog.this.fHfsText.getText());
                }
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    protected void updateEntryKindEnablement() {
        this.fDDNameText.removeModifyListener(this.ddNameTextListener);
        this.fHfsText.removeModifyListener(this.hfsTextListener);
        this.fInStreamText.removeModifyListener(this.inStreamTextListener);
        this.fSubParamText.removeModifyListener(this.subParamTextListener);
        if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.data_definition")) {
            this.fDataDefinitionText.setEnabled(true);
            this.fBrowseButton.setEnabled(true);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setText("");
            this.fInStreamText.setEnabled(false);
            this.fInStreamText.setText("");
            this.fSequentialFlagButton.setEnabled(false);
            this.fHfsText.setText("");
            this.fHfsText.setEnabled(false);
            this.fHfsOptsButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
            this.fDataDefinitionText.setText("");
            this.fDataDefinitionText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fSubParamText.setEnabled(true);
            this.fInStreamText.setEnabled(false);
            this.fInStreamText.setText("");
            this.fSequentialFlagButton.setEnabled(true);
            this.fHfsText.setText("");
            this.fHfsText.setEnabled(false);
            this.fHfsOptsButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant")) {
            this.fDataDefinitionText.setText("");
            this.fDataDefinitionText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setText("");
            this.fInStreamText.setEnabled(false);
            this.fInStreamText.setText("");
            this.fSequentialFlagButton.setEnabled(false);
            this.fHfsText.setText("");
            this.fHfsText.setEnabled(false);
            this.fHfsOptsButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
            this.fDataDefinitionText.setText("");
            this.fDataDefinitionText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setText("");
            this.fInStreamText.setEnabled(true);
            this.fSequentialFlagButton.setEnabled(false);
            this.fHfsText.setText("");
            this.fHfsText.setEnabled(false);
            this.fHfsOptsButton.setEnabled(false);
        } else if (this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.hfs")) {
            this.fDataDefinitionText.setText("");
            this.fDataDefinitionText.setEnabled(false);
            this.fBrowseButton.setEnabled(false);
            this.fSubParamText.setEnabled(false);
            this.fSubParamText.setText("");
            this.fInStreamText.setEnabled(false);
            this.fSequentialFlagButton.setEnabled(false);
            this.fHfsText.setEnabled(true);
            this.fHfsOptsButton.setEnabled(true);
        }
        this.fDDNameText.addModifyListener(this.ddNameTextListener);
        this.fHfsText.addModifyListener(this.hfsTextListener);
        this.fInStreamText.addModifyListener(this.inStreamTextListener);
        this.fSubParamText.addModifyListener(this.subParamTextListener);
    }

    private ModifyListener getNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DDAllocationDialog.this.validate(false);
                DDAllocationDialog.this.fDD.setName(DDAllocationDialog.this.fDDNameText.getText().trim());
            }
        };
    }

    private ModifyListener getOutputNameModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                DDAllocationDialog.this.updateOutputNameOrPattern();
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    private ModifyListener getSubParamModifiedListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DDAllocationDialog.this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable")) {
                    DDAllocationDialog.this.fDD.getDataDefinitionEntry().setValue(DDAllocationDialog.this.fSubParamText.getText().trim());
                }
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    private ModifyListener getInStreamListener() {
        return new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (DDAllocationDialog.this.fDD.getDataDefinitionEntry().getKind().equals("com.ibm.teamz.langdef.entry.constant.instream")) {
                    DDAllocationDialog.this.fDD.getDataDefinitionEntry().setValue(DDAllocationDialog.this.fInStreamText.getText());
                }
                DDAllocationDialog.this.validate(false);
            }
        };
    }

    private void createSpacer(Composite parent, int height, int horizontalSpan) {
        Label label = new Label(parent, 64);
        label.setText("");
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = horizontalSpan;
        label.setLayoutData((Object)gridData);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fTitle);
    }

    public void create() {
        super.create();
        this.updateOutputNameOrPattern();
    }

    protected String nameConflict(String name) {
        boolean otherHasCondition;
        if (!this.isNew && name.equals(this.fOriginalName)) {
            return null;
        }
        boolean thisHasCondition = !this.fConditionalText.getText().trim().isEmpty();
        for (IDDAllocation iDDAllocation : this.fExistingDDs) {
            IDDAllocation dd = iDDAllocation;
            if (!dd.getName().equals(name)) continue;
            boolean bl = otherHasCondition = dd.getCondition() != null && !dd.getCondition().isEmpty();
            if (!otherHasCondition) {
                return NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_EXISTS, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
            }
            if (thisHasCondition) continue;
            return NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_CONDITION_REQUIRED, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
        }
        for (IDDAllocation iDDAllocation : this.fExistingConcatenations) {
            IConcatenation concat = (IConcatenation)iDDAllocation;
            if (!concat.getName().equals(name)) continue;
            boolean bl = otherHasCondition = concat.getCondition() != null && !concat.getCondition().isEmpty();
            if (!otherHasCondition) {
                return NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_EXISTS, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
            }
            if (thisHasCondition) continue;
            return NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_DD_NAME_CONDITION_REQUIRED, (Object)AbstractSystemDefinitionEditor.escapeAmpersands((String)name));
        }
        return null;
    }

    protected DataDefinitionEntryLabelHelper getLabelHelper() {
        return new DataDefinitionEntryLabelHelper(this.definitionCache){

            @Override
            public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!DDAllocationDialog.this.fDataDefinitionText.isDisposed() && DDAllocationDialog.this.fDataDefEntryKindButtonDataDef.getSelection()) {
                    DDAllocationDialog.this.fDataDefinitionText.setText(label);
                }
            }

            @Override
            public void sequentialAvailable(Boolean isSequential, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!DDAllocationDialog.this.fSequentialFlagButton.isDisposed()) {
                    DDAllocationDialog.this.fSequentialFlagButton.setSelection(isSequential.booleanValue());
                }
            }
        };
    }

    protected IModeledDataDefinitionEntryContext getDataDefinitionEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry) {
        return new IModeledDataDefinitionEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry getModeledEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return DDAllocationDialog.this.repository;
            }

            @Override
            public IDataDefinitionEntry getEntry() {
                return null;
            }
        };
    }

    protected List<IDDAllocation> getExistingDDAllocations() {
        return this.fExistingDDs;
    }

    public String getDataDefinitionEntryKind() {
        return this.fDD.getDataDefinitionEntry().getKind();
    }

    public String getDataDefinitionEntryValue() {
        return this.fDD.getDataDefinitionEntry().getValue();
    }

    public boolean getIsKeep() {
        return this.fDD.isKeep();
    }

    public boolean getIsMod() {
        return this.fDD.isMod();
    }

    public boolean getIsMember() {
        return this.fDD.isMember();
    }

    public String getName() {
        return this.fDD.getName();
    }

    public boolean getUsedAsInput() {
        return this.fDD.isUsedAsInput();
    }

    public int getDDPublishType() {
        return this.fDD.getPublishType();
    }

    public boolean getIsOutput() {
        return this.fDD.isOutput();
    }

    public boolean getIsPublish() {
        return this.fDD.isPublish();
    }

    public String getOutputName() {
        return this.fDD.getOutputName();
    }

    public String getCondition() {
        return this.fDD.getCondition();
    }

    public OutputNameKind getOutputNameKind() {
        return this.fDD.getOutputNameKind();
    }

    public boolean getIsSequential() {
        return this.fDD.isSequential();
    }

    public String getDeployType() {
        return this.fDD.getDeployType();
    }

    public int getPublishType() {
        return this.fDD.getPublishType();
    }

    public int getConsolidateLog() {
        return this.fDD.getConsolidateLog();
    }

    public int getCompact() {
        return this.fDD.getCompact();
    }

    private void addControlDecorator(Control targetControl, String descriptionText, int style) {
        final ControlDecoration dec = new ControlDecoration(targetControl, style);
        if (targetControl instanceof Text) {
            dec.setMarginWidth(2);
        }
        dec.setDescriptionText(descriptionText);
        dec.setImage(FieldDecorationRegistry.getDefault().getFieldDecoration("DEC_INFORMATION").getImage());
        dec.hide();
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                if (event.type == 26) {
                    dec.show();
                }
                if (event.type == 27) {
                    dec.hide();
                }
            }
        };
        targetControl.addListener(26, listener);
        targetControl.addListener(27, listener);
    }

    private void updateOutputNameOrPattern() {
        if (!this.fMemberNameButton.isEnabled() || !this.fMemberNameButton.getSelection()) {
            this.fDD.setOutputNameKind(OutputNameKind.SAME_AS_INPUT_LITERAL);
            this.fDD.setOutputName(null);
        } else {
            ZOSTranslatorValidator fTransValidator = ZOSTranslatorValidator.getInstance();
            String nameOrPattern = this.fMemberOutputName.getText().trim();
            if (this.fDD.isSequential()) {
                fTransValidator.clearErrorMessages();
                IStatus fTransValidatorStatus = fTransValidator.validatePatternOrVariable(nameOrPattern, this.fTranslatorVars, true);
                if (fTransValidatorStatus.isOK()) {
                    if (nameOrPattern.length() != 0 && nameOrPattern.charAt(0) == '&') {
                        this.fDD.setOutputNameKind(OutputNameKind.USE_VARIABLE_LITERAL);
                        this.updateExampleTextForSequential(VariableUtils.getVariableValue((String)nameOrPattern, this.fTranslatorVars));
                        String name = VariableUtils.getVariableNameWithoutPrefix((String)nameOrPattern);
                        if (name != null) {
                            this.fDD.setOutputName(name);
                        }
                    } else {
                        this.updateExampleTextForSequential(nameOrPattern);
                        this.fDD.setOutputNameKind(OutputNameKind.USE_PATTERN_LITERAL);
                        this.fDD.setOutputName(nameOrPattern);
                    }
                } else {
                    this.patternErrorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_ERROR_INVALID_PATTERN;
                    this.fExampleLabel.setText(fTransValidatorStatus.getMessage());
                    this.fExampleLabel.setVisible(true);
                    this.validate(false);
                }
            } else {
                IStatus fTransValidatorStatus = fTransValidator.validatePatternOrVariable(nameOrPattern, this.fTranslatorVars);
                if (fTransValidatorStatus.getSeverity() < 4) {
                    if (nameOrPattern.length() != 0 && nameOrPattern.charAt(0) == '&') {
                        if (fTransValidatorStatus.isOK()) {
                            this.updateExampleText(VariableUtils.getVariableValue((String)nameOrPattern, this.fTranslatorVars));
                        } else {
                            this.patternErrorMessage = null;
                            this.fExampleLabel.setText(fTransValidatorStatus.getMessage());
                            this.fExampleLabel.setVisible(true);
                        }
                        this.fDD.setOutputNameKind(OutputNameKind.USE_VARIABLE_LITERAL);
                        String name = VariableUtils.getVariableNameWithoutPrefix((String)nameOrPattern);
                        if (name != null) {
                            this.fDD.setOutputName(name);
                        }
                    } else {
                        if (fTransValidatorStatus.isOK()) {
                            this.updateExampleText(nameOrPattern);
                        } else {
                            this.patternErrorMessage = null;
                            this.fExampleLabel.setText(fTransValidatorStatus.getMessage());
                            this.fExampleLabel.setVisible(true);
                        }
                        this.fDD.setOutputNameKind(OutputNameKind.USE_PATTERN_LITERAL);
                        this.fDD.setOutputName(nameOrPattern);
                    }
                } else {
                    this.patternErrorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_ERROR_INVALID_PATTERN;
                    this.fExampleLabel.setText(fTransValidatorStatus.getMessage());
                    this.fExampleLabel.setVisible(true);
                    this.validate(false);
                }
            }
        }
    }

    private void updateExampleTextForSequential(String pattern) {
        if (pattern != null) {
            if (this.fExampleLabel != null) {
                try {
                    try {
                        MemberNamePattern mnp = new MemberNamePattern(IZosPlatformObject.class);
                        String newPattern = mnp.substituteDateVars(pattern);
                        String[] subPatterns = newPattern.split("\\.");
                        String[] subResults = new String[subPatterns.length];
                        int i = 0;
                        String[] stringArray = subPatterns;
                        int n = subPatterns.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String subPattern = stringArray[n2];
                            subResults[i] = mnp.convert(subPattern, "ORDENTR");
                            ++i;
                            ++n2;
                        }
                        String result = null;
                        String[] stringArray2 = subResults;
                        int n3 = subResults.length;
                        n = 0;
                        while (n < n3) {
                            String subResult = stringArray2[n];
                            result = result != null && !result.isEmpty() ? String.valueOf(result) + "." + subResult : subResult;
                            ++n;
                        }
                        if (result != null && !result.isEmpty()) {
                            this.fExampleLabel.setText(NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_RenameExampleLabel, (Object)"ORDENTR", (Object)result));
                            this.fExampleLabel.setVisible(true);
                        }
                        this.patternErrorMessage = null;
                    }
                    catch (IllegalArgumentException e) {
                        this.fExampleLabel.setText("(" + e.getMessage() + ")");
                        this.fExampleLabel.setVisible(true);
                        this.patternErrorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_ERROR_INVALID_PATTERN;
                        this.validate(false);
                    }
                }
                finally {
                    this.validate(false);
                }
            }
        } else {
            this.fExampleLabel.setVisible(false);
        }
    }

    private void updateExampleText(String pattern) {
        if (pattern != null) {
            if (this.fExampleLabel != null) {
                try {
                    try {
                        MemberNamePattern mnp = new MemberNamePattern(IZosPlatformObject.class);
                        String result = mnp.convert(pattern, "ORDENTR");
                        if (result != null && !result.isEmpty()) {
                            this.fExampleLabel.setText(NLS.bind((String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_RenameExampleLabel, (Object)"ORDENTR", (Object)result));
                            this.fExampleLabel.setVisible(true);
                        }
                        this.patternErrorMessage = null;
                    }
                    catch (IllegalArgumentException e) {
                        this.fExampleLabel.setText("(" + e.getMessage() + ")");
                        this.fExampleLabel.setVisible(true);
                        this.patternErrorMessage = com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationDialog_ERROR_INVALID_PATTERN;
                        this.validate(false);
                    }
                }
                finally {
                    this.validate(false);
                }
            }
        } else {
            this.fExampleLabel.setVisible(false);
        }
    }

    private String openVariableSelectionDialog() {
        Object[] dialogSelections;
        VariableSelectionDialog dialog = new VariableSelectionDialog(this.fComposite.getShell(), this.fTranslatorVars);
        if (dialog.open() == 0 && (dialogSelections = dialog.getResult()) != null && dialogSelections.length > 0) {
            Object selectedItem = dialogSelections[0];
            return "&" + ((IVariable)selectedItem).getName();
        }
        return null;
    }

    public IHFSDD getHfs() {
        return this.fDD.getHfs();
    }
}

