/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.internal.model.Concatenation;
import com.ibm.team.enterprise.systemdefinition.common.internal.model.DataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDDAllocation;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinition;
import com.ibm.team.enterprise.systemdefinition.common.model.IDataSetDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ISystemDefinitionHandle;
import com.ibm.team.enterprise.systemdefinition.common.model.ModelFactory;
import com.ibm.team.enterprise.systemdefinition.ui.IGenericListener;
import com.ibm.team.enterprise.systemdefinition.ui.ISystemDefinitionCache;
import com.ibm.team.enterprise.systemdefinition.ui.jobs.SystemDefinitionJob;
import com.ibm.team.enterprise.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.systemdefinition.ui.util.ListContentProvider;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.AbstractCompositeSystemDefinitionControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationDialog;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationLabelProvider;
import com.ibm.team.enterprise.zos.systemdefinition.common.mapping.api.MappingValidation;
import com.ibm.team.repository.client.ITeamRepository;
import com.ibm.team.repository.common.TeamRepositoryException;
import com.ibm.team.repository.common.UUID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ConcatenationsControl
extends AbstractCompositeSystemDefinitionControl {
    private static final String COLUMN_CONDITION = "condition";
    private static final String COLUMN_NAME = "name";
    private static final String COLUMN_VALUE = "value";
    private final Button fAddButton;
    private final Button fCopyButton;
    private final Button fDownButton;
    private final Button fEditButton;
    private final Button fRemoveButton;
    private final Button fUpButton;
    private final ListenerList fListenerList = new ListenerList();
    private final Shell fParentShell;
    private final TableViewer fTableViewer;
    private final FormToolkit fToolkit;
    private final ITeamRepository repository;
    private final MappingValidation validator;
    private final Map<String, String> ddIdNameMap = new HashMap<String, String>();
    protected List<IConcatenation> fConcatenations;
    protected List<IDDAllocation> fDDAllocations;
    private boolean isEditable = true;

    public ConcatenationsControl(Composite parent, FormToolkit toolkit, List<IConcatenation> concats, ITeamRepository repository, boolean isEditable, ISystemDefinitionCache definitionCache, MappingValidation validator) {
        super(repository, definitionCache);
        this.fParentShell = parent.getShell();
        this.fToolkit = toolkit;
        this.fConcatenations = concats;
        this.isEditable = isEditable;
        this.repository = repository;
        this.validator = validator;
        Composite tableComposite = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().span(2, -1).grab(true, true).indent(5, 3).applyTo((Control)tableComposite);
        Table table = this.fToolkit.createTable(tableComposite, 68354);
        TableColumnLayout tcl = new TableColumnLayout();
        String[] columnProperties = new String[]{COLUMN_NAME, COLUMN_VALUE, COLUMN_CONDITION};
        String[] columnHeaders = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_CONCAT_NAME, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_CONCAT_VALUE, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_CONCAT_CONDITION};
        String[] columnTooltips = new String[]{com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_NAME_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_CONCAT_VALUE_TOOLTIP, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DDAllocationsControl_CONDITION_TOOLTIP};
        int[] columnWeights = new int[]{25, 25, 50};
        int i = 0;
        while (i < columnHeaders.length) {
            TableColumn column = new TableColumn(table, 0);
            column.setText(columnHeaders[i]);
            if (columnTooltips[i] != null) {
                column.setToolTipText(columnTooltips[i]);
            } else {
                column.setToolTipText(columnHeaders[i]);
            }
            tcl.setColumnData((Widget)column, (ColumnLayoutData)new ColumnWeightData(columnWeights[i]));
            ++i;
        }
        tableComposite.setLayout((Layout)tcl);
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        this.fTableViewer = new TableViewer(table);
        this.fTableViewer.setColumnProperties(columnProperties);
        this.fTableViewer.setContentProvider((IContentProvider)new ListContentProvider());
        this.fTableViewer.setLabelProvider((IBaseLabelProvider)new ConcatenationLabelProvider(this.fTableViewer, repository, this));
        this.resolveDDName();
        this.fTableViewer.setInput(this.fConcatenations);
        Composite buttonBar = this.fToolkit.createComposite(parent);
        GridDataFactory.fillDefaults().applyTo((Control)buttonBar);
        GridLayoutFactory.fillDefaults().applyTo(buttonBar);
        this.fAddButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ADD_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fCopyButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.COPY_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fEditButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.EDIT_BUTTON_LABEL_WITH_ELLIPSIS, 8);
        this.fRemoveButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.REMOVE_BUTTON_LABEL, 8);
        this.fUpButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryControl_UP_BUTTON, 8);
        this.fDownButton = this.createButton(buttonBar, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryControl_DOWN_BUTTON, 8);
        if (isEditable) {
            this.fTableViewer.addSelectionChangedListener(this.getSelectionChangedListener());
            this.fTableViewer.addDoubleClickListener(new IDoubleClickListener(){

                public void doubleClick(DoubleClickEvent event) {
                    ConcatenationsControl.this.handleDoubleClick(event);
                }
            });
            this.fAddButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConcatenationsControl.this.addConcatenation();
                }
            });
            this.fCopyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConcatenation concat = ConcatenationsControl.this.getSelectedConcatenation();
                    if (concat != null) {
                        ConcatenationsControl.this.copyConcatenation(concat);
                    }
                }
            });
            this.fEditButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConcatenation concat = ConcatenationsControl.this.getSelectedConcatenation();
                    if (concat != null) {
                        ConcatenationsControl.this.editConcatenation(concat);
                    }
                }
            });
            this.fRemoveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ConcatenationsControl.this.removeSelectedConcatenations();
                }
            });
            this.fUpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConcatenation concat = ConcatenationsControl.this.getSelectedConcatenation();
                    if (concat != null) {
                        ConcatenationsControl.this.moveConcatenation(concat, true);
                    }
                }
            });
            this.fDownButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IConcatenation concat = ConcatenationsControl.this.getSelectedConcatenation();
                    if (concat != null) {
                        ConcatenationsControl.this.moveConcatenation(concat, false);
                    }
                }
            });
        }
        this.updateButtonEnablement();
        this.setButtonLayoutData();
    }

    private IConcatenation getSelectedConcatenation() {
        IStructuredSelection selection = this.getCurrentSelection();
        Object element = selection.getFirstElement();
        if (element instanceof IConcatenation) {
            return (IConcatenation)element;
        }
        return null;
    }

    protected IStructuredSelection getCurrentSelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    public List<IConcatenation> getConcatenations() {
        return this.fConcatenations;
    }

    public void setConcatenations(List<IConcatenation> concats) {
        this.fConcatenations = concats;
        this.resolveDDName();
        this.fTableViewer.setInput(concats);
        this.fTableViewer.refresh();
        this.updateButtonEnablement();
    }

    public void setDDAllocations(List<IDDAllocation> dds) {
        this.fDDAllocations = dds;
    }

    protected ISelectionChangedListener getSelectionChangedListener() {
        return new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ConcatenationsControl.this.updateButtonEnablement();
            }
        };
    }

    public void addListener(IGenericListener listener) {
        this.fListenerList.add((Object)listener);
    }

    public void removeListener(IGenericListener listener) {
        this.fListenerList.remove((Object)listener);
    }

    protected void notifyConcatenationsModified() {
        Object[] listeners = this.fListenerList.getListeners();
        int i = 0;
        while (i < listeners.length) {
            if (listeners[i] instanceof IGenericListener) {
                IGenericListener listener = (IGenericListener)listeners[i];
                listener.contentsModified();
            }
            ++i;
        }
    }

    private void addConcatenation() {
        Concatenation concat = ModelFactory.eINSTANCE.createConcatenation();
        ConcatenationDialog dialog = this.getConcatenationDialog((IConcatenation)concat, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_ADD_TITLE, true);
        if (dialog.open() == 0) {
            this.fConcatenations.add((IConcatenation)concat);
            IConcatenation newConcat = dialog.getWorkingCopy();
            concat.setName(newConcat.getName());
            concat.setCondition(newConcat.getCondition());
            concat.getDataDefinitionEntries().clear();
            for (IDataDefinitionEntry entry : newConcat.getDataDefinitionEntries()) {
                DataDefinitionEntry cloned = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                cloned.setKind(entry.getKind());
                cloned.setMember(entry.isMember());
                cloned.setValue(entry.getValue());
                concat.getDataDefinitionEntries().add(cloned);
            }
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
            this.notifyConcatenationsModified();
        }
    }

    private void copyConcatenation(IConcatenation existingConcat) {
        IConcatenation concat = ModelFactory.eINSTANCE.copyModelDefinition(existingConcat);
        concat.setName(String.valueOf(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_COPY_OF) + existingConcat.getName());
        ConcatenationDialog dialog = this.getConcatenationDialog(concat, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_COPY_TITLE, false);
        if (dialog.open() == 0) {
            this.fConcatenations.add(concat);
            IConcatenation newConcat = dialog.getWorkingCopy();
            concat.setName(newConcat.getName());
            concat.setCondition(newConcat.getCondition());
            concat.getDataDefinitionEntries().clear();
            for (IDataDefinitionEntry entry : newConcat.getDataDefinitionEntries()) {
                DataDefinitionEntry cloned = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                cloned.setKind(entry.getKind());
                cloned.setMember(entry.isMember());
                cloned.setValue(entry.getValue());
                concat.getDataDefinitionEntries().add(cloned);
            }
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.updateButtonEnablement();
            this.notifyConcatenationsModified();
        }
    }

    private ConcatenationDialog getConcatenationDialog(IConcatenation concat, String title, boolean isNew) {
        return new ConcatenationDialog(this.fParentShell, title, concat, this.fConcatenations, this.fDDAllocations, this.repository, isNew, this.fSystemDefinitionCache, this.validator);
    }

    private void editConcatenation(IConcatenation concat) {
        ConcatenationDialog dialog = this.getConcatenationDialog(concat, com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationsControl_EDIT_TITLE, false);
        if (dialog.open() == 0) {
            IConcatenation newConcat = dialog.getWorkingCopy();
            concat.setName(newConcat.getName());
            concat.setCondition(newConcat.getCondition());
            concat.getDataDefinitionEntries().clear();
            for (IDataDefinitionEntry entry : newConcat.getDataDefinitionEntries()) {
                DataDefinitionEntry cloned = ModelFactory.eINSTANCE.createDataDefinitionEntry();
                cloned.setKind(entry.getKind());
                cloned.setMember(entry.isMember());
                cloned.setValue(entry.getValue());
                concat.getDataDefinitionEntries().add(cloned);
            }
            this.resolveDDName();
            this.fTableViewer.refresh();
            this.notifyConcatenationsModified();
        }
    }

    private void moveConcatenation(IConcatenation concat, boolean up) {
        int index = this.fConcatenations.indexOf(concat);
        if (index != -1) {
            if (up && index == 0 || !up && index == this.fConcatenations.size() - 1) {
                return;
            }
            this.fConcatenations.remove(index);
            this.fConcatenations.add(index += up ? -1 : 1, concat);
            this.fTableViewer.refresh();
            this.notifyConcatenationsModified();
            this.updateButtonEnablement();
        }
    }

    private void removeSelectedConcatenations() {
        ISelection selection;
        boolean deleteConfirmed = MessageDialog.openQuestion((Shell)this.fParentShell, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationControl_CONFIRM_TITLE, (String)com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationControl_CONFIRM);
        if (deleteConfirmed && (selection = this.fTableViewer.getSelection()) instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            ArrayList<IConcatenation> entriesRemoved = new ArrayList<IConcatenation>();
            for (IConcatenation concat : structuredSelection) {
                this.fTableViewer.remove((Object)concat);
                this.fConcatenations.remove(concat);
                entriesRemoved.add(concat);
            }
            if (!entriesRemoved.isEmpty()) {
                this.fTableViewer.refresh();
                this.updateButtonEnablement();
                this.notifyConcatenationsModified();
            }
        }
    }

    private IStructuredSelection getCurrentPropertySelection() {
        return (IStructuredSelection)this.fTableViewer.getSelection();
    }

    private void updateButtonEnablement() {
        if (this.fEditButton == null) {
            return;
        }
        IStructuredSelection selection = this.getCurrentPropertySelection();
        this.fAddButton.setEnabled(this.isEditable);
        this.fCopyButton.setEnabled(selection.size() == 1);
        this.fEditButton.setEnabled(selection.size() == 1);
        this.fRemoveButton.setEnabled(!selection.isEmpty());
        this.fUpButton.setEnabled(selection.size() == 1 && this.fConcatenations.indexOf(selection.getFirstElement()) > 0);
        this.fDownButton.setEnabled(selection.size() == 1 && this.fConcatenations.indexOf(selection.getFirstElement()) < this.fConcatenations.size() - 1);
    }

    private Button createButton(Composite parent, String label, int style) {
        if (this.fToolkit != null) {
            return this.fToolkit.createButton(parent, label, style);
        }
        Button button = new Button(parent, style);
        button.setText(label);
        return button;
    }

    private void handleDoubleClick(DoubleClickEvent event) {
        ISelection selection = event.getSelection();
        if (!(selection instanceof IStructuredSelection)) {
            return;
        }
        Object element = ((IStructuredSelection)selection).getFirstElement();
        if (element instanceof IConcatenation) {
            IConcatenation concat = (IConcatenation)element;
            this.editConcatenation(concat);
        }
    }

    private void setButtonLayoutData() {
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fAddButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fCopyButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fEditButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fRemoveButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fUpButton);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.fDownButton);
    }

    public void setEnabled(boolean b) {
        if (!b) {
            this.fAddButton.setEnabled(false);
            this.fEditButton.setEnabled(false);
            this.fRemoveButton.setEnabled(false);
            this.fUpButton.setEnabled(false);
            this.fDownButton.setEnabled(false);
        } else {
            this.updateButtonEnablement();
        }
    }

    private void resolveDDName() {
        if (this.fConcatenations == null) {
            return;
        }
        SystemDefinitionJob job = new SystemDefinitionJob(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryLabelHelper_JOB_LABEL, false){

            protected IStatus runProtected(IProgressMonitor monitor) throws Exception {
                for (IConcatenation nextConcat : ConcatenationsControl.this.fConcatenations) {
                    for (IDataDefinitionEntry entry : nextConcat.getDataDefinitionEntries()) {
                        if (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") || entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && entry.getValue().equals("com.ibm.teamz.langdef.entry.constant.input")) continue;
                        String dataDefUuid = entry.getValue();
                        String label = null;
                        try {
                            if (dataDefUuid.length() > 0 && !this.ddIdExists(dataDefUuid)) {
                                IDataSetDefinition dataDef = null;
                                UUID dataDefUuidValue = UUID.valueOf((String)dataDefUuid);
                                IDataSetDefinitionHandle handle = (IDataSetDefinitionHandle)IDataSetDefinition.ITEM_TYPE.createItemHandle(dataDefUuidValue, null);
                                dataDef = (IDataSetDefinition)ConcatenationsControl.this.fSystemDefinitionCache.getSystemDefinition((ISystemDefinitionHandle)handle, monitor);
                                label = dataDef.getName();
                                if (dataDef.isArchived()) {
                                    label = String.valueOf(label) + Messages.SystemDefinition_ARCHIVED_SUFFIX;
                                }
                            }
                        }
                        catch (TeamRepositoryException teamRepositoryException) {
                            // empty catch block
                        }
                        if (label == null) continue;
                        ConcatenationsControl.this.ddIdNameMap.put(entry.getValue(), label);
                    }
                }
                return Status.OK_STATUS;
            }

            private boolean ddIdExists(String ddIdKey) {
                if (ConcatenationsControl.this.ddIdNameMap != null && !ConcatenationsControl.this.ddIdNameMap.isEmpty()) {
                    return ConcatenationsControl.this.ddIdNameMap.keySet().contains(ddIdKey);
                }
                return false;
            }

            protected void jobFinished(IStatus status) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ConcatenationsControl.this.fTableViewer.getTable().isDisposed()) {
                            ConcatenationsControl.this.fTableViewer.refresh();
                        }
                    }
                });
            }
        };
        job.schedule();
    }

    public String getDDName(IConcatenation concatenation) {
        StringBuffer buffer = new StringBuffer();
        Iterator iterator = concatenation.getDataDefinitionEntries().iterator();
        while (iterator.hasNext()) {
            String label = null;
            IDataDefinitionEntry entry = (IDataDefinitionEntry)iterator.next();
            label = entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.substitution_variable") ? entry.getValue() : (entry.getKind().equals("com.ibm.team.enterprise.systemdefinition.entry.constant") && entry.getValue().equals("com.ibm.teamz.langdef.entry.constant.input") ? com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.DataDefinitionEntryLabelHelper_INPUT : this.ddIdNameMap.get(entry.getValue()));
            if (label == null) {
                buffer.append(com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages.ConcatenationLabelProvider_PENDING);
            } else {
                buffer.append(label);
            }
            if (!iterator.hasNext()) continue;
            buffer.append(',');
        }
        return buffer.toString();
    }
}

