/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors;

import com.ibm.team.enterprise.systemdefinition.common.model.IConcatenation;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.ConcatenationsControl;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.DataDefinitionEntryLabelHelper;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.editors.IModeledDataDefinitionEntryContext;
import com.ibm.team.enterprise.zos.internal.systemdefinition.ui.nls.Messages;
import com.ibm.team.enterprise.zos.systemdefinition.common.IDataDefinitionEntry;
import com.ibm.team.repository.client.ITeamRepository;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.graphics.Image;

public class ConcatenationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    protected TableViewer fTableViewer;
    private ITeamRepository fTeamRepository;
    private ConcatenationsControl control;
    protected Map<String, String> fValueToLabelMap = new HashMap<String, String>();

    public ConcatenationLabelProvider(TableViewer tableViewer, ITeamRepository repo, ConcatenationsControl control) {
        this.fTableViewer = tableViewer;
        this.fTeamRepository = repo;
        this.control = control;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        IConcatenation concat = (IConcatenation)element;
        switch (columnIndex) {
            case 0: {
                return concat.getName();
            }
            case 1: {
                if (this.control != null) {
                    return this.control.getDDName(concat);
                }
                return Messages.ConcatenationLabelProvider_PENDING;
            }
            case 2: {
                return concat.getCondition() == null ? "" : concat.getCondition();
            }
        }
        return null;
    }

    private String getConcatenationValue(IConcatenation concat) {
        if (concat.getDataDefinitionEntries() == null || concat.getDataDefinitionEntries().size() == 0) {
            return "";
        }
        DataDefinitionEntryLabelHelper labelHelper = this.getLabelHelper();
        List concatEntries = concat.getDataDefinitionEntries();
        for (com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry : concatEntries) {
            if (this.fValueToLabelMap.get(entry.getValue()) != null) continue;
            IModeledDataDefinitionEntryContext context = this.getDataDefinitionEntryContext(entry, concat);
            labelHelper.getDataDefinitionEntryValueLabelInBackground(context);
        }
        return this.getLabel(concat);
    }

    private String getLabel(IConcatenation concat) {
        StringBuffer label = new StringBuffer();
        List concatEntries = concat.getDataDefinitionEntries();
        for (com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry : concatEntries) {
            String l = this.fValueToLabelMap.get(entry.getValue());
            if (l != null) {
                label.append(String.valueOf(l) + ",");
                continue;
            }
            label.append(String.valueOf(Messages.ConcatenationLabelProvider_PENDING) + ",");
        }
        return label.substring(0, label.length() - 1);
    }

    protected DataDefinitionEntryLabelHelper getLabelHelper() {
        return new DataDefinitionEntryLabelHelper(this.control.getSystemDefinitionCache()){

            @Override
            public void labelAvailable(String label, com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry dataDefEntry) {
                if (!ConcatenationLabelProvider.this.fTableViewer.getTable().isDisposed()) {
                    ConcatenationLabelProvider.this.fValueToLabelMap.put(dataDefEntry.getValue(), label);
                    ConcatenationLabelProvider.this.fTableViewer.refresh();
                }
            }
        };
    }

    protected IModeledDataDefinitionEntryContext getDataDefinitionEntryContext(final com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry entry, IConcatenation concat) {
        return new IModeledDataDefinitionEntryContext(){

            @Override
            public com.ibm.team.enterprise.systemdefinition.common.model.IDataDefinitionEntry getModeledEntry() {
                return entry;
            }

            @Override
            public ITeamRepository getTeamRepository() {
                return ConcatenationLabelProvider.this.fTeamRepository;
            }

            @Override
            public IDataDefinitionEntry getEntry() {
                return null;
            }
        };
    }
}

